/***************************************************************************
                            kde_HTMLTableElement.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_HTMLTABLEELEMENT
#define KDE_HTMLTABLEELEMENT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 The create* and delete* methods on the table allow authors to
 construct and modify tables. HTML 4.0 specifies that only one of
 each of the <code> CAPTION </code> , <code> THEAD </code> , and
 <code> TFOOT </code> elements may exist in a table. Therefore, if
 one exists, and the createTHead() or createTFoot() method is
 called, the method returns the existing THead or TFoot element. See
 the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#edef-TABLE">
 TABLE element definition </a> in HTML 4.0.

 
 @short 
 The create* and delete* methods on the table allow authors to
 construct and modify tables.
*/
kde_HTMLTableElement * kde_new_HTMLTableElement();
kde_HTMLTableElement * kde_new_HTMLTableElement1(kde_HTMLTableElement* other);
kde_HTMLTableElement * kde_new_HTMLTableElement2(kde_DOMNode* other);
void kde_del_HTMLTableElement( kde_HTMLTableElement* p );

/** 
 Returns the table's <code> CAPTION </code> , or void if none
 exists.

     
*/
kde_HTMLTableCaptionElement* kde_HTMLTableElement_caption(kde_HTMLTableElement* instPointer);

/** 
 see @ref caption
     
*/
void kde_HTMLTableElement_setCaption(kde_HTMLTableElement* instPointer,kde_HTMLTableCaptionElement* arg1);

/** 
 Returns the table's <code> THEAD </code> , or <code> null
 </code> if none exists.

     
*/
kde_HTMLTableSectionElement* kde_HTMLTableElement_tHead(kde_HTMLTableElement* instPointer);

/** 
 see @ref tHead
     
*/
void kde_HTMLTableElement_setTHead(kde_HTMLTableElement* instPointer,kde_HTMLTableSectionElement* arg1);

/** 
 Returns the table's <code> TFOOT </code> , or <code> null
 </code> if none exists.

     
*/
kde_HTMLTableSectionElement* kde_HTMLTableElement_tFoot(kde_HTMLTableElement* instPointer);

/** 
 see @ref tFoot
     
*/
void kde_HTMLTableElement_setTFoot(kde_HTMLTableElement* instPointer,kde_HTMLTableSectionElement* arg1);

/** 
 Returns a collection of all the rows in the table, including
 all in <code> THEAD </code> , <code> TFOOT </code> , all <code>
 TBODY </code> elements.

     
*/
kde_HTMLCollection* kde_HTMLTableElement_rows(kde_HTMLTableElement* instPointer);

/** 
 Returns a collection of the defined table bodies.

     
*/
kde_HTMLCollection* kde_HTMLTableElement_tBodies(kde_HTMLTableElement* instPointer);

/** 
 Specifies the table's position with respect to the rest of the
 document. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-align-TABLE">
 align attribute definition </a> in HTML 4.0. This attribute is
 deprecated in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLTableElement_align(kde_HTMLTableElement* instPointer);

/** 
 see @ref align
     
*/
void kde_HTMLTableElement_setAlign(kde_HTMLTableElement* instPointer,kde_DOMString* arg1);

/** 
 Cell background color. See the <a
 href="http://www.w3.org/TR/REC-html40/present/graphics.html#adef-bgcolor">
 bgcolor attribute definition </a> in HTML 4.0. This attribute
 is deprecated in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLTableElement_bgColor(kde_HTMLTableElement* instPointer);

/** 
 see @ref bgColor
     
*/
void kde_HTMLTableElement_setBgColor(kde_HTMLTableElement* instPointer,kde_DOMString* arg1);

/** 
 The width of the border around the table. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-border-TABLE">
 border attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLTableElement_border(kde_HTMLTableElement* instPointer);

/** 
 see @ref border
     
*/
void kde_HTMLTableElement_setBorder(kde_HTMLTableElement* instPointer,kde_DOMString* arg1);

/** 
 Specifies the horizontal and vertical space between cell
 content and cell borders. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-cellpadding">
 cellpadding attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLTableElement_cellPadding(kde_HTMLTableElement* instPointer);

/** 
 see @ref cellPadding
     
*/
void kde_HTMLTableElement_setCellPadding(kde_HTMLTableElement* instPointer,kde_DOMString* arg1);

/** 
 Specifies the horizontal and vertical separation between cells.
 See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-cellspacing">
 cellspacing attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLTableElement_cellSpacing(kde_HTMLTableElement* instPointer);

/** 
 see @ref cellSpacing
     
*/
void kde_HTMLTableElement_setCellSpacing(kde_HTMLTableElement* instPointer,kde_DOMString* arg1);

/** 
 Specifies which external table borders to render. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-frame">
 frame attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLTableElement_frame(kde_HTMLTableElement* instPointer);

/** 
 see @ref frame
     
*/
void kde_HTMLTableElement_setFrame(kde_HTMLTableElement* instPointer,kde_DOMString* arg1);

/** 
 Specifies which internal table borders to render. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-rules">
 rules attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLTableElement_rules(kde_HTMLTableElement* instPointer);

/** 
 see @ref rules
     
*/
void kde_HTMLTableElement_setRules(kde_HTMLTableElement* instPointer,kde_DOMString* arg1);

/** 
 Supplementary description about the purpose or structure of a
 table. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-summary">
 summary attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLTableElement_summary(kde_HTMLTableElement* instPointer);

/** 
 see @ref summary
     
*/
void kde_HTMLTableElement_setSummary(kde_HTMLTableElement* instPointer,kde_DOMString* arg1);

/** 
 Specifies the desired table width. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.html#adef-width-TABLE">
 width attribute definition </a> in HTML 4.0.

     
*/
kde_DOMString* kde_HTMLTableElement_width(kde_HTMLTableElement* instPointer);

/** 
 see @ref width
     
*/
void kde_HTMLTableElement_setWidth(kde_HTMLTableElement* instPointer,kde_DOMString* arg1);

/** 
 Create a table header row or return an existing one.

     
*/
kde_HTMLElement* kde_HTMLTableElement_createTHead(kde_HTMLTableElement* instPointer);

/** 
 Delete the header from the table, if one exists.

     
*/
void kde_HTMLTableElement_deleteTHead(kde_HTMLTableElement* instPointer);

/** 
 Create a table footer row or return an existing one.

     
*/
kde_HTMLElement* kde_HTMLTableElement_createTFoot(kde_HTMLTableElement* instPointer);

/** 
 Delete the footer from the table, if one exists.

     
*/
void kde_HTMLTableElement_deleteTFoot(kde_HTMLTableElement* instPointer);

/** 
 Create a new table caption object or return an existing one.

     
*/
kde_HTMLElement* kde_HTMLTableElement_createCaption(kde_HTMLTableElement* instPointer);

/** 
 Delete the table caption, if one exists.

     
*/
void kde_HTMLTableElement_deleteCaption(kde_HTMLTableElement* instPointer);

/** 
 Insert a new empty row in the table. Note. A table row cannot
 be empty according to HTML 4.0 Recommendation.

     
*/
kde_HTMLElement* kde_HTMLTableElement_insertRow(kde_HTMLTableElement* instPointer,long index);

/** 
 Delete a table row.

     
*/
void kde_HTMLTableElement_deleteRow(kde_HTMLTableElement* instPointer,long index);

#endif
