/***************************************************************************
                            kde_DOMDocument.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_DOMDOCUMENT
#define KDE_DOMDOCUMENT

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 The <code> Document </code> interface represents the entire HTML or
 XML document. Conceptually, it is the root of the document tree,
 and provides the primary access to the document's data.

  Since elements, text nodes, comments, processing instructions,
 etc. cannot exist outside the context of a <code> Document </code>
 , the <code> Document </code> interface also contains the factory
 methods needed to create these objects. The <code> Node </code>
 objects created have a <code> ownerDocument </code> attribute which
 associates them with the <code> Document </code> within whose
 context they were created.

 
 @short 
 The <code> Document </code> interface represents the entire HTML or
 XML document.
*/
//kde_DOMDocument * kde_new_DOMDocument();

/**
 don't create an implementation if false
 use at own risk

*/
//kde_DOMDocument * kde_new_DOMDocument1(int arg1);
//kde_DOMDocument * kde_new_DOMDocument2(kde_DOMDocument* other);
//kde_DOMDocument * kde_new_DOMDocument3(kde_DOMNode* other);
//void kde_del_DOMDocument( kde_DOMDocument* p );

/**
 The Document Type Declaration (see <code> DocumentType </code>
 ) associated with this document. For HTML documents as well as
 XML documents without a document type declaration this returns
 <code> null </code> . The DOM Level 1 does not support editing
 the Document Type Declaration, therefore <code> docType </code>
 cannot be altered in any way.

     
*/
kde_DocumentType* kde_DOMDocument_doctype(kde_DOMDocument* instPointer);

/** 
 The <code> DOMImplementation </code> object that handles this
 document. A DOM application may use objects from multiple
 implementations.

     
*/
//kde_DOMImplementation* kde_DOMDocument_implementation(kde_DOMDocument* instPointer);

/** 
 This is a convenience attribute that allows direct access to
 the child node that is the root element of the document. For
 HTML documents, this is the element with the tagName "HTML".

     
*/
kde_Element* kde_DOMDocument_documentElement(kde_DOMDocument* instPointer);

/** 
 Creates an element of the type specified. Note that the
 instance returned implements the Element interface, so
 attributes can be specified directly on the returned object.

     
*/
kde_Element* kde_DOMDocument_createElement(kde_DOMDocument* instPointer,kde_DOMString* tagName);

/** 
 Introduced in DOM Level 2
 Creates an element of the given qualified name and namespace URI.

*/
kde_Element* kde_DOMDocument_createElementNS(kde_DOMDocument* instPointer,kde_DOMString* namespaceURI, kde_DOMString* qualifiedName);

/** 
 Creates an empty <code> DocumentFragment </code> object.

     
*/
//kde_DOMDocumentFragment* kde_DOMDocument_createDocumentFragment(kde_DOMDocument* instPointer);

/** 
 Creates a <code> Text </code> node given the specified string.

     
*/
kde_Text* kde_DOMDocument_createTextNode(kde_DOMDocument* instPointer,kde_DOMString* data);

/** 
 Creates a <code> Comment </code> node given the specified
 string.

     
*/
kde_Comment* kde_DOMDocument_createComment(kde_DOMDocument* instPointer,kde_DOMString* data);

/** 
 Creates a <code> CDATASection </code> node whose value is the
 specified string.

     
*/
kde_CDATASection* kde_DOMDocument_createCDATASection(kde_DOMDocument* instPointer,kde_DOMString* data);

/** 
 Creates a <code> ProcessingInstruction </code> node given the
 specified name and data strings.

  NOT_SUPPORTED_ERR: Raised if this document is an HTML
 document.

     
*/
kde_ProcessingInstruction* kde_DOMDocument_createProcessingInstruction(kde_DOMDocument* instPointer,kde_DOMString* target, kde_DOMString* data);

/** 
 Creates an <code> Attr </code> of the given name. Note that the
 <code> Attr </code> instance can then be set on an <code>
 Element </code> using the <code> setAttribute </code> method.

     
*/
kde_Attr* kde_DOMDocument_createAttribute(kde_DOMDocument* instPointer,kde_DOMString* name);

/** 
 Introduced in DOM Level 2
 Creates an attribute of the given qualified name and namespace URI.
 HTML-only DOM implementations do not need to implement this method.

*/
kde_Attr* kde_DOMDocument_createAttributeNS(kde_DOMDocument* instPointer,kde_DOMString* namespaceURI, kde_DOMString* qualifiedName);

/** 
 Creates an EntityReference object.

  NOT_SUPPORTED_ERR: Raised if this document is an HTML
 document.

     
*/
kde_EntityReference* kde_DOMDocument_createEntityReference(kde_DOMDocument* instPointer,kde_DOMString* name);

/** 
 Moved from HTMLDocument in DOM Level 2
 Returns the Element whose <code> id </code> is given by
 elementId. If no such element exists, returns <code> null
 </code> . Behavior is not defined if more than one element has
 this <code> id </code> .

     
*/
kde_Element* kde_DOMDocument_getElementById(kde_DOMDocument* instPointer,kde_DOMString* elementId);

/** 
 No Exceptions.

 Returns a <code> NodeList </code> of all the <code> Element
 </code> s with a given tag name in the order in which they
 would be encountered in a preorder traversal of the <code>
 Document </code> tree.

     
*/
kde_DOMNodeList* kde_DOMDocument_getElementsByTagName(kde_DOMDocument* instPointer,kde_DOMString* tagname);

/** 
 Introduced in DOM Level 2
 No Exceptions

 Returns a NodeList of all the Elements with a given local name and
 namespace URI in the order in which they are encountered in a preorder
 traversal of the Document tree.

*/
kde_DOMNodeList* kde_DOMDocument_getElementsByTagNameNS(kde_DOMDocument* instPointer,kde_DOMString* namespaceURI, kde_DOMString* localName);

/** 
 Introduced in DOM Level 2

 Imports a node from another document to this document. The returned node
 has no parent; (parentNode is null). The source node is not altered or
 removed from the original document; this method creates a new copy of
 the source node.

 For all nodes, importing a node creates a node object owned by the
 importing document, with attribute values identical to the source node's
 nodeName and nodeType, plus the attributes related to namespaces
 (prefix, localName, and namespaceURI).

 As in the cloneNode operation on a Node, the source node is not altered.
 Additional information is copied as appropriate to the nodeType,
 attempting to mirror the behavior expected if a fragment of XML or HTML
 source was copied from one document to another, recognizing that the two
 documents may have different DTDs in the XML case. The following list
 describes the specifics for each type of node.

 ATTRIBUTE_NODE
 The ownerElement attribute is set to null and the specified flag is set
 to true on the generated Attr. The descendants of the source Attr are
 recursively imported and the resulting nodes reassembled to form the
 corresponding subtree. Note that the deep parameter has no effect on
 Attr nodes; they always carry their children with them when imported.

 DOCUMENT_FRAGMENT_NODE
 If the deep option was set to true, the descendants of the source
 element are recursively imported and the resulting nodes reassembled to
 form the corresponding subtree. Otherwise, this simply generates an
 empty DocumentFragment.

 DOCUMENT_NODE
 Document nodes cannot be imported.

 DOCUMENT_TYPE_NODE
 DocumentType nodes cannot be imported.

 ELEMENT_NODE
 Specified attribute nodes of the source element are imported, and the
 generated Attr nodes are attached to the generated Element. Default
 attributes are not copied, though if the document being imported into
 defines default attributes for this element name, those are assigned. If
 the importNode deep parameter was set to true, the descendants of the
 source element are recursively imported and the resulting nodes
 reassembled to form the corresponding subtree.

 ENTITY_NODE
 Entity nodes can be imported, however in the current release of the DOM
 the DocumentType is readonly. Ability to add these imported nodes to a
 DocumentType will be considered for addition to a future release of the
 DOM.
 On import, the publicId, systemId, and notationName attributes are
 copied. If a deep import is requested, the descendants of the the source
 Entity are recursively imported and the resulting nodes reassembled to
 form the corresponding subtree.

 ENTITY_REFERENCE_NODE Only the EntityReference itself is copied, even if
 a deep import is requested, since the source and destination documents
 might have defined the entity differently. If the document being
 imported into provides a definition for this entity name, its value is
 assigned.

 NOTATION_NODE
 Notation nodes can be imported, however in the current release of the
 DOM the DocumentType is readonly. Ability to add these imported nodes to
 a DocumentType will be considered for addition to a future release of
 the DOM.
 On import, the publicId and systemId attributes are copied.
 Note that the deep parameter has no effect on Notation nodes since they
 never have any children.

 PROCESSING_INSTRUCTION_NODE
 The imported node copies its target and data values from those of the
 source node.

 TEXT_NODE, CDATA_SECTION_NODE, COMMENT_NODE
 These three types of nodes inheriting from CharacterData copy their data
 and length attributes from those of the source node.

 @paramimportedNode The node to import.

*/
kde_DOMNode* kde_DOMDocument_importNode(kde_DOMDocument* instPointer,kde_DOMNode* importedNode, int deep);

/** 

 not part of the DOM
     
*/
int kde_DOMDocument_isHTMLDocument(kde_DOMDocument* instPointer);

/** 
 Introduced in DOM Level 2
 This method is from the DocumentRange interface

*/
kde_Range* kde_DOMDocument_createRange(kde_DOMDocument* instPointer);

/** 
 Introduced in DOM Level 2
 This method is from the DocumentTraversal interface

 Create a new NodeIterator over the subtree rooted at the specified node.

*/
kde_NodeIterator* kde_DOMDocument_createNodeIterator(kde_DOMDocument* instPointer,kde_DOMNode* root, unsigned long whatToShow, kde_NodeFilter* filter, int entityReferenceExpansion);

/** 
 Introduced in DOM Level 2
 This method is from the DocumentTraversal interface

 Create a new TreeWalker over the subtree rooted at the specified node.

*/
kde_TreeWalker* kde_DOMDocument_createTreeWalker(kde_DOMDocument* instPointer,kde_DOMNode* root, unsigned long whatToShow, kde_NodeFilter* filter, int entityReferenceExpansion);

/** 
 Introduced in DOM Level 2
 This method is from the DocumentEvent interface

 The createEvent method is used in creating Events when it is either
 inconvenient or unnecessary for the user to create an Event themselves.
 In cases where the implementation provided Event is insufficient, users
 may supply their own Event implementations for use with the
 dispatchEvent method.

*/

/**
 Introduced in DOM Level 2
 This method is from the DocumentView interface

 The default AbstractView for this Document, or null if none available.

*/
//AbstractView kde_DOMDocument_defaultView(kde_DOMDocument* instPointer);

/**
 Introduced in DOM Level 2
 This method is from the DocumentStyle interface

 A list containing all the style sheets explicitly linked into or
 embedded in a document. For HTML documents, this includes external style
 sheets, included via the HTML LINK element, and inline STYLE elements.
 In XML, this includes external style sheets, included via style sheet
 processing instructions (see [XML-StyleSheet]).

*/
kde_StyleSheetList kde_DOMDocument_styleSheets(kde_DOMDocument* instPointer);

/**

*/
kde_KHTMLView* kde_DOMDocument_view(kde_DOMDocument* instPointer);

/**
 Introduced in DOM Level 2
 This method is from the DocumentCSS interface

 This method is used to retrieve the override style declaration for a
 specified element and a specified pseudo-element.

*/
kde_CSSStyleDeclaration* kde_DOMDocument_getOverrideStyle(kde_DOMDocument* instPointer,kde_Element* elt, kde_DOMString* pseudoElt);

/** 
 not part of the DOM

 completes a given URL
     
*/
kde_DOMString* kde_DOMDocument_completeURL(kde_DOMDocument* instPointer,kde_DOMString* url);

#endif
