/***************************************************************************
                            kde_CDATASection.h -  description
                             -------------------
    begin                : Wed Feb  6 15:12:26 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Wed Feb  6 15:12:26 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_CDATASECTION
#define KDE_CDATASECTION

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**

 CDATA sections are used to escape blocks of text containing
 characters that would otherwise be regarded as markup. The only
 delimiter that is recognized in a CDATA section is the "]]&gt;"
 string that ends the CDATA section. CDATA sections can not be
 nested. The primary purpose is for including material such as XML
 fragments, without needing to escape all the delimiters.

  The <code> DOMString </code> attribute of the <code> Text </code>
 node holds the text that is contained by the CDATA section. Note
 that this may contain characters that need to be escaped outside of
 CDATA sections and that, depending on the character encoding
 ("charset") chosen for serialization, it may be impossible to write
 out some characters as part of a CDATA section.

  The <code> CDATASection </code> interface inherits the <code>
 CharacterData </code> interface through the <code> Text </code>
 interface. Adjacent <code> CDATASections </code> nodes are not
 merged by use of the Element.normalize() method.

 
 @short 
 CDATA sections are used to escape blocks of text containing
 characters that would otherwise be regarded as markup.
*/
kde_CDATASection * kde_new_CDATASection();
kde_CDATASection * kde_new_CDATASection1(kde_CDATASection* other);
kde_CDATASection * kde_new_CDATASection2(kde_DOMNode* other);
void kde_del_CDATASection( kde_CDATASection* p );

#endif
