/*****************************************************************

Copyright (c) 2001 Matthias Elter <elter@kde.org>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <kiconloader.h>
#include <klocale.h>
#include <kglobal.h>
#include <kdebug.h>

#include "pluginmanager.h"
#include "pluginloader.h"
#include "panelbutton.h"
#include "containerarea.h"
#include "container_base.h"
#include "container_button.h"

#include "removespecialbutton_mnu.h"
#include "removespecialbutton_mnu.moc"

PanelRemoveSpecialButtonMenu::PanelRemoveSpecialButtonMenu( ContainerArea* cArea,
					      QWidget *parent, const char *name )
    : QPopupMenu( parent, name ), containerArea( cArea )
{
    connect( this, SIGNAL( activated( int ) ), SLOT( slotExec( int ) ) );
    connect( this, SIGNAL( aboutToShow() ), SLOT( slotAboutToShow() ) );

    containers.setAutoDelete( FALSE );
}

void PanelRemoveSpecialButtonMenu::slotAboutToShow()
{
    int id = 0;

    clear();
    containers.clear();
    QPtrList<BaseContainer> list = containerArea->containers( "All" );

    for( QPtrListIterator<BaseContainer> it( list ); it.current() ; ++it ) {

	if ( it.current()->appletType() == "KMenuButton" ) {
	    insertItem( SmallIconSet("go"), "K Menu", id );
	    containers.append( it.current() );
	    id++;
	}
	else if ( it.current()->appletType() == "WindowListButton" ) {
	    insertItem( SmallIconSet("window_list"), "Windowlist", id );
	    containers.append( it.current() );
	    id++;
	}
	else if ( it.current()->appletType() == "BookmarksButton" ) {
	    insertItem( SmallIconSet("bookmark"), "Bookmarks", id );
	    containers.append( it.current() );
	    id++;
	}
	else if ( it.current()->appletType() == "RecentDocumentsButton" ) {
	    insertItem( SmallIconSet("document"), "Recent Documents", id );
	    containers.append( it.current() );
	    id++;
	}
	else if ( it.current()->appletType() == "DesktopButton" ) {
	    insertItem( SmallIconSet("desktop"), "Desktop Access", id );
	    containers.append( it.current() );
	    id++;
	}
	else if ( it.current()->appletType() == "BrowserButton" ) {
	    insertItem( SmallIconSet("kdisknav"), "Quick Browser", id );
	    containers.append( it.current() );
	    id++;
	}
	else if ( it.current()->appletType() == "ExecButton" ) {
	    insertItem( SmallIconSet("exec"), "Non-KDE Application", id );
	    containers.append( it.current() );
	    id++;
	}
	else if ( it.current()->appletType() == "KonsoleButton" ) {
	    insertItem( SmallIconSet("konsole"), "Terminal Sessions", id );
	    containers.append( it.current() );
	    id++;
	}
	else if ( it.current()->appletType() == "ExtensionButton" ) {
	    ButtonContainer* c = static_cast<ButtonContainer*>( it.current() );
	    insertItem( SmallIconSet( c->button()->icon() ), c->button()->title(), id );
	    containers.append( it.current() );
	    id++;
	}
    }

    if ( containers.count() > 1 ) {
	insertSeparator();
	insertItem( i18n( "All" ), this, SLOT( slotRemoveAll() ) );
    }
}

void PanelRemoveSpecialButtonMenu::slotExec( int id )
{
    if ( containers.at( id ) )
	containerArea->removeContainer( containers.at( id ) );
}

PanelRemoveSpecialButtonMenu::~PanelRemoveSpecialButtonMenu()
{

}

void PanelRemoveSpecialButtonMenu::slotRemoveAll()
{
    for( QPtrListIterator<BaseContainer> it( containers ); it.current() ; ++it )
	containerArea->removeContainer( it.current() );
}
