/*
 * GQview
 * (C) 2001 John Ellis
 *
 * Author: John Ellis
 *
 * This software is released under the GNU General Public License (GNU GPL).
 * Please read the included file COPYING for more information.
 * This software comes with no warranty of any kind, use at your own risk!
 */


#ifndef SLIDESHOW_H
#define SLIDESHOW_H


/*
 * It works like this, it uses path_list, if that does not exist, it uses
 * CollectionData, then finally falls back to the file listing.
 */


typedef struct _SlideShowData SlideShowData;
struct _SlideShowData
{
	ImageWindow *imd;

	GList *path_list;
	CollectionData *cd;
	gchar *filelist_path;

	GList *list;
	GList *list_done;

	gchar *slide_path;

	gint slide_count;
	gint timeout_id;

	gint from_selection;

	void (*stop_func)(SlideShowData *, gpointer);
	gpointer stop_data;

	gint paused;
};


void slideshow_free(SlideShowData *ss);

gint slideshow_should_continue(SlideShowData *ss);

void slideshow_next(SlideShowData *ss);
void slideshow_prev(SlideShowData *ss);

SlideShowData *slideshow_start_from_path_list(ImageWindow *imd, GList *list,
					      void (*stop_func)(SlideShowData *, gpointer), gpointer stop_data);
SlideShowData *slideshow_start_from_collection(ImageWindow *imd, CollectionData *cd,
					       void (*stop_func)(SlideShowData *, gpointer), gpointer stop_data,
					       CollectInfo *start_info);
SlideShowData *slideshow_start(ImageWindow *imd,
			       void (*stop_func)(SlideShowData *, gpointer), gpointer stop_data,
			       gint start_point);


gint slideshow_paused(SlideShowData *ss);
void slideshow_pause_set(SlideShowData *ss, gint paused);
gint slideshow_pause_toggle(SlideShowData *ss);


#endif
