/***************************
 TCP peer to peer functions
 (c) 1999 Jeremy Wise
 GnomeICU
****************************/

#ifndef __TCP_H__
#define __TCP_H__

#include <gdk/gdk.h>
#include <gtk/gtk.h>
#include "datatype.h"
#include "filexfer.h"

#define TCP_VERSION 0x03

#define ICQ_CMDxTCP_START             0x07EE
#define ICQ_CMDxTCP_CANCEL            0x07D0
#define ICQ_CMDxTCP_ACK               0x07DA
#define ICQ_CMDxTCP_MSG               0x0001
#define ICQ_CMDxTCP_FILE              0x0003
#define ICQ_CMDxTCP_CHAT              0x0002
#define ICQ_CMDxTCP_URL               0x0004
#define ICQ_CMDxTCP_CONT_LIST         0x0013
#define ICQ_CMDxTCP_VERSION           0x0099
#define ICQ_CMDxTCP_READxAWAYxMSG     0x03E8
#define ICQ_CMDxTCP_READxOCCxMSG      0x03E9
#define ICQ_CMDxTCP_READxNAxMSG       0x03EA
#define ICQ_CMDxTCP_READxDNDxMSG      0x03EB
#define ICQ_CMDxTCP_HANDSHAKE         0x03FF
#define ICQ_CMDxTCP_HANDSHAKE2        0x04FF
#define ICQ_CMDxTCP_HANDSHAKE3        0x02FF

#define ICQ_ACKxTCP_ONLINE            0x0000
#define ICQ_ACKxTCP_AWAY              0x0004
#define ICQ_ACKxTCP_NA                0x000E
#define ICQ_ACKxTCP_DND               0x000A
#define ICQ_ACKxTCP_OCC               0x0009
#define ICQ_ACKxTCP_REFUSE            0x0001

#define FONT_PLAIN                    0x00000000
#define FONT_BOLD                     0x00000001
#define FONT_ITALICS                  0x00000002
#define FONT_UNDERLINE                0x00000004

extern const DWORD LOCALHOST;

/*** File transfer defines ***/

#define XFER_DIRECTION_SENDING		0
#define XFER_DIRECTION_RECEIVING	1

#define XFER_STATUS_PENDING		0
#define XFER_STATUS_CONNECTING		1
#define XFER_STATUS_TRANSFERING		2

extern GSList *pending_xfers;
extern gint max_tcp_port;
extern gint min_tcp_port;

struct file_struct {
	char *short_filename;
	char *full_filename;

	guint total_bytes;
	guint completed_bytes;

	time_t start_time;
};

/* All TCP packets will have this information */
typedef struct
{
	guint seq;
	gchar *text;
	BYTE *data;
	UIN_T uin;
	gint timeout;
	gboolean sent;
	GtkWidget *dialog;
} tcp_message;

tcp_message *tcp_prepare_message( CONTACT_PTR contact, BYTE *data,
                                  gchar *text, gint seq,
                                  gboolean prepend );

int TCPGainConnection( DWORD ip, WORD port, GSList *contact );
int TCPClearQueue( GSList *contact );

int TCPSendMessage( UIN_T uin, gchar *msg );
int TCPSendURL( UIN_T uin, gchar *msg );
int TCPAcceptIncoming( gpointer data, int sock, GdkInputCondition cond );
int TCPRetrieveAwayMessage( GSList *contact, gpointer data );
int TCPRetrieveVersion( GSList *contact, gpointer data );

int TCPAcceptFile( XferInfo *xfer );
int TCPRefuseFile( XferInfo *xfer );
int TCPSendFileRequest( UIN_T uin, const gchar *msg, GSList *files );

void skip_file( GtkWidget *, XferInfo *xfer);
void cancel_transfer( GtkWidget *, XferInfo *xfer);

void TCPSendContactList( GtkWidget *widget, gpointer data );

#endif /* __TCP_H__ */
