/***********************************
 Update contact list in main window
 (c) 1999 Jeremy Wise
 (c) 2001 Gediminas Paulauskas
 GnomeICU
************************************/

#include "common.h"
#include "events.h"
#include "gnomecfg.h"
#include "gnomeicu.h"
#include "gtkconf.h"
#include "icons.h"
#include "showlist.h"
#include "v7send.h"
#include "v7snac13.h"

GSList *OnlineList = NULL;
GSList *OfflineList = NULL;

static void set_foreground_for_contact( GtkCList *list, gint index, CONTACT_PTR contact );

/* This is a wrapper for Show_Quick_Status_lower */
void Show_Quick_Status( void )
{
	Show_Quick_Status_lower (FALSE, NULL);
}

/* Manage the online and offline lists of the main */
/* window's display                                */
void Show_Quick_Status_lower( int forced_update, GSList *passed_contact )
{
	char *statusbuf[2];

	#define PlayOnline 1
	#define PlayOffline 2

	int row = 0;
	static int preshown = FALSE;
	GSList *contact;

	GtkWidget *sellist;

	gboolean not_is_vis = FALSE;
	static gboolean not_was_vis = FALSE;

	gint highlighted_on;
	gint highlighted_off;
	gint highlighted_not;

	gboolean on_changed = FALSE;
	gboolean off_changed = FALSE;
	gboolean not_changed = FALSE;

	int cx;
	UIN_T uin;

#ifdef TRACE_FUNCTION
	g_print( "Show_Quick_Status_lower\n" );
#endif

	if( passed_contact != NULL )
	{
		/* This means that we are removing someone */
		/* We'll take care of that right here */
		OnlineList = g_slist_remove( OnlineList, passed_contact->data );
		OfflineList = g_slist_remove( OfflineList, passed_contact->data );
                /*v7_remcontact(((CONTACT_PTR)passed_contact->data)->uin);*/
		/*v7_remove_contact (((CONTACT_PTR)passed_contact->data)->nick);*/
		Contacts = g_slist_remove (Contacts, passed_contact->data);
		g_free (passed_contact->data);
		Save_RC();
	}

	/* Which list(s) do we have to update, if any? */
	if( forced_update & UPDATE_NOTLIST )
		not_changed = TRUE;
	if( forced_update & UPDATE_ONLINE )
		on_changed = TRUE;
	if( forced_update & UPDATE_OFFLINE )
		off_changed = TRUE;
	if (forced_update & UPDATE_RECONSTRUCT) {
		preshown = FALSE;
		g_slist_free (OnlineList);
		g_slist_free (OfflineList);
		OnlineList = NULL;
		OfflineList = NULL;
	}

	/* This makes for smoother updates :-) */
	gtk_clist_freeze( GTK_CLIST( MainData->lb_userwin_online ) );
	gtk_clist_freeze( GTK_CLIST( MainData->lb_userwin_offline ) );
	gtk_clist_freeze( GTK_CLIST( MainData->lb_userwin_notinlist ) );

	contact = Contacts;


	/* Find out if there's any reason to */
	/* show the Not in List tab...       */
	while( contact != NULL )
	{
		if( kontakt->inlist == FALSE &&
		    kontakt->ignore_list == FALSE &&
		    kontakt->confirmed == TRUE &&
		    toggles->no_new_users == FALSE )
		{
			not_is_vis = TRUE;
			break;
		}
		contact = contact->next;
	}

	/* If the tab isn't already shown, let's show it now */
	if( not_is_vis && !not_was_vis )
	{
		not_was_vis = TRUE;
		gtk_widget_show (MainData->not_contents);
	}

	/* Do we have to hide it (last contact was taken off) */
	else if( not_was_vis && !not_is_vis )
	{
		not_was_vis = FALSE;
		gtk_widget_hide (MainData->not_contents);

		/* Move the current page to online, because that's */
		/* most likely the tab the user wants to see       */
		gtk_notebook_set_page( GTK_NOTEBOOK( MainData->notebook ), 0 );
	}

	contact = Contacts;

	/* Here we go... cycle each contact */
	while( contact != NULL )
	{
		/* I have no idea why it would be negative, */
		/* but we definitely don't want to process  */
		/* it if it IS negative :-)                 */
		if( kontakt->uin <= 0 )
		{
			contact = contact->next;
			continue;
		}

                /* skip displaying contact if no valid uid */
                if (kontakt->uid == 0 && kontakt->inlist == TRUE) {
                  contact = contact->next;
                  continue;
                }

		switch( kontakt->status & 0xffff )
		{
		case STATUS_OCCUPIED_MAC:
			kontakt->status = ( kontakt->status & 0xffff0000 ) | STATUS_OCCUPIED;
			break;
		case STATUS_NA_99A:
			kontakt->status = ( kontakt->status & 0xffff0000 ) | STATUS_NA;
		default:
		}

		/* Is the contact in some kind of online status? */
		if( kontakt->status != STATUS_OFFLINE )
		{
			/* FIXME: What's going on here?? */
			if( kontakt->icon_p == icon_message_pixmap ||
			    g_slist_length( kontakt->stored_messages ) == 0 )
			{
				kontakt->icon_p = get_pixmap_for_status( kontakt->status );
				kontakt->icon_b = get_bitmap_for_status( kontakt->status );
			}

			/* If they've just changed status, we need to change */
			/* the icon for their name                           */
			if( kontakt->last_status != kontakt->status ||
			    kontakt->need_update )
			{
				/* If they were just offline, then we need to */
				/* move them from the offline GSList to the   */
				/* online GSList                              */
				if( kontakt->last_status == STATUS_OFFLINE )
				{
					OnlineList = g_slist_append( OnlineList, kontakt );
					OfflineList = g_slist_remove( OfflineList, kontakt );
					/* If they're not ignored, play a sound */
					if (kontakt->ignore_list == FALSE && kontakt->confirmed == TRUE) {
						gnomeicu_event (EV_USERON, kontakt->uin);
					}
					/* If they're a member of our list, */
					/* our online list has changed      */
					if( kontakt->inlist )
						on_changed = TRUE;
					/* Otherwise, our Not In list has.. */
					else
						not_changed = TRUE;
				}
				else
					/* In previous case everything will be
					 * redrawn anyway */
					Update_Contact_Style( Which_List( kontakt ), kontakt );

				kontakt->last_status = kontakt->status;
			}
		}
		else  /* kontakt->status == STATUS_OFFLINE */
		{
			/* FIXME: Again, what is this?? */
			if( kontakt->icon_p == icon_message_pixmap ||
			    g_slist_length( kontakt->stored_messages ) == 0 )
			{
				kontakt->icon_p = get_pixmap_for_status( kontakt->status );
				kontakt->icon_b = get_bitmap_for_status( kontakt->status );
			}

			/* Update the icon/color of the contact? */
			if( kontakt->need_update )
				Update_Contact_Style( Which_List( kontakt ), kontakt );

			/* Do we need to add them to the offline list? */
			if( kontakt->last_status != STATUS_OFFLINE || !preshown ||
			    kontakt->need_update )
			{
				/* This if/else makes sure contacts who go offline */
				/* are added to the top of the list, and the list  */
				/* isn't initiated in reverse-alphabetical order   */
				if (!preshown)
					OfflineList = g_slist_append( OfflineList, kontakt );
				else
					OfflineList = g_slist_prepend( OfflineList, kontakt );

				/* We need to take them off the online list if they're there */
				if( preshown )
				{
					OnlineList = g_slist_remove( OnlineList, kontakt );
					if (kontakt->ignore_list == FALSE && kontakt->confirmed == TRUE) {
						gnomeicu_event (EV_USEROFF, kontakt->uin);
					}
				}

				/* Which list do we need to update? */
				if( kontakt->inlist )
					off_changed = TRUE;
				else
					not_changed = TRUE;
			}

			kontakt->last_status = STATUS_OFFLINE;
		}

		contact = contact->next;
	}

	preshown = TRUE;

	/* If nothing's changed, we're finished! */
	if( !on_changed && !off_changed && !not_changed )
	{
		gtk_clist_thaw( GTK_CLIST( MainData->lb_userwin_online ) );
		gtk_clist_thaw( GTK_CLIST( MainData->lb_userwin_offline ) );
		gtk_clist_thaw( GTK_CLIST( MainData->lb_userwin_notinlist ) );
		return;
	}

	/* Try to maintain the highlighted row.  GtkCList is a REALLY */
	/* bad widget.  This should actually work, but it doesn't     */
	highlighted_on = GTK_CLIST( MainData->lb_userwin_online )->focus_row;
	highlighted_off = GTK_CLIST( MainData->lb_userwin_offline )->focus_row;
	highlighted_not = GTK_CLIST( MainData->lb_userwin_notinlist )->focus_row;

	/* Clear any GtkCList that we need to modify */
	if( on_changed )
		gtk_clist_clear( GTK_CLIST( MainData->lb_userwin_online ) );
	if( off_changed )
		gtk_clist_clear( GTK_CLIST( MainData->lb_userwin_offline ) );
	if( not_changed )
		gtk_clist_clear( GTK_CLIST( MainData->lb_userwin_notinlist ) );

	if( on_changed || not_changed )
	{
		contact = OnlineList;

		/* Cycle through the contacts and add each */
		/* to the appropriate list...              */
		while( contact != NULL )
		{
			if( ( !on_changed && kontakt->inlist ) ||
			    ( !not_changed && kontakt->inlist == FALSE ) ||
			    ( kontakt->ignore_list == TRUE ) ||
			    ( kontakt->confirmed == FALSE ) )
			{
				contact = contact->next;
				continue;
			}

			if( kontakt->inlist == TRUE )
				sellist = MainData->lb_userwin_online;
			else
				sellist = MainData->lb_userwin_notinlist;

			statusbuf[0] = "";
			statusbuf[1] = kontakt->nick;
			row = gtk_clist_append( GTK_CLIST( sellist ),
			                        statusbuf );
			gtk_clist_set_row_data( GTK_CLIST( sellist ), row,
						GINT_TO_POINTER( kontakt->uin ) );
			kontakt->lb_index = row;

			Update_Contact_Style( GTK_CLIST(sellist), kontakt );

			contact = contact->next;
		}
	}

	if( off_changed || not_changed )
	{
		contact = OfflineList;

		/* Put the rest of them in here, too... */
		while( contact != NULL )
		{
			if( ( !off_changed && kontakt->inlist ) ||
			    ( !not_changed && kontakt->inlist == FALSE ) ||
			    ( kontakt->ignore_list == TRUE ) ||
			    ( kontakt->confirmed == FALSE ) )
			{
				contact = contact->next;
				continue;
			}

			if( kontakt->inlist == TRUE )
				sellist = MainData->lb_userwin_offline;
			else
				sellist = MainData->lb_userwin_notinlist;

			statusbuf[0] = "";
			statusbuf[1] = kontakt->nick;
			row = gtk_clist_append( GTK_CLIST( sellist ),
			                        statusbuf );
			gtk_clist_set_row_data( GTK_CLIST( sellist ), row,
						GINT_TO_POINTER( kontakt->uin ) );
			kontakt->lb_index = row;

			Update_Contact_Style( GTK_CLIST(sellist), kontakt );

			contact = contact->next;
		}
	}

	/* FIXME: this is very expensive! row data should be contact pointer,
	 * not uin */
	cx = 0;
	while ((uin = GPOINTER_TO_INT (gtk_clist_get_row_data (GTK_CLIST (MainData->lb_userwin_online), cx))) != 0) {
		contact = Contacts;
		while (contact != NULL) {
			if (kontakt->uin == uin) {
				kontakt->lb_index = cx;
				break;
			}
			contact = contact->next;
		}
		cx++;
	}

	cx = 0;
	while ((uin = GPOINTER_TO_INT (gtk_clist_get_row_data (GTK_CLIST (MainData->lb_userwin_offline), cx))) != 0) {
		contact = Contacts;
		while (contact != NULL) {
			if (kontakt->uin == uin) {
				kontakt->lb_index = cx;
				break;
			}
			contact = contact->next;
		}
		cx++;
	}

	cx = 0;
	while ((uin = GPOINTER_TO_INT (gtk_clist_get_row_data (GTK_CLIST (MainData->lb_userwin_notinlist), cx))) != 0) {
		contact = Contacts;
		while (contact != NULL) {
			if (kontakt->uin == uin) {
				kontakt->lb_index = cx;
				break;
			}
			contact = contact->next;
		}
		cx++;
	}

	/* Try to rehighlight the selected row */
	if( on_changed )
		gtk_clist_select_row( GTK_CLIST( MainData->lb_userwin_online ), highlighted_on, 0 );
	if( off_changed )
		gtk_clist_select_row( GTK_CLIST( MainData->lb_userwin_offline ), highlighted_off, 0 );
	if( not_changed )
		gtk_clist_select_row( GTK_CLIST( MainData->lb_userwin_notinlist ), highlighted_not, 0 );

	/* Thaw the lists, and we're outta here... */
	gtk_clist_thaw( GTK_CLIST( MainData->lb_userwin_online ) );
	gtk_clist_thaw( GTK_CLIST( MainData->lb_userwin_offline ) );
	gtk_clist_thaw( GTK_CLIST( MainData->lb_userwin_notinlist ) );

	return;
}

void Update_Contact_Style( GtkCList *sellist, CONTACT_PTR contact )
{
	contact->need_update = 0;

	gtk_clist_set_pixmap( GTK_CLIST( sellist ),
			      contact->lb_index, 0,
			      contact->icon_p, contact->icon_b );

	set_foreground_for_contact( sellist, contact->lb_index, contact );
}

void build_mass_list( GtkCList *uins_clist, GSList *current_contact )
{
   	GSList *contact;
	gint cx = 0;
   	gchar *titles[2];
	gboolean online = TRUE;

   	gtk_clist_freeze(uins_clist);

	contact = OnlineList;
	while( ( contact != NULL ) || online )
	{
		/* When online list is finished, jump to offline list */
		if( contact == NULL ) {
			if( OfflineList == NULL )
				break;
			online = FALSE;
			contact = OfflineList;
		}

		titles[0] = "";
		/* This is used in icq_sendmessage to get UIN */
		titles[1] = g_strdup_printf("%d", kontakt->uin);

		gtk_clist_append( uins_clist, titles );
		gtk_clist_set_pixtext( uins_clist, cx, 0, kontakt->nick, 3,
				       kontakt->icon_p, kontakt->icon_b );
		set_foreground_for_contact( uins_clist, cx, kontakt );

		if (current_contact == contact)
			gtk_clist_select_row(uins_clist, cx, 0);

		g_free( titles[1] );

		contact = contact->next;
		cx++;
	}

   	gtk_clist_thaw(uins_clist);
}

void set_foreground_for_contact( GtkCList *list, gint index, CONTACT_PTR contact )
{
	if( contact->status == STATUS_OFFLINE ) {
		gtk_clist_set_foreground( list, index, &color_offline );
		return;
	}

	switch ( contact->status & 0xffff )
	{
	case STATUS_ONLINE:
		gtk_clist_set_foreground( list, index, &color_online );
		break;
	case STATUS_FREE_CHAT:
		gtk_clist_set_foreground( list, index, &color_ffc );
		break;
	case STATUS_AWAY:
		gtk_clist_set_foreground( list, index, &color_away );
		break;
	case STATUS_NA:
		gtk_clist_set_foreground( list, index, &color_na );
		break;
	case STATUS_OCCUPIED:
		gtk_clist_set_foreground( list, index, &color_occ );
		break;
	case STATUS_DND:
		gtk_clist_set_foreground( list, index, &color_dnd );
		break;
	case STATUS_INVISIBLE:
		gtk_clist_set_foreground( list, index, &color_inv );
		break;
	}
}

GtkCList * Which_List( CONTACT_PTR contact )
{
	GtkWidget *l = NULL;
        if( contact->inlist == FALSE )
		l = MainData->lb_userwin_notinlist;
        else if( contact->status == STATUS_OFFLINE )
		l = MainData->lb_userwin_offline;
        else
		l = MainData->lb_userwin_online;
	return GTK_CLIST( l );
}

