#include "common.h"
#include "gnomeicu.h"
#include "listwindow.h"
#include "notify.h"

static void modify_notify_list( GtkWidget *widget, gpointer data );

static gboolean is_notify (CONTACT_PTR contact);
static void remove_func (CONTACT_PTR contact);

gboolean is_notify (CONTACT_PTR contact)
{
	return contact->online_notify == TRUE;
}

void remove_func (CONTACT_PTR contact)
{
  ;/*do nothing*/
}

void notify_list_dialog( void )
{
	static GtkWidget *dlg = NULL;
	
	if( dlg == NULL )
	{
		dlg = list_window_new(
			_("GnomeICU: Online Notify List"), "Online_Notify_List",
			_("Drag the users you wish to add to your\n"
			  "notify list into this window, and then click\n"
			  "the \"Apply\" button below."),
			GNOME_STOCK_BUTTON_OK, NULL,
			GTK_SIGNAL_FUNC (modify_notify_list),
			is_notify,
                        remove_func
		);
		gtk_widget_show_all( dlg );
		gtk_signal_connect( GTK_OBJECT(dlg), "destroy",
				    GTK_SIGNAL_FUNC(gtk_widget_destroyed),
				    &dlg );
	} else {
		gdk_window_show(dlg->window);
		gdk_window_raise(dlg->window);
	}
}

void modify_notify_list( GtkWidget *widget, gpointer data )
{
	GtkCList *clist = GTK_CLIST( data );
	gchar *uin;
	int cx;

	GSList *contact;

#ifdef TRACE_FUNCTION
	g_print( "modify_notify_list\n" );
#endif

	contact = Contacts;
	
	while( contact != NULL )
	{
		kontakt->online_notify = FALSE;
		contact = contact->next;
	}

	for( cx = 0; cx < clist->rows; cx ++ )
	{
		gtk_clist_get_text( clist, cx, 0, &uin );
		contact = Contacts;
		while( contact != NULL )
		{
			if( atoi( uin ) == kontakt->uin )
			{
				kontakt->online_notify = TRUE;
			}

			contact = contact->next;
		}
	}

	gtk_widget_set_sensitive( widget, FALSE );
}
