/* GnomeICU
 * Copyright (C) 1998-2002 Jeremy Wise
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * Migrate local contacts list to server side contacts list (GUI code)
 * first created by Patrick Sung (Jan 2002)
 */

#include "common.h"

#include "cl_migrate.h"
#include "gnomeicu.h"
#include "v7snac13.h"

/* g_idle_add user function, must return false so only run once */
gboolean
migration_dialog (gpointer d)
{
  gchar msg_default[] =
    "Starting with ICQ protocol version 8. ICQ server now supports server "
    "side contacts list.\n\nGnomeICU is about to send your contacts list "
    "to the server.";
  gchar msg_rare[] =
    "Starting with ICQ protocol version 8. ICQ server now supports server "
    "side contacts list.\n\nGnomeICU is about to send your contacts list "
    "to the server.\n\n\n\nWarning: you have an existing server contacts "
    "list, GnomeICU will add your local users to this list. This will likely "
    "create duplicate contacts.";
  GtkWidget *dialog, *hbox;
  GtkWidget *msg;
  GtkWidget *pixmap = NULL;
  gchar *s = NULL;

  dialog = gnome_dialog_new ("GnomeICU", GNOME_STOCK_BUTTON_OK, NULL);
  gnome_dialog_set_parent (GNOME_DIALOG (dialog), GTK_WINDOW (MainData->window));

  s = gnome_unconditional_pixmap_file ("gnome-warning.png");
  if (s) {
    pixmap = gnome_pixmap_new_from_file (s);
    g_free(s);
  }

  hbox = gtk_hbox_new (FALSE, 0);
  gtk_box_pack_start (GTK_BOX(GNOME_DIALOG(dialog)->vbox), hbox, TRUE, TRUE, 10);
  gtk_widget_show (hbox);

  if (pixmap) {
    gtk_box_pack_start (GTK_BOX(hbox), pixmap, FALSE, TRUE, 0);
    gtk_widget_show (pixmap);
  }

  if ((gboolean)d)
    msg = gtk_label_new (msg_rare);
  else
    msg = gtk_label_new (msg_default);

  gtk_label_set_justify (GTK_LABEL (msg), GTK_JUSTIFY_LEFT);
  gtk_label_set_line_wrap (GTK_LABEL (msg), TRUE);
  gtk_box_pack_start (GTK_BOX (hbox), msg, FALSE, TRUE, 0);
  gtk_widget_show (msg);

  switch (gnome_dialog_run_and_close (GNOME_DIALOG (dialog))) {
  case 0: /* ok pressed */
    v7_begin_CL_edit (TRUE);
    v7_migrate_contacts_list ();
    v7_end_CL_edit ();
    break;
  case -1:
    break;
  default:
    break;
  }

  return FALSE;
} /* end migration_dialog (gpointer) */
