/*****************************************************************************\
  dj9xx.h : Interface for the DJ9xx class

  Copyright (c) 1996 - 2001, Hewlett-Packard Co.
  All rights reserved.

  Redistribution and use in source and binary forms, with or without
  modification, are permitted provided that the following conditions
  are met:
  1. Redistributions of source code must retain the above copyright
     notice, this list of conditions and the following disclaimer.
  2. Redistributions in binary form must reproduce the above copyright
     notice, this list of conditions and the following disclaimer in the
     documentation and/or other materials provided with the distribution.
  3. Neither the name of Hewlett-Packard nor the names of its
     contributors may be used to endorse or promote products derived
     from this software without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE AUTHOR "AS IS" AND ANY EXPRESS OR IMPLIED
  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN
  NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
  TO, PATENT INFRINGEMENT; PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS
  OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
  ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
\*****************************************************************************/


#ifndef APDK_DJ9XX_H
#define APDK_DJ9XX_H

APDK_BEGIN_NAMESPACE

extern char *ModelString[MAX_ID_STRING];

/*!
\internal
*/
class DJ9xx : public Printer
{
public:
    DJ9xx(SystemServices* pSS, BOOL proto=FALSE);

    virtual ~DJ9xx();

    BOOL UseGUIMode(PrintMode* pPrintMode);
    Header* SelectHeader(PrintContext* pc);
    Compressor* CreateCompressor(unsigned int RasterSize);
    DISPLAY_STATUS ParseError(BYTE status_reg);
    DRIVER_ERROR VerifyPenInfo();

#if defined(APDK_FONTS_NEEDED)
    Font* RealizeFont(const int index,const BYTE bSize,
                        const TEXTCOLOR eColor=BLACK_TEXT,
                        const BOOL bBold=FALSE,const BOOL bItalic=FALSE,
                        const BOOL bUnderline=FALSE);
#endif

    virtual DRIVER_ERROR ParsePenInfo(PEN_TYPE& ePen, BOOL QueryPrinter=TRUE);

    PAPER_SIZE MandatoryPaperSize();

    DRIVER_ERROR CleanPen();

    virtual BOOL PhotoTrayPresent(BOOL bQueryPrinter);

    virtual PHOTOTRAY_STATE PhotoTrayEngaged (BOOL bQueryPrinter);

protected:
    virtual BYTE PhotoTrayStatus(BOOL bQueryPrinter);

}; //DJ9xx


class BroadwayMode1 : public PrintMode
{
public:
    BroadwayMode1();
}; //BroadwayMode1


class BroadwayMode2 : public PrintMode
{
public:
    BroadwayMode2();
}; //BroadwayMode2


#ifdef APDK_AUTODUPLEX

class BroadwayMode3 : public GrayMode
{
public:
    BroadwayMode3 ();
}; //BroadwayMode3

class BroadwayMode4 : public PrintMode
{
public:
    BroadwayMode4 ();
};

class BroadwayMode5 : public PrintMode
{
public:
    BroadwayMode5 ();
};
#endif // APDK_AUTODUPLEX


#ifdef APDK_PROTO
extern PEN_TYPE ProtoPenType;
/*!
\internal
*/
class ProtoDJ9xx : public DJ9xx
{
public:
    ProtoDJ9xx(ProtoServices* pSS);

    DRIVER_ERROR ParsePenInfo(PEN_TYPE& ePen){ ePen=ProtoPenType; return NO_ERROR; }
    BOOL PhotoTrayInstalled();
}; //ProtoDJ9xx


#endif //APDK_PROTO

APDK_END_NAMESPACE

#endif //APDK_DJ9XX_H
