/*
	menus.c
	27.3.99 tn
*/

#include "largefile.h"

#include <stdio.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <strings.h>
#include <dirent.h>
#include <fcntl.h>
#include <sys/types.h>
#include <errno.h>
#include <ctype.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include "xcdrdata.h"
#include "xcdroast.h"
#include "main.h"
#include "xpms/treefolderopen.xpm"
#include "xpms/treefolderclosed.xpm"
#include "xpms/filesmall.xpm"
#include "xpms/minidata.xpm"
#include "xpms/miniaudio.xpm"
#include "xpms/mininodata.xpm"

extern gint debug;
extern GtkWidget *toplevel;
extern GtkWidget *splitspace;
extern GtkWidget *sidespace;
extern GtkWidget *workspace;
extern GtkWidget *actionspace;
extern scsi_devices_t **scsidevices;
extern writer_driver_t **blankmodes;
extern setup_data_t setupdata;
extern master_param_t masterparam;
extern cd_info_t cdinfo;
extern track_info_t **trackinfo;
extern GList *imagelist;
extern current_set_t curset;
extern track_read_set_t trackreadset;
extern gint read_done;
extern GList *tocfiles;
extern gint read_abort_mark;
extern gchar sharedir[MAXLINE];
extern GtkWidget *cdlist_l1, *imglist_l2;
extern GtkCList *cdlist, *imglist2;

GtkWidget *ctree_window;
GtkWidget *ctree_entry;
GtkWidget *ctree_okbutton;
gint ctree_showfiles;
GtkCTreeNode *parent_node;
GtkCTree *ctree_base;
gchar *ctree_basedir;
GtkWidget *cddb_info_label;
GtkWidget *cddb_info_okbutton;
GtkWidget *cddb_window;
GtkCList *cddb_clist;
GtkWidget *readtrack_info_label, *readtrack_textview, *readtrack_button;
GtkWidget *readtrack_pbar1, *readtrack_pbar2, *readtrack_savebutton;
GtkWidget *readtrack_pbar3;
GtkWidget *readtrack_small_info, *readtrack_small_info2, *readtrack_info_tbl;
GtkWidget *readtrack_info_frame;
GdkPixmap *pixmap1, *pixmap2, *pixmap3;
GdkBitmap *mask1, *mask2, *mask3;
GtkWidget *viewmode_scrolled;
GtkWidget *viewmode_dialog;
GtkWidget *blank_infolabel;
GtkWidget *blank_text_window;
GtkWidget *redir_entry;
gint dialog_done, dialog_done2, dialog_done3;
gint misc_timer;
GtkWidget *cdtext_entry1[MAXTRACKS+1];
GtkWidget *cdtext_entry2[MAXTRACKS+1];

gint dialog_delete_event(GtkWidget *widget, GdkEvent *event, gpointer data) {

	dialog_done = -1;
        return(TRUE);
}

gint dialog_delete_event2(GtkWidget *widget, GdkEvent *event, gpointer data) {

	dialog_done2 = -1;
        return(TRUE);
}

gint dialog_delete_event3(GtkWidget *widget, GdkEvent *event, gpointer data) {

	dialog_done3 = -1;
        return(TRUE);
}

void dialog_btn_press(GtkWidget *widget, gpointer data) {

	dialog_done = GPOINTER_TO_INT(data);
}


/* popup a modal window, set cursor to watch, return button pressed
   or -1 when delete_event found.
   Up to three buttons. Set unused buttons to NULL 
   Centers automatically above the toplevel-widow 
   if no toplevel window available center on display

   specialcase: when defbutton -1, then dont set the window cursor 

*/

/* gint show_dialog(gchar **icon_xpm, gchar *ttext, gchar *btn1, gchar *btn2, gchar *btn3, gint defbutton) { */
gint show_dialog(gchar *icon_file, gchar *ttext, gchar *btn1, gchar *btn2, gchar *btn3, gint defbutton) {
GtkWidget *dialog;
GtkWidget *button1;
GtkWidget *button2;
GtkWidget *button3;
GtkWidget *box1,*box2;
GtkWidget *b1_t,*b1_sep,*pix,*lab;
gint xpos, ypos;
gint xsize, ysize;
GdkCursor *cursor,*normal_cursor;
GdkPixmap *pixmap;
GdkBitmap *mask;
/* GtkStyle *style; */
GtkRequisition rq;
GdkWindowAttr *win_attr;
GdkPixbuf *im;
gchar tmp[MAXLINE];

	/* if another dialog is running, ignore */
	if (dialog_done == 999) {
		return -1;
	}

	dodebug(8, "displaying show_dialog: %s\n", ttext);

	/* mark our dialog as running */
	dialog_done = 999;

	/* create new window and position it relative to the main window */
        dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),text(2));
	/* make sure our window is always on top */
	gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(toplevel));

        gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
                GTK_SIGNAL_FUNC (dialog_delete_event), (gpointer) dialog);


	/* create layout for dialog */
        box1 = gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(dialog),box1);

        b1_t = gtk_table_new(1,10, TRUE);
	gtk_container_border_width(GTK_CONTAINER(b1_t),10);

        gtk_box_pack_start(GTK_BOX(box1),b1_t,FALSE,TRUE,10);

	/* realize table to be able to put a pixmap in it */
        gtk_widget_realize(b1_t);

/*        style = gtk_widget_get_style(b1_t);
        pixmap = gdk_pixmap_create_from_xpm_d(b1_t->window, &mask,
                 &style->bg[GTK_STATE_NORMAL],(gchar **)icon_xpm);
*/
	g_snprintf(tmp,MAXLINE,"%s/%s", sharedir,icon_file);
	dodebug(9, "dialog: trying to load %s\n", tmp);
	im=gdk_pixbuf_new_from_file(tmp);
	if (im) {
		gdk_pixbuf_render_pixmap_and_mask(im, &pixmap, &mask, 128);
        	pix = gtk_pixmap_new(pixmap,mask);
        	gtk_table_attach_defaults(GTK_TABLE(b1_t), pix, 0,2,0,1);
        	gtk_widget_show(pix);
		gdk_pixbuf_unref(im);
	}

        lab = gtk_label_new(ttext);
        gtk_table_attach_defaults(GTK_TABLE(b1_t), lab, 2,10,0,1);

        b1_sep = gtk_hseparator_new();
        gtk_box_pack_start(GTK_BOX(box1),b1_sep,FALSE,TRUE,0);

        box2 = gtk_hbox_new(FALSE,0);
        gtk_box_pack_start(GTK_BOX(box1),box2,FALSE,TRUE,10);

	if (btn1 != NULL) {
        	button1 = gtk_button_new_with_label (btn1);
		gtk_box_pack_start(GTK_BOX(box2),button1,TRUE,TRUE,10);
		gtk_widget_show(button1);
		gtk_signal_connect(GTK_OBJECT(button1),"clicked",
			GTK_SIGNAL_FUNC(dialog_btn_press), GINT_TO_POINTER(0));
		GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
		if (defbutton == 0) gtk_widget_grab_default (button1);
	}
	if (btn2 != NULL) {
        	button2 = gtk_button_new_with_label (btn2);
		gtk_box_pack_start(GTK_BOX(box2),button2,TRUE,TRUE,10);
		gtk_widget_show(button2);
		gtk_signal_connect(GTK_OBJECT(button2),"clicked",
			GTK_SIGNAL_FUNC(dialog_btn_press), GINT_TO_POINTER(1));
		GTK_WIDGET_SET_FLAGS (button2, GTK_CAN_DEFAULT);
		if (defbutton == 1) gtk_widget_grab_default (button2);
	}
	if (btn3 != NULL) {
        	button3 = gtk_button_new_with_label (btn3);
		gtk_box_pack_start(GTK_BOX(box2),button3,TRUE,TRUE,10);
		gtk_widget_show(button3);
		gtk_signal_connect(GTK_OBJECT(button3),"clicked",
			GTK_SIGNAL_FUNC(dialog_btn_press), GINT_TO_POINTER(2));
		GTK_WIDGET_SET_FLAGS (button3, GTK_CAN_DEFAULT);
		if (defbutton == 2) gtk_widget_grab_default (button3);
	}

        gtk_widget_show(box2);
        gtk_widget_show(b1_sep);
        gtk_widget_show(lab);
        gtk_widget_show(b1_t);
        gtk_widget_show(box1);


	/* grab cursor and change to watch */
	if (GTK_WIDGET_MAPPED(toplevel)) {
        	gtk_grab_add(dialog);

		if (defbutton != -1) {
			gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
				(gpointer) &win_attr);
			normal_cursor = win_attr->cursor;
      	 	 	cursor = gdk_cursor_new(GDK_WATCH);
    	   	 	gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
			gdk_cursor_destroy (cursor);
			dodebug(9, "showdialog: set cursor\n");
		}
	}

	/* only center window when toplevel visible */
	if ( GTK_WIDGET_VISIBLE(toplevel)) {
        	gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
        	gdk_window_get_origin(GTK_WIDGET(toplevel)->window,&xpos,&ypos);
        	gdk_window_get_size(GTK_WIDGET(toplevel)->window,&xsize,&ysize);
		gtk_widget_size_request(dialog,&rq);
        	gtk_widget_set_uposition(GTK_WIDGET(dialog),xpos+xsize/2-rq.width/2,ypos+ysize/2-rq.height/2);
	} else {
		/* otherwise center in screen */
        	gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
		xsize = gdk_screen_width();
		ysize = gdk_screen_height();
		gtk_widget_size_request(dialog,&rq);
        	gtk_widget_set_uposition(GTK_WIDGET(dialog),xsize/2-rq.width/2,ysize/2-rq.height/2);
		
	}

	gtk_widget_show(dialog);

	/* if this is a warning sound bell (if requested in setup) */
	if (strcmp(icon_file, ICO_WARN) == 0) {
		dobeep(2);
	}

	/* now wait until button is pressed */
	while (dialog_done == 999) {
		wait_and_process_events();
	}

	if (GTK_WIDGET_MAPPED(toplevel)) {
        	gtk_grab_remove(GTK_WIDGET(dialog));
		if (defbutton != -1) {
			normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
        		gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
			gdk_cursor_destroy (normal_cursor);
			dodebug(9, "showdialog: restored cursor\n");
		}
	}

	/* remove dialog window */
        gtk_widget_destroy(dialog);

	return dialog_done; 
}


/* another version of the dialog -> with nice xcdroast logo on top */

gint show_fancy_dialog(gchar *htext, gchar *ttext, gchar *btn1) {
GtkWidget *dialog, *xcdroast_logo, *vbox;
GdkPixbuf *im, *im2;
GdkPixmap *p;
GdkBitmap *m;
GtkWidget *button1;
GtkWidget *box1,*box2, *f1, *l1, *lab;
gint xpos, ypos;
gint xsize, ysize;
GdkCursor *cursor,*normal_cursor;
GtkRequisition rq;
GdkWindowAttr *win_attr;
gchar tmp[MAXLINE];

	/* if another dialog is running, ignore */
	if (dialog_done == 999) {
		return -1;
	}

	dodebug(8, "displaying show_fancy_dialog: %s\n", ttext);

	/* mark our dialog as running */
	dialog_done = 999;

	/* create new window and position it relative to the main window */
        dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),text(2));
	/* make sure our window is always on top */
	gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(toplevel));

        gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
                GTK_SIGNAL_FUNC (dialog_delete_event), (gpointer) dialog);


	/* create layout for dialog */
        box1 = gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(dialog),box1);
        gtk_widget_show(box1);

        /* load the half scaled logo */
        g_snprintf(tmp,MAXLINE,"%s/%s", sharedir, XCDRLOGO);
        im=gdk_pixbuf_new_from_file(tmp);
        if (im) {
                im2 = gdk_pixbuf_scale_simple(im,
                        gdk_pixbuf_get_width(im)/2,
                        gdk_pixbuf_get_height(im)/2,
                        GDK_INTERP_TILES);
                gdk_pixbuf_render_pixmap_and_mask(im2, &p, &m, 128);
                xcdroast_logo = gtk_pixmap_new(p,m);
                gdk_pixbuf_unref(im);
                gdk_pixbuf_unref(im2);
        } else {
                xcdroast_logo = gtk_label_new("[LOGO]");
        }
        gtk_box_pack_start(GTK_BOX(box1),xcdroast_logo,FALSE,FALSE,0);
        gtk_widget_show(xcdroast_logo);

        g_snprintf(tmp,MAXLINE,text(3),XCDROAST_VERSION);
        l1 = gtk_label_new(tmp);
        gtk_label_set_justify(GTK_LABEL(l1),GTK_JUSTIFY_CENTER);
        set_font_and_color(l1,NULL,"red");
        gtk_box_pack_start(GTK_BOX(box1),l1,FALSE,FALSE,0);
        gtk_widget_show(l1);

        f1 = gtk_frame_new(NULL);
	gtk_box_pack_start(GTK_BOX(box1),f1,TRUE,TRUE,0);
        gtk_container_set_border_width(GTK_CONTAINER (f1),5);
	gtk_widget_show(f1);

        vbox = gtk_vbox_new(FALSE,0);
        gtk_container_set_border_width(GTK_CONTAINER (vbox),5);
        gtk_container_add(GTK_CONTAINER(f1),vbox);
        gtk_widget_show(vbox);

	/* print header text? */
	if (htext) {
  	      	lab = gtk_label_new(htext);
		set_font_and_color(lab,BOLDFONT,NULL);
		gtk_label_set_justify(GTK_LABEL(lab),GTK_JUSTIFY_CENTER);
   		gtk_box_pack_start(GTK_BOX(vbox),lab,FALSE,FALSE,0);
       		gtk_widget_show(lab);
	}

        lab = gtk_label_new(ttext);
	gtk_label_set_justify(GTK_LABEL(lab),GTK_JUSTIFY_CENTER);
        gtk_box_pack_start(GTK_BOX(vbox),lab,FALSE,FALSE, 5);
        gtk_widget_show(lab);

        box2 = gtk_hbox_new(FALSE,0);
        gtk_box_pack_start(GTK_BOX(box1),box2,FALSE,TRUE,10);
        gtk_widget_show(box2);

	if (btn1 != NULL) {
        	button1 = gtk_button_new_with_label (btn1);
		gtk_box_pack_start(GTK_BOX(box2),button1,TRUE,TRUE,10);
		gtk_widget_show(button1);
		gtk_signal_connect(GTK_OBJECT(button1),"clicked",
			GTK_SIGNAL_FUNC(dialog_btn_press), GINT_TO_POINTER(0));
		GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
		gtk_widget_grab_default (button1);
	}


	/* grab cursor and change to watch */
	if (GTK_WIDGET_MAPPED(toplevel)) {
        	gtk_grab_add(dialog);

			gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
				(gpointer) &win_attr);
			normal_cursor = win_attr->cursor;
      	 	 	cursor = gdk_cursor_new(GDK_WATCH);
    	   	 	gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
			gdk_cursor_destroy (cursor);
			dodebug(9, "showdialog: set cursor\n");
	}

	/* only center window when toplevel visible */
	if ( GTK_WIDGET_VISIBLE(toplevel)) {
        	gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
        	gdk_window_get_origin(GTK_WIDGET(toplevel)->window,&xpos,&ypos);
        	gdk_window_get_size(GTK_WIDGET(toplevel)->window,&xsize,&ysize);
		gtk_widget_size_request(dialog,&rq);
        	gtk_widget_set_uposition(GTK_WIDGET(dialog),xpos+xsize/2-rq.width/2,ypos+ysize/2-rq.height/2);
	} else {
		/* otherwise center in screen */
        	gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
		xsize = gdk_screen_width();
		ysize = gdk_screen_height();
		gtk_widget_size_request(dialog,&rq);
        	gtk_widget_set_uposition(GTK_WIDGET(dialog),xsize/2-rq.width/2,ysize/2-rq.height/2);
		
	}

	gtk_widget_show(dialog);

	/* now wait until button is pressed */
	while (dialog_done == 999) {
		wait_and_process_events();
	}

	if (GTK_WIDGET_MAPPED(toplevel)) {
        	gtk_grab_remove(GTK_WIDGET(dialog));
			normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
        		gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
			gdk_cursor_destroy (normal_cursor);
			dodebug(9, "showdialog: restored cursor\n");
	}

	/* remove dialog window */
        gtk_widget_destroy(dialog);

	return dialog_done; 
}


/* clears the left sidebar */

void clear_sidespace() {

	gtk_widget_destroy(sidespace);
	sidespace = gtk_vbox_new(FALSE,0);
	gtk_paned_add1(GTK_PANED(splitspace), sidespace);
	set_sidebar_width();
}


/* clears the right workspace */

void clear_workspace() {

	gtk_widget_destroy(workspace);
	workspace = gtk_vbox_new(FALSE,0);
	gtk_paned_add2(GTK_PANED(splitspace), workspace);
}


/* clears the actionspace subwindow */

void clear_actionspace() {

	gtk_widget_destroy(actionspace);
	actionspace = gtk_vbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(workspace), actionspace,TRUE,TRUE,0);

	/* strange, why we need that...*/
	while (gtk_events_pending())
		gtk_main_iteration();

}


/* add subdirectory nodes to an existing ctree */

void ctree_add_dir_nodes(gchar *path, GtkCTree *ctree, GtkCTreeNode *parent, gint showfiles) {
struct dirent *ent;
DIR *dir;         
gchar *text[1];
gchar tmp[MAXLINE];
GtkCTreeNode *sibling;
gchar *textdata;
GList *dir_list;
GList *file_list;

	dir_list = NULL;
	file_list = NULL;
	dir = opendir(path);

	/* invalid directory */
	if (dir == NULL) 
		return;

	/* read entries */
	while ( (ent = readdir(dir)) ) {

		if (strcmp(ent->d_name,".") == 0 || 
		    strcmp(ent->d_name,"..") == 0) 
			continue;

		strcpy(tmp,path);
		/* add slash when not there */
		if (tmp[strlen(tmp)-1] != '/')  
			strcat(tmp,"/");
		strcat(tmp,ent->d_name);

		/* add only directories */
		if (is_directory(tmp) == 1) {

			dir_list = g_list_append(dir_list, g_strdup(ent->d_name));
		} else {
			if (showfiles) 
				file_list = g_list_append(file_list, g_strdup(ent->d_name));
		}
	}
	closedir(dir);

	/* sort the directory-list */
	if (dir_list == NULL && showfiles == 0)
		return;

	sort_glist(dir_list);

	/* sort the file-list */
	if (file_list != NULL && showfiles) {
		sort_glist(file_list);
	}

	/* draw entries */
	while (dir_list) {
		/* allocate directory names */
		text[0] = dir_list->data;
		strcpy(tmp,path);
		/* add slash when not there */
		if (tmp[strlen(tmp)-1] != '/')  
			strcat(tmp,"/");
		if ((strlen(tmp) + strlen(dir_list->data)) > MAXLINE-1) {
			/* getting to long..writing dummy*/
			strcat(tmp,"+");
		} else {	
			strcat(tmp,dir_list->data);
		}
		textdata = g_strdup(tmp);


		/* now check if there are subdirs in that dir */
		if (is_subdirs(tmp)) {
			sibling = gtk_ctree_insert_node (ctree,parent,
				NULL,text,3,pixmap1,mask1,
				pixmap2,mask2,FALSE,FALSE);

			/* create dummy node */
			gtk_ctree_insert_node (ctree,sibling,
				NULL,text,3,NULL,NULL,NULL,NULL,TRUE,FALSE);
		} else {
			/* no subdirs */
			if (!showfiles || !is_subfiles(tmp)) {
				/* if do not show files, dont allow
				   changing into empty directory */
				sibling = gtk_ctree_insert_node (ctree,parent,
					NULL,text,3,pixmap1,mask1,
					pixmap2,mask2,TRUE,FALSE);
			} else {
				/* let user browse directory */
				sibling = gtk_ctree_insert_node (ctree,parent,
					NULL,text,3,pixmap1,mask1,
					pixmap2,mask2,FALSE,FALSE);
				gtk_ctree_insert_node (ctree,sibling,
				NULL,text,3,NULL,NULL,NULL,NULL,TRUE,FALSE);
			}	
		}

		/* save the full path name in the node-data */
		gtk_ctree_node_set_row_data(ctree,sibling,textdata); 

		dir_list = dir_list->next;
	}

	/* add files */
	while (file_list) {
		text[0] = file_list->data;
		strcpy(tmp,path);
		/* add slash when not there */
		if (tmp[strlen(tmp)-1] != '/')  
			strcat(tmp,"/");
		if ((strlen(tmp) + strlen(file_list->data)) > MAXLINE-1) {
			/* getting to long..writing dummy*/
			strcat(tmp,"+");
		} else {	
			strcat(tmp,file_list->data);
		}
		textdata = g_strdup(tmp);

		sibling = gtk_ctree_insert_node (ctree,parent,
				NULL,text,3,pixmap3,mask3,
				pixmap3,mask3,TRUE,FALSE);

		/* save the full path name in the node-data */
		gtk_ctree_node_set_row_data(ctree,sibling,textdata); 

		file_list = file_list->next;
	}

	/* free list */
	free_glist(&dir_list);
	free_glist(&file_list);
}

	
/* recursively remove all children of a node in a ctree */

void ctree_remove_children(GtkCTree * tree, GtkCTreeNode * node) {
GtkCTreeNode *child;
GList *sibling_list;
gchar *strpnt;

	/* Get the child node and make sure it's not NULL. */
	child = GTK_CTREE_ROW (node)->children;
	if (child == NULL)
		return;

	/* Get the list of siblings. */
	sibling_list = NULL;
	for (; child; child = GTK_CTREE_ROW (child)->sibling)
		sibling_list = g_list_append (sibling_list, child);

	/* break out from recusion */
	if (sibling_list == NULL) 
		return;

  	/* Remove all of the sibling nodes. */
	gtk_clist_freeze (GTK_CLIST (tree));
	for (; sibling_list; sibling_list = sibling_list->next) {
	
		/* go recursive */
		ctree_remove_children(tree, GTK_CTREE_NODE(sibling_list->data));

		/* free allocated node-data */
		strpnt = gtk_ctree_node_get_row_data (tree, 
			GTK_CTREE_NODE (sibling_list->data));
		g_free(strpnt);

		gtk_ctree_remove_node (tree, 
			GTK_CTREE_NODE (sibling_list->data));
		
	}
	gtk_clist_thaw (GTK_CLIST (tree));

	/* Free up memory. */
	g_list_free (g_list_first(sibling_list));

}


/* called when the users expands a directory in the ctree */

gint ctree_expand (GtkCTree *tree, GtkCTreeNode *node, gpointer data) {
gchar *newdir;
GdkCursor *normal_cursor, *clock_cursor;
GdkWindowAttr *win_attr;

	/* fetch full path the node stands for */
	newdir = gtk_ctree_node_get_row_data (tree, node);

	/* skip root-dir */
	if (newdir == NULL) return TRUE;

	/* Change cursor to clock */
	gdk_window_get_user_data (GTK_WIDGET (ctree_window)->window,
			(gpointer) &win_attr);

	/* Why does this cause a core dump? 
	   Bug in GTK I guess...workaround is to allocate a new cursor 
	normal_cursor = win_attr->cursor; 
	*/
	clock_cursor = gdk_cursor_new (GDK_WATCH);
	gdk_window_set_cursor (GTK_WIDGET (ctree_window)->window, clock_cursor);
	gdk_cursor_destroy (clock_cursor);

	/* gives gtk a break and time to update REALLY the cursor */
	/* I dont think this slowes things down */
	gtk_main_iteration_do(FALSE);

	gtk_clist_freeze (GTK_CLIST (tree));

	/* remove first everything and then add new nodes */
	ctree_remove_children(tree,node);
	ctree_add_dir_nodes(newdir,tree,node,ctree_showfiles);

	/* now scroll to position (OPTIONAL) */
	/* gtk_ctree_node_moveto(tree,node,0,0.1,0); */

	/* unfreeze and change cursor back */
	gtk_clist_thaw (GTK_CLIST (tree));
	normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
	gdk_window_set_cursor (GTK_WIDGET (ctree_window)->window, normal_cursor);
	gdk_cursor_destroy (normal_cursor);

	return TRUE;
}


/* returns a list of the selected paths */
/* you have to free that list afterwards */

void ctree_get_selected(GList **retsel) {
GList *sel;
GtkCList *clist;
GtkCTreeNode *lnode;
gchar *p;

	clist = GTK_CLIST(ctree_base);
        sel = clist->selection;
        while (sel) {
		lnode = sel->data;
		p = gtk_ctree_node_get_row_data (ctree_base, lnode);
		if (p) {
			*retsel = g_list_append(*retsel, g_strdup(p));
		}	
		sel = sel->next;
	}
}


/* called when the user selects a row in a ctree */

gint ctree_select_row (GtkCTree *tree, GtkCTreeNode *node, gpointer data) {
gchar *pnt;
GList *sel;
GtkCList *clist;
gint selcount;
gchar tmp[MAXLINE];

	/* how many paths selected right now? */
	clist = GTK_CLIST(tree);
        sel = clist->selection;
	selcount = g_list_length(sel);

	pnt = gtk_ctree_node_get_row_data (tree, node);
	if (selcount <= 1) {
		if (pnt == NULL) {
			/* no path set */
			gtk_entry_set_text(GTK_ENTRY(ctree_entry),"");
			if (ctree_okbutton) 
				gtk_widget_set_sensitive(ctree_okbutton,FALSE);
		} else {
			gtk_entry_set_text(GTK_ENTRY(ctree_entry),pnt);
			if (ctree_okbutton) 
				gtk_widget_set_sensitive(ctree_okbutton,TRUE);
		}
	} else {
		/* more than one path selected */
		g_snprintf(tmp,MAXLINE,text(525), selcount);
		gtk_entry_set_text(GTK_ENTRY(ctree_entry),tmp);
		if (ctree_okbutton) 
			gtk_widget_set_sensitive(ctree_okbutton,TRUE);
	}

	return TRUE;
}


/* called when the user unselects a row in a ctree */

gint ctree_unselect_row (GtkCTree *tree, GtkCTreeNode *node, gpointer data) {
gchar *pnt;
GList *sel;
GtkCList *clist;
gint selcount;
gchar tmp[MAXLINE];

	/* how many paths selected right now? */
	clist = GTK_CLIST(tree);
        sel = clist->selection;
	selcount = g_list_length(sel);

	if (selcount == 0) {
		/* no path set */
		gtk_entry_set_text(GTK_ENTRY(ctree_entry),"");
		if (ctree_okbutton) 
			gtk_widget_set_sensitive(ctree_okbutton,FALSE);
	} else 
	if (selcount == 1) {
		pnt = gtk_ctree_node_get_row_data (tree, sel->data);
		if (pnt) {
			gtk_entry_set_text(GTK_ENTRY(ctree_entry),pnt);
			if (ctree_okbutton) 
				gtk_widget_set_sensitive(ctree_okbutton,TRUE);
		}
	} else {
		/* more than one path selected */
		g_snprintf(tmp,MAXLINE,text(525), selcount);
		gtk_entry_set_text(GTK_ENTRY(ctree_entry),tmp);
		if (ctree_okbutton) 
			gtk_widget_set_sensitive(ctree_okbutton,TRUE);
	}

	return TRUE;
}


/* unselect all in ctree */

void ctree_unselect_all() {

	gtk_clist_unselect_all(GTK_CLIST(ctree_base));
	gtk_entry_set_text(GTK_ENTRY(ctree_entry),"");
}


/* frees the ctree from memory */

void ctree_cleanup() {

	ctree_remove_children(ctree_base,parent_node);
	gtk_ctree_collapse_recursive(ctree_base, parent_node);
}


/* can be used to change the view mode (dirs only or with files) */
/* will collaps the tree to its base mode */

void ctree_change_viewmode(gint showfiles) {

	/* do nothing if the state is the same */
	if (showfiles == ctree_showfiles) 
		return;

	ctree_showfiles = showfiles;

	/* collapse whole tree to ensure correct redraw */
	ctree_remove_children(ctree_base,parent_node);
	gtk_ctree_collapse_recursive(ctree_base, parent_node);

	/* now redraw with correct setting */
	ctree_add_dir_nodes(ctree_basedir,ctree_base,parent_node,ctree_showfiles);
	gtk_ctree_expand(ctree_base,parent_node);
}


/* search current branch of ctree for a certain string */

GtkCTreeNode *ctree_search_nodes(GtkCTree *tree, GtkCTreeNode *node, 
		gchar *cmpstr) {
GtkCTreeNode *child;
GList *sibling_list;
gchar *strpnt;

        /* Get the child node and make sure it's not NULL. */
        child = GTK_CTREE_ROW (node)->children;
        if (child == NULL)
                return NULL;

        /* Get the list of siblings. */
        sibling_list = NULL;
        for (; child; child = GTK_CTREE_ROW (child)->sibling)
                sibling_list = g_list_append (sibling_list, child);

        for (; sibling_list; sibling_list = sibling_list->next) {
		/* get data entry */
		child = GTK_CTREE_NODE (sibling_list->data);
               	strpnt = gtk_ctree_node_get_row_data (tree, child);
		if (strpnt && (strcmp(strpnt,cmpstr) == 0)) {
			g_list_free (g_list_first(sibling_list));
			return child;
		} 
	}

	/* nothing found */
	g_list_free (g_list_first(sibling_list));
	return NULL;
}


/* interprets a manual entered path and adopts the tree-listing */

void ctree_expand_manualpath(GtkWidget* entry) {
gchar *p1;
gchar path[MAXLINE];
gchar tmp[MAXLINE];
gchar tmp2[MAXLINE];
GtkCTreeNode *sibling, *node;

	strncpy(path,gtk_entry_get_text(GTK_ENTRY(entry)),MAXLINE);

	/* must begin with a slash */
	if (path[0] != '/') 
		return;
	if (strlen(path) > MAXLINE) 
		return;
	
	/* walk through directory tree as if user clicked */
	sibling = parent_node;
	strcpy(tmp,path);
	strcpy(tmp2,"");
	p1 = strtok(tmp,"/");
	while (p1) {
		strcat(tmp2,"/");
		strcat(tmp2,p1);

		/* now look in current sibling for a matching string */
		node = ctree_search_nodes(ctree_base, sibling, tmp2);

		/* something found? */
		if (node) {
			/* now expand this node if possible */
			ctree_expand(ctree_base, node, NULL);
			gtk_ctree_expand(ctree_base,node);
			gtk_clist_unselect_all(GTK_CLIST(ctree_base));
			gtk_ctree_select(ctree_base,node);

			/* now scroll to position */
			gtk_ctree_node_moveto(ctree_base,node,0,0.1,0); 

			/* prepare next level */
			sibling = node;
		}

		p1 = strtok(NULL,"/");
	}

	/* restore entry string */
	gtk_entry_set_text(GTK_ENTRY(entry),path);
}


/* creates a ctree for directory browsing */
 
GtkCTree *create_directory_ctree(gchar *basedir,gchar *title, GtkWidget *win, GtkWidget *entry, gint showfiles) {
gchar tmp[MAXLINE];
GtkCTree *ctree;
GtkCTreeNode *parent;
gchar *titles[1];
gchar *text[1];
GtkStyle *style;

	/* save the parent window for cursor handling */
	ctree_window = win;
	ctree_entry = entry;
	ctree_showfiles = showfiles;
	ctree_basedir = basedir;

	/* do we want a title? */
	if (title == NULL) {
		ctree = GTK_CTREE (gtk_ctree_new (1, 0));
	} else {
		titles[0] = title;
		ctree = GTK_CTREE (gtk_ctree_new_with_titles (1, 0, titles));
	}	
	ctree_base = ctree;
	gtk_clist_set_row_height(GTK_CLIST(ctree),tbf(16));

	/* create folder pixmaps */
	style = gtk_widget_get_style(GTK_WIDGET(ctree));
	pixmap1 = gdk_pixmap_create_from_xpm_d(win->window,
		&mask1,&style->bg[GTK_STATE_NORMAL],
		(gchar **) treefolderclosed_xpm);
	pixmap2 = gdk_pixmap_create_from_xpm_d(win->window,
		&mask2,&style->bg[GTK_STATE_NORMAL],
		(gchar **) treefolderopen_xpm);
	pixmap3 = gdk_pixmap_create_from_xpm_d(win->window,
		&mask3,&style->bg[GTK_STATE_NORMAL],
		(gchar **) filesmall_xpm);

	/* connect our signal stuff */
	gtk_signal_connect(GTK_OBJECT(ctree),"tree_expand",
				GTK_SIGNAL_FUNC(ctree_expand),NULL);
	gtk_signal_connect(GTK_OBJECT(ctree),"tree_select_row",
				GTK_SIGNAL_FUNC(ctree_select_row),NULL);
	gtk_signal_connect(GTK_OBJECT(ctree),"tree_unselect_row",
				GTK_SIGNAL_FUNC(ctree_unselect_row),NULL);

	/* make root entry in clist */
	strcpy(tmp,basedir); text[0]=tmp;
	parent = gtk_ctree_insert_node (ctree,NULL,
		NULL,text,3,pixmap1,mask1,pixmap2,mask2,FALSE,TRUE);
	gtk_ctree_node_set_row_data(ctree,parent,g_strdup(basedir)); 
	parent_node = parent;

	ctree_add_dir_nodes(basedir,ctree,parent,ctree_showfiles);

	return ctree;
}


void show_dir_btn_press(GtkWidget *widget, gpointer data) {

	dialog_done = GPOINTER_TO_INT(data);
}


/* popup a modal window, set cursor to watch, return path or NULL-string 
   when cancel or delete_event found.
   Centers automatically above the toplevel-widow 
*/

void show_dir_tree(gchar *retvalue) {
GtkWidget *dialog;
GtkWidget *button1;
GtkWidget *button2;
GtkWidget *box1,*box2,*box3;
GtkWidget *entry1,*b1_sep;
GtkWidget *scrolled_win;
GtkCTree *ctree;
gint xpos, ypos;
gint xsize, ysize;
GdkCursor *cursor,*normal_cursor;
GtkRequisition rq;
GdkWindowAttr *win_attr;

	/* if another dialog is running, ignore */
	if (dialog_done == 999) {
		return;
	}

	dodebug(8, "displaying show_dir_tree\n");

	/* mark our dialog as running */
	dialog_done = 999;

	/* create new window and position it relative to the main window */
        dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),text(2));
	gtk_widget_set_usize(dialog,tbf(350),tbf(300)); 
	/* make sure our window is always on top */
	gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(toplevel));

        gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
                GTK_SIGNAL_FUNC (dialog_delete_event), (gpointer) dialog);

	/* create layout for dialog */
        box1 = gtk_vbox_new(FALSE,0);
        gtk_container_add(GTK_CONTAINER(dialog),box1);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_container_set_border_width (GTK_CONTAINER (scrolled_win), 5);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(box1),scrolled_win,TRUE,TRUE,0);
	gtk_widget_realize(scrolled_win);
	gtk_widget_show(scrolled_win);
	
	box3 = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(box1),box3,FALSE,TRUE,10);
	entry1 = gtk_entry_new();
	gtk_entry_set_editable(GTK_ENTRY(entry1),FALSE);
	gtk_box_pack_start(GTK_BOX(box3),entry1,TRUE,TRUE,10);
	gtk_widget_show(entry1);

	ctree = create_directory_ctree("/",text(84),dialog,entry1,0);
	gtk_clist_set_column_auto_resize(GTK_CLIST(ctree),0,TRUE);

	gtk_container_add (GTK_CONTAINER (scrolled_win), GTK_WIDGET (ctree));
	gtk_widget_show( GTK_WIDGET (ctree));

	gtk_widget_show(box3);
	gtk_widget_show(box1);

	b1_sep = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(box1),b1_sep,FALSE,TRUE,0);
	gtk_widget_show(b1_sep);

	box2 = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(box1),box2,FALSE,TRUE,10);
	gtk_widget_show(box2);

	button1 = gtk_button_new_with_label(T_OK);
	ctree_okbutton = button1;
	gtk_box_pack_start(GTK_BOX(box2),button1,TRUE,TRUE,10);
	gtk_widget_show(button1);
	GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
	gtk_widget_set_sensitive(button1,FALSE);
	gtk_signal_connect(GTK_OBJECT(button1),"clicked",
		GTK_SIGNAL_FUNC(show_dir_btn_press), GINT_TO_POINTER(0));

	button2 = gtk_button_new_with_label(T_CANCEL);
	gtk_box_pack_start(GTK_BOX(box2),button2,TRUE,TRUE,10);
	gtk_widget_show(button2);
	GTK_WIDGET_SET_FLAGS (button2, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (button2);
	gtk_signal_connect(GTK_OBJECT(button2),"clicked",
		GTK_SIGNAL_FUNC(show_dir_btn_press), GINT_TO_POINTER(-1));


	/* grab cursor and change to watch */
        gtk_grab_add(dialog);
	gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
			(gpointer) &win_attr);
	normal_cursor = win_attr->cursor;
        cursor = gdk_cursor_new(GDK_WATCH);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
	gdk_cursor_destroy (cursor);

	/* only center window when toplevel visible */
	if ( GTK_WIDGET_VISIBLE(toplevel)) {
        	gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
        	gdk_window_get_origin(GTK_WIDGET(toplevel)->window,&xpos,&ypos);
        	gdk_window_get_size(GTK_WIDGET(toplevel)->window,&xsize,&ysize);
		gtk_widget_size_request(dialog,&rq);
        	gtk_widget_set_uposition(GTK_WIDGET(dialog),xpos+xsize/2-rq.width/2,ypos+ysize/2-rq.height/2);
	}

	gtk_widget_show(dialog);


	/* now wait until button is pressed */
	while (dialog_done == 999) {
		wait_and_process_events();
	}

        gtk_grab_remove(GTK_WIDGET(dialog));
	normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
       	gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
	gdk_cursor_destroy (normal_cursor);

	if (dialog_done != -1) {
		strcpy(retvalue,gtk_entry_get_text(GTK_ENTRY(entry1)));
	} else {
		/* cancel or delete_event */
		strcpy(retvalue,"");
	}	

	/* free ctree */
	ctree_cleanup();

	/* remove dialog window */
        gtk_widget_destroy(dialog);
}


/* fileselector-box ok-button callback */

void file_selector_ok(GtkWidget *widget, GtkFileSelection *fs) {

	dialog_done3 = 1;
}


/* display a file-selector box with defname preselected. Return "" 
   or filename in retvalue */

void show_file_selector(gchar *title, gchar *defname, gchar *retvalue) {
GtkWidget *dialog;
gint xpos, ypos;
gint xsize, ysize;
GdkCursor *cursor,*normal_cursor;
GtkRequisition rq;
GdkWindowAttr *win_attr;
GtkButton *b1;
GtkCList *dirs;

	/* if another dialog is running, ignore */
	if (dialog_done3 == 999) {
		return;
	}

	dodebug(8, "displaying show_fileselector\n");

	/* mark our dialog as running */
	dialog_done3 = 999;

	/* create new window and position it relative to the main window */
	dialog = gtk_file_selection_new (title);
	/* make sure our window is always on top */
	gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(toplevel));

	gtk_file_selection_hide_fileop_buttons(GTK_FILE_SELECTION(dialog));
	if (defname != NULL) {
		gtk_file_selection_set_filename(GTK_FILE_SELECTION(dialog),
			defname);
	}

	/* translate the default-texts on the selector */
	b1 = GTK_BUTTON(GTK_FILE_SELECTION(dialog)->ok_button);
	gtk_label_set_text(GTK_LABEL(b1->child),T_OK);
	b1 = GTK_BUTTON(GTK_FILE_SELECTION(dialog)->cancel_button);
	gtk_label_set_text(GTK_LABEL(b1->child),T_CANCEL);
	dirs = GTK_CLIST(GTK_FILE_SELECTION(dialog)->dir_list);
	gtk_clist_set_column_title(dirs,0,text(85)); 
	dirs = GTK_CLIST(GTK_FILE_SELECTION(dialog)->file_list);
	gtk_clist_set_column_title(dirs,0,text(86)); 

        gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
                GTK_SIGNAL_FUNC (dialog_delete_event3), dialog);

        gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION(dialog)->ok_button),
		"clicked", GTK_SIGNAL_FUNC(file_selector_ok), dialog);

        gtk_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION(dialog)->cancel_button),
		"clicked", GTK_SIGNAL_FUNC(dialog_delete_event3), dialog);
	

	/* grab cursor and change to watch */
        gtk_grab_add(dialog);
	gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
			(gpointer) &win_attr);
	normal_cursor = win_attr->cursor;
        cursor = gdk_cursor_new(GDK_WATCH);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
	gdk_cursor_destroy (cursor);

	/* only center window when toplevel visible */
	if ( GTK_WIDGET_VISIBLE(toplevel)) {
        	gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
        	gdk_window_get_origin(GTK_WIDGET(toplevel)->window,&xpos,&ypos);
        	gdk_window_get_size(GTK_WIDGET(toplevel)->window,&xsize,&ysize);
		gtk_widget_size_request(dialog,&rq);
        	gtk_widget_set_uposition(GTK_WIDGET(dialog),xpos+xsize/2-rq.width/2,ypos+ysize/2-rq.height/2);
	}

	/* center does not work with gtk-1.2.1, but ok with 1.2.3, well
	   what the heck... */

	gtk_widget_show(dialog);


	/* now wait until button is pressed */
	while (dialog_done3 == 999) {
		wait_and_process_events();
	}

        gtk_grab_remove(GTK_WIDGET(dialog));
	normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
	gdk_cursor_destroy (normal_cursor);

	if (dialog_done3 != -1) {
		strcpy(retvalue,gtk_file_selection_get_filename (GTK_FILE_SELECTION (dialog)));
	} else {
		/* cancel or delete_event */
		strcpy(retvalue,"");
	}	

	/* remove dialog window */
        gtk_widget_destroy(dialog);
}


/* what to do when user selects a CD from the database */

void cddb_select_row(GtkWidget *clist, gint row, gint col,
		     GdkEventButton *event, gpointer data) {

	/* we selected something, unlook ok-button */
	gtk_widget_set_sensitive(cddb_info_okbutton,TRUE);

	/* got double-click? Simulate ok-button-press */
	if (event && event->type == GDK_2BUTTON_PRESS) {
		gtk_button_clicked(GTK_BUTTON(cddb_info_okbutton));
	}
}


/* called from cancel or ok button */
 
void show_cddb_btn_press(GtkWidget *widget, gpointer data) {
GList *sel;
gint row;

	/* cancel event */
	if (GPOINTER_TO_INT(data) == -1) {
		if (read_done == 999) {
			/* abort our cddb-process */
			kill_readcdda();
		}
		dialog_done = -1;
		return;
	}

	/* ok button pressed - find out which entry was selected */
	sel = cddb_clist->selection;
	if (sel != NULL) {
		row = GPOINTER_TO_INT(sel->data);
		/* now go back to network code and fetch fitting CD */
		if (continue_cddb_lookup_action(row) != 0) {
			/* disable ok-button */
			gtk_widget_set_sensitive(cddb_info_okbutton,FALSE);
		} else {
			/* data ok received */
			dialog_done = 0;
		}
	}
}


/* called when somebody closes the cddb-window via window-manager */

gint dialog_cddb_delete_event(GtkWidget *widget, GdkEvent *event, gpointer data) {

	if (read_done == 999) {
		/* abort our cddb-process */
		kill_readcdda();
	}
	dialog_done = -1;
	return(TRUE);
}


/* popup a modal window, set cursor to watch, return 0 if correct
   data was received from cddb-server, -1 if not or 
   when cancel or delete_event found.
   Centers automatically above the toplevel-widow 
*/

gint show_cddb_query() {
GtkWidget *dialog;
GtkWidget *button1;
GtkWidget *button2;
GtkWidget *box1,*box2,*hbox;
GtkWidget *f1, *cddb_logo;
GdkPixmap *p;
GdkBitmap *m;
GdkPixbuf *im;
GtkWidget *b1_sep, *lbl;
GtkWidget *scrolled_win, *c_list;
GtkCList *clist;
gchar *titles[1];
gint xpos, ypos;
gint xsize, ysize;
GdkCursor *cursor,*normal_cursor;
GtkRequisition rq;
GdkWindowAttr *win_attr;
gchar tmp[MAXLINE];

	/* if another dialog is running, ignore */
	if (dialog_done == 999) {
		return -1;
	}

	dodebug(8, "displaying show_cddb_query\n");

	/* mark our dialog as running */
	dialog_done = 999;

	/* create new window and position it relative to the main window */
        dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),text(2));
	gtk_widget_set_usize(dialog,tbf(450),tbf(260));
	/* make sure our window is always on top */
	gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(toplevel));
	cddb_window = dialog;

        gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
                GTK_SIGNAL_FUNC (dialog_cddb_delete_event), (gpointer) dialog);

	/* create layout for dialog */
        box1 = gtk_vbox_new(FALSE,5);
	gtk_container_set_border_width (GTK_CONTAINER (box1), 5);
        gtk_container_add(GTK_CONTAINER(dialog),box1);

	hbox = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(box1),hbox,FALSE,TRUE,5);
	gtk_widget_show(hbox);

	f1 = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(f1),GTK_SHADOW_IN);
	gtk_box_pack_start(GTK_BOX(hbox),f1,TRUE,TRUE,5);
	gtk_widget_show(f1);

	lbl = gtk_label_new("");
	cddb_info_label = lbl;
	gtk_container_add(GTK_CONTAINER(f1), lbl);
	gtk_misc_set_alignment(GTK_MISC(lbl),0.0,0.5);
	gtk_misc_set_padding(GTK_MISC(lbl),10,0);
	gtk_widget_show(lbl);

	/* load a gif-image and put into a pixmap */
	g_snprintf(tmp,MAXLINE,"%s/%s", sharedir,CDDBLOGO);
	im=gdk_pixbuf_new_from_file(tmp);
	if (im) {
		gdk_pixbuf_render_pixmap_and_mask(im, &p, &m, 128);
		cddb_logo = gtk_pixmap_new(p,m);
		gdk_pixbuf_unref(im);
	} else {
		cddb_logo = gtk_label_new("[CDDB]");
	}
	gtk_box_pack_start(GTK_BOX(hbox),cddb_logo,FALSE,FALSE,5);
	gtk_widget_show(cddb_logo);
	
	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_container_set_border_width (GTK_CONTAINER (scrolled_win), 5);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(box1),scrolled_win,TRUE,TRUE,0);
	gtk_widget_show(scrolled_win);
	
	titles[0] = text(108);
	c_list = gtk_clist_new_with_titles(1,titles);
	clist = GTK_CLIST(c_list);
	cddb_clist = clist;
	gtk_clist_set_column_auto_resize(clist, 0, TRUE);
	gtk_container_add (GTK_CONTAINER (scrolled_win), c_list);
	gtk_widget_show(c_list);
	gtk_signal_connect(GTK_OBJECT(clist), "select_row",
		GTK_SIGNAL_FUNC(cddb_select_row), NULL); 

	gtk_widget_show(box1);

	b1_sep = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(box1),b1_sep,FALSE,TRUE,0);
	gtk_widget_show(b1_sep);

	box2 = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(box1),box2,FALSE,TRUE,10);
	gtk_widget_show(box2);

	button1 = gtk_button_new_with_label(T_OK);
	cddb_info_okbutton = button1;
	gtk_box_pack_start(GTK_BOX(box2),button1,TRUE,TRUE,10);
	gtk_widget_show(button1);
	GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
	gtk_widget_set_sensitive(button1,FALSE);
	gtk_signal_connect(GTK_OBJECT(button1),"clicked",
		GTK_SIGNAL_FUNC(show_cddb_btn_press), GINT_TO_POINTER(0));

	button2 = gtk_button_new_with_label(T_CANCEL);
	gtk_box_pack_start(GTK_BOX(box2),button2,TRUE,TRUE,10);
	gtk_widget_show(button2);
	GTK_WIDGET_SET_FLAGS (button2, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (button2);
	gtk_signal_connect(GTK_OBJECT(button2),"clicked",
		GTK_SIGNAL_FUNC(show_cddb_btn_press), GINT_TO_POINTER(-1));


	/* grab cursor and change to watch */
        gtk_grab_add(dialog);
	gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
			(gpointer) &win_attr);
	normal_cursor = win_attr->cursor;
        cursor = gdk_cursor_new(GDK_WATCH);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
	gdk_cursor_destroy (cursor);

	/* only center window when toplevel visible */
	if ( GTK_WIDGET_VISIBLE(toplevel)) {
        	gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
        	gdk_window_get_origin(GTK_WIDGET(toplevel)->window,&xpos,&ypos);
        	gdk_window_get_size(GTK_WIDGET(toplevel)->window,&xsize,&ysize);
		gtk_widget_size_request(dialog,&rq);
        	gtk_widget_set_uposition(GTK_WIDGET(dialog),xpos+xsize/2-rq.width/2,ypos+ysize/2-rq.height/2);
	}

	gtk_widget_show(dialog);


	/* lets do some work */
	start_cddb_lookup_action();

	/* now wait until button is pressed */
	while (dialog_done == 999) {
		wait_and_process_events();
	}

        gtk_grab_remove(GTK_WIDGET(dialog));
	normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
	gdk_cursor_destroy (normal_cursor);

	/* remove dialog window */
        gtk_widget_destroy(dialog);

	return dialog_done;
}


/* start the read-processes according to the trackreadset-struct.
   Update read-dialogbox and return 0 if ok, 1 on error - call
   cdda2wav in bulk mode */

gint start_read_action_bulk(gint read_devnr) {
GList *loop;
track_read_param_t *trackparam;
gfloat percent_done;
gint stat, count;
gint audiocount, datacount;

	if (strcmp(trackreadset.tocfile,"") == 0) {
		/* should not happen */
		return 1;
	}

	dolog(1, "Reading CD with toc file %s (bulk)\n", trackreadset.tocfile);

	percent_done = 0.0;
	count = 0;
	audiocount = 0;
	datacount = 0;

	/* start reading tracks */
	loop = g_list_first(trackreadset.trackparams);
	while (loop) {
		trackparam = loop->data;
		count++;
		
		/* data-track */
		if (trackparam->tracktype == 0) {
			stat = read_data_track(read_devnr,
				trackparam->starttrack,
				trackparam->kbyte,
				trackparam->trackfile,
				trackparam->startoffset,	
				trackparam->endoffset,
				trackreadset.nrtracks,				
				trackparam->percent,
				percent_done, count);
			datacount++;
			percent_done += trackparam->percent;
		} else {
			/* audio-track */
			/* dont read them here - do them as bulk later */
			audiocount++;
			stat = 0;
		}
		if (stat == 0) {
			/* no error */
			/* write inf-file */
			write_inf_file(trackparam); 
		} else {
			/* error while reading */
			return 1;
		}
		loop = loop->next;
	}

	/* ok, we have read all data tracks - now check if there 
	   are audio tracks to do */
	if (audiocount > 0) {
		if (start_bulk_read_action(read_devnr, percent_done,
		    datacount+1) != 0) {
			/* error while reading? */
			return 1;
		}
	}

	/* save the toc file (not for read single tracks) */
	if (strcmp(trackreadset.tocfile,"") != 0) {
		write_copy_cd_toc_file(trackreadset.tocfile);
	}

	/* unset current active toc-file */
	g_free(curset.tocfile);
	curset.tocfile = g_strdup("");

	/* no error reading tracks */
	gtk_label_set_text(GTK_LABEL(readtrack_info_label), text(161));
	gtk_label_set_text(GTK_LABEL(readtrack_small_info), text(165));

	/* now set progressbars to 100% - elsewhere we may end up
	   with 99% due rounding errors */
	gtk_progress_set_percentage(GTK_PROGRESS(readtrack_pbar1),1.0);
	gtk_progress_set_percentage(GTK_PROGRESS(readtrack_pbar2),1.0);

	return 0;
}


/* start the read-processes according to the trackreadset-struct.
   Update read-dialogbox and return 0 if ok, 1 on error */ 

gint start_read_action(gint read_devnr) {
GList *loop;
track_read_param_t *trackparam;
gfloat percent_done;
gint stat, count;

	if (strcmp(trackreadset.tocfile,"") != 0) {
		dolog(1, "Reading CD with toc file %s\n", trackreadset.tocfile);
	} else {
		dolog(1, "Reading single tracks\n");
	}
	percent_done = 0;
	count = 0;

	/* start reading tracks */
	loop = g_list_first(trackreadset.trackparams);
	while (loop) {
		trackparam = loop->data;
		count++;
		
		/* data-track */
		if (trackparam->tracktype == 0) {
			stat = read_data_track(read_devnr,
				trackparam->starttrack,
				trackparam->kbyte,
				trackparam->trackfile,
				trackparam->startoffset,	
				trackparam->endoffset,
				trackreadset.nrtracks,				
				trackparam->percent,
				percent_done, count);
		} else {
		/* audio-track */
			stat = read_audio_track(read_devnr,
				trackparam->starttrack,
				trackparam->endtrack,
				trackparam->kbyte,
				trackparam->trackfile,
				trackparam->startoffset,
				trackparam->endoffset,
				trackreadset.nrtracks,				
				trackparam->percent,
				percent_done, count);
		}
		if (stat == 0) {
			/* no error */
			percent_done += trackparam->percent;

			/* write inf-file */
			write_inf_file(trackparam); 
		} else {
			/* error while reading */
			return 1;
		}
		loop = loop->next;
	}

	/* save the toc file (not for read single tracks) */
	if (strcmp(trackreadset.tocfile,"") != 0) {
		write_copy_cd_toc_file(trackreadset.tocfile);
	}

	/* unset current active toc-file */
	g_free(curset.tocfile);
	curset.tocfile = g_strdup("");

	/* no error reading tracks */
	gtk_label_set_text(GTK_LABEL(readtrack_info_label), text(161));
	gtk_label_set_text(GTK_LABEL(readtrack_small_info), text(165));

	/* now set progressbars to 100% - elsewhere we may end up
	   with 99% due rounding errors */
	gtk_progress_set_percentage(GTK_PROGRESS(readtrack_pbar1),1.0);
	gtk_progress_set_percentage(GTK_PROGRESS(readtrack_pbar2),1.0);

	return 0;
}


/* called from cancel or ok button */
 
void show_readtrack_btn_press(GtkWidget *widget, gpointer data) {

	/* read-process running? */
	if (read_done == 999) {
		read_abort_mark = 1;
		/* abort our read-process */
		kill_readcdda();
		return;
	}

	/* cancel event */
	if (GPOINTER_TO_INT(data) == -1) {
		dialog_done = -1;
		return;
	}
}

void show_readtrack_save_press(GtkWidget *widget, gpointer data) {
char tmp[MAXLINE];

	/* show fileselector */
	show_file_selector(text(162), SAVEREADTRACKS,tmp);
	
	/* not cancel pressed? */
	if (strcmp(tmp,"") != 0) {
		if (save_text2file(tmp, readtrack_textview) == 0) {
			show_dialog(ICO_INFO,text(270), T_OK, NULL, NULL, 0);
		}
	}
}

gint readtrack_dialog_delete_event(GtkWidget *widget, GdkEvent *event, 
	gpointer data) {

	/* read-process running? */
	if (read_done == 999) {
		read_abort_mark = 1;
		/* abort our read-process */
		kill_readcdda();
		return(TRUE);
	}

	dialog_done = -1;
        return(TRUE);
}


/* change the read-tracks menu according to view-setting */
void viewmode_selected(GtkWidget *item, gpointer val) {
	
	curset.proc_view = GPOINTER_TO_INT(val);

	gtk_window_set_policy(GTK_WINDOW(viewmode_dialog), FALSE, TRUE, TRUE );
	if (GPOINTER_TO_INT(val) == 2) {
		/* extended view */
		gtk_widget_show(readtrack_info_frame);
		gtk_widget_show(readtrack_info_tbl);
		gtk_widget_show(viewmode_scrolled);
		gtk_widget_show(readtrack_savebutton);
		gtk_widget_hide(readtrack_small_info);
		gtk_widget_hide(readtrack_small_info2);
	} else if (GPOINTER_TO_INT(val) == 1) {
		/* normal view */
		gtk_widget_show(readtrack_info_frame);
		gtk_widget_show(readtrack_info_tbl);
		gtk_widget_hide(viewmode_scrolled);
		gtk_widget_hide(readtrack_savebutton);
		gtk_widget_hide(readtrack_small_info);
		gtk_widget_hide(readtrack_small_info2);
	} else {
		/* small view */
		gtk_widget_hide(readtrack_info_frame);
		gtk_widget_hide(readtrack_info_tbl);
		gtk_widget_hide(viewmode_scrolled);
		gtk_widget_hide(readtrack_savebutton);
		gtk_widget_show(readtrack_small_info);
		gtk_widget_show(readtrack_small_info2);
	}

	while (gtk_events_pending())
		gtk_main_iteration();

	gtk_window_set_policy(GTK_WINDOW(viewmode_dialog), FALSE, TRUE, FALSE);
}


/* popup a modal window, set cursor to watch, trigger read tracks 
   and return 0 if all ok, -1 if not or 
   when cancel or delete_event found.
   Centers automatically above the toplevel-widow 
*/

gint show_and_do_read_tracks(gint devnr, gint bulk) {
GtkWidget *omenu;
GtkWidget *menu;
GtkWidget *menu_item;
GtkWidget *dialog;
GtkWidget *l1;
GtkWidget *button1, *button2;
GtkWidget *box1,*box2,*txt;
GtkWidget *f1, *tbl;
GtkWidget *b1_sep, *lbl;
GtkWidget *scrolled_win;
gint xpos, ypos;
gint xsize, ysize;
GdkCursor *cursor,*normal_cursor;
GtkRequisition rq;
GdkWindowAttr *win_attr;
GtkAdjustment *adj1, *adj2;
GtkWidget *pbar1, *pbar2;
gint i, menuidx, menuhistory;

	/* if another dialog is running, ignore */
	if (dialog_done == 999) {
		return -1;
	}

	dodebug(8, "displaying show_and_do_read_tracks\n");
	
	/* mark our dialog as running */
	dialog_done = 999;

	/* create new window and position it relative to the main window */
        dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	viewmode_dialog = dialog;
	gtk_window_set_title(GTK_WINDOW(dialog),text(2));
	gtk_widget_set_usize(dialog,tbf(400),0);
	/* make sure our window is always on top */
	gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(toplevel));

        gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
                GTK_SIGNAL_FUNC (readtrack_dialog_delete_event), 
		(gpointer) dialog);

	/* create layout for dialog */
        box1 = gtk_vbox_new(FALSE,5);
	gtk_container_set_border_width (GTK_CONTAINER (box1), 5);
        gtk_container_add(GTK_CONTAINER(dialog),box1);

	f1 = gtk_frame_new(NULL);
	readtrack_info_frame = f1;
	gtk_frame_set_shadow_type(GTK_FRAME(f1),GTK_SHADOW_IN);
	gtk_widget_set_usize(f1,0,36);
	gtk_box_pack_start(GTK_BOX(box1),f1,FALSE,TRUE,5);
	if (curset.proc_view > 0) 
		gtk_widget_show(f1);

	lbl = gtk_label_new("");
	readtrack_info_label = lbl;
	gtk_container_add(GTK_CONTAINER(f1), lbl);
	gtk_misc_set_alignment(GTK_MISC(lbl),0.5,0.5);
	gtk_misc_set_padding(GTK_MISC(lbl),10,0);
	gtk_widget_show(lbl);

	tbl = gtk_table_new(2, 10, TRUE);
	readtrack_info_tbl = tbl;
	gtk_table_set_col_spacing(GTK_TABLE(tbl),1,10);
	gtk_table_set_row_spacings(GTK_TABLE(tbl),5);
	gtk_box_pack_start(GTK_BOX(box1),tbl,FALSE,TRUE,5);
	if (curset.proc_view > 0) 
		gtk_widget_show(tbl);

	l1 = rightjust_gtk_label_new(text(150));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,0,1);
	gtk_widget_show(l1);

	adj1 = (GtkAdjustment *)gtk_adjustment_new(0, 0, 100, 0, 0, 0);
	pbar1 = gtk_progress_bar_new_with_adjustment(adj1);
	readtrack_pbar1 = pbar1;
	gtk_progress_set_format_string(GTK_PROGRESS(pbar1),"%p%%");
	gtk_progress_set_show_text(GTK_PROGRESS(pbar1),TRUE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),pbar1,2,10,0,1);
	gtk_widget_show(pbar1);

	l1 = rightjust_gtk_label_new(text(151));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,1,2);
	gtk_widget_show(l1);

	adj2 = (GtkAdjustment *)gtk_adjustment_new(0, 0, 100, 0, 0, 0);
	pbar2 = gtk_progress_bar_new_with_adjustment(adj2);
	readtrack_pbar2 = pbar2;
	gtk_progress_set_format_string(GTK_PROGRESS(pbar2),"%p%%");
	gtk_progress_set_show_text(GTK_PROGRESS(pbar2),TRUE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),pbar2,2,10,1,2);
	gtk_widget_show(pbar2);

	tbl = gtk_table_new(1, 10, TRUE);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),6,10);
	gtk_table_set_row_spacings(GTK_TABLE(tbl),5);
	gtk_box_pack_start(GTK_BOX(box1),tbl,FALSE,TRUE,0);
	gtk_widget_show(tbl);

	lbl = gtk_label_new("");
	readtrack_small_info = lbl;
	gtk_table_attach_defaults(GTK_TABLE(tbl),lbl,0,3,0,1);
	if (curset.proc_view == 0) 
		gtk_widget_show(lbl);

	lbl = gtk_label_new("");
	readtrack_small_info2 = lbl;
	gtk_table_attach_defaults(GTK_TABLE(tbl),lbl,3,5,0,1);
	if (curset.proc_view == 0) 
		gtk_widget_show(lbl);

	l1 = rightjust_gtk_label_new(text(152));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,5,7,0,1);
	gtk_widget_show(l1);

	omenu = gtk_option_menu_new();
	menu = gtk_menu_new();
	menuidx = 0; menuhistory = -1;

	for (i=0; i<3; i++) {
		menu_item = gtk_menu_item_new_with_label(text(153+i));
		gtk_signal_connect(GTK_OBJECT(menu_item),
			"activate", GTK_SIGNAL_FUNC(viewmode_selected),
			GINT_TO_POINTER(i));
		gtk_menu_append (GTK_MENU (menu), menu_item);
		if (curset.proc_view == i) { menuhistory = menuidx; }
		menuidx++;
		gtk_widget_show (menu_item);
	}
	gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
	if (menuhistory != -1) {
		gtk_option_menu_set_history(GTK_OPTION_MENU (omenu),menuhistory);
	} else {
		curset.proc_view = 1;
		gtk_option_menu_set_history(GTK_OPTION_MENU (omenu),1);
	}
	gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,7,10,0,1);
	gtk_widget_show(omenu);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	viewmode_scrolled = scrolled_win;
	gtk_container_set_border_width (GTK_CONTAINER (scrolled_win), 5);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(box1),scrolled_win,TRUE,TRUE,0);

	/* show only in extended view */
	if (curset.proc_view == 2) 
		gtk_widget_show(scrolled_win);

	txt = gtk_text_new(NULL,NULL);
	readtrack_textview = txt;
	gtk_text_set_editable(GTK_TEXT(txt),FALSE);
	gtk_text_set_word_wrap(GTK_TEXT(txt),TRUE);
	gtk_container_add(GTK_CONTAINER(scrolled_win), txt);
	gtk_widget_show(txt);

	gtk_widget_show(box1);

	b1_sep = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(box1),b1_sep,FALSE,TRUE,0);
	gtk_widget_show(b1_sep);

	box2 = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(box1),box2,FALSE,TRUE,10);
	gtk_widget_show(box2);

	button1 = gtk_button_new_with_label(T_CANCEL);
	readtrack_button = button1;
	gtk_box_pack_start(GTK_BOX(box2),button1,TRUE,TRUE,10);
	gtk_widget_show(button1);
	GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (button1);
	gtk_signal_connect(GTK_OBJECT(button1),"clicked",
		GTK_SIGNAL_FUNC(show_readtrack_btn_press), GINT_TO_POINTER(-1));

	button2 = gtk_button_new_with_label(text(162));
	readtrack_savebutton = button2;
	gtk_box_pack_start(GTK_BOX(box2),button2,TRUE,TRUE,10);
	GTK_WIDGET_SET_FLAGS (button2, GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(button2),"clicked",
		GTK_SIGNAL_FUNC(show_readtrack_save_press), GINT_TO_POINTER(-1));
	/* show only in extended view */
	if (curset.proc_view == 2) 
		gtk_widget_show(button2);


	/* grab cursor and change to watch */
        gtk_grab_add(dialog);
	gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
			(gpointer) &win_attr);
	normal_cursor = win_attr->cursor;
        cursor = gdk_cursor_new(GDK_WATCH);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
	gdk_cursor_destroy (cursor);

	/* only center window when toplevel visible */
	if ( GTK_WIDGET_VISIBLE(toplevel)) {
        	gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
        	gdk_window_get_origin(GTK_WIDGET(toplevel)->window,&xpos,&ypos);
        	gdk_window_get_size(GTK_WIDGET(toplevel)->window,&xsize,&ysize);
		gtk_widget_size_request(dialog,&rq);
        	gtk_widget_set_uposition(GTK_WIDGET(dialog),xpos+xsize/2-rq.width/2,ypos+ysize/2-rq.height/2);
	}

	gtk_widget_show(dialog);

	/* here is the action */
	if (bulk == 0) {
		/* read all selected tracks one at a time */
		start_read_action(devnr);
	} else {
		/* use bulk mode of cdda2wav */
		start_read_action_bulk(devnr);
	}

	/* update image-dir-lists */
	scan_imagedirs();

	/* when done with reading rename button to OK */
	gtk_label_set_text(GTK_LABEL(GTK_BIN(readtrack_button)->child),T_OK);
	
	dobeep(1);

	/* now wait until button is pressed */
	while (dialog_done == 999) {
		wait_and_process_events();
	}

        gtk_grab_remove(GTK_WIDGET(dialog));
	normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
	gdk_cursor_destroy (normal_cursor);

	/* remove dialog window */
        gtk_widget_destroy(dialog);

	return dialog_done;
}


/* popup a modal window, set cursor to watch, return path or NULL-string 
   when cancel or delete_event found.
   Centers automatically above the toplevel-widow 
*/

void show_device_detail(gint devnr) {
GtkWidget *dialog;
GtkWidget *button1;
GtkWidget *box1,*box2,*txt;
GtkWidget *f1;
GtkWidget *scrolled_win;
gint xpos, ypos;
gint xsize, ysize;
GdkCursor *cursor,*normal_cursor;
GtkRequisition rq;
GdkWindowAttr *win_attr;

	/* if another dialog is running, ignore */
	if (dialog_done == 999) {
		return;
	}

	dodebug(8, "displaying show_device_detail\n");

	/* mark our dialog as running */
	dialog_done = 999;

	/* create new window and position it relative to the main window */
        dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),text(2));
	gtk_widget_set_usize(dialog,tbf(500),tbf(300)); 
	/* make sure our window is always on top */
	gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(toplevel));

        gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
                GTK_SIGNAL_FUNC (dialog_delete_event), (gpointer) dialog);

	/* create layout for dialog */
        box1 = gtk_vbox_new(FALSE,0);
	gtk_container_set_border_width (GTK_CONTAINER (box1), 5);
        gtk_container_add(GTK_CONTAINER(dialog),box1);

	f1 = gtk_frame_new(text(166));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(box1),f1,TRUE,TRUE,0);
	gtk_widget_show(f1);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_container_set_border_width (GTK_CONTAINER (scrolled_win), 5);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(f1),scrolled_win);
	gtk_widget_show(scrolled_win);
	
	txt = gtk_text_new(NULL,NULL);
	gtk_text_set_editable(GTK_TEXT(txt),FALSE);
	gtk_text_set_word_wrap(GTK_TEXT(txt),TRUE);
	gtk_container_add(GTK_CONTAINER(scrolled_win), txt);
	gtk_widget_show(txt);

	gtk_widget_show(box1);

	box2 = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(box1),box2,FALSE,TRUE,5);
	gtk_widget_show(box2);

	button1 = gtk_button_new_with_label(T_OK);
	gtk_box_pack_start(GTK_BOX(box2),button1,TRUE,TRUE,10);
	gtk_widget_show(button1);
	GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(button1),"clicked",
		GTK_SIGNAL_FUNC(dialog_btn_press), GINT_TO_POINTER(0));


	/* grab cursor and change to watch */
        gtk_grab_add(dialog);
	gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
			(gpointer) &win_attr);
	normal_cursor = win_attr->cursor;
        cursor = gdk_cursor_new(GDK_WATCH);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
	gdk_cursor_destroy (cursor);

	/* only center window when toplevel visible */
	if ( GTK_WIDGET_VISIBLE(toplevel)) {
        	gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
        	gdk_window_get_origin(GTK_WIDGET(toplevel)->window,&xpos,&ypos);
        	gdk_window_get_size(GTK_WIDGET(toplevel)->window,&xsize,&ysize);
		gtk_widget_size_request(dialog,&rq);
        	gtk_widget_set_uposition(GTK_WIDGET(dialog),xpos+xsize/2-rq.width/2,ypos+ysize/2-rq.height/2);
	}


	/* now fill text-widget with infos */
	fill_device_info(devnr, txt);
	gtk_text_set_point(GTK_TEXT(txt),0);
	gtk_widget_show(dialog);


	/* now wait until button is pressed */
	while (dialog_done == 999) {
		wait_and_process_events();
	}

        gtk_grab_remove(GTK_WIDGET(dialog));
	normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
	gdk_cursor_destroy (normal_cursor);

	/* remove dialog window */
        gtk_widget_destroy(dialog);
}


/* popup a modal window, set cursor to watch, return path or NULL-string 
   when cancel or delete_event found.
   Centers automatically above the toplevel-widow 
*/

void display_atip_info(gint devnr) {
GtkWidget *dialog;
GtkWidget *button1;
GtkWidget *box1,*box2,*txt;
GtkWidget *f1;
GtkWidget *scrolled_win;
gint xpos, ypos;
gint xsize, ysize;
GdkCursor *cursor,*normal_cursor;
GtkRequisition rq;
GdkWindowAttr *win_attr;

	/* if another dialog is running, ignore */
	if (dialog_done == 999) {
		return;
	}

	dodebug(8, "displaying display_atip_info\n");

	/* mark our dialog as running */
	dialog_done = 999;

	/* create new window and position it relative to the main window */
        dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),text(2));
	gtk_widget_set_usize(dialog,tbf(400),tbf(300)); 
	/* make sure our window is always on top */
	gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(toplevel));

        gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
                GTK_SIGNAL_FUNC (dialog_delete_event), (gpointer) dialog);

	/* create layout for dialog */
        box1 = gtk_vbox_new(FALSE,0);
	gtk_container_set_border_width (GTK_CONTAINER (box1), 5);
        gtk_container_add(GTK_CONTAINER(dialog),box1);

	f1 = gtk_frame_new(text(176));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(box1),f1,TRUE,TRUE,0);
	gtk_widget_show(f1);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_container_set_border_width (GTK_CONTAINER (scrolled_win), 5);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(f1),scrolled_win);
	gtk_widget_show(scrolled_win);
	
	txt = gtk_text_new(NULL,NULL);
	gtk_text_set_editable(GTK_TEXT(txt),FALSE);
	gtk_text_set_word_wrap(GTK_TEXT(txt),TRUE);
	gtk_container_add(GTK_CONTAINER(scrolled_win), txt);
	gtk_widget_show(txt);

	gtk_widget_show(box1);

	box2 = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(box1),box2,FALSE,TRUE,5);
	gtk_widget_show(box2);

	button1 = gtk_button_new_with_label(T_OK);
	gtk_box_pack_start(GTK_BOX(box2),button1,TRUE,TRUE,10);
	gtk_widget_show(button1);
	GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(button1),"clicked",
		GTK_SIGNAL_FUNC(dialog_btn_press), GINT_TO_POINTER(0));


	/* grab cursor and change to watch */
        gtk_grab_add(dialog);
	gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
			(gpointer) &win_attr);
	normal_cursor = win_attr->cursor;
        cursor = gdk_cursor_new(GDK_WATCH);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
	gdk_cursor_destroy (cursor);

	/* only center window when toplevel visible */
	if ( GTK_WIDGET_VISIBLE(toplevel)) {
        	gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
        	gdk_window_get_origin(GTK_WIDGET(toplevel)->window,&xpos,&ypos);
        	gdk_window_get_size(GTK_WIDGET(toplevel)->window,&xsize,&ysize);
		gtk_widget_size_request(dialog,&rq);
        	gtk_widget_set_uposition(GTK_WIDGET(dialog),xpos+xsize/2-rq.width/2,ypos+ysize/2-rq.height/2);
	}

	/* now fill text-widget with infos */
	get_atip_info(devnr, txt);
	gtk_text_set_point(GTK_TEXT(txt),0);

	gtk_widget_show(dialog);

	/* now wait until button is pressed */
	while (dialog_done == 999) {
		wait_and_process_events();
	}

        gtk_grab_remove(GTK_WIDGET(dialog));
	normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
	gdk_cursor_destroy (normal_cursor);

	/* remove dialog window */
        gtk_widget_destroy(dialog);
}


/* callbacks for blank-menu */

void blankmode_selected(GtkWidget *item, gpointer mode) {

	curset.blankmode = GPOINTER_TO_INT(mode);
}

void blankoptions_selected(GtkWidget *item, gpointer nr) {
gint sel;

	sel = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(item));

	switch(GPOINTER_TO_INT(nr)) {
		case 0:
			curset.blank_force = sel;
			break;
		case 1:
			curset.blank_eject = sel;
			break;
	}
}


/* timer function for blanking */

gint blank_timer(gpointer data) {
time_t start_time;
time_t curtime;
gint secs;
char tmp[MAXLINE];

	/* how many seconds have passed since first start? */
	start_time = (time_t)data;
	curtime = time((time_t *) 0);
	secs = (gint) curtime - start_time;

	/* set new label */
	g_snprintf(tmp,MAXLINE,text(189),secs/60,secs%60);
	gtk_label_set_text(GTK_LABEL(blank_infolabel),tmp);

	return(TRUE);
}


/* called by ok-button in blank-window */

void blank_start(GtkWidget *widget, gpointer data) {
time_t start_time;
time_t curtime;
gint secs;
gint stat;
char tmp[MAXLINE];

	/* get current time */
	start_time = time((time_t *) 0); 
	misc_timer = gtk_timeout_add(1000, blank_timer, GINT_TO_POINTER(start_time));
		
	/* disable ok button */
	gtk_widget_set_sensitive(widget, FALSE);
	gtk_label_set_text(GTK_LABEL(GTK_BIN(readtrack_button)->child),T_CANCEL);

	/* clear text-window */
	gtk_text_set_point(GTK_TEXT(blank_text_window),
		gtk_text_get_length(GTK_TEXT(blank_text_window)));
	gtk_text_backward_delete(GTK_TEXT(blank_text_window),
		gtk_text_get_length(GTK_TEXT(blank_text_window)));

	/* now this waits here until blanking is done */
	stat = start_blanking_process(curset.writer_devnr, blank_text_window);

	if (stat == 1) {
		/* error? */
		gtk_label_set_text(GTK_LABEL(blank_infolabel),text(191));
	} else
	if (stat == 0) {
		/* ok */
		curtime = time((time_t *) 0);
		secs = (gint) curtime - start_time;
		g_snprintf(tmp,MAXLINE,text(192),secs/60,secs%60);
		gtk_label_set_text(GTK_LABEL(blank_infolabel),tmp);
	} else {
		/* aborted */
		curtime = time((time_t *) 0);
		secs = (gint) curtime - start_time;
		g_snprintf(tmp,MAXLINE,text(193),secs/60,secs%60);
		gtk_label_set_text(GTK_LABEL(blank_infolabel),tmp);
	}
	
	if (misc_timer != 0) 
		gtk_timeout_remove(misc_timer);
	misc_timer = 0;

	/* enable ok button */
	gtk_widget_set_sensitive(widget, TRUE);
	
	/* restore close button */
	gtk_label_set_text(GTK_LABEL(GTK_BIN(readtrack_button)->child),T_CLOSE);

	dobeep(1);

}


/* called by cancel-button in blank-window */

void blank_cancel(GtkWidget *widget, gpointer data) {

	/* nothing more to here, because actual killing is handled
	   in start_blanking_process() */
	dialog_done2 = -1; 
}

gint blank_delete_event(GtkWidget *widget, GdkEvent *event, gpointer data) {

	blank_cancel(widget,data);
        return(TRUE);
}


/* popup a modal window, set cursor to watch, return path or NULL-string 
   when cancel or delete_event found.
   Centers automatically above the toplevel-widow 
*/

void display_blank_cdrw(gint devnr) {
GtkWidget *dialog, *tbl;
GtkWidget *button1, *button2;
GtkWidget *box1,*box2,*box3,*txt;
GtkWidget *f1, *l1, *check, *sep;
GtkWidget *omenu;
GtkWidget *menu;
GtkWidget *menu_item;
GtkWidget *scrolled_win;
gint xpos, ypos;
gint xsize, ysize;
GdkCursor *cursor,*normal_cursor;
GtkRequisition rq;
GdkWindowAttr *win_attr;
gint i,j, menuhistory, menuidx;
gchar tmp[MAXLINE];
gint blanktrans[] = BLANK_MODES;
 
	/* if another dialog is running, ignore */
	if (dialog_done2 == 999) {
		return;
	}

	dodebug(8, "displaying display_blank_cdrw\n");

	/* mark our dialog as running */
	dialog_done2 = 999;
	misc_timer = 0;

	/* create new window and position it relative to the main window */
        dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),text(2));
	gtk_widget_set_usize(dialog,tbf(470),tbf(250)); 
	/* make sure our window is always on top */
	gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(toplevel));

        gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
                GTK_SIGNAL_FUNC (blank_delete_event), (gpointer) dialog);

	/* create layout for dialog */
        box1 = gtk_vbox_new(FALSE,0);
	gtk_container_set_border_width (GTK_CONTAINER (box1), 5);
        gtk_container_add(GTK_CONTAINER(dialog),box1);

	f1 = gtk_frame_new(text(171));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(box1),f1,TRUE,TRUE,0);
	gtk_widget_show(f1);

	box2 = gtk_vbox_new(FALSE,0);
	gtk_container_set_border_width (GTK_CONTAINER (box2), 5);
	gtk_container_add(GTK_CONTAINER(f1),box2);
	gtk_widget_show(box2);

	tbl = gtk_table_new(5, 8, FALSE);
	gtk_table_set_col_spacings(GTK_TABLE(tbl),10);
	gtk_box_pack_start(GTK_BOX(box2),tbl,FALSE,TRUE,0);
	gtk_widget_show(tbl);

	l1 = rightjust_gtk_label_new(text(185));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,3,0,1);
	gtk_widget_show(l1);	
	
	omenu = gtk_option_menu_new();
	menu = gtk_menu_new();
	menuidx = 0; menuhistory = 0;

	i = 0; 
	while (blankmodes[i] != NULL) {
	
		strncpy(tmp, blankmodes[i]->desc, MAXLINE);

		/* get translation to blank mode if available */
		j = 0;
		while (blanktrans[j]) {
			if (strcmp(blankmodes[i]->desc,
			    text0(blanktrans[j])) == 0) {
				strncpy(tmp, text(blanktrans[j]), MAXLINE);
			}
			j++;
		}
		
		menu_item = gtk_menu_item_new_with_label(tmp);
		gtk_signal_connect(GTK_OBJECT(menu_item),
			"activate", GTK_SIGNAL_FUNC(blankmode_selected),
			GINT_TO_POINTER(i));
		gtk_menu_append (GTK_MENU (menu), menu_item);
		if (curset.blankmode == i) { menuhistory = menuidx; }
		menuidx++;
		gtk_widget_show (menu_item);
		i++;
	}

	gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
	gtk_option_menu_set_history(GTK_OPTION_MENU (omenu),menuhistory);
	gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,3,8,0,1);
	gtk_widget_show(omenu);	

	check = gtk_check_button_new_with_label(text(186));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(blankoptions_selected),GINT_TO_POINTER(0));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,3,8,1,2);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		curset.blank_force);
	gtk_widget_show(check);

	check = gtk_check_button_new_with_label(text(187));
	gtk_signal_connect(GTK_OBJECT(check),"clicked",
		GTK_SIGNAL_FUNC(blankoptions_selected),GINT_TO_POINTER(1));
	gtk_table_attach_defaults(GTK_TABLE(tbl),check,3,8,2,3);
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check),
		curset.blank_eject);
	gtk_widget_show(check);

	sep = gtk_hseparator_new();
	gtk_table_attach_defaults(GTK_TABLE(tbl),sep,0,8,3,4);
	gtk_widget_show(sep);
	
	f1 = gtk_frame_new(NULL);

	gtk_frame_set_shadow_type(GTK_FRAME(f1),GTK_SHADOW_IN);
	gtk_container_set_border_width (GTK_CONTAINER (f1), 5);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f1,0,8,4,5);
	gtk_widget_show(f1);

	l1 = gtk_label_new("");
	blank_infolabel = l1;
	gtk_container_add(GTK_CONTAINER(f1),l1);
	gtk_widget_show(l1);	

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_container_set_border_width (GTK_CONTAINER (scrolled_win), 5);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(box2),scrolled_win);
	gtk_widget_show(scrolled_win);
	
	txt = gtk_text_new(NULL,NULL);
	blank_text_window = txt;
	gtk_text_set_editable(GTK_TEXT(txt),FALSE);
	gtk_text_set_word_wrap(GTK_TEXT(txt),TRUE);
	gtk_container_add(GTK_CONTAINER(scrolled_win), txt);
	gtk_widget_show(txt);

	gtk_widget_show(box1);

	box3 = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(box1),box3,FALSE,TRUE,5);
	gtk_widget_show(box3);

	button1 = gtk_button_new_with_label(text(171));
	gtk_box_pack_start(GTK_BOX(box3),button1,TRUE,TRUE,10);
	gtk_widget_show(button1);
	gtk_signal_connect(GTK_OBJECT(button1),"clicked",
		GTK_SIGNAL_FUNC(blank_start), NULL);

	button2 = gtk_button_new_with_label(T_CLOSE);
	readtrack_button = button2;
	gtk_box_pack_start(GTK_BOX(box3),button2,TRUE,TRUE,10);
	gtk_widget_show(button2);
	gtk_signal_connect(GTK_OBJECT(button2),"clicked",
		GTK_SIGNAL_FUNC(blank_cancel), GINT_TO_POINTER(-1));


	/* grab cursor and change to watch */
        gtk_grab_add(dialog);
	gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
			(gpointer) &win_attr);
	normal_cursor = win_attr->cursor;
        cursor = gdk_cursor_new(GDK_WATCH);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
	gdk_cursor_destroy (cursor);

	/* only center window when toplevel visible */
	if ( GTK_WIDGET_VISIBLE(toplevel)) {
        	gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
        	gdk_window_get_origin(GTK_WIDGET(toplevel)->window,&xpos,&ypos);
        	gdk_window_get_size(GTK_WIDGET(toplevel)->window,&xsize,&ysize);
		gtk_widget_size_request(dialog,&rq);
        	gtk_widget_set_uposition(GTK_WIDGET(dialog),xpos+xsize/2-rq.width/2,ypos+ysize/2-rq.height/2);
	}

	/* now fill text-widget with infos */
	gtk_text_insert(GTK_TEXT(txt),NULL,NULL,NULL,
		text(188), strlen(text(188)));

	gtk_widget_show(dialog);


	/* now wait until button is pressed */
	while (dialog_done2 == 999) {
		wait_and_process_events();
	}

        gtk_grab_remove(GTK_WIDGET(dialog));
	normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
	gdk_cursor_destroy (normal_cursor);

	/* remove dialog window */
        gtk_widget_destroy(dialog);
}


/* save output of write process */

void show_writetrack_save_press(GtkWidget *widget, gpointer data) {
char tmp[MAXLINE];

	/* show fileselector */
	show_file_selector(text(162), SAVEOUTCDRECORD,tmp);
	
	/* not cancel pressed? */
	if (strcmp(tmp,"") != 0) {
		if (save_text2file(tmp, readtrack_textview) == 0) {
			show_dialog(ICO_INFO,text(270), T_OK, NULL, NULL, 0);
		}
	}
}


/* called by cancel-button in write-window */

void write_cancel(GtkWidget *widget, gpointer data) {

	/* nothing more to here, because actual killing is handled
	   in start_write_action() */
	dialog_done2 = -1; 
}

gint write_delete_event(GtkWidget *widget, GdkEvent *event, gpointer data) {

	write_cancel(widget,data);
        return(TRUE);
}


/* create the write-tracks-box */
/* when ontheflysetting set to 2 just fixate */
/* when ontheflysetting set to 3 do master on the fly */

gint show_and_do_write_tracks(gint devnr, gint read_devnr, gint onthefly) {
GtkWidget *omenu;
GtkWidget *menu;
GtkWidget *menu_item;
GtkWidget *dialog;
GtkWidget *l1;
GtkWidget *button1, *button2;
GtkWidget *box1,*box2,*txt;
GtkWidget *f1, *tbl;
GtkWidget *b1_sep, *lbl;
GtkWidget *scrolled_win;
gint xpos, ypos;
gint xsize, ysize;
GdkCursor *cursor,*normal_cursor;
GtkRequisition rq;
GdkWindowAttr *win_attr;
GtkAdjustment *adj1, *adj2, *adj3;
GtkWidget *pbar1, *pbar2, *pbar3;
gint i, menuidx, menuhistory;

	/* if another dialog is running, ignore */
	if (dialog_done2 == 999) {
		return -1;
	}

	dodebug(8, "displaying show_and_do_write_tracks\n");

	/* mark our dialog as running */
	dialog_done2 = 999;

	/* create new window and position it relative to the main window */
        dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	viewmode_dialog = dialog;
	gtk_window_set_title(GTK_WINDOW(dialog),text(2));
	gtk_widget_set_usize(dialog,tbf(400),0);
	/* make sure our window is always on top */
	gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(toplevel));

        gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
                GTK_SIGNAL_FUNC (write_delete_event), 
		(gpointer) dialog);

	/* create layout for dialog */
        box1 = gtk_vbox_new(FALSE,5);
	gtk_container_set_border_width (GTK_CONTAINER (box1), 5);
        gtk_container_add(GTK_CONTAINER(dialog),box1);

	f1 = gtk_frame_new(NULL);
	readtrack_info_frame = f1;
	gtk_frame_set_shadow_type(GTK_FRAME(f1),GTK_SHADOW_IN);
	gtk_widget_set_usize(f1,0,36);
	gtk_box_pack_start(GTK_BOX(box1),f1,FALSE,TRUE,5);
	if (curset.proc_view > 0) 
		gtk_widget_show(f1);

	lbl = gtk_label_new("");
	readtrack_info_label = lbl;
	gtk_container_add(GTK_CONTAINER(f1), lbl);
	gtk_misc_set_alignment(GTK_MISC(lbl),0.5,0.5);
	gtk_misc_set_padding(GTK_MISC(lbl),10,0);
	gtk_widget_show(lbl);

	tbl = gtk_table_new(3, 10, TRUE);
	readtrack_info_tbl = tbl;
	gtk_table_set_col_spacing(GTK_TABLE(tbl),1,10);
	gtk_table_set_row_spacings(GTK_TABLE(tbl),5);
	gtk_box_pack_start(GTK_BOX(box1),tbl,FALSE,TRUE,5);
	if (curset.proc_view > 0) 
		gtk_widget_show(tbl);

	l1 = rightjust_gtk_label_new(text(150));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,0,1);
	gtk_widget_show(l1);

	adj1 = (GtkAdjustment *)gtk_adjustment_new(0, 0, 100, 0, 0, 0);
	pbar1 = gtk_progress_bar_new_with_adjustment(adj1);
	readtrack_pbar1 = pbar1;
	gtk_progress_set_format_string(GTK_PROGRESS(pbar1),"%p%%");
	gtk_progress_set_show_text(GTK_PROGRESS(pbar1),TRUE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),pbar1,2,10,0,1);
	gtk_widget_show(pbar1);

	l1 = rightjust_gtk_label_new(text(151));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,1,2);
	gtk_widget_show(l1);

	adj2 = (GtkAdjustment *)gtk_adjustment_new(0, 0, 100, 0, 0, 0);
	pbar2 = gtk_progress_bar_new_with_adjustment(adj2);
	readtrack_pbar2 = pbar2;
	gtk_progress_set_format_string(GTK_PROGRESS(pbar2),"%p%%");
	gtk_progress_set_show_text(GTK_PROGRESS(pbar2),TRUE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),pbar2,2,10,1,2);
	gtk_widget_show(pbar2);

	l1 = rightjust_gtk_label_new(text(205));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,2,3);
	gtk_widget_show(l1);

	adj3 = (GtkAdjustment *)gtk_adjustment_new(0, 0, 100, 0, 0, 0);
	pbar3 = gtk_progress_bar_new_with_adjustment(adj3);
	readtrack_pbar3 = pbar3;
	gtk_progress_set_format_string(GTK_PROGRESS(pbar3),"%p%%");
	gtk_progress_set_show_text(GTK_PROGRESS(pbar3),TRUE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),pbar3,2,10,2,3);
	gtk_widget_show(pbar3);

	tbl = gtk_table_new(1, 10, TRUE);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),6,10);
	gtk_table_set_row_spacings(GTK_TABLE(tbl),5);
	gtk_box_pack_start(GTK_BOX(box1),tbl,FALSE,TRUE,0);
	gtk_widget_show(tbl);

	lbl = gtk_label_new("");
	readtrack_small_info = lbl;
	gtk_table_attach_defaults(GTK_TABLE(tbl),lbl,0,3,0,1);
	if (curset.proc_view == 0) 
		gtk_widget_show(lbl);

	lbl = gtk_label_new("");
	readtrack_small_info2 = lbl;
	gtk_table_attach_defaults(GTK_TABLE(tbl),lbl,3,5,0,1);
	if (curset.proc_view == 0) 
		gtk_widget_show(lbl);

	l1 = rightjust_gtk_label_new(text(152));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,5,7,0,1);
	gtk_widget_show(l1);

	omenu = gtk_option_menu_new();
	menu = gtk_menu_new();
	menuidx = 0; menuhistory = -1;

	for (i=0; i<3; i++) {
		menu_item = gtk_menu_item_new_with_label(text(153+i));
		gtk_signal_connect(GTK_OBJECT(menu_item),
			"activate", GTK_SIGNAL_FUNC(viewmode_selected),
			GINT_TO_POINTER(i));
		gtk_menu_append (GTK_MENU (menu), menu_item);
		if (curset.proc_view == i) { menuhistory = menuidx; }
		menuidx++;
		gtk_widget_show (menu_item);
	}
	gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
	if (menuhistory != -1) {
		gtk_option_menu_set_history(GTK_OPTION_MENU (omenu),menuhistory);
	} else {
		curset.proc_view = 1;
		gtk_option_menu_set_history(GTK_OPTION_MENU (omenu),1);
	}
	gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,7,10,0,1);
	gtk_widget_show(omenu);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	viewmode_scrolled = scrolled_win;
	gtk_container_set_border_width (GTK_CONTAINER (scrolled_win), 5);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(box1),scrolled_win,TRUE,TRUE,0);

	/* show only in extended view */
	if (curset.proc_view == 2) 
		gtk_widget_show(scrolled_win);

	txt = gtk_text_new(NULL,NULL);
	readtrack_textview = txt;
	gtk_text_set_editable(GTK_TEXT(txt),FALSE);
	gtk_text_set_word_wrap(GTK_TEXT(txt),TRUE);
	gtk_container_add(GTK_CONTAINER(scrolled_win), txt);
	gtk_widget_show(txt);

	gtk_widget_show(box1);

	b1_sep = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(box1),b1_sep,FALSE,TRUE,0);
	gtk_widget_show(b1_sep);

	box2 = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(box1),box2,FALSE,TRUE,10);
	gtk_widget_show(box2);

	button1 = gtk_button_new_with_label(T_CANCEL);
	readtrack_button = button1;
	gtk_box_pack_start(GTK_BOX(box2),button1,TRUE,TRUE,10);
	gtk_widget_show(button1);
	GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (button1);
	gtk_signal_connect(GTK_OBJECT(button1),"clicked",
		GTK_SIGNAL_FUNC(write_cancel), GINT_TO_POINTER(-1));

	button2 = gtk_button_new_with_label(text(162));
	readtrack_savebutton = button2;
	gtk_box_pack_start(GTK_BOX(box2),button2,TRUE,TRUE,10);
	GTK_WIDGET_SET_FLAGS (button2, GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(button2),"clicked",
		GTK_SIGNAL_FUNC(show_writetrack_save_press), GINT_TO_POINTER(-1));
	/* show only in extended view */
	if (curset.proc_view == 2) 
		gtk_widget_show(button2);


	/* grab cursor and change to watch */
        gtk_grab_add(dialog);
	gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
			(gpointer) &win_attr);
	normal_cursor = win_attr->cursor;
        cursor = gdk_cursor_new(GDK_WATCH);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
	gdk_cursor_destroy (cursor);

	/* only center window when toplevel visible */
	if ( GTK_WIDGET_VISIBLE(toplevel)) {
        	gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
        	gdk_window_get_origin(GTK_WIDGET(toplevel)->window,&xpos,&ypos);
        	gdk_window_get_size(GTK_WIDGET(toplevel)->window,&xsize,&ysize);
		gtk_widget_size_request(dialog,&rq);
        	gtk_widget_set_uposition(GTK_WIDGET(dialog),xpos+xsize/2-rq.width/2,ypos+ysize/2-rq.height/2);
	}

	gtk_widget_show(dialog);

	/* here is the action */
	if (onthefly == 0) {
		start_write_action(devnr); 
	} else
	if (onthefly == 1) {
		start_write_onthefly_action(read_devnr, devnr);
	} else
	if (onthefly == 2) {
		start_write_fixate_only(devnr);
	} else {
		/* master on the fly */
		start_onthefly_master_action(devnr);
	}

	/* when done with reading rename button to OK */
	gtk_label_set_text(GTK_LABEL(GTK_BIN(readtrack_button)->child),T_OK);

	dobeep(1);
	
	/* now wait until button is pressed */
	while (dialog_done2 == 999) {
		wait_and_process_events();
	}

        gtk_grab_remove(GTK_WIDGET(dialog));
	normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
	gdk_cursor_destroy (normal_cursor);

	/* remove dialog window */
        gtk_widget_destroy(dialog);

	return dialog_done2;
}


/* called by cancel-button in delete-window */

void delete_cancel(GtkWidget *widget, gpointer data) {

	/* delete running? */
	if (read_done == 999) {
		/* abort */
		kill_readcdda();
	} else {
		dialog_done2 = -1; 
	}
}

gint delete_delete_event(GtkWidget *widget, GdkEvent *event, gpointer data) {

	write_cancel(widget,data);
        return(TRUE);
}


/* display a menu and do delete tracks */

gint show_and_do_delete(GList *delfiles) {
GtkWidget *dialog;
GtkWidget *button1;
GtkWidget *box1,*box2;
GtkWidget *f1;
GtkWidget *b1_sep, *lbl;
GtkWidget *scrolled_win, *txt;
gint xpos, ypos;
gint xsize, ysize;
GdkCursor *cursor,*normal_cursor;
GtkRequisition rq;
GdkWindowAttr *win_attr;
GtkAdjustment *adj1;
GtkWidget *pbar1;


	/* if another dialog is running, ignore */
	if (dialog_done2 == 999) {
		return -1;
	}

	dodebug(8, "displaying show_and_do_delete\n");

	/* mark our dialog as running */
	dialog_done2 = 999;

	/* create new window and position it relative to the main window */
        dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	viewmode_dialog = dialog;
	gtk_window_set_title(GTK_WINDOW(dialog),text(2));
	gtk_widget_set_usize(dialog,tbf(400),0);
	/* make sure our window is always on top */
	gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(toplevel));

        gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
                GTK_SIGNAL_FUNC (delete_delete_event), 
		(gpointer) dialog);

	/* create layout for dialog */
        box1 = gtk_vbox_new(FALSE,5);
	gtk_container_set_border_width (GTK_CONTAINER (box1), 5);
        gtk_container_add(GTK_CONTAINER(dialog),box1);
	gtk_widget_show(box1);

	f1 = gtk_frame_new(NULL);
	readtrack_info_frame = f1;
	gtk_frame_set_shadow_type(GTK_FRAME(f1),GTK_SHADOW_IN);
	gtk_widget_set_usize(f1,0,36);
	gtk_box_pack_start(GTK_BOX(box1),f1,FALSE,TRUE,5);
	gtk_widget_show(f1);

	lbl = gtk_label_new("");
	readtrack_info_label = lbl;
	gtk_container_add(GTK_CONTAINER(f1), lbl);
	gtk_misc_set_alignment(GTK_MISC(lbl),0.5,0.5);
	gtk_misc_set_padding(GTK_MISC(lbl),10,0);
	gtk_widget_show(lbl);

	adj1 = (GtkAdjustment *)gtk_adjustment_new(0, 0, 100, 0, 0, 0);
	pbar1 = gtk_progress_bar_new_with_adjustment(adj1);
	readtrack_pbar1 = pbar1;
	gtk_progress_set_format_string(GTK_PROGRESS(pbar1),"%p%%");
	gtk_progress_set_show_text(GTK_PROGRESS(pbar1),TRUE);
	gtk_box_pack_start(GTK_BOX(box1),pbar1,FALSE,TRUE,5);
	gtk_widget_show(pbar1);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_container_set_border_width (GTK_CONTAINER (scrolled_win), 5);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
		GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(box1),scrolled_win);
	gtk_widget_show(scrolled_win);

	txt = gtk_text_new(NULL,NULL);
	readtrack_textview = txt;
	gtk_text_set_editable(GTK_TEXT(txt),FALSE);
	gtk_text_set_word_wrap(GTK_TEXT(txt),TRUE);
	gtk_container_add(GTK_CONTAINER(scrolled_win), txt);
	gtk_widget_show(txt);
	
	b1_sep = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(box1),b1_sep,FALSE,TRUE,0);
	gtk_widget_show(b1_sep);

	box2 = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(box1),box2,FALSE,TRUE,10);
	gtk_widget_show(box2);

	button1 = gtk_button_new_with_label(T_CANCEL);
	readtrack_button = button1;
	gtk_box_pack_start(GTK_BOX(box2),button1,TRUE,TRUE,10);
	gtk_widget_show(button1);
	GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (button1);
	gtk_signal_connect(GTK_OBJECT(button1),"clicked",
		GTK_SIGNAL_FUNC(delete_cancel), GINT_TO_POINTER(-1));

	/* grab cursor and change to watch */
        gtk_grab_add(dialog);
	gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
			(gpointer) &win_attr);
	normal_cursor = win_attr->cursor;
        cursor = gdk_cursor_new(GDK_WATCH);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
	gdk_cursor_destroy (cursor);

	/* only center window when toplevel visible */
	if ( GTK_WIDGET_VISIBLE(toplevel)) {
        	gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
        	gdk_window_get_origin(GTK_WIDGET(toplevel)->window,&xpos,&ypos);
        	gdk_window_get_size(GTK_WIDGET(toplevel)->window,&xsize,&ysize);
		gtk_widget_size_request(dialog,&rq);
        	gtk_widget_set_uposition(GTK_WIDGET(dialog),xpos+xsize/2-rq.width/2,ypos+ysize/2-rq.height/2);
	}

	gtk_widget_show(dialog);

	/* here is the action */
	start_delete_action(delfiles);

	/* when done with delete rename button to OK */
	gtk_label_set_text(GTK_LABEL(GTK_BIN(readtrack_button)->child),T_OK);
	
	/* now wait until button is pressed */
	while (dialog_done2 == 999) {
		wait_and_process_events();
	}

        gtk_grab_remove(GTK_WIDGET(dialog));
	normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
	gdk_cursor_destroy (normal_cursor);

	/* remove dialog window */
        gtk_widget_destroy(dialog);

	return dialog_done2;
}


/* start the read-processes according to the trackreadset-struct.
   Update verify-dialogbox and return 0 if ok, 1 on error */ 

gint start_verify_action(gint read_devnr) {
GList *loop;
track_read_param_t *trackparam;
gfloat percent_done;
gint stat, count;
gint errcount;

	if (strcmp(trackreadset.tocfile,"") != 0) {
		dolog(1, "Verify CD with toc file %s\n", trackreadset.tocfile);
        } else {
                dolog(1, "Verifying single tracks\n");
        }
	percent_done = 0;
	count = 0;
	errcount = 0;

	/* start verifying all tracks */
	loop = g_list_first(trackreadset.trackparams);
	while (loop) {
		trackparam = loop->data;

		/* data-track */
		if (trackparam->tracktype == 0) {
			count++;	
			stat = verify_data_track(read_devnr,
				trackparam->starttrack,
				trackparam->kbyte,
				trackparam->trackfile,
				trackparam->startoffset,	
				trackparam->endoffset,
				trackreadset.nrtracks,				
				trackparam->percent,
				percent_done, count);
			percent_done += trackparam->percent;
		} else {
		/* audio-track */
			if (curset.noaudioverify == 0) {
				count++;	
				stat = verify_audio_track(read_devnr,
					trackparam->starttrack,
					trackparam->endtrack,
					trackparam->kbyte,
					trackparam->trackfile,
					trackparam->startoffset,
					trackparam->endoffset,
					trackreadset.nrtracks,	
					trackparam->percent,
					percent_done, count);
				percent_done += trackparam->percent;
			} else {
				/* we dont want to verify audio */
				stat = 0;
			}
		}
		if (stat == 2) {
			/* user abort */
			return 1;
		}
		if (stat != 0) {
			/* error while reading */
			if (curset.verifyfailabort == 1)
				return 1;
			errcount++;
		}
		loop = loop->next;
	}

	/* if we only got a single error we failed */
	if (errcount > 0) {
		return 1;
	}
	/* no error verifying tracks */
	gtk_label_set_text(GTK_LABEL(readtrack_info_label), text(243));
	gtk_label_set_text(GTK_LABEL(readtrack_small_info), text(165));

	/* now set progressbars to 100% - elsewhere we may end up
	   with 99% due rounding errors */
	gtk_progress_set_percentage(GTK_PROGRESS(readtrack_pbar1),1.0);
	gtk_progress_set_percentage(GTK_PROGRESS(readtrack_pbar2),1.0);

	return 0;
}


/* called from cancel or ok button */
 
void show_verifytrack_btn_press(GtkWidget *widget, gpointer data) {

	/* read-process running? */
	if (read_done == 999) {
		/* mark aborted */
		read_abort_mark = 1;
		/* abort our read-process */
		kill_readcdda();
		return;
	}

	/* cancel event */
	if (GPOINTER_TO_INT(data) == -1) {
		dialog_done = -1;
		return;
	}
}


void show_verifytrack_save_press(GtkWidget *widget, gpointer data) {
char tmp[MAXLINE];

	/* show fileselector */
	show_file_selector(text(162), SAVEVERIFYTRACKS,tmp);
	
	/* not cancel pressed? */
	if (strcmp(tmp,"") != 0) {
		if (save_text2file(tmp, readtrack_textview) == 0) {
			show_dialog(ICO_INFO,text(270), T_OK, NULL, NULL, 0);
		}
	}
}

gint verifytrack_dialog_delete_event(GtkWidget *widget, GdkEvent *event, 
	gpointer data) {

	/* read-process running? */
	if (read_done == 999) {
		/* mark aborted */
		read_abort_mark = 1;
		/* abort our read-process */
		kill_readcdda();
		return(TRUE);
	}

	dialog_done = -1;
        return(TRUE);
}


/* popup a modal window, set cursor to watch, trigger read tracks 
   and return 0 if all ok, -1 if not or 
   when cancel or delete_event found.
   Centers automatically above the toplevel-widow 
*/

gint show_and_do_verify_tracks(gint devnr) {
GtkWidget *omenu;
GtkWidget *menu;
GtkWidget *menu_item;
GtkWidget *dialog;
GtkWidget *l1;
GtkWidget *button1, *button2;
GtkWidget *box1,*box2,*txt;
GtkWidget *f1, *tbl;
GtkWidget *b1_sep, *lbl;
GtkWidget *scrolled_win;
gint xpos, ypos;
gint xsize, ysize;
GdkCursor *cursor,*normal_cursor;
GtkRequisition rq;
GdkWindowAttr *win_attr;
GtkAdjustment *adj1, *adj2;
GtkWidget *pbar1, *pbar2;
gint i, menuidx, menuhistory;

	/* if another dialog is running, ignore */
	if (dialog_done == 999) {
		return -1;
	}

	dodebug(8, "displaying show_and_do_verify_tracks\n");

	/* mark our dialog as running */
	dialog_done = 999;

	/* create new window and position it relative to the main window */
        dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	viewmode_dialog = dialog;
	gtk_window_set_title(GTK_WINDOW(dialog),text(2));
	gtk_widget_set_usize(dialog,tbf(400),0);
	/* make sure our window is always on top */
	gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(toplevel));

        gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
                GTK_SIGNAL_FUNC (verifytrack_dialog_delete_event), 
		(gpointer) dialog);

	/* create layout for dialog */
        box1 = gtk_vbox_new(FALSE,5);
	gtk_container_set_border_width (GTK_CONTAINER (box1), 5);
        gtk_container_add(GTK_CONTAINER(dialog),box1);

	f1 = gtk_frame_new(NULL);
	readtrack_info_frame = f1;
	gtk_frame_set_shadow_type(GTK_FRAME(f1),GTK_SHADOW_IN);
	gtk_widget_set_usize(f1,0,36);
	gtk_box_pack_start(GTK_BOX(box1),f1,FALSE,TRUE,5);
	if (curset.proc_view > 0) 
		gtk_widget_show(f1);

	lbl = gtk_label_new("");
	readtrack_info_label = lbl;
	gtk_container_add(GTK_CONTAINER(f1), lbl);
	gtk_misc_set_alignment(GTK_MISC(lbl),0.5,0.5);
	gtk_misc_set_padding(GTK_MISC(lbl),10,0);
	gtk_widget_show(lbl);

	tbl = gtk_table_new(2, 10, TRUE);
	readtrack_info_tbl = tbl;
	gtk_table_set_col_spacing(GTK_TABLE(tbl),1,10);
	gtk_table_set_row_spacings(GTK_TABLE(tbl),5);
	gtk_box_pack_start(GTK_BOX(box1),tbl,FALSE,TRUE,5);
	if (curset.proc_view > 0) 
		gtk_widget_show(tbl);

	l1 = rightjust_gtk_label_new(text(150));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,0,1);
	gtk_widget_show(l1);

	adj1 = (GtkAdjustment *)gtk_adjustment_new(0, 0, 100, 0, 0, 0);
	pbar1 = gtk_progress_bar_new_with_adjustment(adj1);
	readtrack_pbar1 = pbar1;
	gtk_progress_set_format_string(GTK_PROGRESS(pbar1),"%p%%");
	gtk_progress_set_show_text(GTK_PROGRESS(pbar1),TRUE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),pbar1,2,10,0,1);
	gtk_widget_show(pbar1);

	l1 = rightjust_gtk_label_new(text(151));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,1,2);
	gtk_widget_show(l1);

	adj2 = (GtkAdjustment *)gtk_adjustment_new(0, 0, 100, 0, 0, 0);
	pbar2 = gtk_progress_bar_new_with_adjustment(adj2);
	readtrack_pbar2 = pbar2;
	gtk_progress_set_format_string(GTK_PROGRESS(pbar2),"%p%%");
	gtk_progress_set_show_text(GTK_PROGRESS(pbar2),TRUE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),pbar2,2,10,1,2);
	gtk_widget_show(pbar2);

	tbl = gtk_table_new(1, 10, TRUE);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),6,10);
	gtk_table_set_row_spacings(GTK_TABLE(tbl),5);
	gtk_box_pack_start(GTK_BOX(box1),tbl,FALSE,TRUE,0);
	gtk_widget_show(tbl);

	lbl = gtk_label_new("");
	readtrack_small_info = lbl;
	gtk_table_attach_defaults(GTK_TABLE(tbl),lbl,0,3,0,1);
	if (curset.proc_view == 0) 
		gtk_widget_show(lbl);

	lbl = gtk_label_new("");
	readtrack_small_info2 = lbl;
	gtk_table_attach_defaults(GTK_TABLE(tbl),lbl,3,5,0,1);
	if (curset.proc_view == 0) 
		gtk_widget_show(lbl);

	l1 = rightjust_gtk_label_new(text(152));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,5,7,0,1);
	gtk_widget_show(l1);

	omenu = gtk_option_menu_new();
	menu = gtk_menu_new();
	menuidx = 0; menuhistory = -1;

	for (i=0; i<3; i++) {
		menu_item = gtk_menu_item_new_with_label(text(153+i));
		gtk_signal_connect(GTK_OBJECT(menu_item),
			"activate", GTK_SIGNAL_FUNC(viewmode_selected),
			GINT_TO_POINTER(i));
		gtk_menu_append (GTK_MENU (menu), menu_item);
		if (curset.proc_view == i) { menuhistory = menuidx; }
		menuidx++;
		gtk_widget_show (menu_item);
	}
	gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
	if (menuhistory != -1) {
		gtk_option_menu_set_history(GTK_OPTION_MENU (omenu),menuhistory);
	} else {
		curset.proc_view = 1;
		gtk_option_menu_set_history(GTK_OPTION_MENU (omenu),1);
	}
	gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,7,10,0,1);
	gtk_widget_show(omenu);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	viewmode_scrolled = scrolled_win;
	gtk_container_set_border_width (GTK_CONTAINER (scrolled_win), 5);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(box1),scrolled_win,TRUE,TRUE,0);

	/* show only in extended view */
	if (curset.proc_view == 2) 
		gtk_widget_show(scrolled_win);

	txt = gtk_text_new(NULL,NULL);
	readtrack_textview = txt;
	gtk_text_set_editable(GTK_TEXT(txt),FALSE);
	gtk_text_set_word_wrap(GTK_TEXT(txt),TRUE);
	gtk_container_add(GTK_CONTAINER(scrolled_win), txt);
	gtk_widget_show(txt);

	gtk_widget_show(box1);

	b1_sep = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(box1),b1_sep,FALSE,TRUE,0);
	gtk_widget_show(b1_sep);

	box2 = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(box1),box2,FALSE,TRUE,10);
	gtk_widget_show(box2);

	button1 = gtk_button_new_with_label(T_CANCEL);
	readtrack_button = button1;
	gtk_box_pack_start(GTK_BOX(box2),button1,TRUE,TRUE,10);
	gtk_widget_show(button1);
	GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (button1);
	gtk_signal_connect(GTK_OBJECT(button1),"clicked",
		GTK_SIGNAL_FUNC(show_verifytrack_btn_press), GINT_TO_POINTER(-1));

	button2 = gtk_button_new_with_label(text(162));
	readtrack_savebutton = button2;
	gtk_box_pack_start(GTK_BOX(box2),button2,TRUE,TRUE,10);
	GTK_WIDGET_SET_FLAGS (button2, GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(button2),"clicked",
		GTK_SIGNAL_FUNC(show_verifytrack_save_press), GINT_TO_POINTER(-1));
	/* show only in extended view */
	if (curset.proc_view == 2) 
		gtk_widget_show(button2);


	/* grab cursor and change to watch */
        gtk_grab_add(dialog);
	gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
			(gpointer) &win_attr);
	normal_cursor = win_attr->cursor;
        cursor = gdk_cursor_new(GDK_WATCH);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
	gdk_cursor_destroy (cursor);

	/* only center window when toplevel visible */
	if ( GTK_WIDGET_VISIBLE(toplevel)) {
        	gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
        	gdk_window_get_origin(GTK_WIDGET(toplevel)->window,&xpos,&ypos);
        	gdk_window_get_size(GTK_WIDGET(toplevel)->window,&xsize,&ysize);
		gtk_widget_size_request(dialog,&rq);
        	gtk_widget_set_uposition(GTK_WIDGET(dialog),xpos+xsize/2-rq.width/2,ypos+ysize/2-rq.height/2);
	}

	gtk_widget_show(dialog);

	/* here is the action */
	start_verify_action(devnr);

	/* when done with reading rename button to OK */
	gtk_label_set_text(GTK_LABEL(GTK_BIN(readtrack_button)->child),T_OK);

	dobeep(1);
	
	/* now wait until button is pressed */
	while (dialog_done == 999) {
		wait_and_process_events();
	}

        gtk_grab_remove(GTK_WIDGET(dialog));
	normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
	gdk_cursor_destroy (normal_cursor);

	/* remove dialog window */
        gtk_widget_destroy(dialog);

	return dialog_done;
}


/* called by buttons in dsptest-window */

void dsptest_start(GtkWidget *widget, gpointer data) {

	test_dspdevice_play();
}

void dsptest_cancel(GtkWidget *widget, gpointer data) {

	dialog_done2 = -1; 
}

gint dsptest_delete_event(GtkWidget *widget, GdkEvent *event, gpointer data) {

	dsptest_cancel(widget,data);
        return(TRUE);
}

/* popup a modal window, set cursor to watch, return 0 if correct
   data was received from cddb-server, -1 if not or 
   when cancel or delete_event found.
   Centers automatically above the toplevel-widow 
*/

void show_setup_dsptest() {
GtkWidget *dialog;
GtkWidget *button1, *button2;
GtkWidget *box1,*box2,*box3,*txt;
GtkWidget *f1;
gint xpos, ypos;
gint xsize, ysize;
GdkCursor *cursor,*normal_cursor;
GtkRequisition rq;
GdkWindowAttr *win_attr;

	/* if another dialog is running, ignore */
	if (dialog_done2 == 999) {
		return;
	}

	dodebug(8, "displaying show_setup_dsptest\n");

	/* mark our dialog as running */
	dialog_done2 = 999;
	misc_timer = 0;

	/* create new window and position it relative to the main window */
        dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),text(2));
	gtk_widget_set_usize(dialog,tbf(420),tbf(160)); 
	/* make sure our window is always on top */
	gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(toplevel));

        gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
                GTK_SIGNAL_FUNC (dsptest_delete_event), (gpointer) dialog);

	/* create layout for dialog */
        box1 = gtk_vbox_new(FALSE,0);
	gtk_container_set_border_width (GTK_CONTAINER (box1), 5);
        gtk_container_add(GTK_CONTAINER(dialog),box1);

	f1 = gtk_frame_new(text(273));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(box1),f1,TRUE,TRUE,0);
	gtk_widget_show(f1);

	box2 = gtk_vbox_new(FALSE,0);
	gtk_container_set_border_width (GTK_CONTAINER (box2), 5);
	gtk_container_add(GTK_CONTAINER(f1),box2);
	gtk_widget_show(box2);


	txt = gtk_text_new(NULL,NULL);
	blank_text_window = txt;
	gtk_text_set_editable(GTK_TEXT(txt),FALSE);
	gtk_text_set_word_wrap(GTK_TEXT(txt),TRUE);
	gtk_box_pack_start(GTK_BOX(box2),txt,TRUE,TRUE,0);
	gtk_widget_show(txt);

	gtk_widget_show(box1);

	box3 = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(box1),box3,FALSE,TRUE,5);
	gtk_widget_show(box3);

	button1 = gtk_button_new_with_label(text(274));
	gtk_box_pack_start(GTK_BOX(box3),button1,TRUE,TRUE,10);
	gtk_widget_show(button1);
	gtk_signal_connect(GTK_OBJECT(button1),"clicked",
		GTK_SIGNAL_FUNC(dsptest_start), NULL);

	button2 = gtk_button_new_with_label(T_CLOSE);
	readtrack_button = button2;
	gtk_box_pack_start(GTK_BOX(box3),button2,TRUE,TRUE,10);
	gtk_widget_show(button2);
	gtk_signal_connect(GTK_OBJECT(button2),"clicked",
		GTK_SIGNAL_FUNC(dsptest_cancel), GINT_TO_POINTER(-1));


	/* grab cursor and change to watch */
        gtk_grab_add(dialog);
	gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
			(gpointer) &win_attr);
	normal_cursor = win_attr->cursor;
        cursor = gdk_cursor_new(GDK_WATCH);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
	gdk_cursor_destroy (cursor);

	/* only center window when toplevel visible */
	if ( GTK_WIDGET_VISIBLE(toplevel)) {
        	gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
        	gdk_window_get_origin(GTK_WIDGET(toplevel)->window,&xpos,&ypos);
        	gdk_window_get_size(GTK_WIDGET(toplevel)->window,&xsize,&ysize);
		gtk_widget_size_request(dialog,&rq);
        	gtk_widget_set_uposition(GTK_WIDGET(dialog),xpos+xsize/2-rq.width/2,ypos+ysize/2-rq.height/2);
	}

	/* now fill text-widget with infos */
	gtk_text_insert(GTK_TEXT(txt),NULL,NULL,NULL,
		text(275), strlen(text(275)));

	gtk_widget_show(dialog);


	/* now wait until button is pressed */
	while (dialog_done2 == 999) {
		wait_and_process_events();
	}

        gtk_grab_remove(GTK_WIDGET(dialog));
	normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
	gdk_cursor_destroy (normal_cursor);

	/* remove dialog window */
        gtk_widget_destroy(dialog);
}


void redirect_ok(GtkWidget *widget, gpointer data) {

	dialog_done2 = 0; 
}

void redirect_cancel(GtkWidget *widget, gpointer data) {

	dialog_done2 = -1; 
}

gint redirect_delete_event(GtkWidget *widget, GdkEvent *event, gpointer data) {

	redirect_cancel(widget,data);
        return(TRUE);
}


/* popup a modal window, set cursor to watch, return 0 if correct
   data was entered, -1 if not or 
   when cancel or delete_event found.
   Centers automatically above the toplevel-widow 
*/

gint show_request_redirect_path(gchar *path, gchar *ret) {
GtkWidget *dialog;
GtkWidget *button1, *button2;
GtkWidget *box1,*box2,*box3;
GtkWidget *f1, *l1, *entry;
gint xpos, ypos;
gint xsize, ysize;
GdkCursor *cursor,*normal_cursor;
GtkRequisition rq;
GdkWindowAttr *win_attr;
gchar tmp[MAXLINE];

	/* if another dialog is running, ignore */
	if (dialog_done2 == 999) {
		return -1;
	}

	dodebug(8, "displaying show_request_redirect_path\n");

	/* mark our dialog as running */
	dialog_done2 = 999;

	/* create new window and position it relative to the main window */
        dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),text(2));
	gtk_widget_set_usize(dialog,tbf(420),0); 
	/* make sure our window is always on top */
	gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(toplevel));

        gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
                GTK_SIGNAL_FUNC (redirect_delete_event), (gpointer) dialog);

	/* create layout for dialog */
        box1 = gtk_vbox_new(FALSE,0);
	gtk_container_set_border_width (GTK_CONTAINER (box1), 5);
        gtk_container_add(GTK_CONTAINER(dialog),box1);
	gtk_widget_show(box1);

	f1 = gtk_frame_new(text(382));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(box1),f1,TRUE,TRUE,0);
	gtk_widget_show(f1);

	box2 = gtk_vbox_new(FALSE,5);
	gtk_container_set_border_width (GTK_CONTAINER (box2), 5);
	gtk_container_add(GTK_CONTAINER(f1),box2);
	gtk_widget_show(box2);

	l1 = gtk_label_new(text(383));
	gtk_box_pack_start(GTK_BOX(box2),l1,FALSE,FALSE,0);
	gtk_widget_show(l1);

	f1 = gtk_frame_new(NULL);

	gtk_frame_set_shadow_type(GTK_FRAME(f1),GTK_SHADOW_IN);
	gtk_box_pack_start(GTK_BOX(box2),f1,FALSE,FALSE,5);
	gtk_widget_show(f1);

	l1 = gtk_label_new(path);
	gtk_container_add(GTK_CONTAINER(f1),l1);
	gtk_widget_show(l1);	

	l1 = gtk_label_new("=>");
	gtk_box_pack_start(GTK_BOX(box2),l1,FALSE,FALSE,0);
	gtk_widget_show(l1);	
	
	entry = gtk_entry_new();
	gtk_box_pack_start(GTK_BOX(box2),entry,FALSE,FALSE,5);
	gtk_widget_show(entry);
	gtk_entry_set_text(GTK_ENTRY(entry), ret);

	box3 = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(box1),box3,FALSE,TRUE,10);
	gtk_widget_show(box3);

	button1 = gtk_button_new_with_label(T_OK);
	gtk_box_pack_start(GTK_BOX(box3),button1,TRUE,TRUE,10);
	gtk_widget_show(button1);
	gtk_signal_connect(GTK_OBJECT(button1),"clicked",
		GTK_SIGNAL_FUNC(redirect_ok), NULL);

	button2 = gtk_button_new_with_label(T_CANCEL);
	readtrack_button = button2;
	gtk_box_pack_start(GTK_BOX(box3),button2,TRUE,TRUE,10);
	gtk_widget_show(button2);
	gtk_signal_connect(GTK_OBJECT(button2),"clicked",
		GTK_SIGNAL_FUNC(redirect_cancel), GINT_TO_POINTER(-1));


	/* grab cursor and change to watch */
        gtk_grab_add(dialog);
	gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
			(gpointer) &win_attr);
	normal_cursor = win_attr->cursor;
        cursor = gdk_cursor_new(GDK_WATCH);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
	gdk_cursor_destroy (cursor);

	/* only center window when toplevel visible */
	if ( GTK_WIDGET_VISIBLE(toplevel)) {
        	gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
        	gdk_window_get_origin(GTK_WIDGET(toplevel)->window,&xpos,&ypos);
        	gdk_window_get_size(GTK_WIDGET(toplevel)->window,&xsize,&ysize);
		gtk_widget_size_request(dialog,&rq);
        	gtk_widget_set_uposition(GTK_WIDGET(dialog),xpos+xsize/2-rq.width/2,ypos+ysize/2-rq.height/2);
	}

	gtk_widget_show(dialog);


	/* now wait until button is pressed */
	while (dialog_done2 == 999) {
		wait_and_process_events();
	}

	/* ok pressed? */
	if (dialog_done2 == 0) {
		strncpy(tmp, gtk_entry_get_text(GTK_ENTRY(entry)), MAXLINE);
		strip_string(tmp);

		/* if our master-path is a directory, add a slash to 
		   the redirection */
		if (is_directory(path) && strlen(tmp) > 0) {
			if (tmp[strlen(tmp)-1] != '/') {
				strcat(tmp,"/");
			}	
		}

		strcpy(ret, tmp);
	} else {
		/* aborted */
		strcpy(ret,"");
	}

        gtk_grab_remove(GTK_WIDGET(dialog));
	normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
	gdk_cursor_destroy (normal_cursor);

	/* remove dialog window */
        gtk_widget_destroy(dialog);

	return dialog_done2;
}


/* popup a modal window, set cursor to watch, return path or NULL-string 
   when cancel or delete_event found.
   Centers automatically above the toplevel-widow 
*/

void show_mkisofs_check_output(gint automode) {
GtkWidget *dialog;
GtkWidget *button1;
GtkWidget *box1,*box2,*txt;
GtkWidget *f1;
GtkWidget *scrolled_win;
gint xpos, ypos;
gint xsize, ysize;
GdkCursor *cursor,*normal_cursor;
GtkRequisition rq;
GdkWindowAttr *win_attr;
gchar tmp[MAXLINE];
GdkColor c;

	/* if another dialog is running, ignore */
	if (dialog_done == 999) {
		return;
	}

	dodebug(8, "displaying show_mkisofs_check_output (automode = %d)\n", automode);

	/* mark our dialog as running */
	dialog_done = 999;

	/* create new window and position it relative to the main window */
        dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),text(2));
	gtk_widget_set_usize(dialog,tbf(500),tbf(300)); 
	/* make sure our window is always on top */
	gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(toplevel));

        gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
                GTK_SIGNAL_FUNC (dialog_delete_event), (gpointer) dialog);

	/* create layout for dialog */
        box1 = gtk_vbox_new(FALSE,0);
	gtk_container_set_border_width (GTK_CONTAINER (box1), 5);
        gtk_container_add(GTK_CONTAINER(dialog),box1);

	f1 = gtk_frame_new(text(395));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(box1),f1,TRUE,TRUE,0);
	gtk_widget_show(f1);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_container_set_border_width (GTK_CONTAINER (scrolled_win), 5);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_container_add(GTK_CONTAINER(f1),scrolled_win);
	gtk_widget_show(scrolled_win);
	
	txt = gtk_text_new(NULL,NULL);
	gtk_text_set_editable(GTK_TEXT(txt),FALSE);
	gtk_text_set_word_wrap(GTK_TEXT(txt),TRUE);
	gtk_container_add(GTK_CONTAINER(scrolled_win), txt);
	gtk_widget_show(txt);

	gtk_widget_show(box1);

	box2 = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(box1),box2,FALSE,TRUE,5);
	gtk_widget_show(box2);

	button1 = gtk_button_new_with_label(T_CANCEL);
	readtrack_button = button1;
	gtk_box_pack_start(GTK_BOX(box2),button1,TRUE,TRUE,10);
	gtk_widget_show(button1);
	GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(readtrack_button),"clicked",
		GTK_SIGNAL_FUNC(dialog_btn_press), GINT_TO_POINTER(0));


	/* grab cursor and change to watch */
        gtk_grab_add(dialog);
	gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
			(gpointer) &win_attr);
	normal_cursor = win_attr->cursor;
        cursor = gdk_cursor_new(GDK_WATCH);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
	gdk_cursor_destroy (cursor);

	/* only center window when toplevel visible */
	if ( GTK_WIDGET_VISIBLE(toplevel)) {
        	gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
        	gdk_window_get_origin(GTK_WIDGET(toplevel)->window,&xpos,&ypos);
        	gdk_window_get_size(GTK_WIDGET(toplevel)->window,&xsize,&ysize);
		gtk_widget_size_request(dialog,&rq);
        	gtk_widget_set_uposition(GTK_WIDGET(dialog),xpos+xsize/2-rq.width/2,ypos+ysize/2-rq.height/2);
	}

	/* show only when not in automatic mode */
	if (automode == 0) 
		gtk_widget_show(dialog);

	/* now fill text-widget with infos */
	fill_mkisofs_check_info(txt);
	/* gtk_text_set_point(GTK_TEXT(txt),0); */

	/* when done with reading rename button to OK */
	gtk_label_set_text(GTK_LABEL(GTK_BIN(readtrack_button)->child),T_OK);

	/* getting size failed in auto mode */
	if (automode && masterparam.session_size == 0) {

		/* display dialog now to show the problem */
		gtk_widget_show(dialog);

		/* scroll to last line */
		gtk_text_set_point(GTK_TEXT(txt), 
			gtk_text_get_length(GTK_TEXT(txt)));
		g_snprintf(tmp,MAXLINE,"\n%s\n", text(510));
		gdk_color_parse("red",&c);
		if (!gdk_color_alloc(gtk_widget_get_colormap(dialog),&c)) {
			/* getting color failed, dont use it */
			gtk_text_insert(GTK_TEXT(txt), NULL, NULL, NULL,
				tmp, strlen(tmp));
		} else {
			gtk_text_insert(GTK_TEXT(txt), NULL, &c, NULL,
				tmp, strlen(tmp));
		}
	}

	/* getting size successful in auto mode? */
	if (automode && masterparam.session_size > 0) {
		/* trigger not to wait for a button */
		dialog_done = 0;
	}

	/* now wait until button is pressed */
	while (dialog_done == 999) {
		wait_and_process_events();
	}

        gtk_grab_remove(GTK_WIDGET(dialog));
	normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
	gdk_cursor_destroy (normal_cursor);

	/* remove dialog window */
        gtk_widget_destroy(dialog);
}


void show_master_save_press(GtkWidget *widget, gpointer data) {
char tmp[MAXLINE];

	/* show fileselector */
	show_file_selector(text(162), SAVEMASTERTRACK,tmp);
	
	/* not cancel pressed? */
	if (strcmp(tmp,"") != 0) {
		if (save_text2file(tmp, readtrack_textview) == 0) {
			show_dialog(ICO_INFO,text(270), T_OK, NULL, NULL, 0);
		}
	}
}


/* popup a modal window and start to master a image to the harddisk */

gint show_and_start_master() {
GtkWidget *omenu;
GtkWidget *menu;
GtkWidget *menu_item;
GtkWidget *dialog;
GtkWidget *l1;
GtkWidget *button1, *button2;
GtkWidget *box1,*box2,*txt;
GtkWidget *f1, *tbl;
GtkWidget *b1_sep, *lbl;
GtkWidget *scrolled_win;
gint xpos, ypos;
gint xsize, ysize;
GdkCursor *cursor,*normal_cursor;
GtkRequisition rq;
GdkWindowAttr *win_attr;
GtkAdjustment *adj1;
GtkWidget *pbar1;
gint i, menuidx, menuhistory;

	/* if another dialog is running, ignore */
	if (dialog_done == 999) {
		return -1;
	}

	dodebug(8, "displaying show_and_start_master\n");
	
	/* mark our dialog as running */
	dialog_done = 999;

	/* create new window and position it relative to the main window */
        dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	viewmode_dialog = dialog;
	gtk_window_set_title(GTK_WINDOW(dialog),text(2));
	gtk_widget_set_usize(dialog,tbf(400),0);
	/* make sure our window is always on top */
	gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(toplevel));

        gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
                GTK_SIGNAL_FUNC (readtrack_dialog_delete_event), 
		(gpointer) dialog);

	/* create layout for dialog */
        box1 = gtk_vbox_new(FALSE,5);
	gtk_container_set_border_width (GTK_CONTAINER (box1), 5);
        gtk_container_add(GTK_CONTAINER(dialog),box1);

	f1 = gtk_frame_new(NULL);
	readtrack_info_frame = f1;
	gtk_frame_set_shadow_type(GTK_FRAME(f1),GTK_SHADOW_IN);
	gtk_widget_set_usize(f1,0,36);
	gtk_box_pack_start(GTK_BOX(box1),f1,FALSE,TRUE,5);
	if (curset.proc_view > 0) 
		gtk_widget_show(f1);

	lbl = gtk_label_new("");
	readtrack_info_label = lbl;
	gtk_container_add(GTK_CONTAINER(f1), lbl);
	gtk_misc_set_alignment(GTK_MISC(lbl),0.5,0.5);
	gtk_misc_set_padding(GTK_MISC(lbl),10,0);
	gtk_widget_show(lbl);

	tbl = gtk_table_new(1, 10, TRUE);
	readtrack_info_tbl = tbl;
	gtk_table_set_col_spacing(GTK_TABLE(tbl),1,10);
	gtk_table_set_row_spacings(GTK_TABLE(tbl),5);
	gtk_box_pack_start(GTK_BOX(box1),tbl,FALSE,TRUE,5);
	if (curset.proc_view > 0) 
		gtk_widget_show(tbl);

	l1 = rightjust_gtk_label_new(text(150));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,0,2,0,1);
	gtk_widget_show(l1);

	adj1 = (GtkAdjustment *)gtk_adjustment_new(0, 0, 100, 0, 0, 0);
	pbar1 = gtk_progress_bar_new_with_adjustment(adj1);
	readtrack_pbar1 = pbar1;
	gtk_progress_set_format_string(GTK_PROGRESS(pbar1),"%p%%");
	gtk_progress_set_show_text(GTK_PROGRESS(pbar1),TRUE);
	gtk_table_attach_defaults(GTK_TABLE(tbl),pbar1,2,10,0,1);
	gtk_widget_show(pbar1);

	tbl = gtk_table_new(1, 10, TRUE);
	gtk_table_set_col_spacing(GTK_TABLE(tbl),6,10);
	gtk_table_set_row_spacings(GTK_TABLE(tbl),5);
	gtk_box_pack_start(GTK_BOX(box1),tbl,FALSE,TRUE,0);
	gtk_widget_show(tbl);

	lbl = gtk_label_new("");
	readtrack_small_info = lbl;
	gtk_table_attach_defaults(GTK_TABLE(tbl),lbl,0,3,0,1);
	if (curset.proc_view == 0) 
		gtk_widget_show(lbl);

	lbl = gtk_label_new("");
	readtrack_small_info2 = lbl;
	gtk_table_attach_defaults(GTK_TABLE(tbl),lbl,3,5,0,1);
	if (curset.proc_view == 0) 
		gtk_widget_show(lbl);

	l1 = rightjust_gtk_label_new(text(152));
	gtk_table_attach_defaults(GTK_TABLE(tbl),l1,5,7,0,1);
	gtk_widget_show(l1);

	omenu = gtk_option_menu_new();
	menu = gtk_menu_new();
	menuidx = 0; menuhistory = -1;

	for (i=0; i<3; i++) {
		menu_item = gtk_menu_item_new_with_label(text(153+i));
		gtk_signal_connect(GTK_OBJECT(menu_item),
			"activate", GTK_SIGNAL_FUNC(viewmode_selected),
			GINT_TO_POINTER(i));
		gtk_menu_append (GTK_MENU (menu), menu_item);
		if (curset.proc_view == i) { menuhistory = menuidx; }
		menuidx++;
		gtk_widget_show (menu_item);
	}
	gtk_option_menu_set_menu (GTK_OPTION_MENU (omenu), menu);
	if (menuhistory != -1) {
		gtk_option_menu_set_history(GTK_OPTION_MENU (omenu),menuhistory);
	} else {
		curset.proc_view = 1;
		gtk_option_menu_set_history(GTK_OPTION_MENU (omenu),1);
	}
	gtk_table_attach_defaults(GTK_TABLE(tbl),omenu,7,10,0,1);
	gtk_widget_show(omenu);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	viewmode_scrolled = scrolled_win;
	gtk_container_set_border_width (GTK_CONTAINER (scrolled_win), 5);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
			GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(box1),scrolled_win,TRUE,TRUE,0);

	/* show only in extended view */
	if (curset.proc_view == 2) 
		gtk_widget_show(scrolled_win);

	txt = gtk_text_new(NULL,NULL);
	readtrack_textview = txt;
	gtk_text_set_editable(GTK_TEXT(txt),FALSE);
	gtk_text_set_word_wrap(GTK_TEXT(txt),TRUE);
	gtk_container_add(GTK_CONTAINER(scrolled_win), txt);
	gtk_widget_show(txt);

	gtk_widget_show(box1);

	b1_sep = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(box1),b1_sep,FALSE,TRUE,0);
	gtk_widget_show(b1_sep);

	box2 = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(box1),box2,FALSE,TRUE,10);
	gtk_widget_show(box2);

	button1 = gtk_button_new_with_label(T_CANCEL);
	readtrack_button = button1;
	gtk_box_pack_start(GTK_BOX(box2),button1,TRUE,TRUE,10);
	gtk_widget_show(button1);
	GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (button1);
	gtk_signal_connect(GTK_OBJECT(button1),"clicked",
		GTK_SIGNAL_FUNC(show_readtrack_btn_press), GINT_TO_POINTER(-1));

	button2 = gtk_button_new_with_label(text(162));
	readtrack_savebutton = button2;
	gtk_box_pack_start(GTK_BOX(box2),button2,TRUE,TRUE,10);
	GTK_WIDGET_SET_FLAGS (button2, GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(button2),"clicked",
		GTK_SIGNAL_FUNC(show_master_save_press), GINT_TO_POINTER(-1));
	/* show only in extended view */
	if (curset.proc_view == 2) 
		gtk_widget_show(button2);


	/* grab cursor and change to watch */
        gtk_grab_add(dialog);
	gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
			(gpointer) &win_attr);
	normal_cursor = win_attr->cursor;
        cursor = gdk_cursor_new(GDK_WATCH);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
	gdk_cursor_destroy (cursor);

	/* only center window when toplevel visible */
	if ( GTK_WIDGET_VISIBLE(toplevel)) {
        	gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
        	gdk_window_get_origin(GTK_WIDGET(toplevel)->window,&xpos,&ypos);
        	gdk_window_get_size(GTK_WIDGET(toplevel)->window,&xsize,&ysize);
		gtk_widget_size_request(dialog,&rq);
        	gtk_widget_set_uposition(GTK_WIDGET(dialog),xpos+xsize/2-rq.width/2,ypos+ysize/2-rq.height/2);
	}

	gtk_widget_show(dialog);

	/* here is the action */
	start_master_action();

	/* update image-dir-lists */
	scan_imagedirs();

	/* when done with reading rename button to OK */
	gtk_label_set_text(GTK_LABEL(GTK_BIN(readtrack_button)->child),T_OK);
	
	dobeep(1);

	/* now wait until button is pressed */
	while (dialog_done == 999) {
		wait_and_process_events();
	}

        gtk_grab_remove(GTK_WIDGET(dialog));
	normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
	gdk_cursor_destroy (normal_cursor);

	/* remove dialog window */
        gtk_widget_destroy(dialog);

	return dialog_done;
}


/* called from radio buttons in redir menu */

void redir_type_selected(GtkWidget *item, gpointer data) {

	masterparam.redirtype = GPOINTER_TO_INT(data); 

	if (!redir_entry) return;

	if (masterparam.redirtype != 3) {
		gtk_widget_set_sensitive(redir_entry, FALSE);
	} else {
		gtk_widget_set_sensitive(redir_entry, TRUE);
	}
}


/* called from radio buttons in redir_multi menu */

void redir_type_selected2(GtkWidget *item, gpointer data) {

	masterparam.redirtype2 = GPOINTER_TO_INT(data); 

	if (!redir_entry) return;

	if (masterparam.redirtype2 != 2) {
		gtk_widget_set_sensitive(redir_entry, FALSE);
	} else {
		gtk_widget_set_sensitive(redir_entry, TRUE);
	}
}


/* popup a modal window, where the user can choose where
   to add the new directory on the target CD. 
   Centers automatically above the toplevel-widow 
*/

gint show_mstr_redir(gchar *dir, gchar *ret) {
GtkWidget *dialog;
GtkWidget *button1;
GtkWidget *button2, *entry;
GtkWidget *box1,*box2,*box3;
GtkWidget *f1, *f2, *f3, *l1;
GtkWidget *b1_sep, *lbl, *btn;
GSList *group;
gint xpos, ypos;
gint xsize, ysize;
GdkCursor *cursor,*normal_cursor;
GtkRequisition rq;
GdkWindowAttr *win_attr;
gchar redir[MAXLINE], redir2[MAXLINE], tmp2[MAXLINE];
gint is_dir;
gint bak_redirtype;
gchar *p;

	/* if another dialog is running, ignore */
	if (dialog_done == 999) {
		return -1;
	}

	dodebug(8, "displaying show_mstr_redir\n");

	/* mark our dialog as running */
	dialog_done = 999;

	bak_redirtype = masterparam.redirtype;
	redir_entry = NULL;

	/* create new window and position it relative to the main window */
        dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),text(2));
	gtk_widget_set_usize(dialog,tbf(450),tbf(320));
	/* make sure our window is always on top */
	gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(toplevel));
	cddb_window = dialog;

        gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
                GTK_SIGNAL_FUNC (dialog_delete_event), (gpointer) dialog);

	/* create layout for dialog */
        box1 = gtk_vbox_new(FALSE,5);
	gtk_container_set_border_width (GTK_CONTAINER (box1), 5);
        gtk_container_add(GTK_CONTAINER(dialog),box1);
	gtk_widget_show(box1);

	f1 = gtk_frame_new(text(441));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(box1),f1,TRUE,TRUE,0);
	gtk_widget_show(f1);

	box2 = gtk_vbox_new(FALSE,0);
	gtk_container_set_border_width (GTK_CONTAINER (box2), 5);
	gtk_container_add(GTK_CONTAINER(f1),box2);
	gtk_widget_show(box2);

	f2 = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(f2),GTK_SHADOW_IN);
	gtk_box_pack_start(GTK_BOX(box2),f2,FALSE,TRUE,5);
	gtk_widget_show(f2);

	l1 = gtk_label_new(dir);
	gtk_container_add(GTK_CONTAINER(f2),l1);
	gtk_misc_set_alignment(GTK_MISC(l1),0.5,0.5);
	gtk_misc_set_padding(GTK_MISC(l1),5,5);
	gtk_widget_show(l1);

	/* handling a file or a directory here? */
	is_dir = is_directory(dir);

	if (is_dir) {
		lbl = gtk_label_new(text(442));
	} else {
		lbl = gtk_label_new(text(443));
	}
	gtk_box_pack_start(GTK_BOX(box2),lbl,FALSE,TRUE,5);
	gtk_widget_show(lbl);

        b1_sep = gtk_hseparator_new();
        gtk_box_pack_start(GTK_BOX(box2),b1_sep,FALSE,TRUE,5);
	gtk_widget_show(b1_sep);

	btn = gtk_radio_button_new_with_label(NULL,text(444));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(redir_type_selected),GINT_TO_POINTER(0));

	gtk_box_pack_start(GTK_BOX(box2),btn,FALSE,TRUE,0);
	gtk_widget_show(btn);
	define_tooltip(btn,help(177));
	if (masterparam.redirtype == 0) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);
	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));

	strncpy(redir,dir,MAXLINE);
	get_basedir(redir);
	if (redir == NULL) { 
		strcpy(redir,"/"); 
	} else {
		/* look for last slash */
		p = rindex(redir,'/');
		if (p) {
			/* use only the part beginning from last slash */
			strncpy(tmp2, p, MAXLINE);
			strncpy(redir, tmp2, MAXLINE);
		} else {
			strcpy(redir,"/"); 
		}
	}

	g_snprintf(tmp2,MAXLINE,text(480), redir);

	btn = gtk_radio_button_new_with_label(group,tmp2);
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(redir_type_selected),GINT_TO_POINTER(1));
	gtk_box_pack_start(GTK_BOX(box2),btn,FALSE,TRUE,0);
	gtk_widget_show(btn);
	define_tooltip(btn,help(190));
	if (masterparam.redirtype == 1) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);
	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));

	strncpy(redir2,dir,MAXLINE);
	get_basedir(redir2);
	if (redir2 == NULL) { strcpy(redir2,"/"); }

	g_snprintf(tmp2,MAXLINE,text(445), redir2);

	btn = gtk_radio_button_new_with_label(group,tmp2);
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(redir_type_selected),GINT_TO_POINTER(2));
	gtk_box_pack_start(GTK_BOX(box2),btn,FALSE,TRUE,0);
	gtk_widget_show(btn);
	define_tooltip(btn,help(178));
	if (masterparam.redirtype == 2) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);
	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));
	
	btn = gtk_radio_button_new_with_label(group,text(446));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(redir_type_selected),GINT_TO_POINTER(3));
	gtk_box_pack_start(GTK_BOX(box2),btn,FALSE,TRUE,0);
	gtk_widget_show(btn);
	define_tooltip(btn,help(179));
	if (masterparam.redirtype == 3) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);

	f3 = gtk_hbox_new(FALSE,0);
        gtk_box_pack_start(GTK_BOX(box2),f3,FALSE,FALSE,5);
	gtk_widget_show(f3);

        entry = gtk_entry_new();
	redir_entry = entry;
	gtk_box_pack_start(GTK_BOX(f3),entry,TRUE,TRUE,20);
        gtk_widget_show(entry);
	gtk_entry_set_text(GTK_ENTRY(entry), masterparam.lastredirpath);
	if (masterparam.redirtype != 3) 
		gtk_widget_set_sensitive(redir_entry, FALSE);

	box3 = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(box1),box3,FALSE,TRUE,10);
	gtk_widget_show(box3);

	button1 = gtk_button_new_with_label(T_OK);
	cddb_info_okbutton = button1;
	gtk_box_pack_start(GTK_BOX(box3),button1,TRUE,TRUE,10);
	gtk_widget_show(button1);
	GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (button1);
	gtk_signal_connect(GTK_OBJECT(button1),"clicked",
		GTK_SIGNAL_FUNC(dialog_btn_press), GINT_TO_POINTER(0));

	button2 = gtk_button_new_with_label(T_CANCEL);
	gtk_box_pack_start(GTK_BOX(box3),button2,TRUE,TRUE,10);
	gtk_widget_show(button2);
	GTK_WIDGET_SET_FLAGS (button2, GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(button2),"clicked",
		GTK_SIGNAL_FUNC(dialog_btn_press), GINT_TO_POINTER(-1));


	/* grab cursor and change to watch */
        gtk_grab_add(dialog);
	gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
			(gpointer) &win_attr);
	normal_cursor = win_attr->cursor;
        cursor = gdk_cursor_new(GDK_WATCH);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
	gdk_cursor_destroy (cursor);

	/* only center window when toplevel visible */
	if ( GTK_WIDGET_VISIBLE(toplevel)) {
        	gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
        	gdk_window_get_origin(GTK_WIDGET(toplevel)->window,&xpos,&ypos);
        	gdk_window_get_size(GTK_WIDGET(toplevel)->window,&xsize,&ysize);
		gtk_widget_size_request(dialog,&rq);
        	gtk_widget_set_uposition(GTK_WIDGET(dialog),xpos+xsize/2-rq.width/2,ypos+ysize/2-rq.height/2);
	}

	gtk_widget_show(dialog);


	/* now wait until button is pressed */
	while (dialog_done == 999) {
		wait_and_process_events();
	}

        gtk_grab_remove(GTK_WIDGET(dialog));
	normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
	gdk_cursor_destroy (normal_cursor);

	if (dialog_done != 0) {
		/* restore original value of type */
		masterparam.redirtype = bak_redirtype;
		strcpy(redir,"");
	} else {
		/* ok pressed, do some business */
		g_free(masterparam.lastredirpath);
		masterparam.lastredirpath = g_strdup(
			gtk_entry_get_text(GTK_ENTRY(redir_entry)));

		if (masterparam.redirtype == 0) {
			strcpy(redir,"/");
		}

		if (masterparam.redirtype == 2) {
			strcpy(redir,redir2);
		}

		if (masterparam.redirtype == 3) {
			strncpy(redir,masterparam.lastredirpath, MAXLINE);
		}
		strip_string(redir);

		/* because we handle only directories here, add a slash */
                if (strlen(redir) > 0) {
                        if (redir[strlen(redir)-1] != '/') {
                                strcat(redir,"/");
                        }       
                }
	}

	/* remove dialog window */
        gtk_widget_destroy(dialog);

	/* now "redir" contains the string where we want to go */
	strncpy(ret, redir, MAXLINE);

	return dialog_done;
}


/* radio button to sync all cdtext artists */

void cdtext_sync_artist(GtkWidget *item, gpointer data) {
gint i;
gchar *p;

	curset.sync_cdtext_artist = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(item));

	i = 1;
	/* sync all */ 
	if (curset.sync_cdtext_artist == 1) {
		/* get artist of disk */
		p = gtk_entry_get_text(GTK_ENTRY(cdtext_entry2[0]));
		if (!p) return;
		while(cdtext_entry2[i]) {
			/* copy artist to all artists */
			gtk_entry_set_text(GTK_ENTRY(cdtext_entry2[i]), p);
			gtk_widget_set_sensitive(cdtext_entry2[i], FALSE);
			i++;
		}
	} else {
		/* no longer sync all */
		while(cdtext_entry2[i]) {
			gtk_widget_set_sensitive(cdtext_entry2[i], TRUE);
			i++;
		}
	}
}


/* called when the cdtext artist of the disk is changed */

void cdtext_artist_changed(GtkWidget *item, gpointer data) {
gint i;
gchar *p;

	i = 1;
	if (curset.sync_cdtext_artist == 1) {
		p = gtk_entry_get_text(GTK_ENTRY(cdtext_entry2[0]));
		if (!p) return;
		while(cdtext_entry2[i]) {
			/* copy current status to all fields */
			gtk_entry_set_text(GTK_ENTRY(cdtext_entry2[i]), p);
			i++;
		}
	}
}


/* called by clear all button */

void cdtext_clear_all(GtkWidget *item, gpointer data) {
gint i;

	i = 0;
	while(cdtext_entry1[i]) {
		gtk_entry_set_text(GTK_ENTRY(cdtext_entry1[i]),"");
		gtk_entry_set_text(GTK_ENTRY(cdtext_entry2[i]),"");
		i++;
	}
}


/* called on ok button of cdtext editor (mode 0) */
/* copies the entered cdtext data to memory structure */

void cdtext_edit_ok_mode0() {
gint i;

	/* set cd-info first */
	g_free(cdinfo.title);
	cdinfo.title = g_strdup(gtk_entry_get_text(GTK_ENTRY(cdtext_entry1[0])));
	g_free(cdinfo.artist);
	cdinfo.artist = g_strdup(gtk_entry_get_text(GTK_ENTRY(cdtext_entry2[0])));
	/* free cddb info now */
	if (cdinfo.cddb_dtitle) {
		g_free(cdinfo.cddb_dtitle);
		cdinfo.cddb_dtitle = NULL;
	}

	i = 1; 
	while(cdtext_entry2[i]) {
		/* copy the new entered data to my cd-text data */
		
		g_free(trackinfo[i-1]->title);
		trackinfo[i-1]->title = g_strdup(gtk_entry_get_text(GTK_ENTRY(cdtext_entry1[i])));
		g_free(trackinfo[i-1]->artist);
		trackinfo[i-1]->artist = g_strdup(gtk_entry_get_text(GTK_ENTRY(cdtext_entry2[i])));

		/* free cddb info now */
		if (trackinfo[i-1]->cddb_ttitle) {
			g_free(trackinfo[i-1]->cddb_ttitle);
			trackinfo[i-1]->cddb_ttitle = NULL;
		}
/*
		g_print("%s / %s\n", 
			gtk_entry_get_text(GTK_ENTRY(cdtext_entry1[i])), 
			gtk_entry_get_text(GTK_ENTRY(cdtext_entry2[i])));
*/
		i++;
	}

	/* now the cd-text information is copied to the track-structure..*/
	/* force display of cd-text now */
	setupdata.option_displaycdtext = 1;

}


/* called on ok button of cdtext editor (mode 1 and 2) */
/* write the entered cd-text info to xinf-files and toc */

void cdtext_edit_ok_mode12(gchar *tmptoc) {
gint i;
track_read_param_t *trackparam;
GList *loop;

	/* first edit the toc file */
	if (!tmptoc) {
		if (curset.tocfile && curset.tocfile[0] != '\0') {
			edit_title_artist_in_toc_file(curset.tocfile,
				gtk_entry_get_text(GTK_ENTRY(cdtext_entry1[0])),
				gtk_entry_get_text(GTK_ENTRY(cdtext_entry2[0])));
		}
	} else {
		/* use temporary toc file to edit */
		edit_title_artist_in_toc_file(tmptoc,
			gtk_entry_get_text(GTK_ENTRY(cdtext_entry1[0])),
			gtk_entry_get_text(GTK_ENTRY(cdtext_entry2[0])));
	}

/*
	g_print("edit toc: %s\n", curset.tocfile);
	g_print("title/artist: %s / %s\n",  
		gtk_entry_get_text(GTK_ENTRY(cdtext_entry1[0])),
		gtk_entry_get_text(GTK_ENTRY(cdtext_entry2[0])));
*/
	i = 1; 
	loop = g_list_first(trackreadset.trackparams);
	while(cdtext_entry2[i]) {
		if (!loop) {
			g_error("toc-file inconsistent....should never happen.\n");
		}
		trackparam = loop->data;
		edit_title_artist_in_xinf_file(trackparam->trackfile,
			gtk_entry_get_text(GTK_ENTRY(cdtext_entry1[i])),
			gtk_entry_get_text(GTK_ENTRY(cdtext_entry2[i])));

/*
		g_print("edit xinf: %s\n", trackparam->trackfile);
		g_print("title/artist: %s / %s\n",  
			gtk_entry_get_text(GTK_ENTRY(cdtext_entry1[i])),
			gtk_entry_get_text(GTK_ENTRY(cdtext_entry2[i])));
*/
		loop = loop->next;
		i++;
	}

}


/* show the edit window for cd-text */
/* mode = 0 when called from info-dialog, 
   mode = 1 when called from duplicate write-dialog
   mode = 2 when called from create write-dialog */ 

gint show_edit_cdtext(gint mode, GtkWidget *writetoc_menu) {
GtkWidget *dialog;
GtkWidget *button1;
GtkWidget *button2;
GtkWidget *box1, *box2, *box3, *box4, *scrolled_window;
GtkWidget *f1, *l1, *tbl, *pic;
GtkWidget *lbl, *btn, *e1;
GtkWidget *menu, *menuitem;
gint xpos, ypos;
gint xsize, ysize;
GdkCursor *cursor,*normal_cursor;
GtkRequisition rq;
GdkWindowAttr *win_attr;
gint i;
gchar tmp[MAXLINE], tmp2[MAXLINE];
gchar tmptoc[MAXLINE];
gchar title[MAXLINE], artist[MAXLINE];
gint nrtracks, orgcdtextused;
GtkStyle *style;
GdkPixmap *pixmap1, *pixmap2, *pixmap3;
GdkBitmap *mask1, *mask2, *mask3;
gint bak_sync_cdtext_artist;
track_read_param_t *trackparam;
GList *loop;
image_files_t *entry;
GtkTooltips *tip;

	/* if another dialog is running, ignore */
	if (dialog_done == 999) {
		return -1;
	}

	bak_sync_cdtext_artist = curset.sync_cdtext_artist;
	trackparam = NULL;
	loop = NULL;

	/* cd loaded? */
	if (mode == 0) {
		nrtracks = cdinfo.nr_tracks;
		if (nrtracks < 0) {
			nrtracks = 0;
		}
	} else
	if (mode == 1 || mode == 2) {
		nrtracks = trackreadset.nrtracks;
		loop = g_list_first(trackreadset.trackparams);
	} else {
		return -1;
	}

	/* delete old entry-pointers */
	for (i = 0; i < MAXTRACKS+1; i++) {
		cdtext_entry1[i] = NULL;
		cdtext_entry2[i] = NULL;
	}

	dodebug(8, "displaying show_edit_cdtext\n");

	/* mark our dialog as running */
	dialog_done = 999;

	/* create new window and position it relative to the main window */
        dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),text(2));
	gtk_widget_set_usize(dialog,tbf(600),tbf(400));
	/* make sure our window is always on top */
	gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(toplevel));

        gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
                GTK_SIGNAL_FUNC (dialog_delete_event), (gpointer) dialog);

	/* create layout for dialog */
        box1 = gtk_vbox_new(FALSE,5);
	gtk_container_set_border_width (GTK_CONTAINER (box1), 5);
        gtk_container_add(GTK_CONTAINER(dialog),box1);
	gtk_widget_show(box1);

	f1 = gtk_frame_new(text(475));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(box1),f1,TRUE,TRUE,0);
	gtk_widget_show(f1);

	box2 = gtk_vbox_new(FALSE,0);
	gtk_container_set_border_width (GTK_CONTAINER (box2), 5);
	gtk_container_add(GTK_CONTAINER(f1),box2);
	gtk_widget_show(box2);

	tbl = gtk_table_new(2, 10, TRUE);
	gtk_table_set_row_spacings(GTK_TABLE(tbl),2);
	gtk_table_set_col_spacings(GTK_TABLE(tbl),5);
	gtk_box_pack_start(GTK_BOX(box2),tbl,FALSE,TRUE,0);
	gtk_widget_show(tbl);

	strcpy(title,"");
	strcpy(artist,"");

	/* called from info-screen, get info from cdinfo struct */
	if (mode == 0) {

		/* get title and artist for the current cd */
		orgcdtextused = 0;
		if (setupdata.option_displaycdtext) {
			if (cdinfo.title && cdinfo.artist && cdinfo.title[0] != '\0') {
				strncpy(title, cdinfo.title, MAXLINE);
				strncpy(artist, cdinfo.artist, MAXLINE);
				orgcdtextused = 1;
			}
		}
		if (orgcdtextused == 0) {
			if (cdinfo.cddb_dtitle) {
				get_artist_and_title_from_cddb(cdinfo.cddb_dtitle,
				artist, title);
			} else {
				/* try cd-text as fallback */
				if (cdinfo.title && cdinfo.artist && 
				    cdinfo.title[0] != '\0') {
					strncpy(title, cdinfo.title, MAXLINE);
					strncpy(artist, cdinfo.artist, MAXLINE);
				}
			}
		}
	} else 
	/* read info from trackreadset (dupicate cd-write menu) */
	if (mode == 1) {
		if (trackreadset.cdtitle && trackreadset.cdtitle[0]) {
			get_artist_and_title_from_cddb(trackreadset.cdtitle,
				 artist, title);
		}
	} else 
	/* read cdtitle from temporary toc file for the write-tracks menu */
	if (mode == 2) {
		generate_tmp_tocfile_name(tmptoc);
		get_cdtitle_from_tmp_tocfile(tmptoc, tmp);
		get_artist_and_title_from_cddb(tmp,
				 artist, title);
	}	

	lbl = gtk_label_new(text(476));
	gtk_table_attach_defaults(GTK_TABLE(tbl),lbl,0,2,0,1);
	gtk_widget_show(lbl);

	/* cd-title */
	e1 = gtk_entry_new();
	cdtext_entry1[0] = e1;
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,2,6,0,1);
	gtk_entry_set_text(GTK_ENTRY(e1), title);
	gtk_entry_set_position(GTK_ENTRY(e1), 0);
	if (nrtracks == 0) 
		gtk_widget_set_sensitive(e1, FALSE);
	gtk_widget_show(e1);

	btn = gtk_button_new_with_label(text(479));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(cdtext_clear_all),NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),btn,7,10,0,1);
	gtk_widget_show(btn);	
	define_tooltip(btn,help(188));

	lbl = gtk_label_new(text(477));
	gtk_table_attach_defaults(GTK_TABLE(tbl),lbl,0,2,1,2);
	gtk_widget_show(lbl);


	/* cd-artist */
	e1 = gtk_entry_new();
	cdtext_entry2[0] = e1;
	gtk_table_attach_defaults(GTK_TABLE(tbl),e1,2,6,1,2);
	gtk_signal_connect(GTK_OBJECT(e1),"changed",
		GTK_SIGNAL_FUNC(cdtext_artist_changed),NULL);
	gtk_entry_set_text(GTK_ENTRY(e1), artist);
	gtk_entry_set_position(GTK_ENTRY(e1), 0);
	if (nrtracks == 0) 
		gtk_widget_set_sensitive(e1, FALSE);
	gtk_widget_show(e1);

	btn = gtk_check_button_new_with_label(text(478));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(cdtext_sync_artist),NULL);
	gtk_table_attach_defaults(GTK_TABLE(tbl),btn,6,10,1,2);
	if (nrtracks == 0) 
		gtk_widget_set_sensitive(btn, FALSE);
	gtk_widget_show(btn);	
	define_tooltip(btn,help(189));

	scrolled_window = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window),
     		                  GTK_POLICY_AUTOMATIC, 
                                  GTK_POLICY_AUTOMATIC);
        gtk_box_pack_start(GTK_BOX(box2),scrolled_window,TRUE,TRUE,5);
	gtk_widget_show(scrolled_window);

	box4 = gtk_vbox_new(FALSE,0);
	gtk_scrolled_window_add_with_viewport (
		GTK_SCROLLED_WINDOW (scrolled_window),box4);
	gtk_widget_show(box4);

	tbl = gtk_table_new(nrtracks+1, 21, TRUE);
	gtk_table_set_row_spacings(GTK_TABLE(tbl),2);
        gtk_box_pack_start(GTK_BOX(box4),tbl,FALSE,TRUE,0);
	gtk_widget_realize(tbl);
	gtk_widget_show(tbl);

        style = gtk_style_copy(gtk_widget_get_style(GTK_WIDGET(tbl)));
        pixmap1 = gdk_pixmap_create_from_xpm_d(tbl->window,
                &mask1, &style->bg[GTK_STATE_NORMAL],(gchar **)minidata_xpm);
        pixmap2 = gdk_pixmap_create_from_xpm_d(tbl->window,
                &mask2, &style->bg[GTK_STATE_NORMAL],(gchar **)miniaudio_xpm);
	pixmap3 = gdk_pixmap_create_from_xpm_d(tbl->window,
		&mask3, &style->bg[GTK_STATE_NORMAL],(gchar **)mininodata_xpm);

	/* create title bar */
	f1 = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(f1),GTK_SHADOW_OUT);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f1,0,1,0,1);
	gtk_widget_show(f1);

	f1 = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(f1),GTK_SHADOW_OUT);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f1,1,2,0,1);
	gtk_widget_show(f1);
	l1 = gtk_label_new(text(139));
	gtk_container_add(GTK_CONTAINER(f1),l1);
	gtk_widget_show(l1);

	f1 = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(f1),GTK_SHADOW_OUT);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f1,2,10,0,1);
	gtk_widget_show(f1);
	l1 = gtk_label_new(text(140));
	gtk_misc_set_alignment(GTK_MISC(l1),0.0,0.5);
	gtk_container_add(GTK_CONTAINER(f1),l1);
	gtk_widget_show(l1);

	f1 = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(f1),GTK_SHADOW_OUT);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f1,10,18,0,1);
	gtk_widget_show(f1);
	l1 = gtk_label_new(text(474));
	gtk_misc_set_alignment(GTK_MISC(l1),0.0,0.5);
	gtk_container_add(GTK_CONTAINER(f1),l1);
	gtk_widget_show(l1);

	f1 = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(f1),GTK_SHADOW_OUT);
	gtk_table_attach_defaults(GTK_TABLE(tbl),f1,18,21,0,1);
	gtk_widget_show(f1);
	l1 = gtk_label_new(text(141));
	gtk_container_add(GTK_CONTAINER(f1),l1);
	gtk_widget_show(l1);

	/* fill track information */

	for (i = 0; i < nrtracks; i++) {
	   if (mode == 0) {
                if (trackinfo[i]->type == 0) {
			pic = gtk_pixmap_new(pixmap1, mask1);
                        convert_frames2mbstring(trackinfo[i]->size,tmp2);
		} else {
			pic = gtk_pixmap_new(pixmap2, mask2);
                        convert_frames2minstring(trackinfo[i]->size,tmp2);
		}

		gtk_table_attach_defaults(GTK_TABLE(tbl),pic,0,1,i+1,i+2);
		gtk_widget_show(pic);
	
                g_snprintf(tmp,MAXLINE,"%2d.", trackinfo[i]->track_nr);
		l1 = gtk_label_new(tmp);
		gtk_table_attach_defaults(GTK_TABLE(tbl),l1,1,2,i+1,i+2);
		gtk_widget_show(l1);

		/* get strings to use for cd-text */
		strcpy(title,"");
		strcpy(artist,"");
		orgcdtextused = 0;
		if (setupdata.option_displaycdtext) {
			if (trackinfo[i]->title != NULL &&
			    trackinfo[i]->title[0] != '\0' ) {
				/* cd-text found.. use it */
				strncpy(title, trackinfo[i]->title, MAXLINE);
				orgcdtextused = 1;
			}
			if (trackinfo[i]->artist != NULL &&
			    trackinfo[i]->artist[0] != '\0' ) {
				strncpy(artist, trackinfo[i]->artist, MAXLINE); 
			}	
		}	

		/* no cd-text in use? try cddb */
		if (orgcdtextused == 0) {
			if (trackinfo[i]->cddb_ttitle != NULL) {
				/* use cddb-information */
				strncpy(title, trackinfo[i]->cddb_ttitle, 
					MAXLINE);
			} else {
				/* fall back to try cd-text again */
				if (trackinfo[i]->title != NULL &&
			   	    trackinfo[i]->title[0] != '\0' ) {
					strncpy(title, trackinfo[i]->title, 						MAXLINE);
				}	
				if (trackinfo[i]->artist != NULL &&
			   	    trackinfo[i]->artist[0] != '\0' ) {
					strncpy(artist, trackinfo[i]->artist, 						MAXLINE);
				}	
			}
		}
	   } else 

	   /* get info from trackparams list */
	   if (mode == 1) {
		if (!loop) {
			g_error("Toc file inconsistent....should never happen.\n");
		}
		trackparam = loop->data;
		if (!trackparam) {
			g_warning("trackparam pointer NULL?\n");
			loop = loop->next;
			continue;
		}
                if (trackparam->tracktype == 0) {
			pic = gtk_pixmap_new(pixmap1, mask1);
                        convert_frames2mbstring(trackparam->frames,tmp2);
		} else {
			pic = gtk_pixmap_new(pixmap2, mask2);
                        convert_frames2minstring(trackparam->frames,tmp2);
		}

		gtk_table_attach_defaults(GTK_TABLE(tbl),pic,0,1,i+1,i+2);
		gtk_widget_show(pic);
	
                g_snprintf(tmp,MAXLINE,"%2d.", trackparam->starttrack);
		l1 = gtk_label_new(tmp);
		gtk_table_attach_defaults(GTK_TABLE(tbl),l1,1,2,i+1,i+2);
		gtk_widget_show(l1);

		/* get title and artist from xinf file */
		strcpy(title,"");
		strcpy(artist,"");
		if (trackparam->trackfile) {
			get_title_artist_from_xinf(trackparam->trackfile,
				artist, title);
		}
		loop = loop->next;
	   } else 

	   /* from write tracks menu in create cd */
	   if (mode == 2) {
		if (!loop) {
			g_error("trackreadset inconsistent....should never happen.\n");
		}
		trackparam = loop->data;

                entry = get_entry_from_imagelist(trackparam->trackfile);
                if (entry == NULL) {
                        /* should never happen */
                        loop = loop->next;
                        continue;
                }

                if (trackparam->tracktype == 0) {
			if (entry->type == 0) {
				pic = gtk_pixmap_new(pixmap1, mask1);
			} else {
				pic = gtk_pixmap_new(pixmap3, mask3);
			}
                        convert_frames2mbstring((gint)((off_t)entry->size/DATASECTORSIZE),
				tmp2);
		} else {
			pic = gtk_pixmap_new(pixmap2, mask2);
                        convert_frames2minstring((gint)((off_t)entry->size/CDDAFRAME), tmp2);
		}

		gtk_table_attach_defaults(GTK_TABLE(tbl),pic,0,1,i+1,i+2);
		gtk_widget_show(pic);
		
                g_snprintf(tmp,MAXLINE,"%2d.", trackparam->starttrack);
		l1 = gtk_label_new(tmp);
		gtk_table_attach_defaults(GTK_TABLE(tbl),l1,1,2,i+1,i+2);
		gtk_widget_show(l1);

		/* get title and artist from xinf file */
		strcpy(title,"");
		strcpy(artist,"");
		if (trackparam->trackfile) {
			get_title_artist_from_xinf(trackparam->trackfile,
				artist, title);
		}
		loop = loop->next;
	  }
		/* title entry */
		e1 = gtk_entry_new();
		cdtext_entry1[i+1] = e1;
		gtk_table_attach_defaults(GTK_TABLE(tbl),e1,2,10,i+1,i+2);
		gtk_entry_set_text(GTK_ENTRY(e1), title);
		gtk_entry_set_position(GTK_ENTRY(e1), 0);
		gtk_widget_show(e1);	

		/* set a tooltip with the original filename */
		if (mode != 0 && trackparam->trackfile) {
			tip = gtk_tooltips_new();
                	g_snprintf(tmp,MAXLINE,"%s", trackparam->trackfile);
			gtk_tooltips_set_tip(tip,e1,tmp,NULL);
		}

		/* artist entry */
		e1 = gtk_entry_new();
		cdtext_entry2[i+1] = e1;
		gtk_table_attach_defaults(GTK_TABLE(tbl),e1,10,18,i+1,i+2);
		gtk_entry_set_text(GTK_ENTRY(e1), artist);
		gtk_entry_set_position(GTK_ENTRY(e1), 0);
		gtk_widget_show(e1);	

		l1 = gtk_label_new(tmp2);
		gtk_table_attach_defaults(GTK_TABLE(tbl),l1,18,21,i+1,i+2);
		gtk_widget_show(l1);
	}

	/* terminate entry list */
	cdtext_entry1[i+1] = NULL;
	cdtext_entry2[i+1] = NULL;

	box3 = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(box1),box3,FALSE,TRUE,10);
	gtk_widget_show(box3);

	button1 = gtk_button_new_with_label(T_OK);
	cddb_info_okbutton = button1;
	gtk_box_pack_start(GTK_BOX(box3),button1,TRUE,TRUE,10);
	gtk_widget_show(button1);
	GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (button1);
	gtk_signal_connect(GTK_OBJECT(button1),"clicked",
		GTK_SIGNAL_FUNC(dialog_btn_press), GINT_TO_POINTER(0));

	button2 = gtk_button_new_with_label(T_CANCEL);
	gtk_box_pack_start(GTK_BOX(box3),button2,TRUE,TRUE,10);
	gtk_widget_show(button2);
	GTK_WIDGET_SET_FLAGS (button2, GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(button2),"clicked",
		GTK_SIGNAL_FUNC(dialog_btn_press), GINT_TO_POINTER(-1));


	/* callback for cd-text set-all artist */
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn), 
		curset.sync_cdtext_artist);

	/* grab cursor and change to watch */
        gtk_grab_add(dialog);
	gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
			(gpointer) &win_attr);
	normal_cursor = win_attr->cursor;
        cursor = gdk_cursor_new(GDK_WATCH);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
	gdk_cursor_destroy (cursor);

	/* only center window when toplevel visible */
	if ( GTK_WIDGET_VISIBLE(toplevel)) {
        	gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
        	gdk_window_get_origin(GTK_WIDGET(toplevel)->window,&xpos,&ypos);
        	gdk_window_get_size(GTK_WIDGET(toplevel)->window,&xsize,&ysize);
		gtk_widget_size_request(dialog,&rq);
        	gtk_widget_set_uposition(GTK_WIDGET(dialog),xpos+xsize/2-rq.width/2,ypos+ysize/2-rq.height/2);
	}

	gtk_widget_show(dialog);


	/* now wait until button is pressed */
	while (dialog_done == 999) {
		wait_and_process_events();
	}

	/* ok button pressed */
	if (dialog_done == 0) {
		if (mode == 0) {
			/* get info from entries and save to cdinfo-struct */
			cdtext_edit_ok_mode0();

			/* update cdlist with new info on screen */
			fill_cdlist();
		} else
		if (mode == 1) {
			/* get info from entries and change in xinf files */
			cdtext_edit_ok_mode12(NULL);

			/* update toc selector with new info */
			if ( writetoc_menu && GTK_WIDGET_VISIBLE(writetoc_menu)) {
				/* simulate click on toc selector */
				menu = gtk_option_menu_get_menu(GTK_OPTION_MENU (writetoc_menu));
				menuitem = gtk_menu_get_active(GTK_MENU(menu));
				gtk_menu_item_activate(GTK_MENU_ITEM(menuitem));
			}
		} else 
		if (mode == 2) {
			/* get info from entries and change in xinf files */
			generate_tmp_tocfile_name(tmptoc);
			cdtext_edit_ok_mode12(tmptoc);

			/* now reload the image list */
			scan_imagedirs();

			/* redraw now the image display */
			fill_write_tracks();
			redraw_writelist(cdlist,cdlist_l1);
			fill_writelist2(imglist2,imglist_l2);
		}
	} else {
		/* cancel? restore sync_all_button */
		curset.sync_cdtext_artist = bak_sync_cdtext_artist;
	}

        gtk_grab_remove(GTK_WIDGET(dialog));
	normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
	gdk_cursor_destroy (normal_cursor);

	/* remove dialog window */
        gtk_widget_destroy(dialog);
	
	return dialog_done;
}


/* popup a modal window, where the user can choose where
   to add several directories on the target CD. 
   Centers automatically above the toplevel-widow 
   return -1 on cancel and 0,1,2 according to settings
*/

gint show_mstr_redir_multi(gchar *commondir, gint nrpaths, gchar *ret) {
GtkWidget *dialog;
GtkWidget *button1;
GtkWidget *button2, *entry;
GtkWidget *box1,*box2,*box3;
GtkWidget *f1, *f2, *f3, *l1;
GtkWidget *b1_sep, *lbl, *btn;
GSList *group;
gint xpos, ypos;
gint xsize, ysize;
GdkCursor *cursor,*normal_cursor;
GtkRequisition rq;
GdkWindowAttr *win_attr;
gchar redir[MAXLINE], tmp2[MAXLINE];
gint bak_redirtype;
gchar tmp[MAXLINE];
gint returncode;

	/* if another dialog is running, ignore */
	if (dialog_done == 999) {
		return -1;
	}

	dodebug(8, "displaying show_mstr_redir_multi\n");

	/* mark our dialog as running */
	dialog_done = 999;

	bak_redirtype = masterparam.redirtype2;
	redir_entry = NULL;

	/* no common dir? dont try to prompt for option 2 */
	if (strcmp(commondir,"") == 0 && masterparam.redirtype2 == 1) {
		masterparam.redirtype2 = 0;
	}	

	/* create new window and position it relative to the main window */
        dialog = gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),text(2));
	gtk_widget_set_usize(dialog,tbf(450),tbf(320));
	/* make sure our window is always on top */
	gtk_window_set_transient_for(GTK_WINDOW(dialog),GTK_WINDOW(toplevel));
	cddb_window = dialog;

        gtk_signal_connect (GTK_OBJECT (dialog), "delete_event",
                GTK_SIGNAL_FUNC (dialog_delete_event), (gpointer) dialog);

	/* create layout for dialog */
        box1 = gtk_vbox_new(FALSE,5);
	gtk_container_set_border_width (GTK_CONTAINER (box1), 5);
        gtk_container_add(GTK_CONTAINER(dialog),box1);
	gtk_widget_show(box1);

	f1 = gtk_frame_new(text(531));
	set_font_and_color(f1,BOLDFONT,NULL);
	gtk_box_pack_start(GTK_BOX(box1),f1,TRUE,TRUE,0);
	gtk_widget_show(f1);

	box2 = gtk_vbox_new(FALSE,0);
	gtk_container_set_border_width (GTK_CONTAINER (box2), 5);
	gtk_container_add(GTK_CONTAINER(f1),box2);
	gtk_widget_show(box2);

	f2 = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(f2),GTK_SHADOW_IN);
	gtk_box_pack_start(GTK_BOX(box2),f2,FALSE,TRUE,5);
	gtk_widget_show(f2);

	g_snprintf(tmp,MAXLINE,text(526), commondir, nrpaths);
	l1 = gtk_label_new(tmp);
	gtk_container_add(GTK_CONTAINER(f2),l1);
	gtk_misc_set_alignment(GTK_MISC(l1),0.5,0.5);
	gtk_misc_set_padding(GTK_MISC(l1),5,5);
	gtk_widget_show(l1);

	lbl = gtk_label_new(text(527));
	gtk_box_pack_start(GTK_BOX(box2),lbl,FALSE,TRUE,5);
	gtk_widget_show(lbl);

        b1_sep = gtk_hseparator_new();
        gtk_box_pack_start(GTK_BOX(box2),b1_sep,FALSE,TRUE,5);
	gtk_widget_show(b1_sep);

	btn = gtk_radio_button_new_with_label(NULL,text(528));
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(redir_type_selected2),GINT_TO_POINTER(0));

	gtk_box_pack_start(GTK_BOX(box2),btn,FALSE,TRUE,0);
	gtk_widget_show(btn);
	define_tooltip(btn,help(197));
	if (masterparam.redirtype2 == 0) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);
	group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));

	if (strcmp(commondir,"") != 0) {
		g_snprintf(tmp2,MAXLINE,text(529), commondir);
		btn = gtk_radio_button_new_with_label(group,tmp2);
		gtk_signal_connect(GTK_OBJECT(btn),"clicked",
			GTK_SIGNAL_FUNC(redir_type_selected2),
			GINT_TO_POINTER(1));
		gtk_box_pack_start(GTK_BOX(box2),btn,FALSE,TRUE,0);
		gtk_widget_show(btn);
		define_tooltip(btn,help(198));
		if (masterparam.redirtype2 == 1) 
			gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);
		group = gtk_radio_button_group (GTK_RADIO_BUTTON(btn));
	}

	if (strcmp(commondir,"") != 0) {
		g_snprintf(tmp2,MAXLINE,text(530), commondir);
	} else {
		strncpy(tmp2, text(532), MAXLINE);
	}
	btn = gtk_radio_button_new_with_label(group,tmp2);
	gtk_signal_connect(GTK_OBJECT(btn),"clicked",
		GTK_SIGNAL_FUNC(redir_type_selected2),GINT_TO_POINTER(2));
	gtk_box_pack_start(GTK_BOX(box2),btn,FALSE,TRUE,0);
	gtk_widget_show(btn);
	if (strcmp(commondir,"") != 0) {
		define_tooltip(btn,help(199));
	} else {
		define_tooltip(btn,help(200));
	}
	if (masterparam.redirtype2 == 2) 
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(btn),1);

	f3 = gtk_hbox_new(FALSE,0);
        gtk_box_pack_start(GTK_BOX(box2),f3,FALSE,FALSE,5);
	gtk_widget_show(f3);

        entry = gtk_entry_new();
	redir_entry = entry;
	gtk_box_pack_start(GTK_BOX(f3),entry,TRUE,TRUE,20);
        gtk_widget_show(entry);
	gtk_entry_set_text(GTK_ENTRY(entry), masterparam.lastredirpath2);
	if (masterparam.redirtype2 != 2) 
		gtk_widget_set_sensitive(redir_entry, FALSE);

	box3 = gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(box1),box3,FALSE,TRUE,10);
	gtk_widget_show(box3);

	button1 = gtk_button_new_with_label(T_OK);
	cddb_info_okbutton = button1;
	gtk_box_pack_start(GTK_BOX(box3),button1,TRUE,TRUE,10);
	gtk_widget_show(button1);
	GTK_WIDGET_SET_FLAGS (button1, GTK_CAN_DEFAULT);
	gtk_widget_grab_default (button1);
	gtk_signal_connect(GTK_OBJECT(button1),"clicked",
		GTK_SIGNAL_FUNC(dialog_btn_press), GINT_TO_POINTER(0));

	button2 = gtk_button_new_with_label(T_CANCEL);
	gtk_box_pack_start(GTK_BOX(box3),button2,TRUE,TRUE,10);
	gtk_widget_show(button2);
	GTK_WIDGET_SET_FLAGS (button2, GTK_CAN_DEFAULT);
	gtk_signal_connect(GTK_OBJECT(button2),"clicked",
		GTK_SIGNAL_FUNC(dialog_btn_press), GINT_TO_POINTER(-1));


	/* grab cursor and change to watch */
        gtk_grab_add(dialog);
	gdk_window_get_user_data(GTK_WIDGET(toplevel)->window,
			(gpointer) &win_attr);
	normal_cursor = win_attr->cursor;
        cursor = gdk_cursor_new(GDK_WATCH);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,cursor);
	gdk_cursor_destroy (cursor);

	/* only center window when toplevel visible */
	if ( GTK_WIDGET_VISIBLE(toplevel)) {
        	gtk_window_position(GTK_WINDOW(dialog),GTK_WIN_POS_NONE);
        	gdk_window_get_origin(GTK_WIDGET(toplevel)->window,&xpos,&ypos);
        	gdk_window_get_size(GTK_WIDGET(toplevel)->window,&xsize,&ysize);
		gtk_widget_size_request(dialog,&rq);
        	gtk_widget_set_uposition(GTK_WIDGET(dialog),xpos+xsize/2-rq.width/2,ypos+ysize/2-rq.height/2);
	}

	gtk_widget_show(dialog);


	/* now wait until button is pressed */
	while (dialog_done == 999) {
		wait_and_process_events();
	}

        gtk_grab_remove(GTK_WIDGET(dialog));
	normal_cursor = gdk_cursor_new (GDK_TOP_LEFT_ARROW);
        gdk_window_set_cursor(GTK_WIDGET(toplevel)->window,normal_cursor);
	gdk_cursor_destroy (normal_cursor);

	if (dialog_done != 0) {
		/* restore original value of type */
		masterparam.redirtype2 = bak_redirtype;
		strcpy(redir,"");
		returncode = -1;
	} else {
		/* ok pressed, do some business */
		g_free(masterparam.lastredirpath2);
		masterparam.lastredirpath2 = g_strdup(
			gtk_entry_get_text(GTK_ENTRY(redir_entry)));

		if (masterparam.redirtype2 == 0) {
			strcpy(redir,"");
		}

		if (masterparam.redirtype2 == 1) {
			strcpy(redir,"");
		}

		if (masterparam.redirtype2 == 2) {
			strncpy(redir,masterparam.lastredirpath2, MAXLINE);
		}
		strip_string(redir);

		/* remove trailing slash */
                if (strlen(redir) > 0) {
                        if (redir[strlen(redir)-1] == '/') {
				redir[strlen(redir)-1] = '\0';
                        }       
                }
		/* add leading slash */
		if (redir[0] != '/') {
			strcpy(tmp,"/");
			strcat(tmp, redir);
			strncpy(redir, tmp, MAXLINE);
		}
		/* update changes in copy */
		if (masterparam.redirtype2 == 2) {
			g_free(masterparam.lastredirpath2);
			masterparam.lastredirpath2 = g_strdup(redir);
		}
		returncode = masterparam.redirtype2;
	}

	/* remove dialog window */
        gtk_widget_destroy(dialog);

	/* now "redir" contains the string where we want to go */
	strncpy(ret, redir, MAXLINE);

	return returncode;
}

