/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.io.Serializable;
import java.util.Locale;
import java.util.ResourceBundle;

public final class ComponentOrientation
implements Serializable {
    private static int HORIZONTAL_ID = 1;
    private static int LEFT_TO_RIGHT_ID = 2;
    public static final ComponentOrientation LEFT_TO_RIGHT = new ComponentOrientation(HORIZONTAL_ID & LEFT_TO_RIGHT_ID);
    public static final ComponentOrientation RIGHT_TO_LEFT = new ComponentOrientation(HORIZONTAL_ID);
    public static final ComponentOrientation UNKNOWN = new ComponentOrientation(0);
    int orientation;

    ComponentOrientation(int orientation) {
        this.orientation = orientation;
    }

    public boolean isHorizontal() {
        return (this.orientation & HORIZONTAL_ID) != 0;
    }

    public boolean isLeftToRight() {
        return (this.orientation & LEFT_TO_RIGHT_ID) != 0;
    }

    public static ComponentOrientation getOrientation(Locale locale) {
        return LEFT_TO_RIGHT;
    }

    public static ComponentOrientation getOrientation(ResourceBundle bdl) {
        ComponentOrientation r;
        try {
            Object obj = bdl.getObject("Orientation");
            r = (ComponentOrientation)obj;
            if (r != null) {
                return r;
            }
        }
        catch (Exception l) {
            // empty catch block
        }
        try {
            Locale l = bdl.getLocale();
            r = ComponentOrientation.getOrientation(l);
            if (r != null) {
                return r;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ComponentOrientation.getOrientation(Locale.getDefault());
    }
}

