/* error handling common to all routines. */
/* Copyright (c) 1992, 1995 John E. Davis
 * All rights reserved.
 * 
 * You may distribute under the terms of either the GNU General Public
 * License or the Perl Artistic License.
 */


#include <config.h>

#include <stdio.h>
#include <string.h>


#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif

#include "slang.h"

void (*SLang_Error_Routine)(char *);
void (*SLang_Exit_Error_Hook)(char *);
volatile int SLang_Error = 0;
char *SLang_Error_Message;

void SLang_doerror(char *error)
{
   char err[256]; char *str = NULL;

   if (!SLang_Error) SLang_Error = UNKNOWN_ERROR;
   *err = 0;
   
   if (SLang_Error_Message != NULL) str = SLang_Error_Message;
   else switch(SLang_Error)
     {
      case UNDEFINED_NAME: str = "Undefined_Name"; break;
      case SYNTAX_ERROR: str = "Syntax Error"; break;
      case STACK_OVERFLOW: str = "Stack Overflow"; break;
      case STACK_UNDERFLOW: str = "Stack Underflow"; break;
      case DUPLICATE_DEFINITION: str = "Duplicate Definition"; break;
      case TYPE_MISMATCH: str = "Type Mismatch"; break;
      case READONLY_ERROR: str = "Variable is read only."; break;
      case SL_MALLOC_ERROR : str = "Malloc Error."; break;
      case SL_INVALID_PARM : str = "Invalid Parameter."; break;
      case USER_BREAK: str = "User Break!"; break;
      case INTRINSIC_ERROR: str = "Intrinsic Error"; break;
      case DIVIDE_ERROR: str = "Divide by zero."; break;
	/* application code should handle this */
      default: if (error != NULL) str = error; else str = "Unknown Error.";
     }
   
   SLang_Error_Message = NULL;
   
   sprintf(err, "S-Lang Error: %s", str);
   
   if (SLang_Error_Routine == NULL)
     {
	if (error != NULL) 
	  {
	     fputs(error, stderr);
	     fputs("\r\n", stderr);
	  }
	
	if (str != error) 
	  {
	     fputs(err, stderr);
	     fputs("\r\n", stderr);
	  }
     }
   else
     {	if (error != NULL) (*SLang_Error_Routine)(error);
	if (str != error) (*SLang_Error_Routine)(err);
     }
}

void SLang_exit_error (char *s)
{
   if (SLang_Exit_Error_Hook != NULL)
     {
	(*SLang_Exit_Error_Hook) (s);
     }
   if (s != NULL) fprintf (stderr, "%s\n", s);
   exit (-1);
}
