/*
 * ti113x.h 1.2 1997/05/05 01:22:40 (David Hinds)
 */

#ifndef _LINUX_TI113X_H
#define _LINUX_TI113X_H

/* Register definitions for TI 113X PCI-to-CardBus bridges */

/* System Control Register */
#define TI113X_SYSTEM_CONTROL		0x0080	/* 32 bit */
#define  TI113X_SCR_SMI_CSC		0x04000000
#define  TI113X_SCR_SMI_STATUS		0x02000000
#define  TI113X_SCR_SMI_ENA		0x01000000
#define  TI113X_SCR_VCC_PROT_ENA	0x00200000
#define  TI113X_SCR_RED_ZOOM_ENA	0x00100000
#define  TI113X_SCR_DMA_ENA		0x00080000
#define  TI113X_SCR_DMA_CHANNEL_MASK	0x00070000
#define  TI113X_SCR_SOCK_ACTIVITY	0x00002000
#define  TI113X_SCR_PWR_STREAM		0x00000800
#define  TI113X_SCR_PWR_DOWN_DELAY	0x00000400
#define  TI113X_SCR_PWR_UP_DELAY	0x00000200
#define  TI113X_SCR_INTERROGATE		0x00000100
#define  TI113X_SCR_CLKRUN_SEL		0x00000080
#define  TI113X_SCR_PWR_SAVE_ENA	0x00000040
#define  TI113X_SCR_EXCA_ID_RO		0x00000020
#define  TI113X_SCR_PARITY_ENA		0x00000010
#define  TI113X_SCR_DMA_ENA_2		0x00000008
#define  TI113X_SCR_ASYNC_IRQ		0x00000004
#define  TI113X_SCR_KEEP_CLOCK		0x00000002
#define  TI113X_SCR_CLKRUN_ENA		0x00000001  

/* Retry Status Register */
#define TI113X_RETRY_STATUS		0x0090	/* 8 bit */
#define  TI113X_RSR_PCI_ENA		0x80
#define  TI113X_RSR_CB_ENA		0x40
#define  TI113X_RSR_CB_B_EXP		0x20
#define  TI113X_RSR_MASTER_B_EXP	0x10
#define  TI113X_RSR_CB_A_EXP		0x08
#define  TI113X_RSR_MASTER_A_EXP	0x04
#define  TI113X_RSR_PCI_EXP		0x02
#define  TI113X_RSR_PCI_MASTER_EXP	0x01

/* Card Control Register */
#define TI113X_CARD_CONTROL		0x0091	/* 8 bit */
#define  TI113X_CCR_RING_ENA		0x80
#define  TI113X_CCR_ZOOM_VIDEO		0x40
#define  TI113X_CCR_PCI_IRQ_ENA		0x20
#define  TI113X_CCR_PCI_IREQ		0x10
#define  TI113X_CCR_PCI_CSC		0x04
#define  TI113X_CCR_SPKR_ENA		0x02
#define  TI113X_CCR_INT			0x01

/* Device Control Register */
#define TI113X_DEVICE_CONTROL		0x0092	/* 8 bit */
#define  TI113X_DCR_5V_FORCE		0x40
#define  TI113X_DCR_3V_FORCE		0x20
#define  TI113X_DCR_IMODE_MASK		0x06
#define  TI113X_DCR_IMODE_ISA		0x02
#define  TI113X_DCR_IMODE_SERIAL	0x04

/* Buffer Control Regiser */
#define TI113X_BUFFER_CONTROL		0x0093	/* 8 bit */
#define  TI113X_BCR_CB_READ_DEPTH	0x08
#define  TI113X_BCR_CB_WRITE_DEPTH	0x04
#define  TI113X_BCR_PCI_READ_DEPTH	0x02
#define  TI113X_BCR_PCI_WRITE_DEPTH	0x01

/* DMA Registers */
#define TI113X_DMA_0			0x0094	/* 32 bit */
#define TI113X_DMA_1			0x0098	/* 32 bit */

#endif /* _LINUX_TI113X_H */

