/************************************************************************
 *
 * File:    internal.h
 *
 * Description:
 *    This file lists the common data structures shared for the standard
 *    I/O package. It is ment to be used _only_ for the stdio package
 *    and should not be exported to any other subsystem or user.
 *
 *    It is assumed that <stdio.h> and "file2.h" have been included prior
 *    to this file. If not, you will get compile errors. Just fix the
 *    includes as I do not believe in making internal headers "idiot proof".
 */

extern int  _cflush;                 /* Number of buffers open to be flushed */
extern void (*_libc__cleanup)(void); /* Global pointer to cleanup vector     */

#ifdef COFF_LIBRARY
extern FILE ** _libc__lastbuf;
#define _lastiob	((*_libc__lastbuf) - 1)
#else
extern FILE * _lastiob;              /* Pointer to the _last_ file table     */
#endif

#ifdef COFF_LIBRARY
#define _bufin		_libc__sibuf
#define _bufout		_libc__sobuf
extern unsigned char * _bufin;
extern unsigned char * _bufout;
#else
extern unsigned char _bufin  [];
extern unsigned char _bufout [];
#endif
extern unsigned char _buferr [];

extern unsigned long _tempoff;

extern unsigned char tty_flag_list[];

/*
 *  Internal functions for the package.
 */

FILE *_getstream(void);
FILE *_openfile (const char *name, const char *mode, FILE *stream);
int _stbuf (FILE *stream);
void _ftbuf (int flag, FILE *stream);
int _doprnt (const char *pszFormat, va_list vaArg, FILE *fpStream);
void _cleanup(void);
void _freebuf (FILE *stream);
void _getbuf (FILE *stream);
int _xxflsbuf (int ch, FILE *stream);
int _stbuf (FILE *stream);
void _ftbuf (int flag, FILE *stream);
int _input (FILE *stream, const char *pszFormat, va_list arglist);
