#include <stdio.h>
#include "file2.h"
#include "internal.h"

#include <trace.h>
/***************************************************************************
 *
 * Function:   fputs
 *
 * Description:
 *    Write a string to the indicated file.
 *
 * Entry:
 *    pszString - pointer to the input string to be written.
 *    fpStream  - pointer to the output stream file
 *
 * Returns:
 *    0 to indicate success
 *   -1 to indicate some error or EOF condition.
 */

int fputs (const char *pszString, FILE *fpStream)
    {
    int          fBuffing;
    unsigned int unLength;
    unsigned int unDone;
    FUNC_ENTRY ("fputs");
/*
 *  Correct the buffering mode and write the string
 */
    unLength = strlen (pszString);
    fBuffing = _stbuf (fpStream);
    unDone   = (unsigned int) fwrite (pszString, 1, unLength, fpStream);
    _ftbuf (fBuffing, fpStream);
/*
 *  Return the proper status to the caller.
 */
    FUNC_EXIT ("fputs");
    return (unDone == unLength ? 0 : -1);
    }
