/*
 *  sqloprt.c
 *
 *  $Id$
 *
 *  sql opt intermediate diag
 *
 *  This file is part of the OpenLink Software Virtuoso Open-Source (VOS)
 *  project.
 *
 *  Copyright (C) 1998-2013 OpenLink Software
 *
 *  This project is free software; you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation; only version 2 of the License, dated June 1991.
 *
 *  This program is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 *  General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License along
 *  with this program; if not, write to the Free Software Foundation, Inc.,
 *  51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
 *
 */

#include "sqlnode.h"
#include "sqlpar.h"
#include "sqlpfn.h"
#include "sqlcmps.h"
#include "sqlintrp.h"
#include "sqlbif.h"
#include "arith.h"
#include "security.h"
#include "sqlo.h"
#include "list2.h"





void
sqlo_dfe_list_print (dk_set_t list, int offset)
{
  DO_SET (df_elt_t *, elt, &list)
    {
      sqlo_dfe_print (elt, offset);
    }
  END_DO_SET();
}

void
sqlo_index_path_print (df_elt_t * dfe)
{
  DO_SET (index_choice_t *, ic, &dfe->_.table.index_path)
    {
      if (ic->ic_key)
	{
	  if (ic->ic_text_order)
	    printf ("by_text ");
	  printf ("key %s %9.2g %9.2g ", ic->ic_key->key_name, ic->ic_unit, ic->ic_arity);
	}
      if (ic->ic_inx_op)
	{
	  DO_SET (df_inx_op_t *, dio, &ic->ic_inx_op->dio_terms)
	    printf ("%s ", dio->dio_key->key_name);
	  END_DO_SET();
	}
    }
  END_DO_SET();
  printf ("\n");
}


void
sqlo_dfe_print (df_elt_t * dfe, int offset)
{
  int is_rec = offset == -1;
  if (offset < 0)
    offset = 8;
  sqlo_print (("%*.*s", offset, offset, " "));
  if (!IS_BOX_POINTER (dfe))
    {
      sqlo_print (("#%ld", (long) (ptrlong) dfe));
      return;
    }
  if (DV_ARRAY_OF_POINTER == DV_TYPE_OF (dfe))
    {
      int inx;
      df_elt_t ** dfe_arr = (df_elt_t **) dfe;
      sqlo_print (("{\n"));
      DO_BOX (df_elt_t *, elt, inx, dfe_arr)
	{
	  sqlo_dfe_print (elt, offset + OFS_INCR);
	  sqlo_print (("\n"));
	}
      END_DO_BOX;
      sqlo_print (("%*.*s", offset, offset, " "));
      sqlo_print (("}\n"));
      return;
    }
  if (dfe->dfe_locus && LOC_LOCAL != dfe->dfe_locus)
    {
      sqlo_print (("  %s: ", dfe->dfe_locus->loc_name));
      offset += (int) (4 + strlen (dfe->dfe_locus->loc_name));
    }
  switch (dfe->dfe_type)
    {
    case DFE_COLUMN:
      sqlo_print (("   out col"));
      dbg_print_box ((caddr_t) dfe->dfe_tree, stdout);
      sqlo_print (("\n"));
      break;
    case DFE_CONST:
      sqlo_print (("   const ("));
      dbg_print_box ((caddr_t) dfe->dfe_tree, stdout);
      sqlo_print ((")\n"));
      break;

    case DFE_HEAD:
      sqlo_print (("   HEAD\n"));
      break;

    case DFE_FUN_REF:
      if (AMMSC_USER == dfe->dfe_tree->_.fn_ref.fn_code)
	{
	  int argctr;
	  user_aggregate_t * ua = (user_aggregate_t *)unbox_ptrlong(dfe->dfe_tree->_.fn_ref.user_aggr_addr);
	  sqlo_print (("   AGGREGATE %s (", ua->ua_name));
	  DO_BOX_FAST (ST *, arg, argctr, dfe->dfe_tree->_.fn_ref.fn_arglist)
	    {
	      if (argctr)
		sqlo_print ((", "));
	      dbg_print_box ((caddr_t) arg, stdout);
	    }
	  END_DO_BOX_FAST;
	}
      else
	{
	  sqlo_print (("   %s (", ammsc_name ((int) dfe->dfe_tree->_.fn_ref.fn_code)));
	  dbg_print_box ((caddr_t) dfe->dfe_tree->_.fn_ref.fn_arg, stdout);
	}
      sqlo_print ((")\n"));
      break;

    case DFE_BOP_PRED:
      sqlo_print (("pred "));

    case DFE_BOP:
      {
	if (ST_P (dfe->dfe_tree, KWD_PARAM))
	  {
	    dbg_print_box ((caddr_t) dfe->dfe_tree->_.bin_exp.left, stdout);
	    sqlo_print (("=> "));
	    dbg_print_box ((caddr_t) dfe->dfe_tree->_.bin_exp.right, stdout);
	  }
	else if (ST_P (dfe->dfe_tree, ASG_STMT))
	  {
	    dbg_print_box ((caddr_t) dfe->_.bin.left->dfe_tree, stdout);
	    sqlo_print ((":= "));
	    dbg_print_box ((caddr_t) dfe->_.bin.right->dfe_tree, stdout);
	  }
	else
	  {
	    sqlo_print (("artm "));
	    if (!dfe->_.bin.right)
	      sqlo_print ((" %s ", bop_text (dfe->_.bin.op)));
	    dbg_print_box ((caddr_t) dfe->_.bin.left->dfe_tree, stdout);
	    if (dfe->_.bin.right)
	      {
		sqlo_print ((" %s ", bop_text (dfe->_.bin.op)));
		dbg_print_box ((caddr_t) dfe->_.bin.right->dfe_tree, stdout);
	      }
	  }
	sqlo_print (("\n"));
	break;
      }
    case DFE_TEXT_PRED:
      sqlo_print (("text pred ("));
      dbg_print_box ((caddr_t) dfe->_.text.args, stdout);
      sqlo_print ((")\n%*.*safter_test\n", offset + OFS_INCR, offset + OFS_INCR, " "));
      sqlo_dfe_print ((df_elt_t *) dfe->_.text.after_test, offset + OFS_INCR);
      break;

    case DFE_TABLE:
      {
	sqlo_print (("Table %s(%s %s) by %s %s", dfe->_.table.ot->ot_table->tb_name,
	      dfe->_.table.ot->ot_prefix ? dfe->_.table.ot->ot_prefix : "",
	      dfe->_.table.ot->ot_new_prefix,
	      dfe->_.table.key ? dfe->_.table.key->key_name : "<no key>",
		     dfe->_.table.hash_role == HR_FILL ? " hash filler " : dfe->_.table.hash_role == HR_REF ? "hash join" : ""));
	if (compiler_unit_msecs)
	  sqlo_print (("  Reached %9.2g unit %9.2g (%g msecs) arity %9.2g\n",
		(double) dfe->_.table.in_arity, (double) dfe->dfe_unit,
		(double) dfe->dfe_unit * compiler_unit_msecs,
		(double) dfe->dfe_arity));
	else
	  sqlo_print (("  Reached %9.2g unit %9.2g arity %9.2g\n",
		(double) dfe->_.table.in_arity, (double) dfe->dfe_unit,
		(double) dfe->dfe_arity));
	sqlo_print (("  col preds: "));
	if (dfe->_.table.index_path)
	  sqlo_index_path_print (dfe);
	if (dfe->_.table.col_preds)
	  sqlo_print (("\n"));
	sqlo_dfe_list_print (dfe->_.table.col_preds, offset + OFS_INCR);
	if (dfe->_.table.col_pred_merges)
	  {
	    sqlo_print (("%*.*s", offset, offset, " "));
	    sqlo_print (("  col pred merge pre-code:\n"));
	    DO_SET (df_elt_t *, mrg, &dfe->_.table.col_pred_merges)
	      {
		sqlo_dfe_print (mrg, offset + OFS_INCR);
	      }
	    END_DO_SET();
	    sqlo_print (("\n"));
	    sqlo_print (("%*.*s", offset, offset, " "));
	  }
	if (dfe->_.table.col_preds)
	  sqlo_print (("%*.*s", offset, offset, " "));
	if (dfe->_.table.inx_op && !is_rec)
	  {
	    sqlo_print (("Index AND:\n{\n"));
	    DO_SET (df_inx_op_t *, term, &dfe->_.table.inx_op->dio_terms)
	      {
		sqlo_dfe_print (term->dio_table, -1);
		sqlo_print (("\n"));
	      }
	    END_DO_SET();
	    sqlo_print (("\n}"));
	  }
	if (dfe->_.table.out_cols)
	  {
	    sqlo_print (("  out cols: "));
	    DO_SET (df_elt_t *, col_dfe, &dfe->_.table.out_cols)
	      {
		if (col_dfe->_.col.col == (dbe_column_t *) CI_ROW)
		  sqlo_print ((" _ROW "));
		else if (col_dfe->_.col.col)
		  sqlo_print ((" %s ", col_dfe->_.col.col->col_name));
		else
		  {
		    sqlo_print ((" "));
		    dbg_print_box ((caddr_t) col_dfe->dfe_tree, stdout);
		    sqlo_print ((" "));
		  }
	      }
	    END_DO_SET();
	    sqlo_print (("\n"));
	    sqlo_print (("%*.*s", offset, offset, " "));
	  }
	if (dfe->_.table.join_test)
	  {
	    sqlo_print (("  join test:\n"));
	    sqlo_dfe_print ((df_elt_t *) dfe->_.table.join_test, offset + OFS_INCR);
	  }
	if (dfe->_.table.vdb_join_test)
	  {
	    sqlo_print (("  vdb join test:\n"));
	    sqlo_dfe_print ((df_elt_t *) dfe->_.table.vdb_join_test, offset + OFS_INCR);
	  }
	if (dfe->_.table.after_join_test)
	  {
	    sqlo_print (("  after join test:\n"));
	    sqlo_dfe_print ((df_elt_t *) dfe->_.table.after_join_test, offset + OFS_INCR);
	  }

	if (dfe->_.table.hash_filler)
	  {
	    sqlo_print (("  hash filler dfe:\n"));
	    sqlo_dfe_print (dfe->_.table.hash_filler, offset + OFS_INCR);
	  }

	if (dfe->_.table.hash_filler_after_code)
	  {
	    sqlo_print (("  hash filler after code :\n"));
	    sqlo_dfe_print ((df_elt_t *) dfe->_.table.hash_filler_after_code, offset + OFS_INCR);
	  }

	if (dfe->_.table.text_pred)
	  {
	    sqlo_print (("  text pred :\n"));
	    sqlo_dfe_print ((df_elt_t *) dfe->_.table.text_pred, offset + OFS_INCR);
	  }

	if (dfe->_.table.xpath_pred)
	  {
	    sqlo_print (("  xpath pred :\n"));
	    sqlo_dfe_print ((df_elt_t *) dfe->_.table.xpath_pred, offset + OFS_INCR);
	  }

	break;
      }
    case DFE_EXISTS:
    case DFE_DT:
    case DFE_VALUE_SUBQ:
    case DFE_PRED_BODY:
      {
	df_elt_t * elt;
	sqlo_print (("{\n"));
	sqlo_print (("%*.*s", offset, offset, " "));
	if (dfe->dfe_type == DFE_VALUE_SUBQ)
	  sqlo_print ((" scalar subq  "));
	else if (dfe->dfe_type == DFE_EXISTS)
	  sqlo_print ((" exists subq  "));
	if (dfe->_.sub.ot)
	  {
	    int inx;
	    sqlo_print (("  %s dt %s\n", dfe->_.sub.is_contradiction ? "CONTR" : "",
		  dfe->_.sub.ot->ot_new_prefix));
	    if (compiler_unit_msecs)
	      sqlo_print (("  unit %9.2g (%g msecs) arity %9.2g reached %7.2g \n",
		    (double) dfe->dfe_unit, (double) dfe->dfe_unit * compiler_unit_msecs,
		    (double) dfe->dfe_arity, dfe->_.sub.in_arity));
	    else
	      sqlo_print (("  unit %9.2g arity %9.2g reached %7.2g \n",
		    (double) dfe->dfe_unit, (double) dfe->dfe_arity, dfe->_.sub.in_arity));
	    sqlo_print (("%*.*sOut cols :\n", offset, offset, " "));
	    DO_BOX (df_elt_t *, out, inx, dfe->_.sub.dt_out)
	      {
		sqlo_dfe_print (out, offset + OFS_INCR);
		sqlo_print (("\n"));
	      }
	    END_DO_BOX;
	  }
	if (dfe->_.sub.generated_dfe)
	  {
	    sqlo_print (("%*.*s", offset, offset, " "));
	    sqlo_print (("   dt generated as:\n"));
	    sqlo_dfe_print (dfe->_.sub.generated_dfe, offset + OFS_INCR);
	  }
	if (DFE_DT == dfe->dfe_type && dfe->_.sub.trans)
	  sqlo_print (("  dt transitive\n"));
	if (dfe->_.sub.first)
	  for (elt = dfe->_.sub.first->dfe_next; elt; elt = elt->dfe_next)
	    {
	      sqlo_dfe_print (elt, offset + OFS_INCR);
	      sqlo_print (("\n"));
	    }

	sqlo_print (("%*.*s", offset, offset, " "));
	sqlo_print (("}\n"));
	if (dfe->_.sub.after_join_test)
	  {
	    sqlo_print (("%*.*s", offset, offset, " "));
	    sqlo_print (("  dt after join test:\n"));
	    sqlo_dfe_print ((df_elt_t *) dfe->_.sub.after_join_test, offset + OFS_INCR);
	  }
	if (DFE_DT == dfe->dfe_type && dfe->_.sub.trans && dfe->_.sub.trans->tl_complement)
	  {
	    sqlo_print ((" \nTransitive e from both ends, complement dt:\n"));
	    sqlo_dfe_print (dfe->_.sub.trans->tl_complement, offset);
	  }
	break;
      }
    case DFE_CALL:
      if (dfe->dfe_tree && DV_STRINGP (dfe->dfe_tree->_.call.name))
	sqlo_print (("call %s: ", dfe->dfe_tree->_.call.name));
      else
	sqlo_print (("call %s ...", dfe->_.call.func_name ? dfe->_.call.func_name : ""));
      dbg_print_box ((caddr_t) dfe->dfe_tree, stdout);
      sqlo_print (("\n"));
      break;

    case DFE_CONTROL_EXP:
      sqlo_print (("control_exp "));
      dbg_print_box ((caddr_t) dfe->dfe_tree, stdout);
      sqlo_print (("\n"));
      sqlo_dfe_print ((df_elt_t *) dfe->_.control.terms, offset + OFS_INCR);
      sqlo_print (("\n"));
      break;
    case DFE_QEXP:
      {
	int inx;
	sqlo_print (("{ set op %d\n", dfe->_.qexp.op));
	DO_BOX (df_elt_t *, elt, inx, dfe->_.qexp.terms)
	  {
	    sqlo_dfe_print (elt, offset + OFS_INCR);
	  }
	END_DO_BOX;
	sqlo_print (("%*.*s", offset, offset, " "));
	sqlo_print (("}\n"));
	break;
      }
    case DFE_ORDER:
    case DFE_GROUP:
      sqlo_print (("  %s ", dfe->dfe_type == DFE_ORDER ? "order by" : "group by"));
      if (dfe->_.setp.is_linear)
	sqlo_print ((" linear "));
      dbg_print_box ((caddr_t) dfe->_.setp.specs, stdout);
      if (dfe->_.setp.oby_dep_cols)
	{
	  int inx;
	  printf ("oby dep:\n");
	  DO_BOX (dk_set_t, deps, inx, dfe->_.setp.oby_dep_cols)
	    {
	      DO_SET (df_elt_t *, dfe, &deps)
		{
		  sqlo_dfe_print (dfe, 0);
		}
	      END_DO_SET();
	    }
	  END_DO_BOX;
	}
      if (dfe->_.setp.after_test)
	{
	  sqlo_print (("after test: "));
	  sqlo_dfe_print ((df_elt_t *) dfe->_.setp.after_test, offset + OFS_INCR);
	}
      sqlo_print (("\n"));
      break;
    default:
      sqlo_print (("node\n"));
      break;
    }
}


#define OT_NAME(ot) ot->ot_new_prefix



void
sqlo_scenario_summary (df_elt_t * dfe, float cost)
{
  df_elt_t * elt;
  if (compiler_unit_msecs)
    sqlo_print (("sequence for %s cost %9.2g (%g msec):", dfe->_.sub.ot->ot_new_prefix,
	  cost, cost * compiler_unit_msecs));
  else
    sqlo_print (("sequence for %s cost %9.2g:", dfe->_.sub.ot->ot_new_prefix, cost));
  for (elt = dfe->_.sub.first->dfe_next; elt; elt = elt->dfe_next)
    {
      int elt_printed = 1;
      switch (elt->dfe_type)
	{
	case DFE_TABLE:
	    if (elt->_.table.hash_role == HR_FILL)
	      {
		sqlo_print (("(%s filler) ", elt->_.table.ot->ot_new_prefix));
	      }
	    else
	      {
		sqlo_print (("%s as %s ", elt->_.table.ot->ot_table->tb_name_only, elt->_.table.ot->ot_new_prefix));
		if (elt->_.table.inx_op)
		  {
		    sqlo_print ((" inx and ( "));
		    DO_SET (df_inx_op_t *, dio, &elt->_.table. inx_op->dio_terms)
		      {
			sqlo_print ((" %s on %s, ", OT_NAME (dio->dio_table->_.table.ot), dio->dio_key->key_name));
		      }
		    END_DO_SET();
		    sqlo_print ((" ) "));
		  }
		else if (HR_REF == elt->_.table.hash_role)
		  {
		    sqlo_print ((" hash ref "));
		  }
		else
		  {
		    sqlo_print ((" on %s ", elt->_.table.key->key_name ? elt->_.table.key->key_name : "no inx"));
		  }
		if (elt->_.table.is_oby_order && elt->_.table.ot->ot_order_cols)
		  sqlo_print (("(index_oby %s %s) ",
			elt->_.table.key->key_name,
			elt->_.table.ot->ot_order_dir == ORDER_DESC ? "DESC" : "ASC"));
	      }
	  break;
	case DFE_DT:
	  sqlo_print (("%s ", elt->_.sub.ot->ot_new_prefix));
	  if (elt->_.sub.trans)
	    sqlo_print ((" transdir=%d ", (int)elt->_.sub.trans->tl_direction));
	  break;
	case DFE_ORDER:
	  sqlo_print ((" order_by "));
	  break;
	case DFE_GROUP:
	  if (elt->_.setp.is_linear)
	    sqlo_print ((" linear_group_by "));
	  else
	    sqlo_print ((" group_by "));
	  break;
	default:
	  elt_printed = 0;
	}
      if (elt->dfe_next && elt_printed)
	sqlo_print ((", "));
    }
  sqlo_print (("\n"));
}

void
sqlo_box_print (caddr_t tree)
{
  dbg_print_box (tree, stdout);
  printf ("\n"); fflush (stdout);
}

