/*
 * Decompiled with CFR 0.152.
 */
package virtuoso.jena.driver;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.GraphEvents;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphWithPerform;
import com.hp.hpl.jena.graph.impl.SimpleBulkUpdateHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import virtuoso.jena.driver.VirtGraph;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtBulkUpdateHandler
extends SimpleBulkUpdateHandler {
    public VirtBulkUpdateHandler(VirtGraph virtGraph) {
        super((GraphWithPerform)virtGraph);
    }

    public void add(Triple[] tripleArray) {
        this.addIterator(Arrays.asList(tripleArray).iterator(), false);
        this.manager.notifyAddArray((Graph)this.graph, tripleArray);
    }

    protected void add(List<Triple> list, boolean bl) {
        this.addIterator(list.iterator(), false);
        if (bl) {
            this.manager.notifyAddList((Graph)this.graph, list);
        }
    }

    public void addIterator(Iterator<Triple> iterator, boolean bl) {
        VirtGraph virtGraph = (VirtGraph)this.graph;
        ArrayList<Triple> arrayList = bl ? new ArrayList<Triple>() : null;
        virtGraph.add(null, iterator, arrayList);
        if (bl) {
            this.manager.notifyAddIterator((Graph)this.graph, arrayList);
        }
    }

    public void delete(Triple[] tripleArray) {
        this.deleteIterator(Arrays.asList(tripleArray).iterator(), false);
        this.manager.notifyDeleteArray((Graph)this.graph, tripleArray);
    }

    protected void delete(List<Triple> list, boolean bl) {
        this.deleteIterator(list.iterator(), false);
        if (bl) {
            this.manager.notifyDeleteList((Graph)this.graph, list);
        }
    }

    public void deleteIterator(Iterator<Triple> iterator, boolean bl) {
        VirtGraph virtGraph = (VirtGraph)this.graph;
        ArrayList<Triple> arrayList = bl ? new ArrayList<Triple>() : null;
        boolean bl2 = false;
        virtGraph.delete(iterator, arrayList);
        if (bl) {
            this.manager.notifyDeleteIterator((Graph)this.graph, arrayList);
        }
    }

    public void removeAll() {
        VirtGraph virtGraph = (VirtGraph)this.graph;
        virtGraph.clearGraph(virtGraph.getGraphName());
        this.notifyRemoveAll();
    }

    public void remove(Node node, Node node2, Node node3) {
        VirtGraph virtGraph = (VirtGraph)this.graph;
        virtGraph.delete_match((TripleMatch)Triple.createMatch((Node)node, (Node)node2, (Node)node3));
        this.manager.notifyEvent((Graph)this.graph, (Object)GraphEvents.remove((Node)node, (Node)node2, (Node)node3));
    }
}

