/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.util;

import java.util.ArrayList;
import java.util.List;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.evaluation.QueryOptimizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryOptimizerList
implements QueryOptimizer {
    protected List<QueryOptimizer> optimizers;

    public QueryOptimizerList() {
        this.optimizers = new ArrayList<QueryOptimizer>(8);
    }

    public QueryOptimizerList(List<QueryOptimizer> optimizers) {
        this.optimizers = new ArrayList<QueryOptimizer>(optimizers);
    }

    public QueryOptimizerList(QueryOptimizer ... optimizers) {
        this.optimizers = new ArrayList<QueryOptimizer>(optimizers.length);
        for (QueryOptimizer optimizer : optimizers) {
            this.optimizers.add(optimizer);
        }
    }

    public void add(QueryOptimizer optimizer) {
        this.optimizers.add(optimizer);
    }

    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        for (QueryOptimizer optimizer : this.optimizers) {
            optimizer.optimize(tupleExpr, dataset, bindings);
        }
    }
}

