/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG) && ENABLE(FILTERS)

#include "JSSVGFEImageElement.h"

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedPreserveAspectRatio.h"
#include "JSSVGAnimatedString.h"
#include "KURL.h"
#include "SVGFEImageElement.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGFEImageElement);

/* Hash table */

static const HashTableValue JSSVGFEImageElementTableValues[14] =
{
    { "preserveAspectRatio", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementPreserveAspectRatio), (intptr_t)0 },
    { "href", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementHref), (intptr_t)0 },
    { "xmllang", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementXmllang), (intptr_t)setJSSVGFEImageElementXmllang },
    { "xmlspace", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementXmlspace), (intptr_t)setJSSVGFEImageElementXmlspace },
    { "externalResourcesRequired", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementExternalResourcesRequired), (intptr_t)0 },
    { "x", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementX), (intptr_t)0 },
    { "y", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementY), (intptr_t)0 },
    { "width", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementWidth), (intptr_t)0 },
    { "height", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementHeight), (intptr_t)0 },
    { "result", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementResult), (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementClassName), (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementStyle), (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsSVGFEImageElementConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGFEImageElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 255, JSSVGFEImageElementTableValues, 0 };
#else
    { 33, 31, JSSVGFEImageElementTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSSVGFEImageElementConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGFEImageElementConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGFEImageElementConstructorTableValues, 0 };
#else
    { 1, 0, JSSVGFEImageElementConstructorTableValues, 0 };
#endif

class JSSVGFEImageElementConstructor : public DOMConstructorObject {
public:
    JSSVGFEImageElementConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSSVGFEImageElementConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSSVGFEImageElementPrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSSVGFEImageElementConstructor::s_info = { "SVGFEImageElementConstructor", 0, &JSSVGFEImageElementConstructorTable, 0 };

bool JSSVGFEImageElementConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEImageElementConstructor, DOMObject>(exec, &JSSVGFEImageElementConstructorTable, this, propertyName, slot);
}

bool JSSVGFEImageElementConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFEImageElementConstructor, DOMObject>(exec, &JSSVGFEImageElementConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSSVGFEImageElementPrototypeTableValues[2] =
{
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)static_cast<NativeFunction>(jsSVGFEImageElementPrototypeFunctionGetPresentationAttribute), (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGFEImageElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSSVGFEImageElementPrototypeTableValues, 0 };
#else
    { 2, 1, JSSVGFEImageElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGFEImageElementPrototype::s_info = { "SVGFEImageElementPrototype", 0, &JSSVGFEImageElementPrototypeTable, 0 };

JSObject* JSSVGFEImageElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGFEImageElement>(exec, globalObject);
}

bool JSSVGFEImageElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGFEImageElementPrototypeTable, this, propertyName, slot);
}

bool JSSVGFEImageElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGFEImageElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGFEImageElement::s_info = { "SVGFEImageElement", &JSSVGElement::s_info, &JSSVGFEImageElementTable, 0 };

JSSVGFEImageElement::JSSVGFEImageElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGFEImageElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

JSObject* JSSVGFEImageElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGFEImageElementPrototype(JSSVGFEImageElementPrototype::createStructure(JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGFEImageElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGFEImageElement, Base>(exec, &JSSVGFEImageElementTable, this, propertyName, slot);
}

bool JSSVGFEImageElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGFEImageElement, Base>(exec, &JSSVGFEImageElementTable, this, propertyName, descriptor);
}

JSValue jsSVGFEImageElementPreserveAspectRatio(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEImageElement* castedThis = static_cast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedPreserveAspectRatio> obj = imp->preserveAspectRatioAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFEImageElementHref(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEImageElement* castedThis = static_cast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->hrefAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFEImageElementXmllang(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEImageElement* castedThis = static_cast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->xmllang());
    return result;
}

JSValue jsSVGFEImageElementXmlspace(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEImageElement* castedThis = static_cast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThis->impl());
    JSValue result = jsString(exec, imp->xmlspace());
    return result;
}

JSValue jsSVGFEImageElementExternalResourcesRequired(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEImageElement* castedThis = static_cast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFEImageElementX(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEImageElement* castedThis = static_cast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->xAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFEImageElementY(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEImageElement* castedThis = static_cast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->yAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFEImageElementWidth(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEImageElement* castedThis = static_cast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->widthAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFEImageElementHeight(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEImageElement* castedThis = static_cast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->heightAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFEImageElementResult(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEImageElement* castedThis = static_cast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->resultAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFEImageElementClassName(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEImageElement* castedThis = static_cast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    JSValue result =  toJS(exec, castedThis->globalObject(), obj.get(), imp);
    return result;
}

JSValue jsSVGFEImageElementStyle(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEImageElement* castedThis = static_cast<JSSVGFEImageElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->style()));
    return result;
}

JSValue jsSVGFEImageElementConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSSVGFEImageElement* domObject = static_cast<JSSVGFEImageElement*>(asObject(slotBase));
    return JSSVGFEImageElement::getConstructor(exec, domObject->globalObject());
}
void JSSVGFEImageElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGFEImageElement, Base>(exec, propertyName, value, &JSSVGFEImageElementTable, this, slot);
}

void setJSSVGFEImageElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGFEImageElement* castedThisObj = static_cast<JSSVGFEImageElement*>(thisObject);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThisObj->impl());
    imp->setXmllang(value.toString(exec));
}

void setJSSVGFEImageElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    JSSVGFEImageElement* castedThisObj = static_cast<JSSVGFEImageElement*>(thisObject);
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThisObj->impl());
    imp->setXmlspace(value.toString(exec));
}

JSValue JSSVGFEImageElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSSVGFEImageElementConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}

JSValue JSC_HOST_CALL jsSVGFEImageElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGFEImageElement::s_info))
        return throwError(exec, TypeError);
    JSSVGFEImageElement* castedThisObj = static_cast<JSSVGFEImageElement*>(asObject(thisValue));
    SVGFEImageElement* imp = static_cast<SVGFEImageElement*>(castedThisObj->impl());
    const UString& name = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}


}

#endif // ENABLE(SVG) && ENABLE(FILTERS)
