/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CComponent;
import apple.awt.CToolkit;
import apple.awt.MyCScrollPane;
import com.apple.eawt.CocoaComponent;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.peer.CanvasPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.WindowPeer;
import java.util.Date;
import jep.AppletFrame;
import jep.AppletHandlerFactory;
import sun.awt.AppContext;
import sun.awt.PeerEvent;
import sun.awt.SunToolkit;

public class MyCToolkit
extends CToolkit {
    private static boolean showDebugInfo = false;

    public MyCToolkit() {
        if (showDebugInfo) {
            System.err.println("Calling MyCToolkit()");
        }
        AppletHandlerFactory.resetMainEventQueue();
    }

    public FramePeer createFrame(Frame frame) {
        if (frame == null) {
            return super.createFrame(frame);
        }
        FramePeer peer = null;
        if (frame instanceof AppletFrame) {
            try {
                Object[] parms = new Object[]{frame, frame};
                peer = (FramePeer)AppletHandlerFactory.myCAppletFrameCreateNew.invoke(null, parms);
            }
            catch (Throwable e) {
                System.err.println("MyCToolkit createFrame(): exception: " + e.getMessage());
                e.printStackTrace();
                return null;
            }
            SunToolkit.targetCreatedPeer(frame, peer);
        } else {
            peer = super.createFrame(frame);
            AppletFrame appletFrame = AppletFrame.getCurrentAppletFrame();
            if (appletFrame != null) {
                appletFrame.addChildWindow(frame);
            }
        }
        if (showDebugInfo) {
            System.err.println("MyCToolkit createFrame(): Frame " + peer.toString() + " thread " + Thread.currentThread().toString());
        }
        return peer;
    }

    public WindowPeer createWindow(Window window) {
        AppletFrame appletFrame;
        WindowPeer peer = super.createWindow(window);
        if (window != null && (appletFrame = AppletFrame.getCurrentAppletFrame()) != null) {
            appletFrame.addChildWindow(window);
        }
        return peer;
    }

    public PanelPeer createPanel(Panel panel) {
        Container next;
        if (panel == null) {
            return super.createPanel(panel);
        }
        Container ancestor = panel;
        while ((next = ancestor.getParent()) != null) {
            ancestor = next;
        }
        PanelPeer peer = null;
        if (ancestor instanceof AppletFrame) {
            try {
                Object[] parms = new Object[]{panel, ancestor};
                peer = (PanelPeer)AppletHandlerFactory.myCPanelCreateNew.invoke(null, parms);
            }
            catch (Throwable e) {
                System.err.println("MyCToolkit createPanel(): exception: " + e.getMessage());
                e.printStackTrace();
                return null;
            }
            SunToolkit.targetCreatedPeer(panel, peer);
        } else {
            peer = super.createPanel(panel);
        }
        if (showDebugInfo) {
            System.err.println("MyCToolkit createPanel(): Panel " + peer.toString() + " thread " + Thread.currentThread().toString());
        }
        return peer;
    }

    public ScrollPanePeer createScrollPane(ScrollPane scrollpane) {
        Container next;
        if (scrollpane == null) {
            return super.createScrollPane(scrollpane);
        }
        Container ancestor = scrollpane;
        while ((next = ancestor.getParent()) != null) {
            ancestor = next;
        }
        ScrollPanePeer peer = null;
        if (ancestor instanceof AppletFrame) {
            try {
                Object[] parms = new Object[]{scrollpane, ancestor};
                peer = (ScrollPanePeer)AppletHandlerFactory.myCScrollPaneCreateNew.invoke(null, parms);
            }
            catch (Throwable e) {
                System.err.println("MyCToolkit createScrollPane(): exception: " + e.getMessage());
                e.printStackTrace();
                return null;
            }
            SunToolkit.targetCreatedPeer(scrollpane, peer);
        } else {
            peer = super.createScrollPane(scrollpane);
        }
        if (showDebugInfo) {
            System.err.println("MyCToolkit createScrollPane(): ScrollPane " + peer.toString() + " thread " + Thread.currentThread().toString());
        }
        return peer;
    }

    public CanvasPeer createCanvas(Canvas canvas) {
        Container next;
        if (canvas == null) {
            return super.createCanvas(canvas);
        }
        Component ancestor = canvas;
        while ((next = ancestor.getParent()) != null) {
            ancestor = next;
        }
        CanvasPeer peer = null;
        long nsView = 0L;
        if (ancestor instanceof AppletFrame) {
            if (canvas instanceof CocoaComponent) {
                nsView = ((CocoaComponent)canvas).createNSView();
            }
            try {
                Object[] parms = new Object[]{canvas, new Long(nsView), ancestor};
                peer = (CanvasPeer)AppletHandlerFactory.myCCanvasCreateNew.invoke(null, parms);
            }
            catch (Throwable e) {
                System.err.println("MyCToolkit createCanvas(): exception: " + e.getMessage());
                e.printStackTrace();
                return null;
            }
            SunToolkit.targetCreatedPeer(canvas, peer);
        } else {
            peer = super.createCanvas(canvas);
        }
        if (showDebugInfo) {
            System.err.println("MyCToolkit createCanvas(): (nsView is 0x" + Long.toHexString(nsView) + ") Canvas " + peer.toString() + " thread " + Thread.currentThread().toString());
        }
        return peer;
    }

    public LabelPeer createLabel(Label label) {
        Container next;
        if (label == null || !AppletHandlerFactory.isJava142Tiger()) {
            return super.createLabel(label);
        }
        Component ancestor = label;
        while ((next = ancestor.getParent()) != null) {
            ancestor = next;
        }
        LabelPeer peer = null;
        if (ancestor instanceof AppletFrame) {
            try {
                Object[] parms = new Object[]{label, ancestor};
                peer = (LabelPeer)AppletHandlerFactory.myCLabelCreateNew.invoke(null, parms);
            }
            catch (Throwable e) {
                System.err.println("MyCToolkit createLabel(): exception: " + e.getMessage());
                e.printStackTrace();
                return null;
            }
            SunToolkit.targetCreatedPeer(label, peer);
        } else {
            peer = super.createLabel(label);
        }
        if (showDebugInfo) {
            System.err.println("MyCToolkit createLabel(): Label " + peer.toString() + " thread " + Thread.currentThread().toString());
        }
        return peer;
    }

    public static boolean postMouseMovedEvent(Object peer, int x, int y, long when) {
        if (peer instanceof CComponent) {
            boolean setDirectly;
            Container next;
            Component ancestor = ((CComponent)peer).fTarget;
            while ((next = ancestor.getParent()) != null) {
                ancestor = next;
            }
            if (!(ancestor instanceof AppletFrame)) {
                return false;
            }
            if (((AppletFrame)ancestor).destroying) {
                return true;
            }
            Applet applet = ((AppletFrame)ancestor).getApplet();
            AppContext appletContext = null;
            if (applet != null) {
                appletContext = SunToolkit.targetToAppContext(applet);
            }
            boolean bl = setDirectly = appletContext == null || AppContext.getAppContext().equals(appletContext);
            if (setDirectly) {
                ((CComponent)peer).postEvent((AWTEvent)new MouseEvent(((CComponent)peer).fTarget, 503, when, 0, x, y, 0, false));
            } else {
                SunToolkit.postEvent(appletContext, new PeerEvent(applet, new PostMouseMovedEvent((CComponent)peer, x, y, when), 1L));
            }
            return true;
        }
        return false;
    }

    public static void setScrollPanePosition(Object peer, int x, int y) {
        boolean setDirectly;
        Container next;
        if (!(peer instanceof MyCScrollPane)) {
            return;
        }
        MyCScrollPane scrollPanePeer = (MyCScrollPane)((Object)peer);
        ScrollPane scrollpane = (ScrollPane)scrollPanePeer.fTarget;
        if (scrollpane == null) {
            return;
        }
        Point currentPosition = scrollpane.getScrollPosition();
        if (currentPosition.x == x && currentPosition.y == y) {
            return;
        }
        Container ancestor = scrollpane;
        while ((next = ancestor.getParent()) != null) {
            ancestor = next;
        }
        if (!(ancestor instanceof AppletFrame)) {
            return;
        }
        if (((AppletFrame)ancestor).destroying) {
            return;
        }
        Applet applet = ((AppletFrame)ancestor).getApplet();
        AppContext appletContext = null;
        if (applet != null) {
            appletContext = SunToolkit.targetToAppContext(applet);
        }
        boolean bl = setDirectly = appletContext == null || AppContext.getAppContext().equals(appletContext);
        if (setDirectly) {
            scrollPanePeer.setSkipNextScrollView();
            scrollpane.setScrollPosition(x, y);
        } else {
            SunToolkit.postEvent(appletContext, new PeerEvent(applet, new SetScrollPanePosition((AppletFrame)ancestor, scrollPanePeer, x, y), 1L));
        }
    }

    public static void printStackTrace() {
        System.err.print(new Date() + " ");
        Throwable barf = new Throwable();
        barf.fillInStackTrace();
        barf.printStackTrace();
    }

    public static String getJavaThread() {
        return Thread.currentThread().toString();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + " (jep)";
    }

    static {
        if ("true".equalsIgnoreCase(System.getProperty("jep.debuginfo", "false"))) {
            showDebugInfo = true;
        }
    }

    private static class SetScrollPanePosition
    implements Runnable {
        private final AppletFrame frame;
        private final MyCScrollPane scrollPanePeer;
        private final int x;
        private final int y;

        SetScrollPanePosition(AppletFrame frame, MyCScrollPane scrollPanePeer, int x, int y) {
            this.frame = frame;
            this.scrollPanePeer = scrollPanePeer;
            this.x = x;
            this.y = y;
        }

        public void run() {
            this.scrollPanePeer.setSkipNextScrollView();
            ScrollPane scrollpane = (ScrollPane)this.scrollPanePeer.fTarget;
            this.frame.validateClips();
            scrollpane.setScrollPosition(this.x, this.y);
        }
    }

    private static class PostMouseMovedEvent
    implements Runnable {
        private final CComponent peer;
        private final int x;
        private final int y;
        private final long when;

        PostMouseMovedEvent(CComponent peer, int x, int y, long when) {
            this.peer = peer;
            this.x = x;
            this.y = y;
            this.when = when;
        }

        public void run() {
            this.peer.postEvent((AWTEvent)new MouseEvent(this.peer.fTarget, 503, this.when, 0, this.x, this.y, 0, false));
        }
    }
}

