'\" e
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided ``as is'' without express or implied warranty.
.\" 
.\" $XFree86: xc/doc/man/X11/XAllColor.man,v 1.3 2001/02/09 03:47:45 tsi Exp $
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.na
.de Ds
.nf
.\\$1D \\$2 \\$1
.ft 1
.\".ps \\n(PS
.\".if \\n(VS>=40 .vs \\n(VSu
.\".if \\n(VS<=39 .vs \\n(VSp
..
.de De
.ce 0
.if \\n(BD .DF
.nr BD 0
.in \\n(OIu
.if \\n(TM .ls 2
.sp \\n(DDu
.fi
..
.de FD
.LP
.KS
.TA .5i 3i
.ta .5i 3i
.nf
..
.de FN
.fi
.KE
.LP
..
.de IN		\" send an index entry to the stderr
..
.de C{
.KS
.nf
.D
.\"
.\"	choose appropriate monospace font
.\"	the imagen conditional, 480,
.\"	may be changed to L if LB is too
.\"	heavy for your eyes...
.\"
.ie "\\*(.T"480" .ft L
.el .ie "\\*(.T"300" .ft L
.el .ie "\\*(.T"202" .ft PO
.el .ie "\\*(.T"aps" .ft CW
.el .ft R
.ps \\n(PS
.ie \\n(VS>40 .vs \\n(VSu
.el .vs \\n(VSp
..
.de C}
.DE
.R
..
.de Pn
.ie t \\$1\fB\^\\$2\^\fR\\$3
.el \\$1\fI\^\\$2\^\fP\\$3
..
.de ZN
.ie t \fB\^\\$1\^\fR\\$2
.el \fI\^\\$1\^\fP\\$2
..
.de hN
.ie t <\fB\\$1\fR>\\$2
.el <\fI\\$1\fP>\\$2
..
.de NT
.ne 7
.ds NO Note
.if \\n(.$>$1 .if !'\\$2'C' .ds NO \\$2
.if \\n(.$ .if !'\\$1'C' .ds NO \\$1
.ie n .sp
.el .sp 10p
.TB
.ce
\\*(NO
.ie n .sp
.el .sp 5p
.if '\\$1'C' .ce 99
.if '\\$2'C' .ce 99
.in +5n
.ll -5n
.R
..
.		\" Note End -- doug kraft 3/85
.de NE
.ce 0
.in -5n
.ll +5n
.ie n .sp
.el .sp 10p
..
.ny0
'\" e
.TH XAllocColor __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XAllocColor, XAllocNamedColor, XAllocColorCells, XAllocColorPlanes, XFreeColors \- allocate and free colors
.SH SYNTAX
.HP
Status XAllocColor\^(\^Display *\fIdisplay\fP, Colormap \fIcolormap\fP\^,
XColor *\fIscreen_in_out\fP\^);
.HP
Status XAllocNamedColor\^(\^Display *\fIdisplay\fP, Colormap \fIcolormap\fP\^,
char *\fIcolor_name\fP\^, XColor *\fIscreen_def_return\fP\^, XColor
*\fIexact_def_return\fP\^);
.HP
Status XAllocColorCells\^(\^Display *\fIdisplay\fP, Colormap \fIcolormap\fP\^,
Bool \fIcontig\fP\^, unsigned long \fIplane_masks_return\fP[\^]\^, unsigned int
\fInplanes\fP\^, unsigned long \fIpixels_return\fP[\^]\^, unsigned int
\fInpixels\fP\^);
.HP
Status XAllocColorPlanes\^(\^Display *\fIdisplay\fP, Colormap
\fIcolormap\fP\^, Bool \fIcontig\fP\^, unsigned long
\fIpixels_return\fP[\^]\^, int \fIncolors\fP\^, int \fInreds\fP\^, int
\fIngreens\fP\^, int \fInblues\fP\^, unsigned long *\fIrmask_return\fP\^,
unsigned long *\fIgmask_return\fP\^, unsigned long *\fIbmask_return\fP\^);
.HP
int XFreeColors\^(\^Display *\fIdisplay\fP, Colormap \fIcolormap\fP\^, unsigned
long \fIpixels\fP\^[\^], int \fInpixels\fP\^, unsigned long \fIplanes\fP\^);
.IP \fIcolor_name\fP 1i
Specifies the color name string (for example, red) whose color 
definition structure you want returned.
.IP \fIcolormap\fP 1i
Specifies the colormap.
.IP \fIcontig\fP 1i
Specifies a Boolean value that indicates whether the planes must be contiguous.
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIexact_def_return\fP 1i
Returns the exact RGB values.
.IP \fIncolors\fP 1i
Specifies the number of pixel values that are to be returned in the 
pixels_return array. 
.IP \fInpixels\fP 1i
Specifies the number of pixels. 
.IP \fInplanes\fP 1i
Specifies the number of plane masks that are to be returned in the plane masks 
array. 
.IP \fInreds\fP 1i
.br
.ns
.IP \fIngreens\fP 1i
.br
.ns
.IP \fInblues\fP 1i
.br
.ns
Specify the number of red, green, and blue planes.
The value you pass must be nonnegative. 
.IP \fIpixels\fP 1i
Specifies an array of pixel values. 
.IP \fIpixels_return\fP 1i
Returns an array of pixel values. 
.IP \fIplane_mask_return\fP 1i
Returns an array of plane masks.
.\" *** JIM: NEED MORE INFO FOR THIS. ***
.IP \fIplanes\fP 1i
Specifies the planes you want to free.
.IP \fIrmask_return\fP 1i
.br
.ns
.IP \fIgmask_return\fP 1i
.br
.ns
.IP \fIbmask_return\fP 1i
Return bit masks for the red, green, and blue planes.
.IP \fIscreen_def_return\fP 1i
Returns the closest RGB values provided by the hardware.
.IP \fIscreen_in_out\fP 1i
Specifies and returns the values actually used in the colormap.
.SH DESCRIPTION
The
.ZN XAllocColor
function allocates a read-only colormap entry corresponding to the closest
RGB value supported by the hardware.
.ZN XAllocColor
returns the pixel value of the color closest to the specified
RGB elements supported by the hardware
and returns the RGB value actually used.
The corresponding colormap cell is read-only.
In addition,
.ZN XAllocColor
returns nonzero if it succeeded or zero if it failed.
.IN "Color map"
.IN "Color" "allocation"
.IN "Allocation" "colormap"
.IN "read-only colormap cells"
Multiple clients that request the same effective RGB value can be assigned
the same read-only entry, thus allowing entries to be shared.
When the last client deallocates a shared cell, it is deallocated.
.ZN XAllocColor
does not use or affect the flags in the
.ZN XColor
structure.
.LP
.ZN XAllocColor
can generate a
.ZN BadColor 
error.
.LP
The
.ZN XAllocNamedColor
function looks up the named color with respect to the screen that is
associated with the specified colormap.
It returns both the exact database definition and
the closest color supported by the screen.
The allocated color cell is read-only.
The pixel value is returned in screen_def_return.
If the color name is not in the Host Portable Character Encoding, 
the result is implementation-dependent.
Use of uppercase or lowercase does not matter.
If screen_def_return and exact_def_return
point to the same structure, the pixel field will be set correctly,
but the color values are undefined.
.ZN XAllocNamedColor
returns nonzero if a cell is allocated;
otherwise, it returns zero.
.LP
.ZN XAllocNamedColor
can generate a
.ZN BadColor
error.
.LP
.EQ
delim %%
.EN
The
.ZN XAllocColorCells
function allocates read/write color cells.
The number of colors must be positive and the number of planes nonnegative,
or a
.ZN BadValue
error results.
If ncolors and nplanes are requested, 
then ncolors pixels
and nplane plane masks are returned.
No mask will have any bits set to 1 in common with
any other mask or with any of the pixels.
By ORing together each pixel with zero or more masks,
ncolors * %2 sup nplanes% distinct pixels can be produced.
All of these are
allocated writable by the request.
For 
.ZN GrayScale 
or 
.ZN PseudoColor , 
each mask has exactly one bit set to 1. 
For 
.ZN DirectColor , 
each has exactly three bits set to 1.
If contig is 
.ZN True 
and if all masks are ORed
together, a single contiguous set of bits set to 1 will be formed for 
.ZN GrayScale
or 
.ZN PseudoColor 
and three contiguous sets of bits set to 1 (one within each
pixel subfield) for 
.ZN DirectColor .
The RGB values of the allocated
entries are undefined.
.ZN XAllocColorCells
returns nonzero if it succeeded or zero if it failed.
.LP
.ZN XAllocColorCells
can generate
.ZN BadColor
and
.ZN BadValue 
errors.
.LP
.EQ
delim %%
.EN
The specified ncolors must be positive; 
and nreds, ngreens, and nblues must be nonnegative,
or a
.ZN BadValue
error results.
If ncolors colors, nreds reds, ngreens greens, and nblues blues are requested, 
ncolors pixels are returned; and the masks have nreds, ngreens, and 
nblues bits set to 1, respectively.
If contig is 
.ZN True , 
each mask will have
a contiguous set of bits set to 1.
No mask will have any bits set to 1 in common with
any other mask or with any of the pixels.
For 
.ZN DirectColor , 
each mask
will lie within the corresponding pixel subfield.
By ORing together
subsets of masks with each pixel value, 
ncolors * %2 sup (nreds+ngreens+nblues)% distinct pixel values can be produced. 
All of these are allocated by the request.
However, in the
colormap, there are only ncolors * %2 sup nreds% independent red entries, 
ncolors * %2 sup ngreens% independent green entries, 
and ncolors * %2 sup nblues% independent blue entries. 
This is true even for 
.ZN PseudoColor .
When the colormap entry of a pixel
value is changed (using 
.ZN XStoreColors ,
.ZN XStoreColor ,
or 
.ZN XStoreNamedColor ),
the pixel is decomposed according to the masks, 
and the corresponding independent entries are updated.
.ZN XAllocColorPlanes
returns nonzero if it succeeded or zero if it failed.
.LP
.ZN XAllocColorPlanes
can generate
.ZN BadColor
and
.ZN BadValue 
errors.
.LP
The
.ZN XFreeColors
function frees the cells represented by pixels whose values are in the
pixels array.
The planes argument should not have any bits set to 1 in common with any of the
pixels. 
The set of all pixels is produced by ORing together subsets of
the planes argument with the pixels.
The request frees all of these pixels that
were allocated by the client (using 
.IN XAllocColor
.IN XAllocNamedColor
.IN XAllocColorCells
.IN XAllocColorPlanes
.ZN XAllocColor , 
.ZN XAllocNamedColor ,
.ZN XAllocColorCells ,
and 
.ZN XAllocColorPlanes ).
Note that freeing an
individual pixel obtained from 
.ZN XAllocColorPlanes 
may not actually allow
it to be reused until all of its related pixels are also freed.
Similarly,
a read-only entry is not actually freed until it has been freed by all clients,
and if a client allocates the same read-only entry multiple times,
it must free the entry that many times before the entry is actually freed.
.LP
All specified pixels that are allocated by the client in the colormap are
freed, even if one or more pixels produce an error. 
If a specified pixel is not a valid index into the colormap, a 
.ZN BadValue 
error results.
If a specified pixel is not allocated by the
client (that is, is unallocated or is only allocated by another client)
or if the colormap was created with all entries writable (by passing
.ZN AllocAll
to
.ZN XCreateColormap ),
a
.ZN BadAccess
error results. 
If more than one pixel is in error, 
the one that gets reported is arbitrary.
.LP
.ZN XFreeColors
can generate
.ZN BadAccess ,
.ZN BadColor ,
and
.ZN BadValue 
errors.
.SH DIAGNOSTICS
.TP 1i
.ZN BadAccess
A client attempted
to free a color map entry that it did not already allocate.
.TP 1i
.ZN BadAccess
A client attempted
to store into a read-only color map entry.
.TP 1i
.ZN BadColor
A value for a Colormap argument does not name a defined Colormap.
.TP 1i
.ZN BadValue
Some numeric value falls outside the range of values accepted by the request.
Unless a specific range is specified for an argument, the full range defined
by the argument's type is accepted.  Any argument defined as a set of
alternatives can generate this error.
.SH "SEE ALSO"
XCreateColormap(3X11), 
XQueryColor(3X11),
XStoreColors(3X11) 
.br
\fI\*(xL\fP
