#include "librpc/gen_ndr/ndr_netlogon.h"
#ifndef __CLI_NETLOGON__
#define __CLI_NETLOGON__
NTSTATUS rpccli_netr_LogonUasLogon(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_name /* [in] [unique,charset(UTF16)] */,
				   const char *account_name /* [in] [charset(UTF16)] */,
				   const char *workstation /* [in] [charset(UTF16)] */,
				   struct netr_UasInfo *info /* [out] [ref] */,
				   WERROR *werror);
NTSTATUS rpccli_netr_LogonUasLogoff(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *server_name /* [in] [unique,charset(UTF16)] */,
				    const char *account_name /* [in] [charset(UTF16)] */,
				    const char *workstation /* [in] [charset(UTF16)] */,
				    struct netr_UasLogoffInfo *info /* [out] [ref] */,
				    WERROR *werror);
NTSTATUS rpccli_netr_LogonSamLogon(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *server_name /* [in] [unique,charset(UTF16)] */,
				   const char *computer_name /* [in] [unique,charset(UTF16)] */,
				   struct netr_Authenticator *credential /* [in] [unique] */,
				   struct netr_Authenticator *return_authenticator /* [in,out] [unique] */,
				   enum netr_LogonLevel logon_level /* [in]  */,
				   union netr_LogonInfo *logon /* [in] [ref,switch_is(logon_level)] */,
				   uint16_t validation_level /* [in]  */,
				   union netr_Validation *validation /* [out] [ref,switch_is(validation_level)] */,
				   uint8_t *authoritative /* [out] [ref] */);
NTSTATUS rpccli_netr_LogonSamLogoff(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *server_name /* [in] [unique,charset(UTF16)] */,
				    const char *computer_name /* [in] [unique,charset(UTF16)] */,
				    struct netr_Authenticator *credential /* [in] [unique] */,
				    struct netr_Authenticator *return_authenticator /* [in,out] [unique] */,
				    enum netr_LogonLevel logon_level /* [in]  */,
				    union netr_LogonInfo logon /* [in] [switch_is(logon_level)] */);
NTSTATUS rpccli_netr_ServerReqChallenge(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_name /* [in] [unique,charset(UTF16)] */,
					const char *computer_name /* [in] [charset(UTF16)] */,
					struct netr_Credential *credentials /* [in] [ref] */,
					struct netr_Credential *return_credentials /* [out] [ref] */);
NTSTATUS rpccli_netr_ServerAuthenticate(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_name /* [in] [unique,charset(UTF16)] */,
					const char *account_name /* [in] [charset(UTF16)] */,
					enum netr_SchannelType secure_channel_type /* [in]  */,
					const char *computer_name /* [in] [charset(UTF16)] */,
					struct netr_Credential *credentials /* [in] [ref] */,
					struct netr_Credential *return_credentials /* [out] [ref] */);
NTSTATUS rpccli_netr_ServerPasswordSet(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_name /* [in] [unique,charset(UTF16)] */,
				       const char *account_name /* [in] [charset(UTF16)] */,
				       enum netr_SchannelType secure_channel_type /* [in]  */,
				       const char *computer_name /* [in] [charset(UTF16)] */,
				       struct netr_Authenticator *credential /* [in] [ref] */,
				       struct netr_Authenticator *return_authenticator /* [out] [ref] */,
				       struct samr_Password *new_password /* [in] [ref] */);
NTSTATUS rpccli_netr_DatabaseDeltas(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *logon_server /* [in] [charset(UTF16)] */,
				    const char *computername /* [in] [charset(UTF16)] */,
				    struct netr_Authenticator *credential /* [in] [ref] */,
				    struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
				    enum netr_SamDatabaseID database_id /* [in]  */,
				    uint64_t *sequence_num /* [in,out] [ref] */,
				    struct netr_DELTA_ENUM_ARRAY **delta_enum_array /* [out] [ref] */,
				    uint32_t preferredmaximumlength /* [in]  */);
NTSTATUS rpccli_netr_DatabaseSync(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *logon_server /* [in] [charset(UTF16)] */,
				  const char *computername /* [in] [charset(UTF16)] */,
				  struct netr_Authenticator credential /* [in]  */,
				  struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
				  enum netr_SamDatabaseID database_id /* [in]  */,
				  uint32_t *sync_context /* [in,out] [ref] */,
				  uint32_t preferredmaximumlength /* [in]  */,
				  struct netr_DELTA_ENUM_ARRAY *delta_enum_array /* [out] [ref] */);
NTSTATUS rpccli_netr_AccountDeltas(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *logon_server /* [in] [unique,charset(UTF16)] */,
				   const char *computername /* [in] [charset(UTF16)] */,
				   struct netr_Authenticator credential /* [in]  */,
				   struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
				   struct netr_UAS_INFO_0 uas /* [in]  */,
				   uint32_t count /* [in]  */,
				   uint32_t level /* [in]  */,
				   uint32_t buffersize /* [in]  */,
				   struct netr_AccountBuffer *buffer /* [out] [ref,subcontext(4)] */,
				   uint32_t *count_returned /* [out] [ref] */,
				   uint32_t *total_entries /* [out] [ref] */,
				   struct netr_UAS_INFO_0 *recordid /* [out] [ref] */);
NTSTATUS rpccli_netr_AccountSync(struct rpc_pipe_client *cli,
				 TALLOC_CTX *mem_ctx,
				 const char *logon_server /* [in] [unique,charset(UTF16)] */,
				 const char *computername /* [in] [charset(UTF16)] */,
				 struct netr_Authenticator credential /* [in]  */,
				 struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
				 uint32_t reference /* [in]  */,
				 uint32_t level /* [in]  */,
				 uint32_t buffersize /* [in]  */,
				 struct netr_AccountBuffer *buffer /* [out] [ref,subcontext(4)] */,
				 uint32_t *count_returned /* [out] [ref] */,
				 uint32_t *total_entries /* [out] [ref] */,
				 uint32_t *next_reference /* [out] [ref] */,
				 struct netr_UAS_INFO_0 *recordid /* [in,out] [ref] */);
NTSTATUS rpccli_netr_GetDcName(struct rpc_pipe_client *cli,
			       TALLOC_CTX *mem_ctx,
			       const char *logon_server /* [in] [charset(UTF16)] */,
			       const char *domainname /* [in] [unique,charset(UTF16)] */,
			       const char **dcname /* [out] [ref,charset(UTF16)] */,
			       WERROR *werror);
NTSTATUS rpccli_netr_LogonControl(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *logon_server /* [in] [unique,charset(UTF16)] */,
				  enum netr_LogonControlCode function_code /* [in]  */,
				  uint32_t level /* [in]  */,
				  union netr_CONTROL_QUERY_INFORMATION *info /* [out] [ref,switch_is(level)] */,
				  WERROR *werror);
NTSTATUS rpccli_netr_GetAnyDCName(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *logon_server /* [in] [unique,charset(UTF16)] */,
				  const char *domainname /* [in] [unique,charset(UTF16)] */,
				  const char **dcname /* [out] [ref,charset(UTF16)] */,
				  WERROR *werror);
NTSTATUS rpccli_netr_LogonControl2(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *logon_server /* [in] [unique,charset(UTF16)] */,
				   enum netr_LogonControlCode function_code /* [in]  */,
				   uint32_t level /* [in]  */,
				   union netr_CONTROL_DATA_INFORMATION *data /* [in] [ref,switch_is(function_code)] */,
				   union netr_CONTROL_QUERY_INFORMATION *query /* [out] [ref,switch_is(level)] */,
				   WERROR *werror);
NTSTATUS rpccli_netr_ServerAuthenticate2(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 const char *server_name /* [in] [unique,charset(UTF16)] */,
					 const char *account_name /* [in] [charset(UTF16)] */,
					 enum netr_SchannelType secure_channel_type /* [in]  */,
					 const char *computer_name /* [in] [charset(UTF16)] */,
					 struct netr_Credential *credentials /* [in] [ref] */,
					 struct netr_Credential *return_credentials /* [out] [ref] */,
					 uint32_t *negotiate_flags /* [in,out] [ref] */);
NTSTATUS rpccli_netr_DatabaseSync2(struct rpc_pipe_client *cli,
				   TALLOC_CTX *mem_ctx,
				   const char *logon_server /* [in] [charset(UTF16)] */,
				   const char *computername /* [in] [charset(UTF16)] */,
				   struct netr_Authenticator *credential /* [in] [ref] */,
				   struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
				   enum netr_SamDatabaseID database_id /* [in]  */,
				   uint16_t restart_state /* [in]  */,
				   uint32_t *sync_context /* [in,out] [ref] */,
				   struct netr_DELTA_ENUM_ARRAY **delta_enum_array /* [out] [ref] */,
				   uint32_t preferredmaximumlength /* [in]  */);
NTSTATUS rpccli_netr_DatabaseRedo(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *logon_server /* [in] [charset(UTF16)] */,
				  const char *computername /* [in] [charset(UTF16)] */,
				  struct netr_Authenticator credential /* [in]  */,
				  struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
				  uint8_t *change_log_entry /* [in] [unique,size_is(change_log_entry_size)] */,
				  uint32_t change_log_entry_size /* [in]  */,
				  struct netr_DELTA_ENUM_ARRAY *delta_enum_array /* [out] [ref] */);
NTSTATUS rpccli_netr_LogonControl2Ex(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *logon_server /* [in] [unique,charset(UTF16)] */,
				     uint32_t function_code /* [in]  */,
				     uint32_t level /* [in]  */,
				     union netr_CONTROL_DATA_INFORMATION data /* [in] [switch_is(function_code)] */,
				     union netr_CONTROL_QUERY_INFORMATION *query /* [out] [ref,switch_is(level)] */,
				     WERROR *werror);
NTSTATUS rpccli_netr_NetrEnumerateTrustedDomains(struct rpc_pipe_client *cli,
						 TALLOC_CTX *mem_ctx,
						 const char *server_name /* [in] [unique,charset(UTF16)] */,
						 struct netr_Blob *trusted_domains_blob /* [out] [ref] */,
						 WERROR *werror);
NTSTATUS rpccli_netr_DsRGetDCName(struct rpc_pipe_client *cli,
				  TALLOC_CTX *mem_ctx,
				  const char *server_unc /* [in] [unique,charset(UTF16)] */,
				  const char *domain_name /* [in] [unique,charset(UTF16)] */,
				  struct GUID *domain_guid /* [in] [unique] */,
				  struct GUID *site_guid /* [in] [unique] */,
				  uint32_t flags /* [in]  */,
				  struct netr_DsRGetDCNameInfo **info /* [out] [ref] */,
				  WERROR *werror);
NTSTATUS rpccli_netr_LogonGetCapabilities(struct rpc_pipe_client *cli,
					  TALLOC_CTX *mem_ctx,
					  const char *server_name /* [in] [charset(UTF16)] */,
					  const char *computer_name /* [in] [unique,charset(UTF16)] */,
					  struct netr_Authenticator *credential /* [in] [ref] */,
					  struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
					  uint32_t query_level /* [in]  */,
					  union netr_Capabilities *capabilities /* [out] [ref,switch_is(query_level)] */);
NTSTATUS rpccli_netr_NETRLOGONSETSERVICEBITS(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     WERROR *werror);
NTSTATUS rpccli_netr_LogonGetTrustRid(struct rpc_pipe_client *cli,
				      TALLOC_CTX *mem_ctx,
				      const char *server_name /* [in] [unique,charset(UTF16)] */,
				      const char *domain_name /* [in] [unique,charset(UTF16)] */,
				      uint32_t *rid /* [out] [ref] */,
				      WERROR *werror);
NTSTATUS rpccli_netr_NETRLOGONCOMPUTESERVERDIGEST(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx,
						  WERROR *werror);
NTSTATUS rpccli_netr_NETRLOGONCOMPUTECLIENTDIGEST(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx,
						  WERROR *werror);
NTSTATUS rpccli_netr_ServerAuthenticate3(struct rpc_pipe_client *cli,
					 TALLOC_CTX *mem_ctx,
					 const char *server_name /* [in] [unique,charset(UTF16)] */,
					 const char *account_name /* [in] [charset(UTF16)] */,
					 enum netr_SchannelType secure_channel_type /* [in]  */,
					 const char *computer_name /* [in] [charset(UTF16)] */,
					 struct netr_Credential *credentials /* [in,out] [ref] */,
					 uint32_t *negotiate_flags /* [in,out] [ref] */,
					 uint32_t *rid /* [out] [ref] */);
NTSTATUS rpccli_netr_DsRGetDCNameEx(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *server_unc /* [in] [unique,charset(UTF16)] */,
				    const char *domain_name /* [in] [unique,charset(UTF16)] */,
				    struct GUID *domain_guid /* [in] [unique] */,
				    const char *site_name /* [in] [unique,charset(UTF16)] */,
				    uint32_t flags /* [in]  */,
				    struct netr_DsRGetDCNameInfo **info /* [out] [ref] */,
				    WERROR *werror);
NTSTATUS rpccli_netr_DsRGetSiteName(struct rpc_pipe_client *cli,
				    TALLOC_CTX *mem_ctx,
				    const char *computer_name /* [in] [unique,charset(UTF16)] */,
				    const char **site /* [out] [ref,charset(UTF16)] */,
				    WERROR *werror);
NTSTATUS rpccli_netr_LogonGetDomainInfo(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_name /* [in] [charset(UTF16)] */,
					const char *computer_name /* [in] [unique,charset(UTF16)] */,
					struct netr_Authenticator *credential /* [in] [ref] */,
					struct netr_Authenticator *return_authenticator /* [in,out] [ref] */,
					uint32_t level /* [in]  */,
					union netr_DomainQuery query /* [in] [switch_is(level)] */,
					union netr_DomainInfo *info /* [out] [ref,switch_is(level)] */);
NTSTATUS rpccli_netr_ServerPasswordSet2(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					const char *server_name /* [in] [unique,charset(UTF16)] */,
					const char *account_name /* [in] [charset(UTF16)] */,
					enum netr_SchannelType secure_channel_type /* [in]  */,
					const char *computer_name /* [in] [charset(UTF16)] */,
					struct netr_Authenticator *credential /* [in] [ref] */,
					struct netr_Authenticator *return_authenticator /* [out] [ref] */,
					struct netr_CryptPassword *new_password /* [in] [ref] */);
NTSTATUS rpccli_netr_ServerPasswordGet(struct rpc_pipe_client *cli,
				       TALLOC_CTX *mem_ctx,
				       const char *server_name /* [in] [unique,charset(UTF16)] */,
				       const char *account_name /* [in] [charset(UTF16)] */,
				       enum netr_SchannelType secure_channel_type /* [in]  */,
				       const char *computer_name /* [in] [charset(UTF16)] */,
				       struct netr_Authenticator *credential /* [in] [ref] */,
				       struct netr_Authenticator *return_authenticator /* [out] [ref] */,
				       struct samr_Password *password /* [out] [ref] */,
				       WERROR *werror);
NTSTATUS rpccli_netr_NETRLOGONSENDTOSAM(struct rpc_pipe_client *cli,
					TALLOC_CTX *mem_ctx,
					WERROR *werror);
NTSTATUS rpccli_netr_DsRAddressToSitenamesW(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    const char *server_name /* [in] [unique,charset(UTF16)] */,
					    uint32_t count /* [in] [range(0,32000)] */,
					    struct netr_DsRAddress *addresses /* [in] [ref,size_is(count)] */,
					    struct netr_DsRAddressToSitenamesWCtr **ctr /* [out] [ref] */,
					    WERROR *werror);
NTSTATUS rpccli_netr_DsRGetDCNameEx2(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *server_unc /* [in] [unique,charset(UTF16)] */,
				     const char *client_account /* [in] [unique,charset(UTF16)] */,
				     uint32_t mask /* [in]  */,
				     const char *domain_name /* [in] [unique,charset(UTF16)] */,
				     struct GUID *domain_guid /* [in] [unique] */,
				     const char *site_name /* [in] [unique,charset(UTF16)] */,
				     uint32_t flags /* [in]  */,
				     struct netr_DsRGetDCNameInfo **info /* [out] [ref] */,
				     WERROR *werror);
NTSTATUS rpccli_netr_NETRLOGONGETTIMESERVICEPARENTDOMAIN(struct rpc_pipe_client *cli,
							 TALLOC_CTX *mem_ctx,
							 WERROR *werror);
NTSTATUS rpccli_netr_NetrEnumerateTrustedDomainsEx(struct rpc_pipe_client *cli,
						   TALLOC_CTX *mem_ctx,
						   const char *server_name /* [in] [unique,charset(UTF16)] */,
						   struct netr_DomainTrustList *dom_trust_list /* [out] [ref] */,
						   WERROR *werror);
NTSTATUS rpccli_netr_DsRAddressToSitenamesExW(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      const char *server_name /* [in] [unique,charset(UTF16)] */,
					      uint32_t count /* [in] [range(0,32000)] */,
					      struct netr_DsRAddress *addresses /* [in] [ref,size_is(count)] */,
					      struct netr_DsRAddressToSitenamesExWCtr **ctr /* [out] [ref] */,
					      WERROR *werror);
NTSTATUS rpccli_netr_DsrGetDcSiteCoverageW(struct rpc_pipe_client *cli,
					   TALLOC_CTX *mem_ctx,
					   const char *server_name /* [in] [unique,charset(UTF16)] */,
					   struct DcSitesCtr *ctr /* [out] [ref] */,
					   WERROR *werror);
NTSTATUS rpccli_netr_LogonSamLogonEx(struct rpc_pipe_client *cli,
				     TALLOC_CTX *mem_ctx,
				     const char *server_name /* [in] [unique,charset(UTF16)] */,
				     const char *computer_name /* [in] [unique,charset(UTF16)] */,
				     enum netr_LogonLevel logon_level /* [in]  */,
				     union netr_LogonInfo *logon /* [in] [ref,switch_is(logon_level)] */,
				     uint16_t validation_level /* [in]  */,
				     union netr_Validation *validation /* [out] [ref,switch_is(validation_level)] */,
				     uint8_t *authoritative /* [out] [ref] */,
				     uint32_t *flags /* [in,out] [ref] */);
NTSTATUS rpccli_netr_DsrEnumerateDomainTrusts(struct rpc_pipe_client *cli,
					      TALLOC_CTX *mem_ctx,
					      const char *server_name /* [in] [unique,charset(UTF16)] */,
					      uint32_t trust_flags /* [in]  */,
					      struct netr_DomainTrustList *trusts /* [out] [ref] */,
					      WERROR *werror);
NTSTATUS rpccli_netr_DsrDeregisterDNSHostRecords(struct rpc_pipe_client *cli,
						 TALLOC_CTX *mem_ctx,
						 const char *server_name /* [in] [unique,charset(UTF16)] */,
						 const char *domain /* [in] [unique,charset(UTF16)] */,
						 struct GUID *domain_guid /* [in] [unique] */,
						 struct GUID *dsa_guid /* [in] [unique] */,
						 const char *dns_host /* [in] [ref,charset(UTF16)] */,
						 WERROR *werror);
NTSTATUS rpccli_netr_ServerTrustPasswordsGet(struct rpc_pipe_client *cli,
					     TALLOC_CTX *mem_ctx,
					     const char *server_name /* [in] [unique,charset(UTF16)] */,
					     const char *account_name /* [in] [charset(UTF16)] */,
					     enum netr_SchannelType secure_channel_type /* [in]  */,
					     const char *computer_name /* [in] [charset(UTF16)] */,
					     struct netr_Authenticator *credential /* [in] [ref] */,
					     struct netr_Authenticator *return_authenticator /* [out] [ref] */,
					     struct samr_Password *password /* [out] [ref] */,
					     struct samr_Password *password2 /* [out] [ref] */);
NTSTATUS rpccli_netr_DsRGetForestTrustInformation(struct rpc_pipe_client *cli,
						  TALLOC_CTX *mem_ctx,
						  const char *server_name /* [in] [unique,charset(UTF16)] */,
						  const char *trusted_domain_name /* [in] [unique,charset(UTF16)] */,
						  uint32_t flags /* [in]  */,
						  struct lsa_ForestTrustInformation **forest_trust_info /* [out] [ref] */,
						  WERROR *werror);
NTSTATUS rpccli_netr_GetForestTrustInformation(struct rpc_pipe_client *cli,
					       TALLOC_CTX *mem_ctx,
					       const char *server_name /* [in] [unique,charset(UTF16)] */,
					       const char *trusted_domain_name /* [in] [ref,charset(UTF16)] */,
					       struct netr_Authenticator *credential /* [in] [ref] */,
					       struct netr_Authenticator *return_authenticator /* [out] [ref] */,
					       uint32_t flags /* [in]  */,
					       struct lsa_ForestTrustInformation **forest_trust_info /* [out] [ref] */,
					       WERROR *werror);
NTSTATUS rpccli_netr_LogonSamLogonWithFlags(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    const char *server_name /* [in] [unique,charset(UTF16)] */,
					    const char *computer_name /* [in] [unique,charset(UTF16)] */,
					    struct netr_Authenticator *credential /* [in] [unique] */,
					    struct netr_Authenticator *return_authenticator /* [in,out] [unique] */,
					    enum netr_LogonLevel logon_level /* [in]  */,
					    union netr_LogonInfo logon /* [in] [switch_is(logon_level)] */,
					    uint16_t validation_level /* [in]  */,
					    union netr_Validation *validation /* [out] [ref,switch_is(validation_level)] */,
					    uint8_t *authoritative /* [out] [ref] */,
					    uint32_t *flags /* [in,out] [ref] */);
NTSTATUS rpccli_netr_NETRSERVERGETTRUSTINFO(struct rpc_pipe_client *cli,
					    TALLOC_CTX *mem_ctx,
					    WERROR *werror);
#endif /* __CLI_NETLOGON__ */
