/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.RuleBasedCollator;

public final class CollationElementIterator {
    public static final int NULLORDER = -1;
    RuleBasedCollator collator;
    String text;
    int textIndex;
    boolean lookahead_set;
    int lookahead;

    CollationElementIterator(RuleBasedCollator collator, String text) {
        this.collator = collator;
        this.setText(text);
    }

    public int next() {
        if (this.textIndex == this.text.length()) {
            return -1;
        }
        return this.collator.ceiNext(this);
    }

    public static final int primaryOrder(int order) {
        return order >>> 16;
    }

    public void reset() {
        this.textIndex = 0;
    }

    public static final short secondaryOrder(int order) {
        return (short)((short)(order >>> 8) & 0xFF);
    }

    public static final short tertiaryOrder(int order) {
        return (short)((short)order & 0xFF);
    }

    public void setText(String text) {
        this.text = text;
        this.textIndex = 0;
        this.lookahead_set = false;
        this.lookahead = 0;
    }

    public int getOffset() {
        return this.textIndex;
    }
}

