/*----------------------------------------------------------------------------

   libtunepimp -- The MusicBrainz tagging library.
                  Let a thousand taggers bloom!

   Copyright (C) Robert Kaye 2003

   This file is part of libtunepimp.

   libtunepimp is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   libtunepimp is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with libtunepimp; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   $Id: submit.h,v 1.6 2003/07/31 23:20:01 dave Exp $

----------------------------------------------------------------------------*/
#ifndef __SUBMIT_H__
#define __SUBMIT_H__

#ifdef WIN32
#if _MSC_VER == 1200
#pragma warning(disable:4786)
#endif
#endif

#include <string>
#include <vector>
#include <utility>

using namespace std;

#include "lookuptools.h"

class TunePimp;
class SubmitInfo
{
    public:

           SubmitInfo (TunePimp *pimp,
                       const string &appName,
                       const string &appVersion)
                       {
                           this->tunePimp = pimp;
                           this->appName = appName;
                           this->appVersion = appVersion;
                       };
          ~SubmitInfo (void) {};


      void         add        (const string &trackId,
                               const string &trmId);
      void         remove     (const string &trackId);
      bool         find       (const string &trmId, string &trackId);

      void         clear      (void) { list.clear(); };
      int          getNumItems(void);
      void         getRDF     (string &rdfArg);

      void         setUserInfo(const string &username, const string &password)
                   { this->username = username; this->password = password; };
      void         getUserInfo(string &username, string &password)
                   { username = this->username; password = this->password; };
      LookupStatus submit     (void);
      void         getError   (string &error) { error = err; };

    private:

      string                        appName, appVersion;
      vector<pair<string, string> > list;
      string                        username, password;
      string                        err;
      TunePimp                     *tunePimp;
};

#endif
