/*
 * Copyright (C) 2002-4 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

#include <errno.h>

#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "modules.h"

#include "terminal.h"

#include "misc.h"
#include "input.h"
#include "run.h"

/* This routine is too small to merit a separate gmodule... */

G_MODULE_EXPORT
const gchar *what_term(void){
    static gchar *term=NULL;
    if (term){
       g_free(term);
       term=NULL;
    }
    term=NULL;
    if (getenv("TERMCMD") && strlen( getenv("TERMCMD"))){
	    if (MIME_is_valid_command(getenv("TERMCMD"))){
		    term = g_strdup(getenv("TERMCMD"));
	    } else {
		print_diagnostics("xfce/warning",
			getenv("TERMCMD"),": ",strerror(errno),"\n",NULL);
	    }
    }
    if (!term) {
	term=g_find_program_in_path("xfce4-terminal");
	if (!term) term=g_strdup("xterm");
    }
    if ((strncmp(term,"xterm",strlen("xterm"))==0 || strstr(term,"xfce4-terminal")) 
         && getenv("XFFM_HOLD_XTERM") && strlen( getenv("XFFM_HOLD_XTERM"))){
	gchar *p=term;
	term=g_strconcat(p," -hold",NULL);
	g_free(p);
    }
    return (const gchar *)term;	
}

static void new_terminal_query(void){
    show_input(NEW_TERM_INPUT);
}

G_MODULE_EXPORT
void new_terminal_path(gchar *workdir){
    GError *error=NULL;
    int argc;
    gchar **argv;
  
    g_shell_parse_argv (what_term(), &argc,&argv,&error);
    if (error){
	gchar *msg = g_strcompress (error->message);
	print_diagnostics("xfce/error",msg,": ",what_term(),"\n",NULL);
	g_error_free(error);
	g_free (msg);
	return;
    }
    runvwd(workdir,argv);
    g_strfreev (argv);
    return;
}


static void new_terminal(void)
{
    tree_entry_t *en;
    GtkTreeIter iter;
   
    get_selectpath_iter(&iter, & en);
    new_terminal_path((en && en->path)?en->path:NULL);
    return;
}

/* callbacks */
G_MODULE_EXPORT
void on_term(GtkWidget *w){
    new_terminal();    
}
G_MODULE_EXPORT
void on_term_query(GtkWidget *w){
    new_terminal_query();    
}

G_MODULE_EXPORT
void on_terminal2_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    new_terminal();

}

G_MODULE_EXPORT
void tb_terminal(GtkButton * button, gpointer user_data)
{
    on_term((GtkWidget *)button);
}

G_MODULE_EXPORT
void on_open_in_terminal_activate(GtkMenuItem * menuitem, gpointer user_data)
{
    new_terminal();
}
