/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <limits.h>

#include <errno.h>


#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>


#include "constants.h"
#include "types.h"

#include "scramble.h"

#include "glade_support.h"
#include "input.h"
#include "run.h"
#include "misc.h"
#include "remove.h"
#include "terminal.h"



static 
int 
scramble_it(		const gchar *file, 
			gboolean scram)
{
    GError *error = NULL;
    gchar *nfile;
    gchar *command;
    int argc;
    gchar **argv;
    gchar *options,*p;
    
   
       if (!file) return FALSE;
    
    nfile = g_strconcat(file,".cyt",NULL);
    if(access(nfile, F_OK) == 0)
    {
	if (!query_rm(nfile, nfile,FALSE)){
	    /* XXX query_rm(FALSE) because directories are 
	     * not scrambleable from xffm */
		    g_free(nfile);
		    return FALSE;
	}
    }
    g_free(nfile);
    nfile=NULL;
  
    if (scram) options = g_strdup("-e");
    else options = g_strdup("-db");
    if (g_file_test(file,G_FILE_TEST_IS_DIR) ) {
	p = g_strconcat(options,"r",NULL);
	g_free(options);
	options=p;
	p=NULL;
    }
    if (tree_details->preferences && VERBOSE){
	p = g_strconcat(options,"v",NULL);
	g_free(options);
	options=p;
	p=NULL;
    }
    
    command=g_strconcat(what_term()," -e scramble ",options," \"",file,"\"",NULL);
    g_free(options);
    
    
    /*print_diagnostics(NULL,"$",command,"\n",NULL);*/
    
    g_shell_parse_argv (command, &argc,&argv,&error);
    if (error){
	gchar *msg = g_strcompress (error->message);
	print_diagnostics("xfce/error",msg,":\n",command,"\n",NULL);
	g_error_free(error);
	g_free(command);   
	g_free (msg);
	return FALSE;
    }
    runv(argv);
    g_strfreev (argv);
    g_free(command);   
    
    return TRUE;
}




static
const
gchar *
on_scramble(		GtkWidget *w){
    tree_entry_t *en;
     gint tree_id = get_active_tree_id();
    GtkTreeModel *treemodel = tree_details->treestuff[tree_id].treemodel;
    GtkTreeSelection *selection = tree_details->treestuff[tree_id].selection;

    GtkTreeIter iter;
    
    gtk_tree_selection_set_mode(selection, GTK_SELECTION_SINGLE);
    if(!gtk_tree_selection_get_selected(selection, &treemodel, &iter)) {
    	gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);
	return NULL;
    }
    gtk_tree_model_get(treemodel, &iter, ENTRY_COLUMN, &en, -1);
    gtk_tree_selection_set_mode(selection, GTK_SELECTION_MULTIPLE);
#if USE_XFALL || USE_SCRAMBLEDIR
    if(!en || !IS_PATH(en->type))
#else
    if(!en || !IS_FILE(en->type))
#endif
    {
	print_diagnostics("xfce/error", strerror(EINVAL)," : ",_("Scramble"),"\n", NULL);
	return NULL;
    }
    return (const gchar *)en->path;
}

/*   callback  */

G_MODULE_EXPORT
void on_scramble_activate(GtkMenuItem * menuitem, gpointer user_data)
{
   scramble_it(on_scramble((GtkWidget *)menuitem),TRUE); 
}

G_MODULE_EXPORT
void on_unscramble_activate(GtkMenuItem * menuitem, gpointer user_data)
{
   scramble_it(on_scramble((GtkWidget *)menuitem),FALSE); 
}
