/*
 * Copyright 2002 by Paul Mattes.
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation.
 *
 * x3270 is distributed in the hope that it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the file LICENSE for more details.
 */

/*
 *	widec.h
 *		Global declarations for wide.c.
 */

#if defined(X3270_DBCS) /*[*/
#include <unicode/ucnv.h>

extern int wide_init(const char *csname);
extern void dbcs_to_display(unsigned char ebc1, unsigned char ebc2,
    unsigned char c[]);
extern void dbcs_to_unicode16(unsigned char ebc1, unsigned char ebc2,
    unsigned char c[]);

extern int dbcs_to_mb(unsigned char ebc1, unsigned char ebc2, char *mb);
extern int sbcs_to_mb(unsigned char ebc, char *mb);
extern int mb_to_unicode(char *mb, int mblen, UChar *u, int ulen,
    UErrorCode *err);
extern int dbcs_map8(UChar, unsigned char *);
extern int dbcs_map16(UChar, unsigned char *);
#endif /*]*/
