//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QColor;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import org.kde.qt.QObject;
import org.kde.qt.QPixmap;
import org.kde.qt.QEvent;
import org.kde.qt.QWidget;
import org.kde.qt.QObject;

/**

 Creates pseudo-transparent widgets.
 A pseudo-transparent widget is a widget with its background pixmap set to
 that part of the desktop background that it is currently obscuring. This
 gives a transparency effect.
 To create a transparent widget, construct a KRootPixmap and pass it a
 pointer to your widget. That's it! Moving, resizing and background changes
 are handled automatically.
 Instead of using the default behavior, you can ask KRootPixmap
 to emit a backgroundUpdated(QPixmap) signal whenever
 the background needs updating by using setCustomPainting(boolean).
 Alternatively by reimplementing updateBackground(KSharedPixmap)
 you can take complete control of the behavior.
 See {@link KRootPixmapSignals} for signals emitted by KRootPixmap
		@author Geert Jansen <jansen@kde.org>

		@version  krootpixmap.h,v 1.32 2004/09/09 20:07:27 staniek
 
		@short    Creates pseudo-transparent widgets.

*/
public class KRootPixmap extends QObject  {
	protected KRootPixmap(Class dummy){super((Class) null);}
	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Constructs a KRootPixmap. The KRootPixmap will be created as a child
		 of the target widget so it will be deleted automatically when the
		 widget is destroyed.
			@param target A pointer to the widget that you want to make pseudo
		 transparent.
			@param name The internal name of the pixmap
		     		@short    Constructs a KRootPixmap.
	*/
	public KRootPixmap(QWidget target, String name) {
		super((Class) null);
		newKRootPixmap(target,name);
	}
	private native void newKRootPixmap(QWidget target, String name);
	public KRootPixmap(QWidget target) {
		super((Class) null);
		newKRootPixmap(target);
	}
	private native void newKRootPixmap(QWidget target);
	/**	
		 Constructs a KRootPixmap where the parent QObject and target QWidget are
		 different.
		     		@short    Constructs a KRootPixmap where the parent QObject and target QWidget are  different.
	*/
	public KRootPixmap(QWidget target, QObject parent, String name) {
		super((Class) null);
		newKRootPixmap(target,parent,name);
	}
	private native void newKRootPixmap(QWidget target, QObject parent, String name);
	public KRootPixmap(QWidget target, QObject parent) {
		super((Class) null);
		newKRootPixmap(target,parent);
	}
	private native void newKRootPixmap(QWidget target, QObject parent);
	/**	
		 Checks if pseudo-transparency is available.
				@return <code>true</code> if transparency is available, <code>false</code> otherwise.
     
		@short    Checks if pseudo-transparency is available.
	*/
	public native boolean isAvailable();
	/**	
		 Returns true if the KRootPixmap is active.
		     		@short    Returns true if the KRootPixmap is active.
	*/
	public native boolean isActive();
	/**	
		 Returns the number of the current desktop.
		     		@short    Returns the number of the current desktop.
	*/
	public native int currentDesktop();
	/**	
		 Returns true if custom painting is enabled, false otherwise.
				@short    Returns true if custom painting is enabled, false otherwise.
		@see #setCustomPainting(boolean)
	*/
	public native boolean customPainting();
	/**	 @since 3.2
				@return the fade color.
     
		@short   @since 3.
	*/
	public native QColor color();
	/**	 @since 3.2
				@return the color opacity.
     
		@short   @since 3.
	*/
	public native double opacity();
	/**	
		 Starts background handling.
		     		@short    Starts background handling.
	*/
	public native void start();
	/**	
		 Stops background handling.
		     		@short    Stops background handling.
	*/
	public native void stop();
	/**	
		 Sets the fade effect.
			 This effect will fade the background to the
		 specified color.
			@param opacity A value between 0 and 1, indicating the opacity
		 of the color. A value of 0 will not change the image, a value of 1
		 will use the fade color unchanged.
			@param color The color to fade to.
		     		@short    Sets the fade effect.
	*/
	public native void setFadeEffect(double opacity, QColor color);
	/**	
		 Repaints the widget background. Normally, you shouldn't need this
		 as it is handled automatically.
			@param force Force a repaint, even if the contents did not change.
		     		@short    Repaints the widget background.
	*/
	public native void repaint(boolean force);
	/**	
		 Repaints the widget background. Normally, you shouldn't need this
		 as it is handled automatically. This is equivalent to calling
		 repaint( false ).
		     		@short    Repaints the widget background.
	*/
	public native void repaint();
	/**	
		 Enables custom handling of the background painting. If custom
		 painting is enabled then KRootPixmap will emit a
		 backgroundUpdated() signal when the background for the
		 target widget changes, instead of applying the new background.
		     		@short    Enables custom handling of the background painting.
	*/
	public native void setCustomPainting(boolean enable);
	/**	
		 Asks KDesktop to export the desktop background as a KSharedPixmap.
		 This method uses DCOP to call KBackgroundIface/setExport(int).
		     		@short    Asks KDesktop to export the desktop background as a KSharedPixmap.
	*/
	public native void enableExports();
	/**	
		 Returns the name of the shared pixmap (only needed for low level access)
		     		@short    Returns the name of the shared pixmap (only needed for low level access)
	*/
	public static native String pixmapName(int desk);
	/**	
		 Reimplemented to filter the events from the target widget and
		 track its movements.
		     		@short    Reimplemented to filter the events from the target widget and  track its movements.
	*/
	public native boolean eventFilter(QObject arg1, QEvent arg2);
	/**	
		 Called when the pixmap has been updated. The default implementation
		 applies the fade effect, then sets the target's background, or emits
		 backgroundUpdated(QPixmap) depending on the painting mode.
		     		@short    Called when the pixmap has been updated.
	*/
	// void updateBackground(KSharedPixmap* arg1); >>>> NOT CONVERTED
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
