/*
 * xlog - GTK+ logging program for amateur radio operators
 * Copyright (C) 2001 - 2005 Joop Stakenborg <pg4i@amsat.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/* gui_aboutdialog.c - creation of the about dialog */

#include <gtk/gtk.h>

#include "gui_aboutdialog.h"
#include "gui_utils.h"
#include "support.h"
#include "types.h"

extern preferencestype preferences;
extern GtkWidget *mainwindow;

#if GTK_MAJOR_VERSION > 1 && GTK_MINOR_VERSION > 5
static void
handle_url (GtkAboutDialog *about, const char *link, gpointer data)
{
	gchar *command[] = {"firefox", NULL, NULL};

	command[1] = g_strdup (link);
	g_spawn_async
		(NULL, command, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, NULL);
	g_free (command[1]);
}

static void
handle_email (GtkAboutDialog *about, const char *link, gpointer data)
{
	gchar *command[] = {"evolution", NULL, NULL};

	command[1] = g_strdup_printf ("mailto:%s", link);
	g_spawn_async
		(NULL, command, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, NULL, NULL);
	g_free (command[1]);
}
#endif

void
on_menu_about_activate (GtkMenuItem * menuitem, gpointer user_data)
{
#if GTK_MAJOR_VERSION > 1 && GTK_MINOR_VERSION > 5
		gchar *authors[] = { "Joop Stakenborg PG4I <pg4i@amsat.org>", 
			"Stephane Fillod F8CFE <f8cfe@free.fr>", NULL };
		GdkPixbuf *pixbuf = create_pixbuf ("xlog.png");

		gtk_about_dialog_set_url_hook (handle_url, NULL, NULL);
		gtk_about_dialog_set_email_hook (handle_email, NULL, NULL);

		gtk_show_about_dialog (GTK_WINDOW(mainwindow), 
			"authors", authors,
			"comments", _("logbook program for amateur radio operators"),
			"license", 
"Copyright (C) 2001 - 2005 Joop Stakenborg <pg4i@amsat.org>\n"
"\n"
"This program is free software; you can redistribute it and/or modify\n"
"it under the terms of the GNU General Public License as published by\n"
"the Free Software Foundation; either version 2 of the License, or\n"
"(at your option) any later version.\n"
"\n"
"This program is distributed in the hope that it will be useful,\n"
"but WITHOUT ANY WARRANTY; without even the implied warranty of\n"
"MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the\n"
"GNU Library General Public License for more details.\n"
"\n"
"You should have received a copy of the GNU General Public License\n"
"along with this program; if not, write to the Free Software\n"
"Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.\n",
			"website", "http://www.qsl.net/pg4i/linux/xlog.html",
			"logo", pixbuf,
			"translator-credits",
"Danish: Alexandru Csete OZ9AEC <alexc@phys.au.dk>\n"
"Dutch: Joop Stakenborg PG4I <pg4i@amsat.org>\n"
"French: Jean-Luc Coulon F5IBH <jean-luc.coulon@wanadoo.fr>\n"
"Polish: Boguslaw Ciastek SQ5TB <sq5tb@op.pl>\n"
"Spanish: Jaime Robles EA4TV <jaime@robles.nu>\n"
"Slovak: Michal Karas OM4AA <zoliq@ilm.utc.sk>\n",
			"version", VERSION,
			NULL);
#else
		GtkWidget *aboutdialog, *aboutlabel1, *aboutlabel2, *aboutlabel3,
			*aboutlabel4, *vbox, *image;
		gchar *labeltext, *text1, *text2;
		gint response;

		aboutdialog = gtk_dialog_new_with_buttons (_("xlog - about"),
			GTK_WINDOW(mainwindow), GTK_DIALOG_DESTROY_WITH_PARENT,
			GTK_STOCK_OK, GTK_RESPONSE_OK, NULL);

		vbox = gtk_vbox_new (FALSE, 10);
		gtk_container_set_border_width (GTK_CONTAINER (vbox), 10);
		gtk_container_add
			(GTK_CONTAINER (GTK_DIALOG (aboutdialog)->vbox), vbox);
		image = gtk_image_new_from_stock
			("gtk-dialog-info", GTK_ICON_SIZE_DIALOG);
		gtk_box_pack_start (GTK_BOX (vbox), image, FALSE, FALSE, 0);

		aboutlabel1 = gtk_label_new ("");
		gtk_box_pack_start (GTK_BOX (vbox), aboutlabel1, FALSE, FALSE, 0);
		text1 = g_strdup_printf ("%s %s, ", PACKAGE, VERSION);
		text2 = g_strdup_printf
			(_("logbook program for amateur radio operators"));

		labeltext = g_strconcat (text1, text2, NULL);
		gtk_label_set_text (GTK_LABEL (aboutlabel1), labeltext);
		g_free (labeltext);
		g_free (text2);
		g_free (text1);

		aboutlabel2 = gtk_label_new ("Copyright (C) 2001-2005, "
			"Joop Stakenborg PG4I <pg4i@amsat.org>, "
			"Stephane Fillod F8CFE <f8cfe@free.fr>");
		gtk_box_pack_start (GTK_BOX (vbox), aboutlabel2, FALSE, FALSE, 0);

		aboutlabel3 = gtk_label_new 
			("Homepage: http://www.qsl.net/pg4i/linux/xlog.html, "
	"mailing list: http://mail.nongnu.org/mailman/listinfo/xlog-discussion");
		gtk_box_pack_start (GTK_BOX (vbox), aboutlabel3, FALSE, FALSE, 0);

		aboutlabel4 = gtk_label_new 
			(_("Published under the GNU GPL License"));
		gtk_box_pack_start (GTK_BOX (vbox), aboutlabel4, FALSE, FALSE, 0);

		setlabelstyle (aboutlabel1, preferences.themecolor,
			preferences.themefont);
		gtk_label_set_line_wrap (GTK_LABEL (aboutlabel2), TRUE);
		gtk_label_set_line_wrap (GTK_LABEL (aboutlabel3), TRUE);
		gtk_label_set_line_wrap (GTK_LABEL (aboutlabel4), TRUE);

		gtk_widget_show_all (aboutdialog);
		response = gtk_dialog_run (GTK_DIALOG (aboutdialog));
		gtk_widget_destroy (aboutdialog);
#endif
}
