/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.LongBuffer;
import java.nio.ReadOnlyBufferException;

final class LongBufferImpl
extends LongBuffer {
    private boolean readOnly;

    LongBufferImpl(int capacity) {
        this(new long[capacity], 0, capacity, capacity, 0, -1, false);
    }

    LongBufferImpl(long[] buffer, int offset, int capacity, int limit, int position, int mark, boolean readOnly) {
        super(buffer, offset, capacity, limit, position, mark);
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public LongBuffer slice() {
        return new LongBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    public LongBuffer duplicate() {
        return new LongBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    public LongBuffer asReadOnlyBuffer() {
        return new LongBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    public LongBuffer compact() {
        int copied = 0;
        while (this.remaining() > 0) {
            this.put(copied, this.get());
            ++copied;
        }
        this.position(copied);
        return this;
    }

    public boolean isDirect() {
        return false;
    }

    public final long get() {
        long result = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return result;
    }

    public final LongBuffer put(long value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[this.position()] = value;
        this.position(this.position() + 1);
        return this;
    }

    public final long get(int index) {
        return this.backing_buffer[index];
    }

    public final LongBuffer put(int index, long value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[index] = value;
        return this;
    }

    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

