/*
 * Copyright (c) 2004 Jean-Franois Wauthy (pollux@xfce.org)
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gmodule.h>
#include <string.h>
#include <libxfcegui4/libxfcegui4.h>
#include <libxfce4util/libxfce4util.h>
#include <printing-system.h>

/***************/
/* Main window */
/***************/

/* Returns the printer list  */
/* returned pointer must be freed */
G_MODULE_EXPORT
GList* printing_system_get_printers_list_impl ()
{
  return NULL;
}

/* Customize main window */
G_MODULE_EXPORT
void printing_system_main_window_customize_impl (ManagerDlg *dlg)
{
  gtk_widget_set_sensitive (dlg->menuitem_properties, FALSE);
  gtk_widget_set_sensitive (dlg->menuitem_setdefault, FALSE);
  gtk_widget_set_sensitive (dlg->treeview, FALSE);
}

G_MODULE_EXPORT
gboolean printing_system_set_default_printer_impl (const gchar *printer)
{
  return TRUE;
}

G_MODULE_EXPORT
Printer *printing_system_get_default_printer_impl (GList *printers)
{
  return NULL;
}
/****************/
/* Queue dialog */
/****************/

/* Refresh the job list */
/* returned pointer must be freed */
G_MODULE_EXPORT
GList *printing_system_get_jobs_list_impl (const gchar *printer)
{
  return NULL;
}

/* Remove job from printer_name queue */
G_MODULE_EXPORT
gboolean printing_system_remove_job_impl (const gchar *printer, gint id)
{
  return TRUE;
}

/* Customize the queue dialog */
G_MODULE_EXPORT
void printing_system_queue_dialog_customize_impl (QueueDlg *dialog)
{
}

/*********************/
/* Properties dialog */
/*********************/
/* Show the properties dialog */
G_MODULE_EXPORT
void printing_system_properties_dialog_run_impl (GtkWidget *widget, const gchar *printer)
{
}

/****************/
/* Print dialog */
/****************/
static void button_select_clicked_cb (GtkWidget *widget, gpointer data)
{
  PrintDlg *dlg;
  GtkWidget *selection;
  gint response = GTK_RESPONSE_NONE;
  gchar *file = NULL;

  dlg = (PrintDlg *) data;

  selection = xfce_file_chooser_new (_("Select file where to print"),
				     GTK_WINDOW (dlg->dialog),
				     XFCE_FILE_CHOOSER_ACTION_SAVE,
				     GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
				     GTK_STOCK_OPEN, GTK_RESPONSE_OK, NULL);

  response = gtk_dialog_run (GTK_DIALOG (selection));
  
  if (response == GTK_RESPONSE_OK)
  {
      file = xfce_file_chooser_get_filename (XFCE_FILE_CHOOSER (selection));

      gtk_entry_set_text (GTK_ENTRY (dlg->customization), file);

      g_free (file);
  }
  
  gtk_widget_destroy (selection);
}

/* Customize the print dialog */
G_MODULE_EXPORT
void printing_system_print_dialog_customize_impl (PrintDlg *dialog)
{
  GtkWidget *hbox;
  GtkWidget *label;
  GtkWidget *image;
  GtkWidget *button_select_file;

  gchar *path;

  /* Print to */
  hbox = gtk_hbox_new(FALSE, 0);

  label = gtk_label_new (_("Print to file:"));
  gtk_box_pack_start (GTK_BOX (hbox), label, FALSE, TRUE, 5);
  dialog->customization = (gpointer) gtk_entry_new ();
  gtk_box_pack_start (GTK_BOX (hbox), GTK_WIDGET (dialog->customization), TRUE, TRUE, 0);

  /* set default value in print to */
  path = xfce_get_homefile ("print.ps", NULL);
  gtk_entry_set_text (GTK_ENTRY (dialog->customization), path);
  g_free (path);

  button_select_file = gtk_button_new ();
  g_signal_connect (G_OBJECT (button_select_file), "clicked",
   		    G_CALLBACK (button_select_clicked_cb), dialog);
  
  image = gtk_image_new_from_stock (GTK_STOCK_OPEN, GTK_ICON_SIZE_BUTTON);
  gtk_container_add (GTK_CONTAINER (button_select_file), image);
  gtk_box_pack_start (GTK_BOX (hbox), button_select_file, FALSE, TRUE, 0);
    
  gtk_widget_show_all (hbox);
  gtk_box_pack_start (GTK_BOX (GTK_DIALOG (dialog->dialog)->vbox), hbox,
		      TRUE, TRUE, 0);
  gtk_box_reorder_child (GTK_BOX (GTK_DIALOG (dialog->dialog)->vbox), hbox, 0);
}

/****************/
/* About dialog */
/****************/
G_MODULE_EXPORT
void printing_system_about_dialog_run_impl (GtkWidget *widget, gpointer data)
{
  XfceAboutInfo *info;
  GtkWidget *dialog;
  GdkPixbuf *icon = NULL;
  ManagerDlg *dlg;

  dlg = (ManagerDlg *) data;

  info = xfce_about_info_new ("xfprint-file-plugin", VERSION,
			      _("File plugin for Xfprint"),
			      XFCE_COPYRIGHT_TEXT("2004", "Xfce4 Team"),
			      XFCE_LICENSE_BSD);
  xfce_about_info_set_homepage (info, "http://www.xfce.org/");

  /* Credits */
  xfce_about_info_add_credit (info,
			      "Jean-Francois Wauthy",
			      "pollux@xfce.org",
			      _("Developer"));
  xfce_about_info_add_credit (info,
			      "Francois Le Clainche",
			      "fleclainche@wanadoo.fr",
			      _("Icon designer"));

  //  icon = xfce_themed_icon_load ("xfprint-file-plugin" , 48);

  dialog = xfce_about_dialog_new (GTK_WINDOW (dlg->window), info, icon);

  gtk_window_set_default_size (GTK_WINDOW (dialog),500,400);
  xfce_about_info_free (info);

  gtk_dialog_run (GTK_DIALOG (dialog));
  
  gtk_widget_destroy (dialog);

  //  g_object_unref (icon);
}

/************/
/* Printing */
/************/
G_MODULE_EXPORT
gboolean printing_system_print_file_impl (PrintDlg *dialog, const gchar *file)
{
  FILE *src_file_descr;
  FILE *dest_file_descr;
  gchar buf[255];

  const gchar* dest_file;

  g_return_val_if_fail (strlen(file) != 0, FALSE);

  dest_file = gtk_entry_get_text (GTK_ENTRY (dialog->customization));

  if (strlen (dest_file) == 0){
     xfce_err (_("You have to provide a destination file !"));
     return FALSE;
  }
  
  /* Copy the temporary file to destination file */
  dest_file_descr = fopen (dest_file, "w+");
  if (!dest_file_descr){
    g_warning ("unable to create the destination file");
    return FALSE;
  }
  
  src_file_descr = fopen (file, "r");
  if (!src_file_descr) {
    g_warning ("unable to open the temporary file");
    fclose (dest_file_descr);
    return FALSE;
  }
  
  while (fgets (buf, sizeof (buf), src_file_descr)) {
    fputs (buf, dest_file_descr);
  }
  
  fclose (dest_file_descr);
  fclose (src_file_descr);
  
  return TRUE;
}

/**********/
/* Others */
/**********/

/* Module informations initialization function */
G_MODULE_EXPORT
void printing_system_info_init_impl (PrintingSystemInfo *psinfo)
{
  psinfo->name = g_strdup ("File");
  psinfo->description = g_strdup ("File printing system support for Xfprint");
  psinfo->version = g_strdup (VERSION);
  psinfo->author = g_strdup ("Jean-Francois Wauthy");
  psinfo->homepage = g_strdup ("http://www.xfce.org");
}

