/*  settings.c
 *  
 *  Copyright (C) 2003 Edscott Wilson Garcia (edscott@users.sourceforge.net)
 *  Copyright (C) 2002 Jasper Huijsmans (huysmans@users.sourceforge.net)
 *
 *   modified for xffm by Edscott Wilson Garcia
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/stat.h>

#include <limits.h>
#include <memory.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <glib.h>
#include <gtk/gtk.h>


#include <libxml/parser.h>
#include <libxml/tree.h>

#include "glade_support.h"

#include "constants.h"

#include "modules.h"

#include "settings.h"


#include "preferences.i"
/* keep gcc happy */
G_MODULE_EXPORT
preferences_t *prefs = opt_branches_titles;


#define CONFIG_VERSION  "0.8.8"

#define GEOMETRY_X 600
#define GEOMETRY_Y 500
/* although this works to set an alternate width for xfetc,
 * the size of the toolbar will in the end determine the minimum width 
 * of the window... */
#define HPANE_POS 125
#define ALT_HPANE_POS 0
#define DEFAULT_XFFM_THEME "Rodent"
#define FALLBACK_XFFM_THEME "hicolor"
#define XFFM_ICON_SIZE 2

/* the size of env_string must coincide with that of env_vars! */
G_MODULE_EXPORT
gchar *env_string[14]={
	NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,
	NULL,NULL,NULL,NULL,NULL,NULL
};
G_MODULE_EXPORT
char *env_vars[14]={
	"TERMCMD",
	"LANG",
	"XFFM_HOME",
	"XFFM_STATUS_LINE_LENGTH",
	"XFFM_MAX_PREVIEW_SIZE",
	"SMB_USER",
	"SMB_CODESET",
	"XFFM_APPEND_FILES",
	"XFFM_HOLD_XTERM",
	"XFFM_DEFAULT_UNLINK",
	"XFFM_USE_SUDO",
	"XFFM_DIAGNOSTICS_DISABLED",
	"PWD",
	NULL
};

static gboolean write_config_active=FALSE;
G_MODULE_EXPORT
void enable_write_config(void){
    write_config_active=TRUE;
}

/*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*
  Reading xml
-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*-*/
static xmlDocPtr xmlconfig = NULL;


G_MODULE_EXPORT
void get_config(char *rcfile)
{
    xmlChar *value;
    xmlNodePtr node;
    int i;
#ifdef DEBUG
    printf("DBG: now reading rcfile...\n");
#endif

    tree_details->preferences = DEFAULT_PREFERENCES;
    tree_details->hpane = ((strstr(tree_details->argv[0],"xffm"))? HPANE_POS:ALT_HPANE_POS);
    tree_details->geometryX = GEOMETRY_X;
    tree_details->geometryY = GEOMETRY_Y;
    tree_details->smart_hash = NULL;
    tree_details->recent_days=3;
    tree_details->frequent_count=13;
    tree_details->loading=FALSE;
    tree_details->stop=FALSE;
    tree_details->selectionOK=0;
    tree_details->tubo_object=NULL;
    tree_details->input=OTHER_INPUT;
    tree_details->hpane_ratio=-1.0;
    tree_details->icon_size=1;
    tree_details->sidebar=g_strdup("single_selection_button");
    tree_details->theme = g_build_filename(PACKAGE_DATA_DIR,"icons",FALLBACK_XFFM_THEME,NULL);
    for (i=0;i<TREECOUNT;i++){
	switch (i) {
	    case RIGHT_TREEVIEW:
	    {
		int branch;
		if(strstr(tree_details->argv[0],"xfbook")) branch=ACTIVATE_BOOK;
		else if(strstr(tree_details->argv[0],"xftree")) branch=ACTIVATE_LOCAL;
		else if(strstr(tree_details->argv[0],"xffrequent")) branch=ACTIVATE_FREQUENT;
		else if(strstr(tree_details->argv[0],"xfrecent")) branch=ACTIVATE_RECENT;
		else if(strstr(tree_details->argv[0],"xftrash")) branch=ACTIVATE_TRASH;
		else if(strstr(tree_details->argv[0],"xffstab")) branch=ACTIVATE_FSTAB;
		else if(strstr(tree_details->argv[0],"xfsamba")) branch=ACTIVATE_SMB;
		else branch=ACTIVATE_LOCAL;
		
		tree_details->treestuff[i].preferences = (INDIVIDUAL_TOGGLE|SHOW_SIZE|SHOW_DATE|SHOW_GID|SHOW_UID|SHOW_MODE|DETAILED_VIEW|branch);
		break;
	    }
	    default:
		tree_details->treestuff[i].preferences = (INDIVIDUAL_TOGGLE|DEFAULT_VIEW|ACTIVATE_ALL);
	}
    }


    /* global xmlDocPtr */
    if(!xmlconfig){
       xmlKeepBlanksDefault(0);
       xmlconfig = xmlParseFile(rcfile);
       if (!xmlconfig) {
	       goto new_xffm_config;
       }
    }

    node = xmlDocGetRootElement(xmlconfig);
    if(!node){
        goto new_xffm_config;
    }

    if(!xmlStrEqual(node->name, (const xmlChar *)tree_details->argv[0]))
    {
new_xffm_config:
	xmlFreeDoc(xmlconfig);
	xmlconfig=NULL;
	write_xffm_config();
	return;
    }
    
    
    for(node = node->children; node; node = node->next){
	if(xmlStrEqual(node->name, (const xmlChar *)"CONFIG_VERSION")){
		char *e=xmlNodeListGetString(xmlconfig, node->children, 1);
		if (strcmp(e,CONFIG_VERSION)==0)
		{
			break;
		} else {
       		    goto new_xffm_config;
		}
	}

    }
    node = xmlDocGetRootElement(xmlconfig);

    /* Now parse the xml tree */
    for(node = node->children; node; node = node->next)
    {
	for(i = 0; i<TREECOUNT; i++) {
	  gchar *g=g_strdup_printf("treeview_%d",i);
	  if(xmlStrEqual(node->name, (const xmlChar *)g)){
	    value = xmlGetProp(node, (const xmlChar *)"icon_size");
	    if (value) 	    {
		tree_details->icon_size = atoi(value);
		g_free(value);value=NULL;
	    }  
	    value = xmlGetProp(node, (const xmlChar *)"preferences");
	    if (value) 	    {
		tree_details->treestuff[i].preferences = atoi(value);
		g_free(value);value=NULL;
	    }  else tree_details->treestuff[i].preferences = 0;  
	    value = xmlGetProp(node, (const xmlChar *)"name_size");
	    if (value) 	    {
		tree_details->treestuff[i].name_size = atoi(value);
		g_free(value);value=NULL;
	    }  else tree_details->treestuff[i].name_size = 100;  
	  }
	}
	if(xmlStrEqual(node->name, (const xmlChar *)"options"))
	{	    
	    value = xmlGetProp(node, (const xmlChar *)"preferences");
	    if (value) 	    {
		tree_details->preferences = atoi(value);
		g_free(value);value=NULL;
	    }  else tree_details->preferences = DEFAULT_PREFERENCES;

	    
	    value = xmlGetProp(node, (const xmlChar *)"frequent_count");
	    if (value) 	    {
		tree_details->frequent_count = atoi(value);
		g_free(value);value=NULL;
	    }  else tree_details->frequent_count = 3;
	    
	    value = xmlGetProp(node, (const xmlChar *)"recent_days");
	    if (value) 	    {
		tree_details->recent_days = atoi(value);
		g_free(value);value=NULL;
	    }  else tree_details->recent_days = 13;
	    
#if 0
	    value = xmlGetProp(node, (const xmlChar *)"theme");
	    if(value) {
		g_free(tree_details->theme);    
		tree_details->theme = (char*)value;
	    }
#endif
	    
	    value = xmlGetProp(node, (const xmlChar *)"sidebar");
	    if(value) {
		g_free(tree_details->sidebar);    
		tree_details->sidebar = (char*)value;
	    }
	}

	if(xmlStrEqual(node->name, (const xmlChar *)"geometry"))
	{
	    value = xmlGetProp(node, (const xmlChar *)"width");
	    if (value) tree_details->geometryX =  atoi(value);
	    g_free(value);
	    value = xmlGetProp(node, (const xmlChar *)"height");
	    if (value) tree_details->geometryY =  atoi(value);
	    g_free(value);
	    value = xmlGetProp(node, (const xmlChar *)"hpane");
	    if (value) {
		    
		tree_details->hpane = atoi(value);
		TRACE("pane is read=%d\n",tree_details->hpane);
	    }
	    g_free(value);value=NULL;
	    
	    /*tree_details->hpane_ratio = (double)tree_details->hpane / (double)tree_details->geometryX;*/
	}
	if(xmlStrEqual(node->name, (const xmlChar *)"smart_button")){
	    gchar *name = xmlGetProp(node, (const xmlChar *)"name");
	    if (name){
		int v;
		value = xmlGetProp(node, (const xmlChar *)"value");
		v=atoi(value);
#ifdef DEBUG
		printf("DBG:loading hash value %s=%s\n",name,value);
#endif
		if (tree_details->smart_hash == NULL){
		    tree_details->smart_hash = 
			g_hash_table_new( g_str_hash, g_str_equal);
		}
		g_hash_table_insert(tree_details->smart_hash,(gpointer)name,(gpointer)((long)v));
		g_free(value);
	    }
	}
	

    }
    xmlFreeDoc(xmlconfig);
    xmlconfig = NULL;
}

G_MODULE_EXPORT
void get_xffm_config(){
    gchar *rcfile;
    gchar *fname=g_strconcat(tree_details->argv[0],"rc.xml",NULL);
    gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CONFIG,"/",TRUE);
    
    rcfile=g_build_filename(xdg_dir,XFFM_RC_FILE,fname,NULL);
    g_free(xdg_dir);
    g_free(fname);
   get_config(rcfile);
   g_free(rcfile);
}

G_MODULE_EXPORT
void get_local_xffm_config(){
    get_xffm_config();
}

static void  save_sb(gpointer key, gpointer value,gpointer user_data){
    xmlNodePtr root,node;
    gchar *v=g_strdup_printf("%d",(int)((long)value));
    root = (xmlNodePtr)user_data;
#ifdef DEBUG
    printf("DBG:saving hash value %s\n ",(char *)key);
#endif
    node = xmlNewTextChild(root, NULL,"smart_button", NULL);
    xmlSetProp(node, (const xmlChar *)"name",(const xmlChar *)key);
    xmlSetProp(node, (const xmlChar *)"value",(const xmlChar *)v);
    g_free(v);
}

G_MODULE_EXPORT
void xffm_write_xml(xmlNodePtr root)
{
    xmlNodePtr node;
    xmlNodePtr child;
    char value[32];
    int i;
    
    node = xmlNewTextChild(root, NULL, "CONFIG_VERSION",CONFIG_VERSION);
    
    for(i = 0; i<TREECOUNT; i++) {
	gchar *g=g_strdup_printf("treeview_%d",i);
	node = xmlNewTextChild(root, NULL, g, NULL);
	g_free(g);
	snprintf(value, 32, "%d", tree_details->icon_size);
	xmlSetProp(node, "icon_size", value);
	snprintf(value, 32, "%d", tree_details->treestuff[i].preferences);
	xmlSetProp(node, "preferences", value);
	snprintf(value, 32, "%d", tree_details->treestuff[i].name_size);
	xmlSetProp(node, "name_size", value);
    }
    
    node = xmlNewTextChild(root, NULL, "options", NULL);
    /*xmlSetProp(node, "theme", tree_details->theme);*/
 
    snprintf(value, 32, "%d", tree_details->preferences);
    xmlSetProp(node, "preferences", value);

    snprintf(value, 32, "%d", tree_details->recent_days);
    xmlSetProp(node, "recent_days", value);
    snprintf(value, 32, "%d", tree_details->frequent_count);
    xmlSetProp(node, "frequent_count", value);
    xmlSetProp(node, "sidebar", tree_details->sidebar);

    if (!tree_details->window){
	g_warning("!tree_details->window");
    } else {
	GtkWidget *hpaned= WIDGET("hpaned1");
#ifdef DEBUG
        printf("1 hpane is %d\n",tree_details->hpane);
#endif
	tree_details->geometryX = tree_details->window->allocation.width;
	tree_details->geometryY = tree_details->window->allocation.height;
	tree_details->hpane = gtk_paned_get_position((GtkPaned *)hpaned);

	child = xmlNewTextChild(root, NULL, "geometry", NULL);
	snprintf(value, 32, "%d", tree_details->geometryX);
	xmlSetProp(child, "width", value);

	snprintf(value, 32, "%d", tree_details->geometryY);
	xmlSetProp(child, "height", value);
	
#ifdef DEBUG
        printf("2 hpane is %d\n",tree_details->hpane);
#endif
	snprintf(value, 32, "%d",tree_details->hpane);
	xmlSetProp(child, "hpane", value);

    }   
    
    if (tree_details->smart_hash)
	g_hash_table_foreach(tree_details->smart_hash,save_sb,(gpointer)root);
}

G_MODULE_EXPORT
void write_config(char *rcfile)
{
    char *dir;
    xmlNodePtr root;
    if (!write_config_active) return;

    if(!g_file_test(rcfile, G_FILE_TEST_EXISTS))
    {
	dir = g_path_get_dirname(rcfile);

	if(!g_file_test(dir, G_FILE_TEST_IS_DIR))
	    mkdir(dir, S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH);

	g_free(dir);dir=NULL;
    }

    xmlconfig = xmlNewDoc("1.0");
    xmlconfig->children = xmlNewDocRawNode(xmlconfig, NULL, tree_details->argv[0], NULL);

    root = (xmlNodePtr) xmlconfig->children;
    xmlDocSetRootElement(xmlconfig, root);

    xffm_write_xml(root);

    xmlSaveFormatFile(rcfile, xmlconfig, 1);

    xmlFreeDoc(xmlconfig);
    xmlconfig = NULL;
}

G_MODULE_EXPORT
void write_xffm_config()
{
    gchar *rcfile;
    gchar *fname=g_strconcat(tree_details->argv[0],"rc.xml",NULL);
    gchar *xdg_dir=xfce_resource_save_location (XFCE_RESOURCE_CONFIG,"/",TRUE);
    
    rcfile=g_build_filename(xdg_dir,XFFM_RC_FILE,fname,NULL);
    g_free(xdg_dir);
    g_free(fname);
    write_config(rcfile);
    chmod(rcfile,0644);
    g_free(rcfile);
}
G_MODULE_EXPORT
void write_local_xffm_config()
{
    write_xffm_config();
}

/***   callbackS   ***/
