#!/usr/bin/env python

# Qt tutorial 7.

import sys
from qt import *


class LCDRange(QVBox):
    def __init__(self,parent=None,name=None):
        QVBox.__init__(self,parent,name)

        lcd = QLCDNumber(2,self,'lcd')
        self.slider = QSlider(Qt.Horizontal,self,'slider')
        self.slider.setRange(0,99)
        self.slider.setValue(0)
        self.connect(self.slider,SIGNAL('valueChanged(int)'),lcd,SLOT('display(int)'))
        self.connect(self.slider,SIGNAL('valueChanged(int)'),self,PYSIGNAL('valueChanged(int)'))

    def value(self):
        return self.slider.value()

    def setValue(self,value):
        self.slider.setValue(value)


class MyWidget(QVBox):
    def __init__(self,parent=None,name=None):
        QVBox.__init__(self,parent,name)

        quit = QPushButton("Quit",self,"quit")
        quit.setFont(QFont("Times",18,QFont.Bold))

        self.connect(quit,SIGNAL("clicked()"),qApp,SLOT("quit()"))

        grid = QGrid(4,self)

        self.lcdlist = []
        previous = None

        for r in range(4):
            for c in range(4):
                lr = LCDRange(grid)

                if previous is not None:
                    self.connect(lr,PYSIGNAL("valueChanged(int)"),previous.setValue)

                previous = lr
                self.lcdlist.append(lr)


a = QApplication(sys.argv)

w = MyWidget()
a.setMainWidget(w)
w.show()
a.exec_loop()
