//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QRect;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import org.kde.qt.QObject;
import org.kde.qt.QObject;

/**

 The class KWinModule provides information about the state of the
 window manager as required by windowmanager modules. It informs a
 module about all currently managed windows and changes to them (via
 Qt signals).
 KWinModule uses NETRootInfo internally. Modules written with this
 class will work fine under any window manager that implements the
 NET_WM protocol.
 There are no methods to manipulate windows. Those are defined in
 the classes KWin, NETWinInfo and NETRootInfo.
 See {@link KWinModuleSignals} for signals emitted by KWinModule
		@author Matthias Ettrich (ettrich@kde.org)

		@version  kwinmodule.h,v 1.27 2004/01/22 12:20:36 raabe
 
		@short Base class for KDE Window Manager modules.

*/
public class KWinModule extends QObject  {
	protected KWinModule(Class dummy){super((Class) null);}
	public static final int INFO_DESKTOP = 1;
	public static final int INFO_WINDOWS = 2;
	public static final int INFO_ALL = 32767;

	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Creates a KWinModule object and connects to the window
		 manager.
			@param parent the parent for the QObject
			@param what The information you are interested in:
		   INFO_DESKTOP:  currentDesktop, 
		                  numberOfDesktops, 
		                  desktopName, 
		                  currentDesktopChanged, 
		                  numberOfDesktopsChanged, 
		                  desktopNameChanged,
		                  activeWindow,
		                  activeWindowChanged,
		                  workArea(int desktop),
		                  workAreaChanged
			   INFO_WINDOWS:  windows,
		                  windowAdded,
		                  windowRemoved,
		                  stackingOrder,
		                  systemTrayWindows,
		                  systemTrayWindowAdded,
		                  systemTrayWindowRemoved,
		                  windowChanged,
		                  strutChanged,
		                  workArea(const QValueList<WId> &excludes, int desktop)
				@short    Creates a KWinModule object and connects to the window  manager.
	*/
	public KWinModule(QObject parent, int what) {
		super((Class) null);
		newKWinModule(parent,what);
	}
	private native void newKWinModule(QObject parent, int what);
	/**	
		 Creates a KWinModule object and connects to the window
		 manager.
			@param parent the parent for the QObject
				@short    Creates a KWinModule object and connects to the window  manager.
	*/
	public KWinModule(QObject parent) {
		super((Class) null);
		newKWinModule(parent);
	}
	private native void newKWinModule(QObject parent);
	public KWinModule() {
		super((Class) null);
		newKWinModule();
	}
	private native void newKWinModule();
	/**	
		 Returns the list of all toplevel windows currently managed by the
		 window manager in the order of creation. Please do not rely on
		 indexes of this list: Whenever you enter Qt's event loop in your
		 application, it may happen that entries are removed or added.
		 Your module should perhaps work on a copy of this list and verify a
		 window with hasWId() before any operations.
			 Iteration over this list can be done easily with
		 <pre>
		  QValueList<WId>.ConstIterator it;
		  for ( it = module.windows().begin();
		        it != modules.windows().end(); ++it ) {
		     ... do something here,  (it) is the current WId.
		       }
		 </pre>
				@return the list of all toplevel windows
     
		@short    Returns the list of all toplevel windows currently managed by the  window manager in the order of creation.
	*/
	// const QValueList<WId>& windows(); >>>> NOT CONVERTED
	/**	
		 Returns the list of all toplevel windows currently managed by the
		 window manager in the current stacking order (from lower to
		 higher). May be useful for pagers.
				@return the list of all toplevel windows in stacking order
     
		@short    Returns the list of all toplevel windows currently managed by the  window manager in the current stacking order (from lower to  higher).
	*/
	// const QValueList<WId>& stackingOrder(); >>>> NOT CONVERTED
	/**	
		 Test to see if <code>id</code> still managed at present.
			@param id the window id to test
				@return true if the window id is still managed

		@short    Test to see if <code>id</code> still managed at present.
	*/
	public native boolean hasWId(long id);
	/**	
		 Returns a list of the system tray windows.
				@return a list of all system tray windows

		@short    Returns a list of the system tray windows.
	*/
	// const QValueList<WId>& systemTrayWindows(); >>>> NOT CONVERTED
	/**	
		 Returns the current desktop.
				@return the current virtual desktop

		@short    Returns the current virtual desktop.
	*/
	public native int currentDesktop();
	/**	
		 Returns the number of desktops.
				@return the number of virtual desktops

		@short    Returns the number of virtual desktops.
	*/
	public native int numberOfDesktops();
	/**	
		 Returns the currently active window, or 0 if no window is active.
				@return the window id of the active window, or 0 if no window is 
  active

		@short    Returns the currently active window, or 0 if no window is active.
	*/
	public native long activeWindow();
	/**	
		 Returns the workarea for the specified desktop, or the current
		 work area if no desktop has been specified.
			@param desktop the number of the desktop to check, -1 for the
		        current desktop
				@return the size and position of the desktop

		@short    Returns the workarea for the specified desktop, or the current  work area if no desktop has been specified.
	*/
	public native QRect workArea(int desktop);
	public native QRect workArea();
	/**	
		 Returns the workarea for the specified desktop, or the current
		 work area if no desktop has been specified. Excludes struts of
		 clients in the exclude List.
			@param excludes the list of clients whose struts will be excluded
			@param desktop the number of the desktop to check, -1 for the
		        current desktop
				@return the size and position of the desktop

		@short    Returns the workarea for the specified desktop, or the current  work area if no desktop has been specified.
	*/
	// QRect workArea(const QValueList<WId>& arg1,int arg2); >>>> NOT CONVERTED
	// QRect workArea(const QValueList<WId>& arg1); >>>> NOT CONVERTED
	/**	
		 Returns the name of the specified desktop.
			@param desktop the number of the desktop
				@return the name of the desktop

		@short    Returns the name of the specified desktop.
	*/
	public native String desktopName(int desktop);
	/**	
		 Sets the name of the specified desktop.
			@param desktop the number of the desktop
			@param name the new name for the desktop
				@short    Sets the name of the specified desktop.
	*/
	public native void setDesktopName(int desktop, String name);
	/**	
		 Informs kwin via dcop to not manage a window with the
		 specified <code>title.</code>
			 Useful for swallowing legacy applications, for example java
		 applets.
			@param title the title of the window
		     		@short    Informs kwin via dcop to not manage a window with the  specified <code>title.</code>
	*/
	public native void doNotManage(String title);
	protected native void connectNotify(String signal);
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
