/* GnomeICU
 * Copyright (C) 1998-2003 Jeremy Wise
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * Manage GnomeICU contact list with gtktreeview/treemodel/liststore
 */


#ifndef __SHOWLIST_H__
#define __SHOWLIST_H__

#include "common.h"

enum {
  UPDATE_ONLINE  = 1<<0,
  UPDATE_OFFLINE = 1<<1,
  UPDATE_NOTLIST = 1<<2,
  UPDATE_RECONSTRUCT = 1<<3
};

void gnomeicu_tree_create (void);
void gnomeicu_tree_user_online (Contact_Member *contact);
void gnomeicu_tree_user_offline (Contact_Member *contact);
void gnomeicu_tree_user_remove (Contact_Member *contact);
void gnomeicu_tree_user_add (Contact_Member *contact);
void gnomeicu_tree_set_contact_icon (Contact_Member *contact, GdkPixbuf *pixbuf);
gint gnomeicu_tree_total_contacts (void);
gint gnomeicu_tree_online_contacts (void);
void gnomeicu_tree_group_add (const GroupInfo *ginfo);
void gnomeicu_tree_group_rename (const GroupInfo *ginfo);
void gnomeicu_tree_group_remove (const GroupInfo *ginfo);
void gnomeicu_tree_refresh_visuals (void);
void gnomeicu_tree_update_headers (void);
void gnomeicu_tree_set_status (Contact_Member *contact);

#endif /* __SHOWLIST_H__ */
