/*
 * Decompiled with CFR 0.152.
 */
package java.text;

import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.MessageFormatElement;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Date;
import java.util.Locale;
import java.util.Vector;

public class MessageFormat
extends Format {
    private static final long serialVersionUID = 6479157306784022952L;
    private String pattern;
    private Locale locale;
    private MessageFormatElement[] elements;
    private String leader;

    private static final int scanString(String pat, int index, StringBuffer buffer) {
        int max = pat.length();
        buffer.setLength(0);
        while (index < max) {
            char c = pat.charAt(index);
            if (c == '\'' && index + 2 < max && pat.charAt(index + 2) == '\'') {
                buffer.append(pat.charAt(index + 1));
                index += 2;
            } else if (c == '\'' && index + 1 < max && pat.charAt(index + 1) == '\'') {
                buffer.append(c);
                ++index;
            } else {
                if (c == '{') break;
                if (c == '}') {
                    throw new IllegalArgumentException("Found '}' without '{'");
                }
                buffer.append(c);
            }
            ++index;
        }
        return index;
    }

    private static final int scanFormatElement(String pat, int index, StringBuffer buffer, char term) {
        int max = pat.length();
        buffer.setLength(0);
        int brace_depth = 1;
        while (index < max) {
            char c = pat.charAt(index);
            if (c == '\'' && index + 2 < max && pat.charAt(index + 2) == '\'') {
                buffer.append(c);
                buffer.append(pat.charAt(index + 1));
                buffer.append(c);
                index += 2;
            } else if (c == '\'' && index + 1 < max && pat.charAt(index + 1) == '\'') {
                buffer.append(c);
                ++index;
            } else if (c == '{') {
                buffer.append(c);
                ++brace_depth;
            } else if (c == '}') {
                if (--brace_depth == 0) break;
                buffer.append(c);
            } else {
                if (c == term) break;
                buffer.append(c);
            }
            ++index;
        }
        return index;
    }

    private static final int scanFormat(String pat, int index, StringBuffer buffer, Vector elts, Locale locale) {
        MessageFormatElement mfe = new MessageFormatElement();
        elts.addElement(mfe);
        int max = pat.length();
        ++index;
        index = MessageFormat.scanFormatElement(pat, index, buffer, ',');
        try {
            mfe.argNumber = Integer.parseInt(buffer.toString());
        }
        catch (NumberFormatException nfx) {
            throw new IllegalArgumentException("Failed to parse integer string");
        }
        if (index < max && pat.charAt(index) == ',') {
            index = MessageFormat.scanFormatElement(pat, index + 1, buffer, ',');
            mfe.type = buffer.toString();
            if (index < max && pat.charAt(index) == ',') {
                index = MessageFormat.scanFormatElement(pat, index + 1, buffer, '}');
                mfe.style = buffer.toString();
            }
        }
        if (index >= max || pat.charAt(index) != '}') {
            throw new IllegalArgumentException("Missing '}' at end of message format");
        }
        ++index;
        index = MessageFormat.scanString(pat, index, buffer);
        mfe.trailer = buffer.toString();
        mfe.setLocale(locale);
        return index;
    }

    public void applyPattern(String newPattern) {
        this.pattern = newPattern;
        StringBuffer tempBuffer = new StringBuffer();
        int index = MessageFormat.scanString(newPattern, 0, tempBuffer);
        this.leader = tempBuffer.toString();
        Vector elts = new Vector();
        while (index < newPattern.length()) {
            index = MessageFormat.scanFormat(newPattern, index, tempBuffer, elts, this.locale);
        }
        this.elements = new MessageFormatElement[elts.size()];
        elts.copyInto(this.elements);
    }

    public Object clone() {
        MessageFormat c = (MessageFormat)super.clone();
        c.elements = (MessageFormatElement[])this.elements.clone();
        return c;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof MessageFormat)) {
            return false;
        }
        MessageFormat mf = (MessageFormat)obj;
        return this.pattern.equals(mf.pattern) && this.locale.equals(mf.locale);
    }

    public static String format(String pattern, Object[] arguments) {
        MessageFormat mf = new MessageFormat(pattern);
        StringBuffer sb = new StringBuffer();
        FieldPosition fp = new FieldPosition(0);
        return mf.format(arguments, sb, fp).toString();
    }

    public final StringBuffer format(Object[] arguments, StringBuffer appendBuf, FieldPosition ignore) {
        appendBuf.append(this.leader);
        for (int i = 0; i < this.elements.length; ++i) {
            if (this.elements[i].argNumber >= arguments.length) {
                throw new IllegalArgumentException("Not enough arguments given");
            }
            Object thisArg = arguments[this.elements[i].argNumber];
            Format formatter = null;
            if (this.elements[i].setFormat != null) {
                formatter = this.elements[i].setFormat;
            } else if (this.elements[i].format != null) {
                if (this.elements[i].formatClass != null && !this.elements[i].formatClass.isInstance(thisArg)) {
                    throw new IllegalArgumentException("Wrong format class");
                }
                formatter = this.elements[i].format;
            } else if (thisArg instanceof Number) {
                formatter = NumberFormat.getInstance(this.locale);
            } else if (thisArg instanceof Date) {
                formatter = DateFormat.getTimeInstance(2, this.locale);
            } else {
                appendBuf.append(thisArg);
            }
            if (formatter != null) {
                if (formatter instanceof ChoiceFormat) {
                    StringBuffer buf = new StringBuffer();
                    formatter.format(thisArg, buf, ignore);
                    MessageFormat mf = new MessageFormat();
                    mf.setLocale(this.locale);
                    mf.applyPattern(buf.toString());
                    mf.format(arguments, appendBuf, ignore);
                } else {
                    formatter.format(thisArg, appendBuf, ignore);
                }
            }
            appendBuf.append(this.elements[i].trailer);
        }
        return appendBuf;
    }

    public final StringBuffer format(Object singleArg, StringBuffer appendBuf, FieldPosition ignore) {
        Object[] args = singleArg instanceof Object[] ? (Object[])singleArg : new Object[]{singleArg};
        return this.format(args, appendBuf, ignore);
    }

    public Format[] getFormats() {
        Format[] f = new Format[this.elements.length];
        for (int i = this.elements.length - 1; i >= 0; --i) {
            f[i] = this.elements[i].setFormat;
        }
        return f;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public int hashCode() {
        return this.pattern.hashCode() + this.locale.hashCode();
    }

    private MessageFormat() {
    }

    public MessageFormat(String pattern) {
        this(pattern, Locale.getDefault());
    }

    public MessageFormat(String pattern, Locale locale) {
        this.locale = locale;
        this.applyPattern(pattern);
    }

    public Object[] parse(String sourceStr, ParsePosition pos) {
        int index = pos.getIndex();
        if (!sourceStr.startsWith(this.leader, index)) {
            pos.setErrorIndex(index);
            return null;
        }
        index += this.leader.length();
        Vector results = new Vector(this.elements.length, 1);
        for (int i = 0; i < this.elements.length; ++i) {
            Format formatter = null;
            if (this.elements[i].setFormat != null) {
                formatter = this.elements[i].setFormat;
            } else if (this.elements[i].format != null) {
                formatter = this.elements[i].format;
            }
            Object[] value = null;
            if (formatter instanceof ChoiceFormat) {
                int j;
                ChoiceFormat cf = (ChoiceFormat)formatter;
                String[] formats = (String[])cf.getFormats();
                double[] limits = cf.getLimits();
                MessageFormat subfmt = new MessageFormat();
                subfmt.setLocale(this.locale);
                ParsePosition subpos = new ParsePosition(index);
                for (j = 0; value == null && j < limits.length; ++j) {
                    subfmt.applyPattern(formats[j]);
                    subpos.setIndex(index);
                    value = subfmt.parse(sourceStr, subpos);
                }
                if (value != null) {
                    index = subpos.getIndex();
                    value = new Double(limits[j]);
                }
            } else if (formatter != null) {
                pos.setIndex(index);
                value = formatter.parseObject(sourceStr, pos);
                if (value != null) {
                    index = pos.getIndex();
                }
            } else {
                int next_index = sourceStr.indexOf(this.elements[i].trailer, index);
                if (next_index == -1) {
                    pos.setErrorIndex(index);
                    return null;
                }
                value = sourceStr.substring(index, next_index);
                index = next_index;
            }
            if (value == null || !sourceStr.startsWith(this.elements[i].trailer, index)) {
                pos.setErrorIndex(index);
                return null;
            }
            if (this.elements[i].argNumber >= results.size()) {
                results.setSize(this.elements[i].argNumber + 1);
            }
            results.setElementAt(value, this.elements[i].argNumber);
            index += this.elements[i].trailer.length();
        }
        Object[] r = new Object[results.size()];
        results.copyInto(r);
        return r;
    }

    public Object[] parse(String sourceStr) throws ParseException {
        ParsePosition pp = new ParsePosition(0);
        Object[] r = this.parse(sourceStr, pp);
        if (r == null) {
            throw new ParseException("couldn't parse string", pp.getErrorIndex());
        }
        return r;
    }

    public Object parseObject(String sourceStr, ParsePosition pos) {
        return this.parse(sourceStr, pos);
    }

    public void setFormat(int variableNum, Format newFormat) {
        this.elements[variableNum].setFormat = newFormat;
    }

    public void setFormats(Format[] newFormats) {
        if (newFormats.length < this.elements.length) {
            throw new IllegalArgumentException("Not enough format objects");
        }
        int len = Math.min(newFormats.length, this.elements.length);
        for (int i = 0; i < len; ++i) {
            this.elements[i].setFormat = newFormats[i];
        }
    }

    public void setLocale(Locale loc) {
        this.locale = loc;
        if (this.elements != null) {
            for (int i = 0; i < this.elements.length; ++i) {
                this.elements[i].setLocale(loc);
            }
        }
    }

    public String toPattern() {
        return this.pattern;
    }
}

