/*
 * Decompiled with CFR 0.152.
 */
package java.beans;

import gnu.java.lang.ClassHelper;
import java.awt.Image;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.Introspector;
import java.beans.MethodDescriptor;
import java.beans.PropertyDescriptor;
import java.util.Hashtable;
import java.util.Vector;

class ExplicitInfo {
    BeanDescriptor explicitBeanDescriptor;
    BeanInfo[] explicitBeanInfo;
    PropertyDescriptor[] explicitPropertyDescriptors;
    EventSetDescriptor[] explicitEventSetDescriptors;
    MethodDescriptor[] explicitMethodDescriptors;
    int defaultProperty;
    int defaultEvent;
    Image[] im;
    Class propertyStopClass;
    Class eventStopClass;
    Class methodStopClass;
    static Hashtable explicitBeanInfos = new Hashtable();
    static Vector emptyBeanInfos = new Vector();

    private /* synthetic */ void finit$() {
        this.im = new Image[4];
    }

    ExplicitInfo(Class beanClass, Class stopClass) {
        this.finit$();
        while (beanClass != null && !beanClass.equals(stopClass)) {
            BeanInfo explicit = ExplicitInfo.findExplicitBeanInfo(beanClass);
            if (explicit != null) {
                if (this.explicitBeanDescriptor == null) {
                    this.explicitBeanDescriptor = explicit.getBeanDescriptor();
                }
                if (this.explicitBeanInfo == null) {
                    this.explicitBeanInfo = explicit.getAdditionalBeanInfo();
                }
                if (this.explicitPropertyDescriptors == null && explicit.getPropertyDescriptors() != null) {
                    this.explicitPropertyDescriptors = explicit.getPropertyDescriptors();
                    this.defaultProperty = explicit.getDefaultPropertyIndex();
                    this.propertyStopClass = beanClass;
                }
                if (this.explicitEventSetDescriptors == null && explicit.getEventSetDescriptors() != null) {
                    this.explicitEventSetDescriptors = explicit.getEventSetDescriptors();
                    this.defaultEvent = explicit.getDefaultEventIndex();
                    this.eventStopClass = beanClass;
                }
                if (this.explicitMethodDescriptors == null && explicit.getMethodDescriptors() != null) {
                    this.explicitMethodDescriptors = explicit.getMethodDescriptors();
                    this.methodStopClass = beanClass;
                }
                if (this.im[0] == null && this.im[1] == null && this.im[2] == null && this.im[3] == null) {
                    this.im[0] = explicit.getIcon(0);
                    this.im[1] = explicit.getIcon(1);
                    this.im[2] = explicit.getIcon(2);
                    this.im[3] = explicit.getIcon(3);
                }
            }
            beanClass = beanClass.getSuperclass();
        }
        if (this.propertyStopClass == null) {
            this.propertyStopClass = stopClass;
        }
        if (this.eventStopClass == null) {
            this.eventStopClass = stopClass;
        }
        if (this.methodStopClass == null) {
            this.methodStopClass = stopClass;
        }
    }

    static BeanInfo findExplicitBeanInfo(Class beanClass) {
        BeanInfo retval = (BeanInfo)explicitBeanInfos.get(beanClass);
        if (retval != null) {
            return retval;
        }
        if (emptyBeanInfos.indexOf(beanClass) != -1) {
            return null;
        }
        retval = ExplicitInfo.reallyFindExplicitBeanInfo(beanClass);
        if (retval != null) {
            explicitBeanInfos.put(beanClass, retval);
        } else {
            emptyBeanInfos.addElement(beanClass);
        }
        return retval;
    }

    static BeanInfo reallyFindExplicitBeanInfo(Class beanClass) {
        ClassLoader beanClassLoader = beanClass.getClassLoader();
        BeanInfo beanInfo = ExplicitInfo.getBeanInfo(beanClassLoader, beanClass.getName() + "BeanInfo");
        if (beanInfo == null) {
            String newName = ClassHelper.getTruncatedClassName(beanClass) + "BeanInfo";
            for (int i = 0; i < Introspector.beanInfoSearchPath.length; ++i) {
                beanInfo = Introspector.beanInfoSearchPath[i].equals("") ? ExplicitInfo.getBeanInfo(beanClassLoader, newName) : ExplicitInfo.getBeanInfo(beanClassLoader, Introspector.beanInfoSearchPath[i] + "." + newName);
                if (beanInfo == null) continue;
                return beanInfo;
            }
        }
        return beanInfo;
    }

    private static BeanInfo getBeanInfo(ClassLoader cl, String infoName) {
        try {
            return (BeanInfo)Class.forName(infoName, true, cl).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        catch (IllegalAccessException iae) {
            return null;
        }
        catch (InstantiationException ie) {
            return null;
        }
    }
}

