/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2002 by Luis Carvalho
    email                : lpassos@mail.telepac.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/


#include "pmlibrarybrowser.h"

#include <qlayout.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qsplitter.h>

#include <kurl.h>
#include <klocale.h>
#include <kconfig.h>
#include <kmessagebox.h>
#include <kdialog.h>
#include <kdiroperator.h>
#include <kiconloader.h>

#include <stdlib.h>

#include "pmlineedits.h"
#include "pmdialogeditbase.h"
#include "pmlibrarymanager.h"
#include "pmlibraryhandle.h"
#include "pmlibraryobject.h"
#include "pmlibraryiconview.h"
#include "pmlibraryobjectpreview.h"
//#include "pmobjectdrag.h"

QSize PMLibraryBrowser::s_size = QSize( 600, 400 );
PMLibraryBrowser* PMLibraryBrowser::s_pLibraryBrowser = NULL;

// ************** PMLibraryBrowser **************************

PMLibraryBrowser::PMLibraryBrowser( QWidget* parent, const char* name )
      : QWidget( parent, name )
{
   setCaption( i18n( "Library Objects" ) );
   resize( s_size );

   QVBoxLayout* vl = new QVBoxLayout( this, KDialog::spacingHint( ) );

   QHBoxLayout* hl = new QHBoxLayout( vl );
   m_pNewObjectButton = new QPushButton( this );
   m_pNewObjectButton->setPixmap( SmallIcon( "filenew" ) );
   m_pEditObjectButton = new QPushButton( this );
   m_pEditObjectButton->setPixmap( SmallIcon( "fileopen" ) );
   m_pDeleteObjectButton = new QPushButton( this );
   m_pDeleteObjectButton->setPixmap( SmallIcon( "edit_remove" ) );

   QLabel* lbl = new QLabel( i18n( "Library: " ), this );
   m_pLibraryComboBox = new QComboBox( this );
   m_pLibraryComboBox->insertStringList( PMLibraryManager::theManager( )->availableLibraries( ) );
   m_pLibraryComboBox->setDuplicatesEnabled( false );
   m_pLibraryComboBox->setCurrentItem( 0 );
   hl->addWidget( m_pNewObjectButton );
   hl->addWidget( m_pEditObjectButton );
   hl->addWidget( m_pDeleteObjectButton );
   hl->addWidget( lbl );
   hl->addWidget( m_pLibraryComboBox );
   hl->addStretch( 1 );

   QSplitter *splitv = new QSplitter( this );
   m_pLibraryIconView = new PMLibraryIconView( splitv );
   m_pLibraryIconView->setMinimumSize( PMDialogEditBase::previewSize( ), PMDialogEditBase::previewSize( ) );
   m_pLibraryObjectPreview = new PMLibraryObjectPreview( splitv );
   vl->addWidget( splitv, 99 );

   // Connect all objects
   connect( m_pNewObjectButton, SIGNAL( clicked( ) ), SLOT( slotNewClicked( ) ) );
   connect( m_pEditObjectButton, SIGNAL( clicked( ) ), SLOT( slotEditClicked( ) ) );
   connect( m_pLibraryComboBox, SIGNAL( highlighted( const QString& ) ), 
                                SLOT( slotPathSelected( const QString& ) ) );
   connect( m_pLibraryIconView, SIGNAL( selectionChanged( QIconViewItem* ) ),
                                SLOT( slotSelectionChanged( QIconViewItem* ) ) );

   // Set the selected library
   slotPathSelected( m_pLibraryComboBox->currentText( ) );
}

void PMLibraryBrowser::setLibraryPaths( const QStringList& l )
{
   if( s_pLibraryBrowser )
   {
      int item;
      QString url = s_pLibraryBrowser->m_pLibraryComboBox->currentText( );

      s_pLibraryBrowser->m_pLibraryComboBox->clear( );
      s_pLibraryBrowser->m_pLibraryComboBox->insertStringList( l );
      item = l.findIndex( url );
      s_pLibraryBrowser->m_pLibraryComboBox->setCurrentItem( item );
      if( url != s_pLibraryBrowser->m_pLibraryComboBox->currentText( ) )
         s_pLibraryBrowser->slotPathSelected( s_pLibraryBrowser->m_pLibraryComboBox->currentText( ) );
   }
}

void PMLibraryBrowser::saveConfig( KConfig* cfg )
{
   cfg->setGroup( "Appearance" );
   cfg->writeEntry( "LibraryObjectBrowserSize", s_size );
}

void PMLibraryBrowser::restoreConfig( KConfig* cfg )
{
   cfg->setGroup( "Appearance" );

   QSize defaultSize( 300, 200 );
   s_size = cfg->readSizeEntry( "LibraryObjectBrowserSize", &defaultSize );
}

void PMLibraryBrowser::resizeEvent( QResizeEvent* ev )
{
   s_size = ev->size( );
}

void PMLibraryBrowser::showBrowser( )
{
   if( !s_pLibraryBrowser )
      s_pLibraryBrowser = new PMLibraryBrowser( NULL );

   s_pLibraryBrowser->show( );
}

void PMLibraryBrowser::slotPathSelected( const QString& str )
{
   PMLibraryHandle* h = PMLibraryManager::theManager( )->getLibraryHandle( str );
   m_pLibraryIconView->setLibraryBasePath( h->path( ) );
   m_pCurrentLibrary = h;
}

void PMLibraryBrowser::slotSelectionChanged( QIconViewItem* item )
{
   if( m_pLibraryObjectPreview->showPreview( static_cast<PMLibraryIconViewItem*>(item)->path( ) ) )
      m_pLibraryIconView->refresh( );
}

void PMLibraryBrowser::slotEditClicked( )
{
   m_pLibraryObjectPreview->allowEdit( true );
}

void PMLibraryBrowser::slotNewClicked( )
{
   if( m_pCurrentLibrary->createNewObject( ) == PMLibraryHandle::Ok )
      m_pLibraryIconView->refresh( );
}

#include "pmlibrarybrowser.moc"
