/*
    KDE Icon Editor - a small graphics drawing program for the KDE
    Copyright (C) 1998  Thomas Tanghus (tanghus@kde.org)

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
    Boston, MA 02111-1307, USA.
*/

#include <kconfig.h>
#include <kdebug.h>
#include <kapplication.h>

#include "properties.h"

KIconEditProperties* KIconEditProperties::m_self = 0;

KIconEditProperties* KIconEditProperties::self()
{
    if (!m_self)
        m_self = new KIconEditProperties();
    return m_self;
}

KIconEditProperties::KIconEditProperties() : QObject()
{
    KConfig *config = kapp->config();

    config->setGroup( "Appearance" );

    m_bgMode = (QWidget::BackgroundMode)config->readNumEntry( "BackgroundMode", QWidget::FixedPixmap);
    m_bgColor = config->readColorEntry( "BackgroundColor", &gray);
    m_bgPixmap = config->readPathEntry("BackgroundPixmap");

    config->setGroup( "Grid" );
    m_pasteTransparent = config->readBoolEntry( "PasteTransparent", false );
    m_showGrid = config->readBoolEntry( "ShowGrid", true );
    m_gridScale = config->readNumEntry( "GridScaling", 10 );
    m_showRulers = config->readBoolEntry( "ShowRulers", true );
}

KIconEditProperties::~KIconEditProperties()
{
  kdDebug(4640) << "KIconEditProperties: Deleting properties" << endl;
  m_self = 0;
}

void KIconEditProperties::save()
{
    KConfig *config = kapp->config();

    config->setGroup( "Appearance" );

    config->writeEntry("BackgroundMode", m_bgMode );
    config->writeEntry("BackgroundColor", m_bgColor );
    config->writePathEntry("BackgroundPixmap", m_bgPixmap );

    config->setGroup( "Grid" );
    config->writeEntry("PasteTransparent", m_pasteTransparent );
    config->writeEntry("ShowGrid", m_showGrid );
    config->writeEntry("GridScaling", m_gridScale );
    config->writeEntry("ShowRulers", m_showRulers );
    config->sync();
}

