<?xml version="1.0" encoding="iso-8859-1"?>
<!--
  ** Author: Marco Ladermann <marco.ladermann@gmx.de>
  ** Date:   Tue Jan 28 17:19:16 CET 2003 @721 /Internet Time/
  ** 
  ** This software is free software. It is released under the terms of the
  ** GNU Lesser General Public Licence (LGPL)
  ** see http://www.gnu.org/copyleft/lesser.html
  **
  ** These stylesheets are distributed in the hope that they will be useful,
  ** but WITHOUT ANY WARRANTY; without even the implied warranty of
  ** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
  -->
<xsl:stylesheet 
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:exsl="http://exslt.org/common"
    xmlns:date="http://exslt.org/dates-and-times"
    xmlns:redirect="http://xml.apache.org/xalan/redirect"
    xmlns:saxon="http://icl.com/saxon"
    xmlns:kde="http://kde.org/functions"
    xmlns:java="http://kde.org/java"
    extension-element-prefixes="exsl redirect saxon"
 >
    <!--
      ** This is the toplevel stylesheet of the language dependend parts
      -->

    <xsl:import href="definitions.xsl"/>
    <xsl:import href="properties.xsl"/>
    <xsl:import href="methods.xsl"/>
    <xsl:include href="../common/util.xsl"/>
    <xsl:include href="util.xsl"/>

    <xsl:variable name="mainClass" select="/UI/class"/>

    <!-- read XML file with Information about the Qt classes for Java -->
    <xsl:variable name="qtJavaClassesXml" select="'JavaClasses.xml'"/>
    <!--<xsl:variable name="qtJavaClasses" select="document($qtJavaClassesXml)"/> -->
    
    <xsl:variable name="nlIndent8" select="concat($newline, '        ')"/>

    <!-- 
      ** This template starts the whole process.
      ** 
      -->
    <xsl:template match="/">
        <xsl:variable name="file">
            <xsl:choose>
                <xsl:when test="$package =  ''">
                    <xsl:value-of select="concat($mainClass, '.java')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat(translate($package, '.', '/'), '/', $mainClass, '.java')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="element-available('exsl:document')">
                <xsl:message>Using output file <xsl:value-of select="$file"/> with Exslt extension</xsl:message>
                <exsl:document href="{$file}" method="text">
                    <xsl:apply-templates mode="main" select="/"/>
                </exsl:document>
            </xsl:when>
            <xsl:when test="element-available('saxon:output')">
                <xsl:message>Using output file <xsl:value-of select="$file"/> with Saxon extension</xsl:message>
                <saxon:output href="{$file}" method="text">
                    <xsl:apply-templates mode="main" select="/"/>
                </saxon:output>
            </xsl:when>
            <xsl:when test="element-available('redirect:write')">
                <xsl:message>Using output file <xsl:value-of select="$file"/> with Xalan extension</xsl:message>
                <redirect:write file="$file" method="text">
                    <xsl:apply-templates mode="main" select="/"/>
                </redirect:write>
            </xsl:when>
            <xsl:otherwise>
                <xsl:message>Using stdout</xsl:message>
                <xsl:apply-templates mode="main" select="/"/>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>
    
    <!-- 
      ** Put the file header
      ** @param comment from ui file
      ** @param author name of author from ui file
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putFileHeader">
        <xsl:param name="comment"/>
        <xsl:param name="author"/>
        <xsl:param name="data"/>
        <xsl:text>/*
 * </xsl:text><xsl:value-of select="$mainClass"/><xsl:text>.java
 *
 * This class is generated from a UI description generated by
 * the QtDesigner with XSLT.
 *
 * DO NOT EDIT! File will be overidden
 *
 * Author: </xsl:text>
        <xsl:value-of select="$author"/>
        <xsl:text>
 * Date:   </xsl:text><xsl:value-of select="date:date()"/>
        <xsl:text>
 * Comment: </xsl:text>
<xsl:value-of select="$comment"/>
        <xsl:text>
 */
</xsl:text>
    </xsl:template>

    <!--
      ** Put the class preamble. Use this to generate package information, imports etc.
      ** @param classes node-set with sorted list of all classes needed
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putClassPreamble">
        <xsl:param name="classes"/>
        <xsl:param name="data"/>
        <xsl:if test="not($package = '')">
            <xsl:value-of select="$newline"/>
            <xsl:text>package </xsl:text>
            <xsl:value-of select="$package"/>
            <xsl:text>;</xsl:text>
        </xsl:if>
        
        <!-- import Qt specific classes -->
        <xsl:value-of select="$newline"/>
        <xsl:for-each select="$classes/class">
            <xsl:variable name="name" select="."/>
            <xsl:variable name="classInfo" select="document($qtJavaClassesXml)/Qt/class[name = $name]"/>
            <xsl:if test="not($classInfo)">
                <xsl:message terminate="yes">Can't find a description of class <xsl:value-of select="."/> in <xsl:value-of select="$qtJavaClassesXml"/></xsl:message>
            </xsl:if>
            <xsl:value-of select="$newline"/>
            <xsl:value-of select="concat('import ', $classInfo/package, '.', $classInfo/name, ';')"/>
        </xsl:for-each>
        
        <xsl:value-of select="$newline"/>
        
        <!-- import of java specific classes -->
        <xsl:if test="/UI/images">
            <xsl:message>Create imports to handle Images</xsl:message>
            <xsl:value-of select="'import java.io.ByteArrayInputStream;'"/>
            <xsl:value-of select="$newline"/>
            <xsl:value-of select="'import java.io.IOException;'"/>
            <xsl:value-of select="$newline"/>
            <xsl:value-of select="'import java.util.zip.InflaterInputStream;'"/>
            <xsl:value-of select="$newline"/>
        </xsl:if>
    </xsl:template>
    
    <!--
      ** Put the class header.
      ** @param extends the class that is extended by this
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putClassHeader">
        <xsl:param name="extends"/>
        <xsl:param name="data"/>

        <xsl:text>
/**
 * </xsl:text><xsl:value-of select="$mainClass"/> a user interface class using Qt<xsl:text>
 */
        </xsl:text>
        <xsl:value-of select="$newline"/>
        <xsl:text>public </xsl:text>
        <xsl:if test="$abstract and /UI/slots/slot">
            <xsl:text>abstract </xsl:text>
        </xsl:if>
        <xsl:text>class </xsl:text>
        <xsl:value-of select="$mainClass"/>
        <xsl:if test="$extends"> 
            <xsl:text> extends </xsl:text>
            <xsl:value-of select="$extends"/>
        </xsl:if>
        <xsl:text> {</xsl:text>
        <xsl:value-of select="$newline"/>
    </xsl:template>
    
    <!--
      ** Put the definition of user defined variables.
      ** Here we define some QPixmap instances for embedded images
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putVariables">
        <xsl:param name="data"/>
        <xsl:for-each select="/UI/images/image">
            <xsl:value-of select="$newline"/>
            <xsl:text>    protected QPixmap </xsl:text>
            <xsl:value-of select="@name"/>
            <xsl:choose>
                <xsl:when test="data/@format = 'XPM.GZ'">
                    <xsl:text> = uncompressPixmap( </xsl:text>
                    <xsl:value-of select="concat(data/@length, ', ')"/>
                </xsl:when>
                <xsl:when test="data/@format = 'PNG'">
                    <xsl:text> = new QPixmap( </xsl:text>
                </xsl:when>
            </xsl:choose>
            <xsl:text>new byte [] { </xsl:text>
            <xsl:call-template name="toBytes">
                <xsl:with-param name="hexstring" select="data"/>
            </xsl:call-template>
            <xsl:text> } ); </xsl:text>
        </xsl:for-each>
    </xsl:template>

    <!-- helper template -->
    <xsl:template name="toBytes">
        <xsl:param name="hexstring" select="''"/>
        <xsl:param name="count" select="0"/>
        <xsl:variable name="len" select="string-length($hexstring)"/>
        <xsl:if test="$count = 0">
            <xsl:value-of select="$nlIndent8"/>
        </xsl:if>
        <xsl:variable name="cnt">
            <xsl:choose>
                <xsl:when test="$count = 6">0</xsl:when>
                <xsl:otherwise><xsl:value-of select="$count + 1"/></xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="$len &gt; 2">
                <xsl:value-of select="concat('(byte)0x', substring($hexstring, 1, 2), ', ')"/>
                <xsl:call-template name="toBytes">
                    <xsl:with-param name="hexstring" select="substring($hexstring, 3)"/>
                    <xsl:with-param name="count" select="$cnt"/>
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="$len = 2">
                <xsl:value-of select="concat('(byte)0x', $hexstring)"/>
            </xsl:when>
        </xsl:choose>
    </xsl:template>    
    
    <!--
      ** Put the definition of instance variables
      ** @context property
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putInstanceVariable">
        <xsl:param name="class"/>
        <xsl:param name="name"/>
        <xsl:param name="data"/>
        <xsl:variable name="varname">
            <xsl:choose>
                <xsl:when test="$name">
                    <xsl:value-of select="$name"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="java:getNodeName(..)"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>
        <xsl:value-of select="$newline"/>
        <xsl:value-of select="concat('    protected ', $class, ' ', $varname, ' = null;')"/>
    </xsl:template>
    
    <!--
      ** Put the declaration of the constructors
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putConstructors">
        <xsl:param name="data"/>
        <xsl:variable name="modalParam">
            <xsl:if test="/UI/widget/@class != 'QMainWindow'">
                <xsl:text>, false</xsl:text>
            </xsl:if>
        </xsl:variable>
        <xsl:variable name="modalArg">
            <xsl:if test="/UI/widget/@class != 'QMainWindow'">
                <xsl:text>, boolean modal</xsl:text>
            </xsl:if>
        </xsl:variable>

    /**
     * Constructor for class <xsl:value-of select="$mainClass"/>
     */
    public <xsl:value-of select="$mainClass"/>() {
        this(null, "<xsl:value-of select="$mainClass"/>"<xsl:value-of select="$modalParam"/>, WType_TopLevel);
    }

    /**
     * Constructor for class <xsl:value-of select="$mainClass"/>
     * @param parent the parent widget of this class
     */
    public <xsl:value-of select="$mainClass"/>(QWidget parent) {
        this(parent, "<xsl:value-of select="$mainClass"/>"<xsl:value-of select="$modalParam"/>, WType_TopLevel);
    }

    /**
     * Constructor for class <xsl:value-of select="$mainClass"/>
     * @param parent the patent widget of this class
     * @param name the name of the widget
     */
    public <xsl:value-of select="$mainClass"/>(QWidget parent, String name) {
        this(parent, name<xsl:value-of select="$modalParam"/>, WType_TopLevel);
    }
<xsl:if test="$modalArg != ''">
    /**
     * Constructor for class <xsl:value-of select="$mainClass"/>
     * @param parent the patent widget of this class
     * @param name the name of the widget
     * @param modal modality of the widget
     */
    public <xsl:value-of select="$mainClass"/>(QWidget parent, String name, boolean modal) {
        this(parent, name, modal, WType_TopLevel);
    }
</xsl:if>
    /**
     * Constructor for class <xsl:value-of select="$mainClass"/>
     * @param parent the patent widget of this class
     * @param name the name of the widget
     * @param flags some "or"ed properties
     */
    public <xsl:value-of select="$mainClass"/>(QWidget parent, String name<xsl:value-of select="$modalArg"/>, int flags) {
        super(parent, name<xsl:value-of select="$modalParam"/>, flags);
<xsl:if test="/UI/widget/@class = 'QMainWindow'"> 
        statusBar();
</xsl:if>
        if (name == null) setName("<xsl:value-of select="$mainClass"/>");
        
        // setup widgets 
        <xsl:call-template name="createInstanceDefinitions"/>
        
        // setup actions
        <xsl:call-template name="createActionDefinitions"/>
        
        // setup toolbar
        <xsl:call-template name="createToolbarDefinitions"/>
        
        // setup menubar
        <xsl:call-template name="createMenubarDefinitions"/>
        
        resize(size().expandedTo(minimumSizeHint()));

        // signals and slots connections
        <xsl:call-template name="createConnectionDefinitions"/>
    }
    </xsl:template>

    <!--
      ** Put the definition of a slot
      ** @context slot
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putSlot">
        <xsl:param name="data"/>
        <xsl:variable name="access" select="kde:if(@access, @access, 'public')"/>
        <xsl:variable name="return" select="kde:if(@returnType, @returnType, 'void')"/>
        <xsl:variable name="sig" select="java:cpp-to-java-signature(.)"/>
        <xsl:variable name="method" select="concat($access, ' ',
                                                   kde:if($abstract, 'abstract ', ''),
                                                   $return , ' ',
                                                   $sig)"/>
        <xsl:if test="$access = 'private'">
            <xsl:message>Error in slot: <xsl:value-of select="$method"/></xsl:message>
            <xsl:message>A private method can't be overriden.</xsl:message>
        </xsl:if>
        <xsl:message>Generating slot "<xsl:value-of select="$method"/></xsl:message>
    /**
     * SLOT <xsl:value-of select="$method"/>
     */
    <xsl:choose>
        <xsl:when test="$abstract">
    <xsl:value-of select="$method"/>;
        </xsl:when>
        <xsl:otherwise>
    <xsl:value-of select="$method"/> {
        System.out.println("Warning: SLOT \"<xsl:value-of select="$method"/>\" must be overridden");
        <xsl:if test="not($return = 'void')">
        <xsl:choose>
            <xsl:when test="$return = 'byte' or $return = 'short' or $return = 'int' or $return = 'long'">
                <xsl:text>return </xsl:text><xsl:value-of select="concat('(',$return,')')"/><xsl:text>0;</xsl:text>
            </xsl:when>
            <xsl:when test="$return = 'char'">
                <xsl:text>return '\0'</xsl:text>
            </xsl:when>
            <xsl:when test="$return = 'float' or $return = 'double'">
                <xsl:text>return 0.0;</xsl:text>
            </xsl:when>
            <xsl:otherwise>return null;</xsl:otherwise>
        </xsl:choose>
        </xsl:if>
    }
    </xsl:otherwise>
    </xsl:choose>
    </xsl:template>

    <!--
      ** Put the definition of a signal
      ** @context slot
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putSignal">
        <xsl:param name="data"/>
        <xsl:variable name="sig" select="java:cpp-to-java-signature(.)"/>
    /** SIGNAL <xsl:value-of select="."/> */
    </xsl:template>
    
    <!--
      ** Put the class footer.
      ** Here it is nothing more, but a closing brace
      ** @param data opaque data for user purpose
      -->
    <xsl:template name="putClassFooter">
        <xsl:param name="data"/>
        <xsl:value-of select="$newline"/>
        <xsl:text>}</xsl:text>
        <xsl:value-of select="$newline"/>
    </xsl:template>

</xsl:stylesheet>

