/***************************************************************************
                            KXYSelector.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KXYSELECTOR_H
#define KXYSELECTOR_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <qtobjc/QWidget.h>

/**

 KXYSelector is the base class for other widgets which
 provides the ability to choose from a two-dimensional
 range of values. The currently chosen value is indicated
 by a cross. An example is the @ref KHSSelector which
 allows to choose from a range of colors, and which is
 used in KColorDialog.

 A custom drawing routine for the widget surface has
 to be provided by the subclass.
 
 @short 
 KXYSelector is the base class for other widgets which
 provides the ability to choose from a two-dimensional
 range of values.
*/
@interface KXYSelector : QWidget 

/** 
 Constructs a two-dimensional selector widget which
 has a value range of [0..100] in both directions.
   
*/
- initWithWidget: (QWidget *)parent name: (NSString *)name;
- init;

/** 
 Destructs the widget.
   
*/
- (void) dealloc;

/** 
 Sets the current values in horizontal and
 vertical direction.
   
*/
- setValues: (int)xPos yPos: (int)yPos;

/** 
 Sets the range of possible values.
   
*/
- setRange: (int)minX minY: (int)minY maxX: (int)maxX maxY: (int)maxY;

/** 

*/
- (int) xValue;

/** 

*/
- (int) yValue;

/** 

*/
- (QRect*) contentsRect;

/** 
 Override this function to draw the contents of the widget.
 The default implementation doesn nothing.

 Draw within -contentsRect only.
   
*/
- drawContents: (QPainter *)arg1;

/** 
 Override this function to draw the cursor which
 indicates the currently selected value pair.
   
*/
- drawCursor: (QPainter *)p xp: (int)xp yp: (int)yp;
@end

/** Override these methods in subclasses of KXYSelector to customise event handling behaviour */
@protocol KXYSelectorEventHandling
- keyPressEvent:(QKeyEvent*) arg1;
- keyReleaseEvent:(QKeyEvent*) arg1;
- focusOutEvent:(QFocusEvent*) arg1;
- childEvent:(QChildEvent*) arg1;
- dragMoveEvent:(QDragMoveEvent*) arg1;
- leaveEvent:(QEvent*) arg1;
- tabletEvent:(QTabletEvent*) arg1;
- showEvent:(QShowEvent*) arg1;
- contextMenuEvent:(QContextMenuEvent*) arg1;

/** 

   
*/
- mousePressEvent:(QMouseEvent*) e;
- imComposeEvent:(QIMEvent*) arg1;
- customEvent:(QCustomEvent*) arg1;
- mouseReleaseEvent:(QMouseEvent*) arg1;
- mouseDoubleClickEvent:(QMouseEvent*) arg1;
- dragLeaveEvent:(QDragLeaveEvent*) arg1;
- enterEvent:(QEvent*) arg1;
- focusInEvent:(QFocusEvent*) arg1;
- imEndEvent:(QIMEvent*) arg1;
- dropEvent:(QDropEvent*) arg1;
- dragEnterEvent:(QDragEnterEvent*) arg1;

/** 

   
*/
- mouseMoveEvent:(QMouseEvent*) e;
- moveEvent:(QMoveEvent*) arg1;
- wheelEvent:(QWheelEvent*) arg1;
- hideEvent:(QHideEvent*) arg1;
- imStartEvent:(QIMEvent*) arg1;
- closeEvent:(QCloseEvent*) arg1;

/** 

   
*/
- paintEvent:(QPaintEvent*) e;
- timerEvent:(QTimerEvent*) arg1;
- resizeEvent:(QResizeEvent*) arg1;
@end


#endif
