//Auto-generated by kalyptus. DO NOT EDIT.
package org.kde.koala;

import org.kde.qt.Qt;
import org.kde.qt.QColor;
import org.kde.qt.QRect;
import org.kde.qt.QMetaObject;
import org.kde.qt.QtSupport;
import org.kde.qt.QObject;
import org.kde.qt.QPopupMenu;
import org.kde.qt.QPixmap;
import org.kde.qt.QPoint;
import org.kde.qt.QSize;
import java.util.ArrayList;
import org.kde.qt.QEvent;
import org.kde.qt.QWidget;
import org.kde.qt.QResizeEvent;

/**

 It contains the child frame area (QMainWindow's central widget) and a child view taskbar
 for switching the MDI views. Most methods are functions for later overriding.
 Basically, this class provides functionality for docking/undocking view windows and
 manages the taskbar. Usually the programmer just need to know about this class and the child view class.
 Your program mainwidget should inherit KMdiMainFrm. Then usually you'll just need
 addWindow() and removeWindowFromMdi() to control the views.
   <pre>
   public class MyMainWindow implements KMdiMainFrm
   { .... }
   ...
   MyMainWindow mainframe;
   qApp.setMainWidget(&mainframe);
   mainframe.addWindow(view1); // put it under MDI control
   mainframe.addWindow(view2);
   </pre>
 Most public and protected methods of this class are for program calls of the actions
 the user could click.<br>
 Dynamic switching the MDI mode can be done via switchToChildframeMode(), switchToToplevelMode(),
 switchToTabPageMode() or fakeSDIApplication() or asked via mdiMode(), isFakingSDIApplication().
 This class provides already the "Window" menu needed in common MDI applications. Just
 insert it in your main menu:
 <pre>
 if (!isFakingSDIApplication()) {
    menuBar().insertItem( tr("&Window"), windowMenu());
 }
 </pre>
 Synchronize the positions of the MDI control buttons inserted in your mainmenu:
 <pre>
 void B_MainModuleWidget.initMenuBar()
 {
   setMenuForSDIModeSysButtons( menuBar());
 ...
 void B_MainModuleWidget.resizeEvent ( QResizeEvent e)
 {
   KMdiMainFrm.resizeEvent( e);
   setSysButtonsAtMenuPosition();
 }
 </pre>
 You can dynamically change the shape of the attached MDI views using setFrameDecorOfAttachedViews().
 Additionally, here's a hint how to restore the mainframe's settings from config file:
 <pre>
    // restore MDI mode (toplevel, childframe, tabpage)
    int mdiMode = config.readIntEntry( "mainmodule session", "MDI mode", KMdi.ChildframeMode);
    switch (mdiMode) {
    case KMdi.ToplevelMode:
       {
          int childFrmModeHt = config.readIntEntry( "mainmodule session", "Childframe mode height", desktop().height() - 50);
          mainframe.resize( m_pMdiMainFrm.width(), childFrmModeHt);
          mainframe.switchToToplevelMode();
       }
       break;
    case KMdi.ChildframeMode:
       break;
    case KMdi.TabPageMode:
       {
          int childFrmModeHt = m_pCfgFileManager.readIntEntry( "mainmodule session", "Childframe mode height", desktop().height() - 50);
          mainframe.resize( m_pMdiMainFrm.width(), childFrmModeHt);
          mainframe.switchToTabPageMode();
       }
       break;
    default:
       break;
    }
    // restore a possible maximized Childframe mode
    boolean maxChildFrmMode = config.readBoolEntry( "mainmodule session", "maximized childframes", true);
    mainframe.setEnableMaximizedChildFrmMode(maxChildFrmMode);
 </pre>
 The maximized-Childframe mode means that currently all views are maximized in Childframe mode's application desktop.
 This class provides placing algorithms in Childframe mode. Call tilePragma(), tileAnodine(), tileVertically(),
 cascadeWindows(), cascadeMaximized(), expandVertical(), expandHorizontal() for those actions.
 activateView(KMdiChildView) and activateView(int index) set the appropriate MDI child view as the active
 one. It will be raised, gets an active MDI frame and gets the focus. Call activeView() to find out what the
 current MDI view is.
 Use detachWindow() and attachWindow() for docking the MDI views to desktop and back.
 Connect accels of your program with activatePrevWin(), activateNextWin() and activateView(int index).
 Note: KMdiChildViews can be added in 2 meanings: Either as a normal child view (usually containing
 user document views) or as a tool-view (usually containing status, info or control widgets).
 The tool-views can be added as floating dockwidgets or as stay-on-top desktop windows in tool style.
 Here's an example how you can suggest things for the adding of views to the MDI control via flags:
 <pre>
 m_mapOfMdiWidgets.insert( pWnd, mh);
 unsigned int mdiFlags = KMdi.StandardAdd;
 if( !bShow)
    mdiFlags |= KMdi.Hide;
 if( !bAttach)
    mdiFlags |= KMdi.Detach;
 if( bMinimize)
    mdiFlags |= KMdi.Minimize;
 if( bToolWindow)
    mdiFlags |= KMdi.ToolWindow;
 if (m_pMdiMainFrm.isFakingSDIApplication()) {
    if (bAttach) { // fake an SDI app
       mdiFlags |= KMdi.Maximize;
    }
    else {
       m_pMdiMainFrm.addWindow( pWnd, QPoint(20, 20), KMdi.AddWindowFlags(mdiFlags));
       return;
    }
 }
 m_pMdiMainFrm.addWindow( pWnd, KMdi.AddWindowFlags(mdiFlags));
 </pre>
 Further note: Pay attention to the fact that when you click on the close button of MDI views that their
 close event should be redirected to closeWindow(). Otherwise the mainframe class will
 not get noticed about the deleted view and a dangling pointer will remain in the MDI control. The
 closeWindow() or the removeWindowFromMdi() method is for that issue. The difference is closeWindow()
 deletes the view object. So if your application wants to control that by itself, call removeWindowFromMdi()
 and call delete by yourself. See also KMdiChildView.closeEvent() for tat issue.
   See {@link KMdiMainFrmSignals} for signals emitted by KMdiMainFrm
		@short Base class for all your special main frames.

*/
public class KMdiMainFrm extends DockMainWindow  {
	protected KMdiMainFrm(Class dummy){super((Class) null);}
	/**	
		 Returns whether this MDI child view is under MDI control (using addWindow() ) or not.
		   		@short    Returns whether this MDI child view is under MDI control (using addWindow() ) or not.
	*/
	public static final int DocumentView = 0;
	public static final int ToolView = 1;
	public static final int AnyView = 2;

	public native QMetaObject metaObject();
	public native String className();
	/**	
		 Constructor.
		   		@short    Constructor.
	*/
	public KMdiMainFrm(QWidget parentWidget, String name, int mdiMode, int flags) {
		super((Class) null);
		newKMdiMainFrm(parentWidget,name,mdiMode,flags);
	}
	private native void newKMdiMainFrm(QWidget parentWidget, String name, int mdiMode, int flags);
	public KMdiMainFrm(QWidget parentWidget, String name, int mdiMode) {
		super((Class) null);
		newKMdiMainFrm(parentWidget,name,mdiMode);
	}
	private native void newKMdiMainFrm(QWidget parentWidget, String name, int mdiMode);
	public KMdiMainFrm(QWidget parentWidget, String name) {
		super((Class) null);
		newKMdiMainFrm(parentWidget,name);
	}
	private native void newKMdiMainFrm(QWidget parentWidget, String name);
	public KMdiMainFrm(QWidget parentWidget) {
		super((Class) null);
		newKMdiMainFrm(parentWidget);
	}
	private native void newKMdiMainFrm(QWidget parentWidget);
	public native void setStandardMDIMenuEnabled(boolean showModeMenu);
	public native void setStandardMDIMenuEnabled();
	public native void setManagedDockPositionModeEnabled(boolean enabled);
	/**	
		 Returns whether the application's MDI views are in maximized state or not.
		   		@short    Returns whether the application's MDI views are in maximized state or not.
	*/
	public native boolean isInMaximizedChildFrmMode();
	/**	
		 Returns the MDI mode. This can be one of the enumerations KMdi.MdiMode.
		   		@short    Returns the MDI mode.
	*/
	public native int mdiMode();
	/**	
		 Returns the focused attached MDI view.
		   		@short    Returns the focused attached MDI view.
	*/
	public native KMdiChildView activeWindow();
	/**	
		 Returns a popup menu filled according to the MDI view state. You can override this
		 method to insert additional entries there. The popup menu is usually popuped when the user
		 clicks with the right mouse button on a taskbar entry. The default entries are:
		 Undock/Dock, Restore/Maximize/Minimize, Close and an empty sub-popup ( windowPopup() )
		 menu called Operations.
		   		@short    Returns a popup menu filled according to the MDI view state.
	*/
	public native QPopupMenu taskBarPopup(KMdiChildView pWnd, boolean bIncludeWindowPopup);
	public native QPopupMenu taskBarPopup(KMdiChildView pWnd);
	/**	
		 Returns a popup menu with only a title "Window". You can fill it with own operations entries
		 on the MDI view. This popup menu is inserted as last menu item in taskBarPopup() .
		   		@short    Returns a popup menu with only a title "Window".
	*/
	public native QPopupMenu windowPopup(KMdiChildView pWnd, boolean bIncludeTaskbarPopup);
	public native QPopupMenu windowPopup(KMdiChildView pWnd);
	/**	
		 Called in the constructor (forces a resize of all MDI views)
		   		@short    Called in the constructor (forces a resize of all MDI views)
	*/
	public native void applyOptions();
	/**	
		 Returns the KMdiChildView belonging to the given caption string.
		   		@short    Returns the KMdiChildView belonging to the given caption string.
	*/
	public native KMdiChildView findWindow(String caption);
	public native boolean windowExists(KMdiChildView pWnd, int as);
	/**	
		 Catches certain Qt events and processes it here.
		 Currently, here this catches only the KMdiViewCloseEvent (a KMdi user event) which is sent
		 from itself in childWindowCloseRequest() right after a KMdiChildView.closeEvent() .
		 The reason for this event to itself is simple: It just wants to break the function call stack.
		 It continues the processing with calling closeWindow() .
		 You see, a close() is translated to a closeWindow() .
		 It is necessary that the main frame has to start an MDI view close action because it must
		 remove the MDI view from MDI control, additionally.
			 This method calls QMainWindow.event , additionally.
		   		@short    Catches certain Qt events and processes it here.
	*/
	public native boolean event(QEvent e);
	/**	
		 If there's a main menubar given, it will create the 4 maximize mode buttons there (undock, minimize, restore, close).
		   		@short    If there's a main menubar given, it will create the 4 maximize mode buttons there (undock, minimize, restore, close).
	*/
	public native void setSysButtonsAtMenuPosition();
	/**	
		 Returns the height of the taskbar.
		   		@short    Returns the height of the taskbar.
	*/
	public native int taskBarHeight();
	/**	
		 Sets an offset value that is used on detachWindow() . The undocked window
		 is visually moved on the desktop by this offset.
		   		@short    Sets an offset value that is used on detachWindow() .
	*/
	public native void setUndockPositioningOffset(QPoint offset);
	/**	
		 If you don't want to know about the inner structure of the KMdi system, you can use
		 this iterator to handle with the MDI view list in a more abstract way.
		 The iterator hides what special data structure is used in KMdi.
		   		@short    If you don't want to know about the inner structure of the KMdi system, you can use  this iterator to handle with the MDI view list in a more abstract way.
	*/
	// KMdiIterator<KMdiChildView*>* createIterator(); >>>> NOT CONVERTED
	/**	
		 Deletes an KMdiIterator created in the KMdi library (needed for the windows dll problem).
		   		@short    Deletes an KMdiIterator created in the KMdi library (needed for the windows dll problem).
	*/
	// void deleteIterator(KMdiIterator<KMdiChildView* >* arg1); >>>> NOT CONVERTED
	/**	
		 Returns a popup menu that contains the MDI controlled view list.
		 Additionally, this menu provides some placing actions for these views.
		 Usually, you insert this popup menu in your main menubar as "Window" menu.
		   		@short    Returns a popup menu that contains the MDI controlled view list.
	*/
	public native QPopupMenu windowMenu();
	/**	
		 Sets a background color for the MDI view area widget.
		   		@short    Sets a background color for the MDI view area widget.
	*/
	public native void setBackgroundColor(QColor c);
	/**	
		 Sets a background pixmap for the MDI view area widget.
		   		@short    Sets a background pixmap for the MDI view area widget.
	*/
	public native void setBackgroundPixmap(QPixmap pm);
	/**	
		 Sets a size that is used as the default size for a newly to the MDI system added KMdiChildView .
		  By default this size is 600x400. So all non-resized added MDI views appear in that size.
		   		@short    Sets a size that is used as the default size for a newly to the MDI system added KMdiChildView .
	*/
	public native void setDefaultChildFrmSize(QSize sz);
	/**	
		 Returns the default size for a newly added KMdiChildView. See setDefaultChildFrmSize() .
		   		@short    Returns the default size for a newly added KMdiChildView.
	*/
	public native QSize defaultChildFrmSize();
	/**	
		 Do nothing when in Toplevel mode
		   		@short    Do nothing when in Toplevel mode
	*/
	public native void setMinimumSize(int minw, int minh);
	/**	
		 Returns the Childframe mode height of this. Makes only sense when in Toplevel mode.
		   		@short    Returns the Childframe mode height of this.
	*/
	public native int childFrameModeHeight();
	/**	
		 Tells the MDI system a QMenu where it can insert buttons for
		 the system menu, undock, minimize, restore actions.
		 If no such menu is given, KMdi simply overlays the buttons
		 at the upper right-hand side of the main widget.
		   		@short    Tells the MDI system a QMenu where it can insert buttons for  the system menu, undock, minimize, restore actions.
	*/
	public native void setMenuForSDIModeSysButtons(KMenuBar arg1);
	public native void setMenuForSDIModeSysButtons();
	/**	
		 An SDI application user interface is faked:
		
			<li>
			an opened view is always maximized
			</li>
			
			<li>
			buttons for maximized childframe mode aren't inserted in the main menubar
			</li>
			
			<li>
			taskbar and windowmenu are not created/updated
			   
			</li>		@short    An SDI application user interface is faked:
	*/
	public native void fakeSDIApplication();
	/**	
				@return if we are faking an SDI application (fakeSDIApplication())
   
		@short
	*/
	public native boolean isFakingSDIApplication();
	/**	
			   		@short
	*/
	public native boolean eventFilter(QObject arg1, QEvent e);
	/**	
			   		@short
	*/
	// void findRootDockWidgets(QPtrList<KDockWidget>* arg1,QValueList<QRect>* arg2); >>>> NOT CONVERTED
	public native void setSwitching(boolean switching);
	public native boolean switching();
	/**	 addWindow demands a KMdiChildView. This method wraps every QWidget in such an object and
		       this way you can every widget put under MDI control.
		    		@short   addWindow demands a KMdiChildView.
	*/
	public native KMdiChildView createWrapper(QWidget view, String name, String shortName);
	/**	
		 One of the most important methods at all!
		 Adds a KMdiChildView to the MDI system. The main frame takes it under control.
		 You can specify here whether:
		 <UL><LI>the view should be attached or detached.</LI>
		 <LI>shown or hidden</LI>
		 <LI>maximized, minimized or restored (normalized)</LI>
		 <LI>added as tool view (stay-on-top and toplevel) or added as document-type view.</LI?
		 </UL>
		    		@short    One of the most important methods at all!  Adds a KMdiChildView to the MDI system.
	*/
	public native void addWindow(KMdiChildView pView, int flags);
	public native void addWindow(KMdiChildView pView);
	/**	
		 See the method above for more details. Additionally, it moves to point pos.
		   		@short    See the method above for more details.
	*/
	public native void addWindow(KMdiChildView pView, QPoint pos, int flags);
	public native void addWindow(KMdiChildView pView, QPoint pos);
	/**	
		 See the method above for more details. Additionally, it sets the geometry.
		   		@short    See the method above for more details.
	*/
	public native void addWindow(KMdiChildView pView, QRect rectNormal, int flags);
	public native void addWindow(KMdiChildView pView, QRect rectNormal);
	/**	
		 Usually called from addWindow() when adding a tool view window. It reparents the given widget
		 as toplevel and stay-on-top on the application's main widget.
		   		@short    Usually called from addWindow() when adding a tool view window.
	*/
	// KMdiToolViewAccessor* addToolWindow(QWidget* arg1,KDockWidget::DockPosition arg2,QWidget* arg3,int arg4,const QString& arg5,const QString& arg6); >>>> NOT CONVERTED
	// KMdiToolViewAccessor* addToolWindow(QWidget* arg1,KDockWidget::DockPosition arg2,QWidget* arg3,int arg4,const QString& arg5); >>>> NOT CONVERTED
	// KMdiToolViewAccessor* addToolWindow(QWidget* arg1,KDockWidget::DockPosition arg2,QWidget* arg3,int arg4); >>>> NOT CONVERTED
	// KMdiToolViewAccessor* addToolWindow(QWidget* arg1,KDockWidget::DockPosition arg2,QWidget* arg3); >>>> NOT CONVERTED
	// KMdiToolViewAccessor* addToolWindow(QWidget* arg1,KDockWidget::DockPosition arg2); >>>> NOT CONVERTED
	// KMdiToolViewAccessor* addToolWindow(QWidget* arg1); >>>> NOT CONVERTED
	public native void deleteToolWindow(QWidget pWnd);
	// void deleteToolWindow(KMdiToolViewAccessor* arg1); >>>> NOT CONVERTED
	/**	
		 Using this method you have to use the setWidget method of the access object, and it is very recommendet, that you use
		 the widgetContainer() method for the parent of your newly created widget
		    		@short    Using this method you have to use the setWidget method of the access object, and it is very recommendet, that you use  the widgetContainer() method for the parent of your newly created widget
	*/
	// KMdiToolViewAccessor* createToolWindow(); >>>> NOT CONVERTED
	/**	
		 Removes a KMdiChildView from the MDI system and from the main frame`s control.
		 Note: The view will not be deleted, but it's getting toplevel (reparent to 0)!
		   		@short    Removes a KMdiChildView from the MDI system and from the main frame`s control.
	*/
	public native void removeWindowFromMdi(KMdiChildView pWnd);
	/**	
		 Removes a KMdiChildView from the MDI system and from the main frame`s control.
		 Note: The view will be deleted!
		   		@short    Removes a KMdiChildView from the MDI system and from the main frame`s control.
	*/
	public native void closeWindow(KMdiChildView pWnd, boolean layoutTaskBar);
	public native void closeWindow(KMdiChildView pWnd);
	/**	
		 Switches the KMdiTaskBar on and off.
		   		@short    Switches the KMdiTaskBar on and off.
	*/
	public native void slot_toggleTaskBar();
	/**	
		 Makes a main frame controlled undocked KMdiChildView docked.
		 Doesn't work on KMdiChildView which aren't added to the MDI system.
		 Use addWindow() for that.
		    		@short    Makes a main frame controlled undocked KMdiChildView docked.
	*/
	public native void attachWindow(KMdiChildView pWnd, boolean bShow, boolean bAutomaticResize);
	public native void attachWindow(KMdiChildView pWnd, boolean bShow);
	public native void attachWindow(KMdiChildView pWnd);
	/**	
		 Makes a docked KMdiChildView undocked.
		 The view window still remains under the main frame's MDI control.
		    		@short    Makes a docked KMdiChildView undocked.
	*/
	public native void detachWindow(KMdiChildView pWnd, boolean bShow);
	public native void detachWindow(KMdiChildView pWnd);
	/**	
		 Someone wants that the MDI view to be closed. This method sends a KMdiViewCloseEvent to itself
		 to break the function call stack. See also event() .
		   		@short    Someone wants that the MDI view to be closed.
	*/
	public native void childWindowCloseRequest(KMdiChildView pWnd);
	/**	
		 Close all views
		   		@short    Close all views
	*/
	public native void closeAllViews();
	/**	
		 Iconfiy all views
		   		@short    Iconfiy all views
	*/
	public native void iconifyAllViews();
	/**	
		 Closes the view of the active (topchild) window
		   		@short    Closes the view of the active (topchild) window
	*/
	public native void closeActiveView();
	/**	
		 Undocks all view windows (unix-like)
		   		@short    Undocks all view windows (unix-like)
	*/
	public native void switchToToplevelMode();
	public native void finishToplevelMode();
	/**	
		 Docks all view windows (Windows-like)
		   		@short    Docks all view windows (Windows-like)
	*/
	public native void switchToChildframeMode();
	public native void finishChildframeMode();
	/**	
		 Docks all view windows (Windows-like)
		   		@short    Docks all view windows (Windows-like)
	*/
	public native void switchToTabPageMode();
	public native void finishTabPageMode();
	/**	
		 Docks all view windows. Toolviews use dockcontainers
		    		@short    Docks all view windows.
	*/
	public native void switchToIDEAlMode();
	public native void finishIDEAlMode(boolean full);
	public native void finishIDEAlMode();
	/**	
		 Sets the appearance of the IDEAl mode. See KMultiTabBar styles for the first 3 bits.
		    		@short    Sets the appearance of the IDEAl mode.
	*/
	public native void setIDEAlModeStyle(int flags);
	public native boolean isViewTaskBarOn();
	/**	
		 Shows the view taskbar. This should be connected with your "View" menu.
		   		@short    Shows the view taskbar.
	*/
	public native void showViewTaskBar();
	/**	
		 Hides the view taskbar. This should be connected with your "View" menu.
		   		@short    Hides the view taskbar.
	*/
	public native void hideViewTaskBar();
	/**	
		 Update of the window menu contents.
		   		@short    Update of the window menu contents.
	*/
	public native void fillWindowMenu();
	/**	
		 Cascades the windows without resizing them.
		   		@short    Cascades the windows without resizing them.
	*/
	public native void cascadeWindows();
	/**	
		 Cascades the windows resizing them to the maximum available size.
		   		@short    Cascades the windows resizing them to the maximum available size.
	*/
	public native void cascadeMaximized();
	/**	
		 Maximizes only in vertical direction.
		   		@short    Maximizes only in vertical direction.
	*/
	public native void expandVertical();
	/**	
		 Maximizes only in horizontal direction.
		   		@short    Maximizes only in horizontal direction.
	*/
	public native void expandHorizontal();
	/**	
		 Tile Pragma
		   		@short    Tile Pragma
	*/
	public native void tilePragma();
	/**	
		 Tile Anodine
		   		@short    Tile Anodine
	*/
	public native void tileAnodine();
	/**	
		 Tile Vertically
		   		@short    Tile Vertically
	*/
	public native void tileVertically();
	/**	
		 Sets the decoration of the window frame of docked (attached) MDI views
		   		@short    Sets the decoration of the window frame of docked (attached) MDI views
	*/
	public native void setFrameDecorOfAttachedViews(int frameDecor);
	/**	
		 If in Childframe mode, we can switch between maximized or restored shown MDI views
		   		@short    If in Childframe mode, we can switch between maximized or restored shown MDI views
	*/
	public native void setEnableMaximizedChildFrmMode(boolean bEnable);
	/**	
		 Activates the next open view
		   		@short    Activates the next open view
	*/
	public native void activateNextWin();
	/**	
		 Activates the previous open view
		   		@short    Activates the previous open view
	*/
	public native void activatePrevWin();
	/**	
		 Activates the view first viewed concerning to the access time.
		   		@short    Activates the view first viewed concerning to the access time.
	*/
	public native void activateFirstWin();
	/**	
		 Activates the view last viewed concerning to the access time.
		   		@short    Activates the view last viewed concerning to the access time.
	*/
	public native void activateLastWin();
	/**	
		 Activates the view with the tab page index (TabPage mode only)
		   		@short    Activates the view with the tab page index (TabPage mode only)
	*/
	public native void activateView(int index);
	public native void prevToolViewInDock();
	public native void nextToolViewInDock();
	/**	
				@return the decoration of the window frame of docked (attached) MDI views
   
		@short
	*/
	public static native int frameDecorOfAttachedViews();
	/**	
			   		@short
	*/
	protected native void resizeEvent(QResizeEvent arg1);
	/**	
		 Creates a new MDI taskbar (showing the MDI views as taskbar entries) and shows it.
		   		@short    Creates a new MDI taskbar (showing the MDI views as taskbar entries) and shows it.
	*/
	protected native void createTaskBar();
	/**	
		 Creates the MDI view area and connects some signals and slots with the KMdiMainFrm widget.
		   		@short    Creates the MDI view area and connects some signals and slots with the KMdiMainFrm widget.
	*/
	protected native void createMdiManager();
	/**	
		 prevents fillWindowMenu() from m_pWindowMenu.clear(). You have to care for it by yourself.
		 This is useful if you want to add some actions in your overridden fillWindowMenu() method.
		   		@short    prevents fillWindowMenu() from m_pWindowMenu.clear().
	*/
	protected native void blockClearingOfWindowMenu(boolean bBlocked);
	// void findToolViewsDockedToMain(QPtrList<KDockWidget>* arg1,KDockWidget::DockPosition arg2); >>>> NOT CONVERTED
	// void dockToolViewsIntoContainers(QPtrList<KDockWidget>& arg1,KDockWidget* arg2); >>>> NOT CONVERTED
	protected native ArrayList prepareIdealToTabs(KDockWidget container);
	protected native void idealToolViewsToStandardTabs(String[] widgetNames, int pos, int sizee);
	/**	
		 Sets the focus to this MDI view, raises it, activates its taskbar button and updates
		 the system buttons in the main menubar when in maximized (Maximize mode).
		   		@short    Sets the focus to this MDI view, raises it, activates its taskbar button and updates  the system buttons in the main menubar when in maximized (Maximize mode).
	*/
	protected native void activateView(KMdiChildView pWnd);
	/**	
		 Activates the MDI view (see activateView() ) and popups the taskBar popup menu (see taskBarPopup() ).
		   		@short    Activates the MDI view (see activateView() ) and popups the taskBar popup menu (see taskBarPopup() ).
	*/
	protected native void taskbarButtonRightClicked(KMdiChildView pWnd);
	/**	
		 Turns the system buttons for maximize mode (SDI mode) off, and disconnects them
		   		@short    Turns the system buttons for maximize mode (SDI mode) off, and disconnects them
	*/
	protected native void switchOffMaximizeModeForMenu(KMdiChildFrm oldChild);
	/**	
		 Reconnects the system buttons form maximize mode (SDI mode) with the new child frame
		   		@short    Reconnects the system buttons form maximize mode (SDI mode) with the new child frame
	*/
	protected native void updateSysButtonConnections(KMdiChildFrm oldChild, KMdiChildFrm newChild);
	/**	
		 Usually called when the user clicks an MDI view item in the "Window" menu.
		   		@short    Usually called when the user clicks an MDI view item in the "Window" menu.
	*/
	protected native void windowMenuItemActivated(int id);
	/**	
		 Usually called when the user clicks an MDI view item in the sub-popup menu "Docking" of the "Window" menu.
		   		@short    Usually called when the user clicks an MDI view item in the sub-popup menu "Docking" of the "Window" menu.
	*/
	protected native void dockMenuItemActivated(int id);
	/**	
		 Popups the "Window" menu. See also windowPopup() .
		   		@short    Popups the "Window" menu.
	*/
	protected native void popupWindowMenu(QPoint p);
	/**	
		 The timer for main widget moving has elapsed . send drag end to all concerned views.
		   		@short    The timer for main widget moving has elapsed . send drag end to all concerned views.
	*/
	protected native void dragEndTimeOut();
	/**	
		 internally used to handle click on view close button (TabPage mode, only)
		   		@short    internally used to handle click on view close button (TabPage mode, only)
	*/
	protected native void closeViewButtonPressed();
	/** Deletes the wrapped C++ instance */
	protected native void finalize() throws InternalError;
	/** Delete the wrapped C++ instance ahead of finalize() */
	public native void dispose();
	/** Has the wrapped C++ instance been deleted? */
	public native boolean isDisposed();
}
