/***************************************************************************
                            kde_KDockManager.h -  description
                             -------------------
    begin                : Sun Nov 24 16:54:36 2002
    copyright            : (C) 2000-2001 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Sun Nov 24 16:54:36 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef KDE_KDOCKMANAGER
#define KDE_KDOCKMANAGER

#include <qtc/qtc_types.h>

#include <kdec/kde_types.h>

/**
*
 The manager that knows all dockwidgets and handles the dock process (and member of the dockwidget class set).
 More or less a helper class for the KDockWidget class set but of interest for some functionality
 that can be called within a @ref KDockMainWindow or a @ref KDockWidget .

 An important feature is the ability to read or save the current state of all things concerning to
 dockwidgets to @ref KConfig .

 The dockmanager is also often used when a certain dockwidget or a child of such dockwidget must be found.

 @author Max Judin (documentation: Falk Brettschneider).
 
 @short *
 The manager that knows all dockwidgets and handles the dock process (and member of the dockwidget class set).
*/

/** *
 Constructs a dockmanager. Some initialization happen:

*/
#ifdef __cplusplus
extern   "C" {
#endif
kde_KDockManager * kde_new_KDockManager(qt_QWidget * mainWindow, char* name);

/** *
 Destructs a dockmanager.
   
*/
void kde_del_KDockManager( kde_KDockManager* p );

/** *
 Saves the current state of the dockmanager and of all controlled widgets.
 State means here to save the geometry, visibility, parents, internal object names, orientation,
 separator positions, dockwidget-group information, tab widget states (if it is a tab group) and
 last but not least some necessary things for recovering the dockmainwindow state.

*/
void kde_KDockManager_writeConfig(kde_KDockManager* instPointer,kde_KConfig* c, qt_QString * group);

/** *
 Like writeConfig but reads the whole stuff in.

 In order to restore a window configuration
 from a config file, it looks up widgets by name
 (QObject::name) in the childDock variable of
 KDockManager. This list in turn contains all
 KDockWidgets (according to the KDockWidget constructor).
 So in principle, in order to restore a window layout,
 one must first construct all widgets, put each of them in a
 KDockWidget and then call readConfig(). And for all that
 to work, each widget must have a unique name.

*/
void kde_KDockManager_readConfig(kde_KDockManager* instPointer,kde_KConfig* c, qt_QString * group);
void kde_KDockManager_setMainDockWidget2(kde_KDockManager* instPointer,kde_KDockWidget* arg1);

/** *
 Saves the current dock window layout into a DOM tree below the given element.
   
*/
void kde_KDockManager_writeConfig1(kde_KDockManager* instPointer,qt_QDomElement* base);

/** *
 Reads the current dock window layout from a DOM tree below the given element.
   
*/
void kde_KDockManager_readConfig1(kde_KDockManager* instPointer,qt_QDomElement* base);

/** *
 Shows all encapsulated widgets of all controlled dockwidgets and shows all dockwidgets which are
 parent of a dockwidget tab group.
   
*/
void kde_KDockManager_activate(kde_KDockManager* instPointer);

/** *
 It's more or less a method that catches several events which are interesting for the dockmanager.
 Mainly mouse events during the drag process of a dockwidgets are of interest here.

*/
int kde_KDockManager_eventFilter(kde_KDockManager* instPointer,qt_QObject * arg1, qt_QEvent * arg2);

/** *
 This method finds out what a widgets' dockwidget is. That means the dockmanager has a look at all
 dockwidgets it knows and tells you when one of those dockwidgets covers the given widget.

*/
kde_KDockWidget* kde_KDockManager_findWidgetParentDock(kde_KDockManager* instPointer,qt_QWidget * w);

/** *
 Works like makeDockVisible() but can be called for widgets that covered by a dockwidget.

*/
void kde_KDockManager_makeWidgetDockVisible(kde_KDockManager* instPointer,qt_QWidget * w);

/** *

*/
qt_QPopupMenu* kde_KDockManager_dockHideShowMenu(kde_KDockManager* instPointer);

/** *

*/
kde_KDockWidget* kde_KDockManager_getDockWidgetFromName(kde_KDockManager* instPointer,qt_QString * dockName);

/** *
 Enables opaque resizing. Opaque resizing is initially turned off.
 Call this method before you create any dock widgets!   
   
*/
void kde_KDockManager_setSplitterOpaqueResize(kde_KDockManager* instPointer,int b);

/** *
 Returns TRUE if opaque resizing is enabled, FALSE otherwise.
   
*/
int kde_KDockManager_splitterOpaqueResize(kde_KDockManager* instPointer);

/** *
 Try to preserve the widget's size. Works like KeepSize resize mode
 of QSplitter. Off by default.
 Call this method before you create any dock widgets!
   
*/
void kde_KDockManager_setSplitterKeepSize(kde_KDockManager* instPointer,int b);

/** *
 Returns TRUE if the KeepSize is enabled, FALSE otherwise.
   
*/
int kde_KDockManager_splitterKeepSize(kde_KDockManager* instPointer);

/** *
 Operate the splitter with a higher resolution. Off by default.
 Call this method before you create any dock widgets!
 If high resolution is used all splitter position parameters
 are percent*100 instead of percent.
   
*/
void kde_KDockManager_setSplitterHighResolution(kde_KDockManager* instPointer,int b);

/** *
 Returns TRUE if the splitter uses the high resolution, FALSE otherwise.
   
*/
int kde_KDockManager_splitterHighResolution(kde_KDockManager* instPointer);

/** *
 An internal list containing data for the menuitems for the visibility popup menu.
   
*/
void kde_KDockManager_virtual_hook(kde_KDockManager* instPointer,int identifier, void* data);

#ifdef __cplusplus
}
#endif
#endif
