/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.output;

import com.icl.saxon.charcode.CharacterSetFactory;
import com.icl.saxon.charcode.PluggableCharacterSet;
import com.icl.saxon.charcode.UnicodeCharacterSet;
import com.icl.saxon.om.Builder;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.CDATAFilter;
import com.icl.saxon.output.ContentHandlerProxy;
import com.icl.saxon.output.DOMEmitter;
import com.icl.saxon.output.Emitter;
import com.icl.saxon.output.HTMLEmitter;
import com.icl.saxon.output.HTMLIndenter;
import com.icl.saxon.output.NamespaceEmitter;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.output.ProxyEmitter;
import com.icl.saxon.output.TEXTEmitter;
import com.icl.saxon.output.UncommittedEmitter;
import com.icl.saxon.output.XHTMLEmitter;
import com.icl.saxon.output.XMLEmitter;
import com.icl.saxon.output.XMLIndenter;
import com.icl.saxon.tinytree.TinyBuilder;
import com.icl.saxon.tree.AttributeCollection;
import com.icl.saxon.tree.DocumentImpl;
import com.icl.saxon.tree.TreeBuilder;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Hashtable;
import java.util.Properties;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class GeneralOutputter
extends Outputter {
    private NamePool namePool;
    private Properties outputProperties;
    private Writer writer;
    private OutputStream outputStream;
    private boolean closeAfterUse = false;
    private int pendingStartTag = -1;
    private AttributeCollection pendingAttList;
    private int[] pendingNSList = new int[20];
    private int pendingNSListSize = 0;
    char[] charbuffer = new char[1024];

    public GeneralOutputter(NamePool namePool) {
        this.namePool = namePool;
        this.pendingAttList = new AttributeCollection(this.namePool, 10);
    }

    public void setOutputDestination(Properties properties, Result result) throws TransformerException {
        this.setOutputProperties(properties);
        Emitter emitter = this.makeEmitter(properties, result);
        emitter.setNamePool(this.namePool);
        emitter.setOutputProperties(properties);
        this.setEmitter(emitter);
        this.open();
    }

    public static String urlToFileName(String string) {
        if (null != string) {
            if (string.startsWith("file:////")) {
                string = string.substring(7);
            } else if (string.startsWith("file:///")) {
                string = string.substring(6);
            } else if (string.startsWith("file://")) {
                string = string.substring(5);
            } else if (string.startsWith("file:/")) {
                string = string.substring(5);
            } else if (string.startsWith("file:")) {
                string = string.substring(4);
            }
            if (string.startsWith("file:\\\\\\\\")) {
                string = string.substring(7);
            } else if (string.startsWith("file:\\\\\\")) {
                string = string.substring(6);
            } else if (string.startsWith("file:\\\\")) {
                string = string.substring(5);
            } else if (string.startsWith("file:\\")) {
                string = string.substring(5);
            }
        }
        if (File.separatorChar != '/') {
            string = string.replace('/', File.separatorChar);
        }
        return string;
    }

    public static FileOutputStream makeFileOutputStream(String string, String string2, boolean bl) throws TransformerException {
        try {
            File file;
            Object object;
            File file2 = new File(string2);
            if (!file2.isAbsolute() && null != (object = GeneralOutputter.urlToFileName(string))) {
                file = new File((String)object);
                file2 = new File(file.getParent(), string2);
            }
            if (bl && null != (object = file2.getParent()) && ((String)object).length() > 0) {
                file = new File((String)object);
                file.mkdirs();
            }
            object = new FileOutputStream(file2);
            return object;
        }
        catch (Exception exception) {
            throw new TransformerException("Failed to create output file", exception);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Emitter makeEmitter(Properties properties, Result result) throws TransformerException {
        Object object;
        Object object2;
        if (result instanceof DOMResult) {
            object2 = ((DOMResult)result).getNode();
            if (object2 != null) {
                if (object2 instanceof NodeInfo) {
                    if (!(object2 instanceof DocumentInfo)) throw new TransformerException("Cannot add to an existing Saxon document");
                    DocumentInfo documentInfo = (DocumentInfo)object2;
                    if (object2.getFirstChild() != null) {
                        throw new TransformerException("Target document must be empty");
                    }
                    Builder builder = documentInfo instanceof DocumentImpl ? new TreeBuilder() : new TinyBuilder();
                    builder.setRootNode(documentInfo);
                    builder.setSystemId(result.getSystemId());
                    builder.setNamePool(this.namePool);
                    object = builder;
                } else {
                    object = new DOMEmitter();
                    ((DOMEmitter)object).setNode((Node)object2);
                }
            } else {
                TinyBuilder tinyBuilder = new TinyBuilder();
                tinyBuilder.setSystemId(result.getSystemId());
                tinyBuilder.setNamePool(this.namePool);
                tinyBuilder.createDocument();
                Document document = (Document)((Object)tinyBuilder.getCurrentDocument());
                ((DOMResult)result).setNode(document);
                object = tinyBuilder;
            }
        } else if (result instanceof SAXResult) {
            object2 = (SAXResult)result;
            ContentHandlerProxy contentHandlerProxy = new ContentHandlerProxy();
            contentHandlerProxy.setUnderlyingContentHandler(((SAXResult)object2).getHandler());
            if (((SAXResult)object2).getLexicalHandler() != null) {
                contentHandlerProxy.setLexicalHandler(((SAXResult)object2).getLexicalHandler());
            }
            object = contentHandlerProxy;
        } else if (result instanceof Emitter) {
            object = (Emitter)result;
        } else {
            if (!(result instanceof StreamResult)) throw new IllegalArgumentException("Unknown type of Result: " + result.getClass());
            object2 = properties.getProperty("method");
            if (object2 == null) {
                object = new UncommittedEmitter();
            } else if (((String)object2).equals("html")) {
                object = new HTMLEmitter();
                if (!"no".equals(properties.getProperty("indent"))) {
                    HTMLIndenter hTMLIndenter = new HTMLIndenter();
                    hTMLIndenter.setUnderlyingEmitter((Emitter)object);
                    object = hTMLIndenter;
                }
            } else if (((String)object2).equals("xml")) {
                Object object3;
                object = new XMLEmitter();
                if ("yes".equals(properties.getProperty("indent"))) {
                    object3 = new XMLIndenter();
                    ((ProxyEmitter)object3).setUnderlyingEmitter((Emitter)object);
                    object = object3;
                }
                if ((object3 = properties.getProperty("cdata-section-elements")) != null && ((String)object3).length() > 0) {
                    CDATAFilter cDATAFilter = new CDATAFilter();
                    cDATAFilter.setUnderlyingEmitter((Emitter)object);
                    object = cDATAFilter;
                }
            } else if (((String)object2).equals("text")) {
                object = new TEXTEmitter();
            } else {
                int n = ((String)object2).indexOf(125);
                String string = ((String)object2).substring(n + 1);
                int n2 = string.indexOf(58);
                if ((string = string.substring(n2 + 1)).equals("fop")) {
                    object = Emitter.makeEmitter("com.icl.saxon.fop.FOPEmitter");
                } else if (string.equals("xhtml")) {
                    Object object4;
                    object = new XHTMLEmitter();
                    if ("yes".equals(properties.getProperty("indent"))) {
                        object4 = new HTMLIndenter();
                        ((ProxyEmitter)object4).setUnderlyingEmitter((Emitter)object);
                        object = object4;
                    }
                    if ((object4 = properties.getProperty("cdata-section-elements")) != null && ((String)object4).length() > 0) {
                        CDATAFilter cDATAFilter = new CDATAFilter();
                        cDATAFilter.setUnderlyingEmitter((Emitter)object);
                        object = cDATAFilter;
                    }
                } else {
                    object = Emitter.makeEmitter(string);
                }
            }
            if (((Emitter)object).usesWriter()) {
                this.writer = this.getStreamWriter((StreamResult)result, properties);
                ((Emitter)object).setWriter(this.writer);
            } else {
                this.outputStream = this.getOutputStream((StreamResult)result, properties);
                ((Emitter)object).setOutputStream(this.outputStream);
            }
        }
        object2 = new NamespaceEmitter();
        ((ProxyEmitter)object2).setUnderlyingEmitter((Emitter)object);
        return object2;
    }

    private Writer getStreamWriter(StreamResult streamResult, Properties properties) throws TransformerException {
        Writer writer;
        block12: {
            this.closeAfterUse = false;
            writer = streamResult.getWriter();
            if (writer == null) {
                Object object;
                OutputStream outputStream = streamResult.getOutputStream();
                if (outputStream == null) {
                    object = streamResult.getSystemId();
                    if (object == null) {
                        outputStream = System.out;
                    } else {
                        outputStream = GeneralOutputter.makeFileOutputStream("", GeneralOutputter.urlToFileName((String)object), true);
                        this.closeAfterUse = true;
                    }
                }
                object = CharacterSetFactory.getCharacterSet(properties);
                String string = properties.getProperty("encoding");
                if (string == null) {
                    string = "UTF8";
                }
                if (string.equalsIgnoreCase("utf-8")) {
                    string = "UTF8";
                }
                if (object instanceof PluggableCharacterSet) {
                    string = ((PluggableCharacterSet)object).getEncodingName();
                }
                while (true) {
                    try {
                        writer = new BufferedWriter(new OutputStreamWriter(outputStream, string));
                        break block12;
                    }
                    catch (Exception exception) {
                        if (string.equalsIgnoreCase("UTF8")) {
                            throw new TransformerException("Failed to create a UTF8 output writer");
                        }
                        System.err.println("Encoding " + string + " is not supported: using UTF8");
                        string = "UTF8";
                        object = new UnicodeCharacterSet();
                        ((Hashtable)properties).put("encoding", "utf-8");
                        continue;
                    }
                    break;
                }
            }
            if (writer instanceof OutputStreamWriter) {
                String string = ((OutputStreamWriter)writer).getEncoding();
                ((Hashtable)properties).put("encoding", string);
            }
        }
        return writer;
    }

    private OutputStream getOutputStream(StreamResult streamResult, Properties properties) throws TransformerException {
        this.closeAfterUse = false;
        OutputStream outputStream = streamResult.getOutputStream();
        if (outputStream == null) {
            String string = streamResult.getSystemId();
            if (string == null) {
                outputStream = System.out;
            } else {
                outputStream = GeneralOutputter.makeFileOutputStream("", GeneralOutputter.urlToFileName(string), true);
                this.closeAfterUse = true;
            }
        }
        if (outputStream == null) {
            throw new TransformerException("This output method requires a binary output destination");
        }
        return outputStream;
    }

    private void setEmitter(Emitter emitter) {
        this.emitter = emitter;
    }

    public void reset() throws TransformerException {
        if (this.pendingStartTag != -1) {
            this.flushStartTag();
        }
    }

    private void setOutputProperties(Properties properties) throws TransformerException {
        this.outputProperties = properties;
    }

    public Properties getOutputProperties() {
        return this.outputProperties;
    }

    public void write(String string) throws TransformerException {
        if (this.pendingStartTag != -1) {
            this.flushStartTag();
        }
        this.emitter.setEscaping(false);
        int n = string.length();
        if (n > this.charbuffer.length) {
            this.charbuffer = new char[n];
        }
        string.getChars(0, n, this.charbuffer, 0);
        this.emitter.characters(this.charbuffer, 0, n);
        this.emitter.setEscaping(true);
    }

    public void writeContent(String string) throws TransformerException {
        if (string == null) {
            return;
        }
        int n = string.length();
        if (n > this.charbuffer.length) {
            this.charbuffer = new char[n];
        }
        string.getChars(0, n, this.charbuffer, 0);
        this.writeContent(this.charbuffer, 0, n);
    }

    public void writeContent(char[] cArray, int n, int n2) throws TransformerException {
        if (n2 == 0) {
            return;
        }
        if (this.pendingStartTag != -1) {
            this.flushStartTag();
        }
        this.emitter.characters(cArray, n, n2);
    }

    public void writeContent(StringBuffer stringBuffer, int n, int n2) throws TransformerException {
        if (n2 == 0) {
            return;
        }
        if (this.pendingStartTag != -1) {
            this.flushStartTag();
        }
        if (n2 > this.charbuffer.length) {
            this.charbuffer = new char[n2];
        }
        stringBuffer.getChars(n, n + n2, this.charbuffer, 0);
        this.emitter.characters(this.charbuffer, 0, n2);
    }

    public void writeStartTag(int n) throws TransformerException {
        if (this.pendingStartTag != -1) {
            this.flushStartTag();
        }
        this.pendingAttList.clear();
        this.pendingNSListSize = 0;
        this.pendingStartTag = n;
    }

    public int checkAttributePrefix(int n) throws TransformerException {
        int n2 = this.namePool.allocateNamespaceCode(n);
        int n3 = 0;
        while (n3 < this.pendingNSListSize) {
            if (n2 >> 16 == this.pendingNSList[n3] >> 16) {
                if ((n2 & 0xFFFF) == (this.pendingNSList[n3] & 0xFFFF)) {
                    return n;
                }
                String string = this.getSubstitutePrefix(n2);
                int n4 = this.namePool.allocate(string, this.namePool.getURI(n), this.namePool.getLocalName(n));
                this.writeNamespaceDeclaration(this.namePool.allocateNamespaceCode(n4));
                return n4;
            }
            ++n3;
        }
        this.writeNamespaceDeclaration(n2);
        return n;
    }

    public void writeNamespaceDeclaration(int n) throws TransformerException {
        if (this.pendingStartTag == -1) {
            throw new TransformerException("Cannot write a namespace declaration when there is no open start tag");
        }
        int n2 = 0;
        while (n2 < this.pendingNSListSize) {
            if (n >> 16 == this.pendingNSList[n2] >> 16) {
                return;
            }
            ++n2;
        }
        if (this.pendingNSListSize + 1 > this.pendingNSList.length) {
            int[] nArray = new int[this.pendingNSListSize * 2];
            System.arraycopy(this.pendingNSList, 0, nArray, 0, this.pendingNSListSize);
            this.pendingNSList = nArray;
        }
        this.pendingNSList[this.pendingNSListSize++] = n;
    }

    public void copyNamespaceNode(int n) throws TransformerException {
        if (this.pendingStartTag == -1) {
            throw new TransformerException("Cannot copy a namespace node when there is no containing element node");
        }
        if (this.pendingAttList.getLength() > 0) {
            throw new TransformerException("Cannot copy a namespace node to an element after attributes have been added");
        }
        int n2 = 0;
        while (n2 < this.pendingNSListSize) {
            if (n >> 16 == this.pendingNSList[n2] >> 16) {
                if (n == this.pendingNSList[n2]) {
                    return;
                }
                throw new TransformerException("Cannot create two namespace nodes with the same name");
            }
            ++n2;
        }
        this.writeNamespaceDeclaration(n);
    }

    private String getSubstitutePrefix(int n) {
        String string = this.namePool.getPrefixFromNamespaceCode(n);
        return string + "." + (n & 0xFFFF);
    }

    public boolean thereIsAnOpenStartTag() {
        return this.pendingStartTag != -1;
    }

    public void writeAttribute(int n, String string) throws TransformerException {
        this.writeAttribute(n, string, false);
    }

    public void writeAttribute(int n, String string, boolean bl) throws TransformerException {
        if (this.pendingStartTag == -1) {
            throw new TransformerException("Cannot write an attribute when there is no open start tag");
        }
        this.pendingAttList.setAttribute(n, bl ? "NO-ESC" : "CDATA", string);
    }

    public void writeEndTag(int n) throws TransformerException {
        if (this.pendingStartTag != -1) {
            this.flushStartTag();
        }
        this.emitter.endElement(n);
    }

    public void writeComment(String string) throws TransformerException {
        if (this.pendingStartTag != -1) {
            this.flushStartTag();
        }
        this.emitter.comment(string.toCharArray(), 0, string.length());
    }

    public void writePI(String string, String string2) throws TransformerException {
        if (this.pendingStartTag != -1) {
            this.flushStartTag();
        }
        this.emitter.processingInstruction(string, string2);
    }

    public void close() throws TransformerException {
        this.emitter.endDocument();
        if (this.closeAfterUse) {
            try {
                if (this.writer != null) {
                    this.writer.close();
                }
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
            }
            catch (IOException iOException) {
                throw new TransformerException(iOException);
            }
        }
    }

    protected void flushStartTag() throws TransformerException {
        this.emitter.startElement(this.pendingStartTag, this.pendingAttList, this.pendingNSList, this.pendingNSListSize);
        this.pendingNSListSize = 0;
        this.pendingStartTag = -1;
    }
}

