/*****************************************************************

Copyright (c) 2001 Matthias Elter <elter@kde.org>

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN
AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

******************************************************************/

#include <qdir.h>
#include <kapplication.h>
#include <klocale.h>
#include <kiconloader.h>
#include <kglobal.h>
#include <kfiledialog.h>
#include <kstandarddirs.h>
#include <kmessagebox.h>

#include "addspecialbutton_mnu.h"
#include "addspecialbutton_mnu.moc"

#include "panelmenuiteminfo.h"

#include "exe_dlg.h"
#include "browser_dlg.h"
#include "containerarea.h"
#include "menuinfo.h"

PanelAddSpecialButtonMenu::PanelAddSpecialButtonMenu( ContainerArea* cArea,
                                                      QWidget *parent, const char *name)
    : QPopupMenu(parent, name), containerArea(cArea)
{
    QValueList<PanelMenuItemInfo> items;
    items.append(PanelMenuItemInfo("kmenu", i18n("K Menu"), this, SLOT(slotAddKMenu())));
    items.append(PanelMenuItemInfo("window_list", i18n("Window List"), this, SLOT(slotAddWindowList())));
    if (kapp->authorizeKAction("bookmarks"))
    {
        items.append(PanelMenuItemInfo("bookmark", i18n("Bookmarks"), this, SLOT(slotAddBookmarks())));
    }
    items.append(PanelMenuItemInfo("desktop", i18n("Desktop Access"), this, SLOT(slotAddDesktop())));
    items.append(PanelMenuItemInfo("kdisknav", i18n("Quick Browser"), this, SLOT(slotAddQuickBrowser())));
    if (kapp->authorize("shell_access"))
    {
        items.append(PanelMenuItemInfo("exec", i18n("Non-KDE Application"), this, SLOT(slotAddNonKDEApp())));
    }

    int ID = 0;
    QStringList dirs = KGlobal::dirs()->findDirs("data", "kicker/menuext");
    for (QStringList::ConstIterator it=dirs.begin(); it!=dirs.end(); ++it)
    {
        QDir d(*it, "*.desktop");
        QStringList entries = d.entryList();
        for (QStringList::ConstIterator e=entries.begin(); e!=entries.end(); ++e)
            if (extensionList.findIndex(*e) == -1)
            {
                MenuInfo info(*e);
                if (info.isValid())
                {
                    items.append(PanelMenuItemInfo(info.icon(), info.name(), ID++));
                    extensionList << *e;
                }
            }
    }

    qHeapSort(items);
    QValueList<PanelMenuItemInfo>::iterator it = items.begin();
    for (; it != items.end(); ++it)
    {
        (*it).plug(this);
    }

    connect(this, SIGNAL(activated(int)), SLOT(slotExec(int)));

    adjustSize();
}

PanelAddSpecialButtonMenu::~PanelAddSpecialButtonMenu()
{

}

void PanelAddSpecialButtonMenu::slotAddKMenu()
{
    if (containerArea)
	containerArea->addKMenuButton();
}

void PanelAddSpecialButtonMenu::slotAddDesktop()
{
    if (containerArea)
	containerArea->addDesktopButton();
}

void PanelAddSpecialButtonMenu::slotAddWindowList()
{
    if (containerArea)
	containerArea->addWindowListButton();
}

void PanelAddSpecialButtonMenu::slotAddBookmarks()
{
    if (containerArea)
	containerArea->addBookmarksButton();
}

void PanelAddSpecialButtonMenu::slotAddQuickBrowser()
{
    PanelBrowserDialog *dlg = new PanelBrowserDialog( QDir::home().path(), "kdisknav" );

    if( dlg->exec() == QDialog::Accepted )
	containerArea->addBrowserButton( dlg->path(), dlg->icon() );
}

void PanelAddSpecialButtonMenu::slotAddNonKDEApp()
{
    PanelExeDialog dlg(QString::null, QString::null, QString::null, false, 0);

    if(dlg.exec() == QDialog::Accepted)
	if (containerArea)
	    containerArea->addNonKDEAppButton(dlg.command(), dlg.icon(),
					      dlg.commandLine(), dlg.useTerminal());
}

void PanelAddSpecialButtonMenu::slotExec(int ID)
{
    if (ID >= 0 && ID < int(extensionList.count()) && containerArea)
	containerArea->addExtensionButton(extensionList[ID]);
}
