// Copyright (c) 2003 Charles Samuels <charles@kde.org>
// See the file COPYING for redistribution terms.

#ifndef MENU_H
#define MENU_H

#include <kpopupmenu.h>
#include <kpropertiesdialog.h>

#include "file.h"

/**
 * a context menu for a item in the list
 **/
class FileMenu : public KPopupMenu
{
Q_OBJECT
	File mFile;

public:
	FileMenu(QWidget *parent, File file, bool deleteMe=true);

private slots:
	void removeFromList();
	void properties();
};

class ObliquePropertiesDialog : public KPropertiesDialog
{
Q_OBJECT
	File mFile;
public:
	ObliquePropertiesDialog(File file, QWidget *parent);

private slots:
	void modified();
};


#endif
