/***************************************************************************
                          xmmsInterface.h
            this is the abstract class to access xmms from
                             -------------------
    begin                : Tue Apr 25 11:53:11 CEST 2000
    copyright            : (C) 2000-2002 by Stefan Gehn
    email                : sgehn@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_XMMS // only use if there's xmms installed on compiletime

#ifndef XMMSINTERFACE_H
#define XMMSINTERFACE_H

#include "playerInterface.h"
#include <qtimer.h>

class XmmsInterface : public PlayerInterface
{
	Q_OBJECT
	public:
		XmmsInterface();
		~XmmsInterface();
	public slots:
		void updateSlider();

		void sliderStartDrag();
		void sliderStopDrag();
		void jumpToTime( int msec );

		void play();
		void pause();
		void stop();
		void next();
		void prev();

		void dragEnterEvent(QDragEnterEvent* event);
		void dropEvent(QDropEvent* event);

		const QString getTrackTitle() const;

	signals:
		void newSliderPosition ( int, int );
		void playerStarted(void);
		void playerStopped(void);

	private:
		QTimer *xmms_timer;
		int timervalue;
};
#endif // XMMSINTERFACE_H
#endif // HAVE_XMMS
