/*
 * Decompiled with CFR 0.152.
 */
package org.kde.kjas.server;

import java.io.PrintStream;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import org.kde.kjas.server.Console;
import org.kde.kjas.server.KJASProtocolHandler;
import org.kde.kjas.server.KJASSwingConsole;
import org.kde.kjas.server.KJASURLStreamHandlerFactory;

public class Main {
    public static final KJASProtocolHandler protocol;
    private static Console console;
    private static final boolean show_console;
    public static final boolean Debug;
    public static final boolean log;
    static final boolean cacheImages;
    static float java_version;
    public static String proxyHost;
    public static int proxyPort;
    private static boolean good_jdk;

    public static void debug(String string) {
        if (Debug) {
            System.out.println("KJAS: " + string);
        }
    }

    public static void info(String string) {
        System.err.println("KJAS: " + string);
    }

    public static void kjas_err(String string, Exception exception) {
        System.err.println(string);
        System.err.println("Backtrace: ");
        exception.printStackTrace();
    }

    public static void kjas_err(String string, Throwable throwable) {
        System.err.println(string);
        throwable.printStackTrace();
    }

    public static void main(String[] stringArray) {
        if (!good_jdk) {
            console.setVisible(true);
            System.err.println("ERROR: This version of Java is not supported for security reasons.");
            System.err.println("\t\tPlease use Java version 1.2 or higher.");
            return;
        }
        if (show_console) {
            console.setVisible(true);
        }
        boolean bl = true;
        try {
            Object object;
            Provider[] providerArray = Security.getProviders("SSLContext.SSL");
            if (providerArray == null || providerArray.length == 0) {
                object = Class.forName("com.sun.net.ssl.internal.ssl.Provider");
                if (object != null) {
                    Main.debug("adding Security Provider");
                    Provider provider = (Provider)((Class)object).newInstance();
                    Security.addProvider(provider);
                } else {
                    Main.debug("could not get class: com.sun.net.ssl.internal.ssl.Provider");
                    bl = false;
                }
            }
            if (bl) {
                object = System.getProperty("java.protocol.handler.pkgs");
                object = object == null ? "com.sun.net.ssl.internal.www.protocol|com.ibm.net.ssl.www.protocol" : (String)object + "|com.sun.net.ssl.internal.www.protocol|com.ibm.net.ssl.www.protocol";
                System.setProperty("java.protocol.handler.pkgs", (String)object);
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        if (!bl) {
            System.out.println("Unable to load JSSE SSL stream handler, https support not available");
            System.out.println("For more information see http://java.sun.com/products/jsse/");
        }
        protocol.commandLoop();
    }

    static {
        console = null;
        java_version = 0.0f;
        proxyHost = null;
        proxyPort = 0;
        good_jdk = true;
        Debug = System.getProperty("kjas.debug") != null;
        boolean bl = show_console = System.getProperty("kjas.showConsole") != null;
        if (System.getProperty("kjas.useKio") != null) {
            URL.setURLStreamHandlerFactory(new KJASURLStreamHandlerFactory());
        }
        log = System.getProperty("kjas.log") != null;
        cacheImages = System.getProperty("kjas.noImageCache") != null;
        proxyHost = System.getProperty("http.proxyHost");
        String string = System.getProperty("http.proxyPort");
        try {
            proxyPort = Integer.parseInt(string);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = System.getProperty("java.version").substring(0, 3);
        if (string2 == "Jav") {
            string2 = System.getProperty("java.version").substring(7, 3);
        }
        try {
            java_version = Float.parseFloat(string2);
            if ((double)java_version < 1.2) {
                good_jdk = false;
            }
        }
        catch (NumberFormatException numberFormatException) {
            good_jdk = false;
        }
        PrintStream printStream = System.out;
        if (show_console || !good_jdk) {
            console = new KJASSwingConsole();
        } else {
            PrintStream printStream2 = new PrintStream(System.err);
            System.setOut(printStream2);
            System.setErr(printStream2);
        }
        protocol = new KJASProtocolHandler(System.in, printStream);
    }
}

