//-*-C++-*-
/*
**************************************************************************
                                 description
                             --------------------
    copyright            : (C) 2002 by Luis Carvalho
    email                : lpassos@mail.telepac.pt
**************************************************************************

**************************************************************************
*                                                                        *
*  This program is free software; you can redistribute it and/or modify  *
*  it under the terms of the GNU General Public License as published by  *
*  the Free Software Foundation; either version 2 of the License, or     *
*  (at your option) any later version.                                   *
*                                                                        *
**************************************************************************/

#ifndef PMLIBRARYBROWSER_H
#define PMLIBRARYBROWSER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <qwidget.h>
#include <qdict.h>

class QPushButton;
class QComboBox;
class QIconViewItem;
class KConfig;
class KDirOperator;
class PMLibraryIconView;
class PMLibraryObjectPreview;
class PMLibraryHandle;
class PMPart;

typedef QDict<QString> QStringDict;
/** 
 * This class provides a non-modal dialog to browse the available libraries.
 */
class PMLibraryBrowser: public QWidget
{
   Q_OBJECT
public:
   static void saveConfig( KConfig* cfg );
   static void restoreConfig( KConfig* cfg );
   static QSize s_size;

   /**
    * Sets the known libraries
    */
   void setLibraryPaths( const QStringList& l );

   /** 
    * Creates and shows the Library Browser 
    */
   static void showBrowser( );

private slots:
   void resizeEvent( QResizeEvent* ev );
   void slotPathSelected( const QString& str );
   void slotSelectionChanged( QIconViewItem* str );
   void slotEditClicked( );
   void slotNewClicked( );

private:

   PMLibraryBrowser( QWidget *parent, const char* name = NULL );

   QPushButton*            m_pNewObjectButton;
   QPushButton*            m_pEditObjectButton;
   QPushButton*            m_pDeleteObjectButton;
   QComboBox*              m_pLibraryComboBox;
   PMLibraryIconView*      m_pLibraryIconView;
   PMLibraryObjectPreview* m_pLibraryObjectPreview;
   PMLibraryHandle*        m_pCurrentLibrary;

   static PMLibraryBrowser* s_pLibraryBrowser;
};

#endif
